/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;

public class SVNSSLAuthentication
extends SVNAuthentication {
    public static final String MSCAPI = "MSCAPI";
    public static final String SSL = "SSL";
    private File myCertificate;
    private char[] myPassword;
    private String mySSLKind;
    private String myAlias;
    private String myCertificatePath;
    private byte[] myCertificateData;

    public static SVNSSLAuthentication newInstance(File certFile, char[] password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNSSLAuthentication(SSL, null, certFile, password, storageAllowed, url, isPartial);
    }

    public static SVNSSLAuthentication newInstance(byte[] cert, char[] password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNSSLAuthentication(SSL, null, cert, password, storageAllowed, url, isPartial);
    }

    public static SVNSSLAuthentication newInstance(String kind, String alias, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNSSLAuthentication(kind, alias, null, null, storageAllowed, url, isPartial);
    }

    public SVNSSLAuthentication(File certFile, String password, boolean storageAllowed) {
        this(SSL, null, certFile, password != null ? password.toCharArray() : null, storageAllowed, null, false);
    }

    public SVNSSLAuthentication(File certFile, String password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this(SSL, null, certFile, password != null ? password.toCharArray() : null, storageAllowed, url, isPartial);
    }

    public SVNSSLAuthentication(String sslKind, String alias, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this(sslKind, alias, (File)null, (char[])null, storageAllowed, url, isPartial);
    }

    private SVNSSLAuthentication(String sslKind, String alias, File certFile, char[] password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        super("svn.ssl.client-passphrase", null, storageAllowed, url, isPartial);
        this.mySSLKind = sslKind;
        this.myAlias = alias;
        this.myCertificate = certFile;
        this.myPassword = password;
    }

    private SVNSSLAuthentication(String sslKind, String alias, byte[] cert, char[] password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        super("svn.ssl.client-passphrase", null, storageAllowed, url, isPartial);
        this.mySSLKind = sslKind;
        this.myAlias = alias;
        this.myCertificateData = cert;
        this.myPassword = password;
    }

    public String getPassword() {
        return this.myPassword != null ? new String(this.myPassword) : null;
    }

    public byte[] getCertificate() {
        return this.myCertificateData;
    }

    public char[] getPasswordValue() {
        return this.myPassword;
    }

    public File getCertificateFile() {
        return this.myCertificate;
    }

    public String getSSLKind() {
        return this.mySSLKind;
    }

    public String getAlias() {
        return this.myAlias;
    }

    public String getCertificatePath() {
        if (this.myCertificatePath != null) {
            return this.myCertificatePath;
        }
        return this.myCertificate.getAbsolutePath();
    }

    public void setCertificatePath(String path) {
        this.myCertificatePath = path;
    }

    public static boolean isCertificatePath(String path) {
        return SVNFileType.getType(new File(path)) == SVNFileType.FILE;
    }

    public void dismissSensitiveData() {
        super.dismissSensitiveData();
        SVNEncodingUtil.clearArray(this.myPassword);
    }

    public SVNAuthentication copy() {
        return new SVNSSLAuthentication(this.mySSLKind, this.myAlias, this.myCertificate, this.copyOf(this.myPassword), this.isStorageAllowed(), this.getURL(), this.isPartial());
    }
}

