/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.tigris.subversion.javahl.ClientException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.client.ISVNClientInterfaceEx;
import org.tmatesoft.svn.core.client.SVNClientAuthenticationManager;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.SVNMoveClient;

public class SVNClientEx
extends SVNClientImpl
implements ISVNClientInterfaceEx {
    private boolean myIsCommitMissingFiles;
    private String myProxyPassword;
    private String myProxyUserName;
    private int myProxyPort;
    private String myProxyHost;
    private int mySSHPort;
    private String mySSHUserName;
    private String mySSHPassphrase;
    private String mySSHKeyPath;
    private String mySSLPassphrase;
    private String mySSLCertPath;
    private String mySSH2Password;
    private String mySSH2UserName;
    private int mySSH2Port;

    public SVNClientEx() {
        super(null);
    }

    public void setCommitMissedFiles(boolean commitMissingFiles) {
        this.myIsCommitMissingFiles = commitMissingFiles;
        DefaultSVNCommitParameters params = new DefaultSVNCommitParameters(){

            public ISVNCommitParameters.Action onMissingFile(File file) {
                return SVNClientEx.this.myIsCommitMissingFiles ? DELETE : SKIP;
            }

            public ISVNCommitParameters.Action onMissingDirectory(File file) {
                return SVNClientEx.this.myIsCommitMissingFiles ? DELETE : ERROR;
            }
        };
        this.getSVNCommitClient().setCommitParameters(params);
        this.getSVNCopyClient().setCommitParameters(params);
    }

    public boolean isCommitMissingFile() {
        return this.myIsCommitMissingFiles;
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        this.mySSLCertPath = certPath;
        this.mySSLPassphrase = passphrase;
        this.updateClientManager();
    }

    public void setSSHCredentials(String userName, String privateKeyPath, String passphrase, int port) {
        this.mySSHKeyPath = privateKeyPath;
        this.mySSHPassphrase = passphrase;
        this.mySSHUserName = userName;
        this.mySSHPort = port;
        this.updateClientManager();
    }

    public void setSSHCredentials(String userName, String password, int port) {
        this.mySSH2Password = password;
        this.mySSH2UserName = userName;
        this.mySSH2Port = port;
        this.updateClientManager();
    }

    public void setProxy(String host, int port, String userName, String password) {
        this.myProxyHost = host;
        this.myProxyPort = port;
        this.myProxyUserName = userName;
        this.myProxyPassword = password;
        this.updateClientManager();
    }

    public void move(String[] srcPaths, String destPath, String message, boolean force, boolean moveAsChild, boolean makeParents, Map revprops) throws ClientException {
        String[] urlSources = null;
        if (!SVNClientEx.isURL(destPath)) {
            SVNMoveClient client = this.getClientManager().getMoveClient();
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < srcPaths.length) {
                if (!SVNClientEx.isURL(srcPaths[i])) {
                    try {
                        client.doMove(new File(srcPaths[i]), new File(destPath));
                    }
                    catch (SVNException e) {
                        this.throwException(e);
                    }
                } else {
                    list.add(srcPaths[i]);
                }
                ++i;
            }
            urlSources = list.toArray(new String[list.size()]);
        }
        if (urlSources != null && urlSources.length > 0) {
            super.move(urlSources, destPath, message, force, moveAsChild, makeParents, revprops);
        }
    }

    protected ISVNAuthenticationManager createAuthenticationManager(File configDir, String userName, String password, boolean allowSave, boolean saveSSL) {
        SVNClientAuthenticationManager authManager = new SVNClientAuthenticationManager(configDir, allowSave, saveSSL, userName, password);
        authManager.setProxy(this.myProxyHost, this.myProxyPort, this.myProxyUserName, this.myProxyPassword);
        authManager.setClientSSLCertificate(this.mySSLCertPath, this.mySSLPassphrase);
        authManager.setSSHCredentials(this.mySSHUserName, this.mySSHKeyPath, this.mySSHPassphrase, this.mySSHPort);
        authManager.setSSHCredentials(this.mySSH2UserName, this.mySSH2Password, this.mySSH2Port);
        return authManager;
    }
}

