/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SVNSqlJetStatement {
    protected SVNSqlJetDb sDb;
    private ISqlJetCursor cursor;
    protected List<Object> binds = new ArrayList<Object>();
    protected SqlJetTransactionMode transactionMode = SqlJetTransactionMode.READ_ONLY;

    protected ISqlJetCursor openCursor() throws SVNException {
        throw new UnsupportedOperationException();
    }

    public long insert(Object ... data) throws SVNException {
        throw new UnsupportedOperationException();
    }

    public long exec() throws SVNException {
        throw new UnsupportedOperationException();
    }

    public SVNSqlJetStatement(SVNSqlJetDb sDb) {
        this.sDb = sDb;
        this.setCursor(null);
    }

    public List<Object> getBinds() {
        return this.binds;
    }

    public boolean isNeedsReset() {
        return this.getCursor() != null;
    }

    public void reset() throws SVNException {
        this.binds.clear();
        if (this.isNeedsReset()) {
            try {
                try {
                    this.getCursor().close();
                }
                catch (SqlJetException e) {
                    SVNSqlJetDb.createSqlJetError(e);
                    this.setCursor(null);
                    this.sDb.commit();
                }
            }
            finally {
                this.setCursor(null);
                this.sDb.commit();
            }
        }
    }

    public boolean next() throws SVNException {
        try {
            if (this.getCursor() == null) {
                this.sDb.beginTransaction(this.transactionMode);
                try {
                    this.setCursor(this.openCursor());
                    return !this.getCursor().eof();
                }
                catch (SVNException e) {
                    if (this.getCursor() == null) {
                        this.sDb.commit();
                    }
                    throw e;
                }
            }
            return this.getCursor().next();
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return false;
        }
    }

    public boolean eof() throws SVNException {
        try {
            if (this.getCursor() == null) {
                this.sDb.beginTransaction(this.transactionMode);
                this.setCursor(this.openCursor());
            }
            return this.getCursor().eof();
        }
        catch (SqlJetException e) {
            SVNSqlJetDb.createSqlJetError(e);
            return false;
        }
    }

    public void bindf(String format, Object ... data) throws SVNException {
        int n = 0;
        int length = data.length;
        int i = 0;
        while (i < format.length()) {
            char fmt = format.charAt(i);
            switch (fmt) {
                case 's': 
                case 't': {
                    if (n > length || data[n] == null) {
                        this.bindNull(i + 1);
                    } else if (data[n] instanceof File) {
                        this.bindString(i + 1, SVNFileUtil.getFilePath((File)data[n]));
                    } else {
                        this.bindString(i + 1, data[n].toString());
                    }
                    ++n;
                    break;
                }
                case 'i': {
                    if (n > length || data[n] == null) {
                        this.bindNull(i + 1);
                    } else if (data[n] instanceof Number) {
                        this.bindLong(i + 1, ((Number)data[n]).longValue());
                    } else if (data[n] instanceof SVNDate) {
                        this.bindLong(i + 1, ((SVNDate)data[n]).getTimeInMicros());
                    } else {
                        SVNErrorManager.assertionFailure(false, String.format("Number argument required in %d", i + 1), SVNLogType.WC);
                    }
                    ++n;
                    break;
                }
                case 'r': {
                    if (n > length || data[n] == null) {
                        this.bindNull(i + 1);
                    } else if (data[n] instanceof Number) {
                        this.bindRevision(i + 1, ((Number)data[n]).longValue());
                    } else {
                        SVNErrorManager.assertionFailure(false, String.format("Number argument required in %d", i + 1), SVNLogType.WC);
                    }
                    ++n;
                    break;
                }
                case 'b': {
                    if (n > length || data[n] == null) {
                        this.bindNull(i + 1);
                    } else if (data[n] instanceof byte[]) {
                        this.bindBlob(i + 1, (byte[])data[n]);
                    } else {
                        SVNErrorManager.assertionFailure(false, String.format("Byte array argument required in %d", i + 1), SVNLogType.WC);
                    }
                    ++n;
                    break;
                }
                case 'n': {
                    this.bindNull(i + 1);
                    break;
                }
                default: {
                    SVNErrorManager.assertionFailure(false, String.format("Unknown format '%s' in %d", Character.valueOf(fmt), i + 1), SVNLogType.WC);
                }
            }
            ++i;
        }
    }

    private void adjustBinds(int i) {
        int size = this.binds.size();
        if (size < i) {
            int n = size;
            while (n < i) {
                this.binds.add(null);
                ++n;
            }
        }
    }

    public void bindNull(int i) {
        this.adjustBinds(i);
        this.binds.set(i - 1, null);
    }

    public void bindLong(int i, long v) {
        this.adjustBinds(i);
        this.binds.set(i - 1, v);
    }

    public void bindString(int i, String string) {
        this.adjustBinds(i);
        this.binds.set(i - 1, string);
    }

    public void bindProperties(int i, SVNProperties props) throws SVNException {
        this.adjustBinds(i);
        this.binds.set(i - 1, props != null ? SVNSkel.createPropList(props.asMap()).unparse() : null);
    }

    public void bindIProperties(int i, Map<String, SVNProperties> iprops) throws SVNException {
        this.adjustBinds(i);
        this.binds.set(i - 1, iprops != null ? SVNSkel.createInheritedProperties(iprops).unparse() : null);
    }

    public void bindChecksum(int i, SvnChecksum checksum) {
        this.adjustBinds(i);
        this.binds.set(i - 1, checksum != null ? checksum.toString() : null);
    }

    public void bindBlob(int i, byte[] serialized) {
        this.adjustBinds(i);
        this.binds.set(i - 1, serialized);
    }

    public void bindRevision(int i, long revision) {
        this.adjustBinds(i);
        if (SVNRevision.isValidRevisionNumber(revision)) {
            this.bindLong(i, revision);
        } else {
            this.bindNull(i);
        }
    }

    protected Object getBind(int i) {
        this.adjustBinds(i);
        return this.binds.get(i - 1);
    }

    public long count() throws SVNException {
        block3: {
            try {
                if (this.getCursor() != null && !this.getCursor().eof()) break block3;
                return 0L;
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return 0L;
            }
        }
        return this.getCursor().getRowCount();
    }

    public Object getColumn(Enum<?> f) throws SVNException {
        return this.getColumn(f.toString());
    }

    protected Object getColumn(String f) throws SVNException {
        block3: {
            try {
                if (this.getCursor() != null && !this.getCursor().eof()) break block3;
                return null;
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return null;
            }
        }
        return this.getCursor().getValue(f);
    }

    public long getColumnLong(Enum<?> f) throws SVNException {
        return this.getColumnLong(f.toString());
    }

    protected long getColumnLong(String f) throws SVNException {
        block3: {
            try {
                if (this.getCursor() != null && !this.getCursor().eof()) break block3;
                return 0L;
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return 0L;
            }
        }
        return this.getCursor().getInteger(f);
    }

    public String getColumnString(Enum<?> f) throws SVNException {
        return this.getColumnString(f.toString());
    }

    protected String getColumnString(String f) throws SVNException {
        block3: {
            try {
                if (this.getCursor() != null && !this.getCursor().eof()) break block3;
                return null;
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return null;
            }
        }
        return this.getCursor().getString(f);
    }

    public boolean isColumnNull(Enum<?> f) throws SVNException {
        return this.isColumnNull(f.toString());
    }

    protected boolean isColumnNull(String f) throws SVNException {
        block3: {
            try {
                if (this.getCursor() != null && !this.getCursor().eof()) break block3;
                return true;
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return false;
            }
        }
        return this.getCursor().isNull(f);
    }

    public byte[] getColumnBlob(Enum<?> f) throws SVNException {
        return this.getColumnBlob(f.toString());
    }

    protected byte[] getColumnBlob(String f) throws SVNException {
        block3: {
            try {
                if (this.getCursor() != null && !this.getCursor().eof()) break block3;
                return null;
            }
            catch (SqlJetException e) {
                SVNSqlJetDb.createSqlJetError(e);
                return null;
            }
        }
        return this.getCursor().getBlobAsArray(f);
    }

    public boolean getColumnBoolean(Enum<?> f) throws SVNException {
        return this.getColumnLong(f) != 0L;
    }

    public SVNSqlJetStatement getJoinedStatement(String joinedTable) throws SVNException {
        SVNErrorManager.assertionFailure(false, "unsupported", SVNLogType.WC);
        return null;
    }

    public SVNSqlJetStatement getJoinedStatement(Enum<?> joinedTable) throws SVNException {
        return this.getJoinedStatement(joinedTable.toString());
    }

    public SVNProperties getColumnProperties(Enum<?> f) throws SVNException {
        return this.getColumnProperties(f.name());
    }

    public boolean hasColumnProperties(Enum<?> f) throws SVNException {
        return this.hasColumnProperties(f.name());
    }

    public List<Structure<StructureFields.InheritedProperties>> getColumnInheritedProperties(Enum<?> f) throws SVNException {
        return this.getColumnInheritedProperties(f.name());
    }

    public boolean hasColumnInheritedProperties(Enum<?> f) throws SVNException {
        return this.hasColumnInheritedProperties(f.name());
    }

    protected SVNProperties getColumnProperties(String f) throws SVNException {
        if (this.isColumnNull(f)) {
            return null;
        }
        byte[] val = this.getColumnBlob(f);
        return SVNSqlJetStatement.parseProperties(val);
    }

    protected boolean hasColumnProperties(String f) throws SVNException {
        if (this.isColumnNull(f)) {
            return false;
        }
        byte[] val = this.getColumnBlob(f);
        return val.length > 2;
    }

    public List<Structure<StructureFields.InheritedProperties>> getColumnInheritedProperties(String f) throws SVNException {
        if (this.isColumnNull(f)) {
            return null;
        }
        byte[] val = this.getColumnBlob(f);
        return SVNSqlJetStatement.parseInheritedProperties(val);
    }

    public boolean hasColumnInheritedProperties(String f) throws SVNException {
        if (this.isColumnNull(f)) {
            return false;
        }
        byte[] val = this.getColumnBlob(f);
        return val.length > 2;
    }

    public static SVNProperties parseProperties(byte[] val) throws SVNException {
        if (val == null) {
            return null;
        }
        SVNSkel skel = SVNSkel.parse(val);
        if (!skel.isValidPropList()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "proplist");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return SVNProperties.wrap(skel.parsePropList());
    }

    public static List<Structure<StructureFields.InheritedProperties>> parseInheritedProperties(byte[] val) throws SVNException {
        if (val == null) {
            return null;
        }
        SVNSkel skel = SVNSkel.parse(val);
        if (!skel.isValidInheritedProperties()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_MALFORMED_SKEL, "inhertied-props");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return skel.parseInheritedProperties();
    }

    public long done() throws SVNException {
        try {
            long l = this.exec();
            return l;
        }
        finally {
            this.reset();
        }
    }

    public void nextRow() throws SVNException {
        if (!this.next()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, "Expected database row missing");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    public long getColumnRevnum(Enum<?> f) throws SVNException {
        if (this.isColumnNull(f)) {
            return -1L;
        }
        return this.getColumnLong(f);
    }

    protected ISqlJetCursor getCursor() {
        return this.cursor;
    }

    protected void setCursor(ISqlJetCursor cursor) {
        this.cursor = cursor;
    }

    public Map<String, Object> getRowValues() throws SVNException {
        throw new UnsupportedOperationException();
    }
}

