/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.InflaterInputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDeltaReader {
    private ByteBuffer myBuffer = ByteBuffer.allocate(4096);
    private int myHeaderBytes;
    private long myLastSourceOffset;
    private int myLastSourceLength;
    private boolean myIsWindowSent;
    private byte myVersion;

    public SVNDeltaReader() {
        this.myBuffer.clear();
        this.myBuffer.limit(0);
    }

    public void reset(String path, ISVNDeltaConsumer consumer) throws SVNException {
        if (this.myHeaderBytes == 4 && !this.myIsWindowSent) {
            OutputStream os = consumer.textDeltaChunk(path, SVNDiffWindow.EMPTY);
            SVNFileUtil.closeFile(os);
        }
        this.myLastSourceLength = 0;
        this.myLastSourceOffset = 0L;
        this.myHeaderBytes = 0;
        this.myIsWindowSent = false;
        this.myVersion = 0;
        this.myBuffer.clear();
        this.myBuffer.limit(0);
    }

    public void nextWindow(byte[] data, int offset, int length, String path, ISVNDeltaConsumer consumer) throws SVNException {
        this.appendToBuffer(data, offset, length);
        if (this.myHeaderBytes < 4) {
            if (this.myBuffer.remaining() < 4) {
                return;
            }
            if (this.myBuffer.get(0) != 83 || this.myBuffer.get(1) != 86 || this.myBuffer.get(2) != 78 || this.myBuffer.get(3) != 0 && this.myBuffer.get(3) != 1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW, "Svndiff has invalid header");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            this.myVersion = this.myBuffer.get(3);
            this.myBuffer.position(4);
            int remainging = this.myBuffer.remaining();
            this.myBuffer.compact();
            this.myBuffer.position(0);
            this.myBuffer.limit(remainging);
            this.myHeaderBytes = 4;
        }
        long sourceOffset;
        while ((sourceOffset = this.readLongOffset()) >= 0L) {
            int sourceLength = this.readOffset();
            if (sourceLength < 0) {
                return;
            }
            int targetLength = this.readOffset();
            if (targetLength < 0) {
                return;
            }
            int instructionsLength = this.readOffset();
            if (instructionsLength < 0) {
                return;
            }
            int newDataLength = this.readOffset();
            if (newDataLength < 0) {
                return;
            }
            if (sourceLength > 0 && (sourceOffset < this.myLastSourceOffset || sourceOffset + (long)sourceLength < this.myLastSourceOffset + (long)this.myLastSourceLength)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW, "Svndiff has backwards-sliding source views");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if (this.myBuffer.remaining() < instructionsLength + newDataLength) {
                return;
            }
            this.myLastSourceOffset = sourceOffset;
            this.myLastSourceLength = sourceLength;
            SVNDiffWindow window = null;
            int allDataLength = newDataLength + instructionsLength;
            if (this.myVersion == 1) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int bufferPosition = this.myBuffer.position();
                try {
                    instructionsLength = this.deflate(instructionsLength, out);
                    newDataLength = this.deflate(newDataLength, out);
                }
                catch (IOException e) {
                    SVNDebugLog.getDefaultLog().logSevere(SVNLogType.DEFAULT, e);
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                    SVNErrorManager.error(errorMessage, SVNLogType.NETWORK);
                }
                byte[] bytes = out.toByteArray();
                ByteBuffer decompressed = ByteBuffer.wrap(bytes);
                decompressed.position(0);
                window = new SVNDiffWindow(sourceOffset, sourceLength, targetLength, instructionsLength, newDataLength);
                window.setData(decompressed);
                this.myBuffer.position(bufferPosition);
            } else {
                window = new SVNDiffWindow(sourceOffset, sourceLength, targetLength, instructionsLength, newDataLength);
                window.setData(this.myBuffer);
            }
            int position = this.myBuffer.position();
            OutputStream os = consumer.textDeltaChunk(path, window);
            SVNFileUtil.closeFile(os);
            this.myBuffer.position(position + allDataLength);
            int remains = this.myBuffer.remaining();
            this.myIsWindowSent = true;
            this.myBuffer.compact();
            this.myBuffer.position(0);
            this.myBuffer.limit(remains);
        }
        return;
    }

    private int deflate(int compressedLength, OutputStream out) throws IOException {
        int originalPosition = this.myBuffer.position();
        int uncompressedLength = this.readOffset();
        if (uncompressedLength == compressedLength - (this.myBuffer.position() - originalPosition)) {
            int offset = this.myBuffer.arrayOffset() + this.myBuffer.position();
            out.write(this.myBuffer.array(), offset, uncompressedLength);
        } else {
            byte[] uncompressedData = new byte[uncompressedLength];
            byte[] compressed = this.myBuffer.array();
            int offset = this.myBuffer.arrayOffset() + this.myBuffer.position();
            InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(compressed, offset, compressedLength));
            int read = 0;
            while (read < uncompressedLength) {
                int r = ((InputStream)in).read(uncompressedData, read, uncompressedLength - read);
                if (r < 0) break;
                read += r;
            }
            out.write(uncompressedData);
        }
        this.myBuffer.position(originalPosition + compressedLength);
        return uncompressedLength;
    }

    private void appendToBuffer(byte[] data, int offset, int length) {
        int limit = this.myBuffer.limit();
        if (this.myBuffer.capacity() < limit + length) {
            ByteBuffer newBuffer = ByteBuffer.allocate((limit + length) * 3 / 2);
            this.myBuffer.position(0);
            newBuffer.put(this.myBuffer);
            this.myBuffer = newBuffer;
        } else {
            this.myBuffer.limit(limit + length);
            this.myBuffer.position(limit);
        }
        this.myBuffer.put(data, offset, length);
        this.myBuffer.position(0);
        this.myBuffer.limit(limit + length);
    }

    private int readOffset() {
        this.myBuffer.mark();
        int offset = 0;
        while (this.myBuffer.hasRemaining()) {
            byte b = this.myBuffer.get();
            offset = offset << 7 | b & 0x7F;
            if ((b & 0x80) != 0) continue;
            return offset;
        }
        this.myBuffer.reset();
        return -1;
    }

    private long readLongOffset() {
        this.myBuffer.mark();
        long offset = 0L;
        while (this.myBuffer.hasRemaining()) {
            byte b = this.myBuffer.get();
            offset = offset << 7 | (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            return offset;
        }
        this.myBuffer.reset();
        return -1L;
    }
}

