/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.util.Map;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaAlgorithm;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNXDeltaAlgorithm
extends SVNDeltaAlgorithm {
    private static final int MATCH_BLOCK_SIZE = 64;
    private static int ADLER32_MASK = 65535;

    public void computeDelta(byte[] a, int aLength, byte[] b, int bLength) {
        if (bLength < 64) {
            this.copyFromNewData(b, 0, bLength);
            return;
        }
        PseudoAdler32 bAdler = new PseudoAdler32();
        Map aMatchesTable = SVNXDeltaAlgorithm.createMatchesTable(a, aLength, 64, bAdler);
        bAdler.reset();
        bAdler.add(b, 0, 64);
        int lo = 0;
        int size = bLength;
        Match previousInsertion = null;
        while (lo < size) {
            Match match = SVNXDeltaAlgorithm.findMatch(aMatchesTable, bAdler, a, aLength, b, bLength, lo, previousInsertion);
            if (match == null) {
                if (previousInsertion != null && previousInsertion.length > 0) {
                    ++previousInsertion.length;
                } else {
                    previousInsertion = new Match(lo, 1);
                }
            } else {
                if (previousInsertion != null && previousInsertion.length > 0) {
                    this.copyFromNewData(b, previousInsertion.position, previousInsertion.length);
                    previousInsertion = null;
                }
                this.copyFromSource(match.position, match.length);
            }
            int advance = match != null ? match.advance : 1;
            int next = lo;
            while (next < lo + advance) {
                bAdler.remove(b[next]);
                if (next + 64 < bLength) {
                    bAdler.add(b[next + 64]);
                }
                ++next;
            }
            lo += advance;
        }
        if (previousInsertion != null && previousInsertion.length > 0) {
            this.copyFromNewData(b, previousInsertion.position, previousInsertion.length);
            previousInsertion = null;
        }
    }

    private static Match findMatch(Map matchesTable, PseudoAdler32 checksum, byte[] a, int aLength, byte[] b, int bLength, int bPos, Match previousInsertion) {
        Match existingMatch = (Match)matchesTable.get(new Integer(checksum.getValue()));
        if (existingMatch == null) {
            return null;
        }
        if (!SVNXDeltaAlgorithm.equals(a, aLength, existingMatch.position, existingMatch.length, b, bLength, bPos)) {
            return null;
        }
        existingMatch = new Match(existingMatch.position, existingMatch.length);
        existingMatch.advance = existingMatch.length;
        while (existingMatch.position + existingMatch.length < aLength && bPos + existingMatch.advance < bLength && a[existingMatch.position + existingMatch.length] == b[bPos + existingMatch.advance]) {
            ++existingMatch.length;
            ++existingMatch.advance;
        }
        if (previousInsertion != null) {
            while (existingMatch.position > 0 && bPos > 0 && a[existingMatch.position - 1] == b[bPos - 1] && previousInsertion.length != 0) {
                --previousInsertion.length;
                --bPos;
                --existingMatch.position;
                ++existingMatch.length;
            }
        }
        return existingMatch;
    }

    private static Map createMatchesTable(byte[] data, int dataLength, int blockLength, PseudoAdler32 adler32) {
        SVNHashMap matchesTable = new SVNHashMap();
        int i = 0;
        while (i < dataLength) {
            int length = i + blockLength >= dataLength ? dataLength - i : blockLength;
            adler32.add(data, i, length);
            Integer checksum = new Integer(adler32.getValue());
            if (!matchesTable.containsKey(checksum)) {
                matchesTable.put(checksum, new Match(i, length));
            }
            adler32.reset();
            i += blockLength;
        }
        return matchesTable;
    }

    private static boolean equals(byte[] a, int aLength, int aPos, int length, byte[] b, int bLength, int bPos) {
        if (aPos + length - 1 > aLength || bPos + length > bLength) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (a[aPos + i] != b[bPos + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class Match {
        public int position;
        public int length;
        public int advance;

        public Match(int p, int l) {
            this.position = p;
            this.length = l;
        }
    }

    private static class PseudoAdler32 {
        private int myS1;
        private int myS2;
        private int myLength;

        public PseudoAdler32() {
            this.reset();
        }

        public void add(byte b) {
            int z = b & 0xFF;
            this.myS1 += z;
            this.myS1 &= ADLER32_MASK;
            this.myS2 += this.myS1;
            this.myS2 &= ADLER32_MASK;
            ++this.myLength;
        }

        public void remove(byte b) {
            int z = b & 0xFF;
            this.myS1 -= z;
            this.myS1 &= ADLER32_MASK;
            this.myS2 -= this.myLength * z + 1;
            this.myS2 &= ADLER32_MASK;
            --this.myLength;
        }

        public void add(byte[] data, int offset, int length) {
            int i = offset;
            while (i < offset + length) {
                this.add(data[i]);
                ++i;
            }
        }

        public int getValue() {
            return this.myS2 << 16 | this.myS1;
        }

        public void reset() {
            this.myS1 = 1;
            this.myS2 = 0;
            this.myLength = 0;
        }
    }
}

