/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVLogHandler
extends BasicDAVHandler {
    private static final DAVElement LOG_ITEM = DAVElement.getElement("svn:", "log-item");
    private static final DAVElement ADDED_PATH = DAVElement.getElement("svn:", "added-path");
    private static final DAVElement DELETED_PATH = DAVElement.getElement("svn:", "deleted-path");
    private static final DAVElement MODIFIED_PATH = DAVElement.getElement("svn:", "modified-path");
    private static final DAVElement REPLACED_PATH = DAVElement.getElement("svn:", "replaced-path");
    private static final DAVElement HAS_CHILDREN = DAVElement.getElement("svn:", "has-children");
    private static final DAVElement REVPROP = DAVElement.getElement("svn:", "revprop");
    private static final DAVElement SUBTRACTIVE_MERGE = DAVElement.getElement("svn:", "subtractive-merge");
    private ISVNLogEntryHandler myLogEntryHandler;
    private long myRevision;
    private Map myPaths;
    private String myAuthor;
    private Date myDate;
    private String myComment;
    private SVNLogEntryPath myPath;
    private long myCount;
    private long myLimit;
    private int myNestLevel;
    private boolean myIsCompatibleMode;
    private boolean myHasChildren;
    private boolean myIsWantAuthor;
    private boolean myIsWantDate;
    private boolean myIsWantComment;
    private boolean myIsWantCustomRevProps;
    private String myRevPropName;
    private SVNProperties myRevProps;
    private boolean myIsSubtractiveMerge;

    public static StringBuffer generateLogRequest(StringBuffer xmlBuffer, long startRevision, long endRevision, boolean includeChangedPaths, boolean strictNodes, boolean includeMergedRevisions, String[] revPropNames, long limit, String[] paths) {
        int i;
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "log-report", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        if (startRevision >= 0L) {
            SVNXMLUtil.openCDataTag("S", "start-revision", String.valueOf(startRevision), xmlBuffer);
        }
        if (endRevision >= 0L) {
            SVNXMLUtil.openCDataTag("S", "end-revision", String.valueOf(endRevision), xmlBuffer);
        }
        if (limit > 0L) {
            SVNXMLUtil.openCDataTag("S", "limit", String.valueOf(limit), xmlBuffer);
        }
        if (includeChangedPaths) {
            SVNXMLUtil.openXMLTag("S", "discover-changed-paths", 4, null, xmlBuffer);
        }
        if (strictNodes) {
            SVNXMLUtil.openXMLTag("S", "strict-node-history", 4, null, xmlBuffer);
        }
        if (includeMergedRevisions) {
            SVNXMLUtil.openXMLTag("S", "include-merged-revisions", 4, null, xmlBuffer);
        }
        if (revPropNames != null) {
            i = 0;
            while (i < revPropNames.length) {
                String revPropName = revPropNames[i];
                SVNXMLUtil.openCDataTag("S", "revprop", revPropName, xmlBuffer);
                ++i;
            }
        } else {
            SVNXMLUtil.openXMLTag("S", "all-revprops", 4, null, xmlBuffer);
        }
        i = 0;
        while (i < paths.length) {
            SVNXMLUtil.openCDataTag("S", "path", paths[i], xmlBuffer);
            ++i;
        }
        SVNXMLUtil.addXMLFooter("S", "log-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVLogHandler(ISVNLogEntryHandler handler, long limit, String[] revPropNames) {
        this.myLogEntryHandler = handler;
        this.myRevision = -1L;
        this.myCount = 0L;
        this.myLimit = limit;
        if (revPropNames != null && revPropNames.length > 0) {
            int i = 0;
            while (i < revPropNames.length) {
                String revPropName = revPropNames[i];
                if ("svn:author".equals(revPropName)) {
                    this.myIsWantAuthor = true;
                } else if ("svn:log".equals(revPropName)) {
                    this.myIsWantComment = true;
                } else if ("svn:date".equals(revPropName)) {
                    this.myIsWantDate = true;
                } else {
                    this.myIsWantCustomRevProps = true;
                }
                ++i;
            }
        } else {
            this.myIsWantDate = true;
            this.myIsWantComment = true;
            this.myIsWantAuthor = true;
        }
        this.init();
    }

    public boolean isWantCustomRevprops() {
        return this.myIsWantCustomRevProps;
    }

    public boolean isCompatibleMode() {
        return this.myIsCompatibleMode;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        char type = '\u0000';
        String copyPath = null;
        long copyRevision = -1L;
        if (element == REVPROP) {
            this.myRevPropName = attrs.getValue("name");
            if (this.myRevPropName == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in revprop element");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
        } else if (element == HAS_CHILDREN) {
            this.myHasChildren = true;
        } else if (element == SUBTRACTIVE_MERGE) {
            this.myIsSubtractiveMerge = true;
        }
        if (element == ADDED_PATH || element == REPLACED_PATH) {
            type = element == ADDED_PATH ? (char)'A' : 'R';
            copyPath = attrs.getValue("copyfrom-path");
            String copyRevisionStr = attrs.getValue("copyfrom-rev");
            if (copyPath != null && copyRevisionStr != null) {
                try {
                    copyRevision = Long.parseLong(copyRevisionStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (element == MODIFIED_PATH) {
            type = 'M';
        } else if (element == DELETED_PATH) {
            type = 'D';
        }
        if (type != '\u0000') {
            SVNNodeKind nodeKind = SVNNodeKind.UNKNOWN;
            String nodeKindStr = attrs.getValue("node-kind");
            if (nodeKindStr != null) {
                nodeKind = SVNNodeKind.parseKind(nodeKindStr);
            }
            this.myPath = new SVNLogEntryPath(null, type, copyPath, copyRevision, nodeKind);
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == LOG_ITEM) {
            if (this.myNestLevel == 0) {
                ++this.myCount;
            }
            if (this.myLimit > 0L && this.myCount > this.myLimit && this.myNestLevel == 0) {
                this.myIsCompatibleMode = true;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN);
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            if (this.myLogEntryHandler != null) {
                if (this.myPaths == null) {
                    this.myPaths = new SVNHashMap();
                }
                if (this.myRevProps == null) {
                    this.myRevProps = new SVNProperties();
                }
                if (this.myAuthor != null) {
                    this.myRevProps.put("svn:author", this.myAuthor);
                }
                if (this.myComment != null) {
                    this.myRevProps.put("svn:log", this.myComment);
                }
                if (this.myDate != null) {
                    this.myRevProps.put("svn:date", SVNDate.formatDate(this.myDate));
                }
                SVNLogEntry logEntry = new SVNLogEntry(this.myPaths, this.myRevision, this.myRevProps, this.myHasChildren);
                logEntry.setSubtractiveMerge(this.myIsSubtractiveMerge);
                this.myLogEntryHandler.handleLogEntry(logEntry);
                if (logEntry.hasChildren()) {
                    ++this.myNestLevel;
                }
                if (logEntry.getRevision() < 0L) {
                    this.myNestLevel = this.myNestLevel <= 0 ? 0 : this.myNestLevel - 1;
                }
            }
            this.myPaths = null;
            this.myRevProps = null;
            this.myRevision = -1L;
            this.myAuthor = null;
            this.myDate = null;
            this.myComment = null;
            this.myRevPropName = null;
            this.myHasChildren = false;
            this.myIsSubtractiveMerge = false;
        } else if (element == DAVElement.VERSION_NAME && cdata != null) {
            try {
                this.myRevision = Long.parseLong(cdata.toString());
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        } else if (element == REVPROP) {
            if (this.myRevProps == null) {
                this.myRevProps = new SVNProperties();
            }
            if (this.myRevPropName != null && cdata != null) {
                this.myRevProps.put(this.myRevPropName, cdata.toString());
            }
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME && cdata != null) {
            if (this.myIsWantAuthor) {
                this.myAuthor = cdata.toString();
            }
        } else if (element == DAVElement.COMMENT && cdata != null) {
            if (this.myIsWantComment) {
                this.myComment = cdata.toString();
            }
        } else if (element == DAVElement.DATE && cdata != null) {
            if (this.myIsWantDate) {
                this.myDate = SVNDate.parseDate(cdata.toString());
            }
        } else if (element == ADDED_PATH || element == MODIFIED_PATH || element == REPLACED_PATH || element == DELETED_PATH) {
            if (this.myPath != null && cdata != null) {
                if (this.myPaths == null) {
                    this.myPaths = new SVNHashMap();
                }
                this.myPath.setPath(cdata.toString());
                String path = this.myPath.getPath();
                this.myPath.setPath(path);
                this.myPaths.put(this.myPath.getPath(), this.myPath);
            }
            this.myPath = null;
        }
    }

    public long getEntriesCount() {
        return this.myCount;
    }
}

