/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.ISVNSSLPasspharsePromptSupport;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTTPSSLKeyManager
implements X509KeyManager {
    private final ISVNAuthenticationManager authenticationManager;
    private final String realm;
    private final SVNURL url;
    private KeyManager[] myKeyManagers;
    private SVNSSLAuthentication myAuthentication;
    private Exception myException;
    private String chooseAlias = null;
    private boolean myIsFirstRequest = true;

    public static KeyManager[] loadClientCertificate() throws SVNException {
        Provider pjacapi = Security.getProvider("CAPI");
        Provider pmscapi = Security.getProvider("SunMSCAPI");
        KeyManager[] result = null;
        SVNDebugLog.getDefaultLog().logError(SVNLogType.CLIENT, "using mscapi");
        KeyStore keyStore = null;
        try {
            if (pmscapi != null) {
                pmscapi.setProperty("Signature.SHA1withRSA", "sun.security.mscapi.RSASignature$SHA1");
                keyStore = KeyStore.getInstance("Windows-MY", pmscapi);
            } else if (pjacapi != null) {
                keyStore = KeyStore.getInstance("CAPI");
            }
            if (keyStore != null) {
                keyStore.load(null, null);
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Problems, when connecting with ms capi! " + th.getMessage(), null, 0, th), th);
        }
        KeyManagerFactory kmf = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                if (kmf != null) {
                    kmf.init(keyStore, null);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "MS Capi error: " + th.getMessage()), th);
            }
        }
        return result;
    }

    public static KeyManager[] loadClientCertificate(File clientCertFile, String clientCertPassword) throws SVNException {
        return HTTPSSLKeyManager.loadClientCertificate(clientCertFile, clientCertPassword != null ? clientCertPassword.toCharArray() : null);
    }

    public static KeyManager[] loadClientCertificate(byte[] clientCert, char[] clientCertPassword) throws SVNException {
        if (clientCertPassword == null || clientCertPassword.length == 0) {
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "No client certificate passphrase supplied (did you forget to specify?).\nNote that client certificates with empty passphrases can''t be used. In this case please re-create the certificate with a passphrase."));
        }
        KeyManager[] result = null;
        KeyStore keyStore = null;
        ByteArrayInputStream is = new ByteArrayInputStream(clientCert);
        try {
            try {
                keyStore = KeyStore.getInstance("PKCS12");
                if (keyStore != null) {
                    keyStore.load(is, clientCertPassword);
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage(), null, 0, th), th);
            }
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        KeyManagerFactory kmf = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, clientCertPassword);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage()), th);
            }
        }
        return result;
    }

    public static KeyManager[] loadClientCertificate(File clientCertFile, char[] clientCertPassword) throws SVNException {
        if (clientCertPassword == null || clientCertPassword.length == 0) {
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "No client certificate passphrase supplied (did you forget to specify?).\nNote that client certificates with empty passphrases can''t be used. In this case please re-create the certificate with a passphrase."));
        }
        KeyManager[] result = null;
        KeyStore keyStore = null;
        if (clientCertFile != null && clientCertFile.getName().startsWith("MSCAPI")) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.CLIENT, "using mscapi");
            try {
                keyStore = KeyStore.getInstance("Windows-MY");
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "using my windows store");
                if (keyStore != null) {
                    keyStore.load(null, null);
                }
                KeyManagerFactory kmf = null;
                if (keyStore != null && (kmf = KeyManagerFactory.getInstance("SunX509")) != null) {
                    kmf.init(keyStore, clientCertPassword);
                    result = kmf.getKeyManagers();
                }
                return result;
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "loadClientCertificate ms capi with file - should not be called: " + th.getMessage(), null, 0, th), th);
            }
        }
        InputStream is = SVNFileUtil.openFileForReading(clientCertFile, SVNLogType.NETWORK);
        try {
            try {
                keyStore = KeyStore.getInstance("PKCS12");
                if (keyStore != null) {
                    keyStore.load(is, clientCertPassword);
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage(), null, 0, th), th);
            }
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        KeyManagerFactory kmf = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, clientCertPassword);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage()), th);
            }
        }
        return result;
    }

    public KeyManager[] loadClientCertificate(SVNSSLAuthentication sslAuthentication) throws SVNException {
        char[] clientCertPassword = sslAuthentication.getPasswordValue();
        String clientCertPath = sslAuthentication.getCertificatePath();
        File clientCertFile = sslAuthentication.getCertificateFile();
        byte[] clientCertData = sslAuthentication.getCertificate();
        char[] passphrase = clientCertPassword == null ? new char[]{} : clientCertPassword;
        String realm = clientCertPath;
        SVNAuthentication auth = null;
        KeyManager[] result = null;
        KeyStore keyStore = null;
        if (clientCertFile != null && clientCertFile.getName().startsWith("MSCAPI")) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.CLIENT, "using mscapi");
            try {
                keyStore = KeyStore.getInstance("Windows-MY");
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "using my windows store");
                if (keyStore != null) {
                    keyStore.load(null, null);
                }
                KeyManagerFactory kmf = null;
                if (keyStore != null && (kmf = KeyManagerFactory.getInstance("SunX509")) != null) {
                    kmf.init(keyStore, passphrase);
                    result = kmf.getKeyManagers();
                }
                return result;
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "loadClientCertificate ms capi with file - should not be called: " + th.getMessage(), null, 0, th), th);
            }
        }
        while (true) {
            try {
                InputStream is = clientCertData != null ? new ByteArrayInputStream(clientCertData) : SVNFileUtil.openFileForReading(clientCertFile, SVNLogType.NETWORK);
                try {
                    keyStore = KeyStore.getInstance("PKCS12");
                    if (keyStore != null) {
                        keyStore.load(is, passphrase);
                    }
                }
                finally {
                    SVNFileUtil.closeFile(is);
                }
                if (auth != null) {
                    BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.ssl.client-passphrase", realm, null, auth, this.url, this.authenticationManager);
                    break;
                }
                BasicAuthenticationManager.acknowledgeAuthentication(true, "svn.ssl.client-passphrase", clientCertPath, null, SVNPasswordAuthentication.newInstance("", clientCertPassword, sslAuthentication.isStorageAllowed(), sslAuthentication.getURL(), false), this.url, this.authenticationManager);
            }
            catch (IOException io) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, io);
                if (auth != null) {
                    BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssl.client-passphrase", realm, SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, io.getMessage()), auth, this.url, this.authenticationManager);
                    auth = this.authenticationManager.getNextAuthentication("svn.ssl.client-passphrase", realm, sslAuthentication.getURL());
                } else {
                    auth = this.authenticationManager.getFirstAuthentication("svn.ssl.client-passphrase", realm, sslAuthentication.getURL());
                }
                if (auth instanceof SVNPasswordAuthentication) {
                    passphrase = ((SVNPasswordAuthentication)auth).getPasswordValue();
                    continue;
                }
                auth = null;
                SVNErrorManager.cancel("authentication cancelled", SVNLogType.NETWORK);
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage(), null, 0, th), th);
            }
            break;
        }
        KeyManagerFactory kmf = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, passphrase);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNAuthenticationException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage()), th);
            }
        }
        return result;
    }

    public HTTPSSLKeyManager(ISVNAuthenticationManager authenticationManager, String realm, SVNURL url) {
        this.authenticationManager = authenticationManager;
        this.realm = realm;
        this.url = url;
    }

    @Override
    public String[] getClientAliases(String location, Principal[] principals) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager keyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String[] clientAliases = keyManager.getClientAliases(location, principals);
            if (clientAliases == null) continue;
            return clientAliases;
        }
        return null;
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        if (!this.initializeNoException()) {
            return null;
        }
        if (this.chooseAlias != null) {
            return this.chooseAlias;
        }
        for (X509KeyManager keyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String clientAlias = keyManager.chooseClientAlias(strings, principals, socket);
            if (clientAlias == null) continue;
            return clientAlias;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String location, Principal[] principals) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager keyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String[] serverAliases = keyManager.getServerAliases(location, principals);
            if (serverAliases == null) continue;
            return serverAliases;
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String location, Principal[] principals, Socket socket) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager keyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            String serverAlias = keyManager.chooseServerAlias(location, principals, socket);
            if (serverAlias == null) continue;
            return serverAlias;
        }
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String location) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager keyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            X509Certificate[] certificateChain = keyManager.getCertificateChain(location);
            if (certificateChain == null) continue;
            return certificateChain;
        }
        return null;
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        if (!this.initializeNoException()) {
            return null;
        }
        for (X509KeyManager keyManager : HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers)) {
            PrivateKey privateKey = keyManager.getPrivateKey(string);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    public Exception getException() {
        return this.myException;
    }

    public void acknowledgeAndClearAuthentication(SVNErrorMessage errorMessage) throws SVNException {
        if (this.myAuthentication != null) {
            BasicAuthenticationManager.acknowledgeAuthentication(errorMessage == null, "svn.ssl.client-passphrase", this.realm, errorMessage, this.myAuthentication, this.url, this.authenticationManager);
        }
        if (errorMessage != null) {
            this.myKeyManagers = null;
            this.chooseAlias = null;
        } else {
            this.myAuthentication = null;
            this.myIsFirstRequest = true;
        }
        Exception exception = this.myException;
        this.myException = null;
        if (exception instanceof SVNException) {
            throw (SVNException)exception;
        }
        if (exception != null) {
            throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE, (Throwable)exception);
        }
    }

    public boolean isInitialized() {
        return this.myKeyManagers != null;
    }

    private boolean initializeNoException() {
        try {
            boolean result = this.initialize();
            this.myException = null;
            return result;
        }
        catch (Exception exception) {
            this.myException = exception;
            return false;
        }
    }

    private boolean initialize() throws SVNException {
        KeyManager[] keyManagers;
        if (this.myKeyManagers != null) {
            return true;
        }
        while (true) {
            if (this.myIsFirstRequest) {
                this.myAuthentication = (SVNSSLAuthentication)this.authenticationManager.getFirstAuthentication("svn.ssl.client-passphrase", this.realm, this.url);
                this.myIsFirstRequest = false;
            } else {
                this.myAuthentication = (SVNSSLAuthentication)this.authenticationManager.getNextAuthentication("svn.ssl.client-passphrase", this.realm, this.url);
            }
            if (this.myAuthentication == null) {
                SVNErrorManager.cancel("SSL authentication with client certificate cancelled", SVNLogType.NETWORK);
            }
            try {
                if (HTTPSSLKeyManager.isMSCAPI(this.myAuthentication)) {
                    keyManagers = HTTPSSLKeyManager.loadClientCertificate();
                    this.chooseAlias = this.myAuthentication.getAlias();
                    break;
                }
                if (this.authenticationManager instanceof ISVNSSLPasspharsePromptSupport && ((ISVNSSLPasspharsePromptSupport)((Object)this.authenticationManager)).isSSLPassphrasePromtSupported()) {
                    keyManagers = this.loadClientCertificate(this.myAuthentication);
                    break;
                }
                if (this.myAuthentication.getCertificate() != null) {
                    keyManagers = HTTPSSLKeyManager.loadClientCertificate(this.myAuthentication.getCertificate(), this.myAuthentication.getPasswordValue());
                    break;
                }
                keyManagers = HTTPSSLKeyManager.loadClientCertificate(this.myAuthentication.getCertificateFile(), this.myAuthentication.getPasswordValue());
            }
            catch (SVNAuthenticationException authenticationException) {
                throw authenticationException;
            }
            catch (SVNCancelException cancel) {
                throw cancel;
            }
            catch (SVNException ex) {
                SVNErrorMessage sslErr = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "Failed to load SSL client certificate: ''{0}''", new Object[]{ex.getMessage()}, 0, ex.getCause());
                BasicAuthenticationManager.acknowledgeAuthentication(false, "svn.ssl.client-passphrase", this.realm, sslErr, this.myAuthentication, this.url, this.authenticationManager);
                continue;
            }
            break;
        }
        this.myKeyManagers = keyManagers;
        return true;
    }

    private static List<X509KeyManager> getX509KeyManagers(KeyManager[] keyManagers) {
        ArrayList<X509KeyManager> x509KeyManagers = new ArrayList<X509KeyManager>();
        int index = 0;
        while (index < keyManagers.length) {
            KeyManager keyManager = keyManagers[index];
            if (keyManager instanceof X509KeyManager) {
                x509KeyManagers.add((X509KeyManager)keyManager);
            }
            ++index;
        }
        return x509KeyManagers;
    }

    private static boolean isMSCAPI(SVNSSLAuthentication sslAuthentication) {
        return sslAuthentication != null && "MSCAPI".equals(sslAuthentication.getSSLKind());
    }
}

