/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import org.tmatesoft.svn.core.io.SVNRepository;

public interface IHTTPConnectionFactory {
    public static final IHTTPConnectionFactory DEFAULT = new IHTTPConnectionFactory(){

        public IHTTPConnection createHTTPConnection(SVNRepository repository) throws SVNException {
            File spoolDirectory;
            String charset = System.getProperty("svnkit.http.encoding", "UTF-8");
            String spoolPath = System.getProperty("svnkit.http.spoolDirectory", null);
            File file = spoolDirectory = spoolPath != null ? new File(spoolPath) : null;
            if (spoolDirectory != null) {
                spoolDirectory.mkdirs();
                if (!spoolDirectory.isDirectory()) {
                    spoolDirectory = null;
                }
            }
            return new HTTPConnection(repository, charset, spoolDirectory, spoolDirectory != null);
        }

        public boolean useSendAllForDiff(SVNRepository repository) throws SVNException {
            return false;
        }
    };

    public IHTTPConnection createHTTPConnection(SVNRepository var1) throws SVNException;

    public boolean useSendAllForDiff(SVNRepository var1) throws SVNException;
}

