/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SVNHashMap
implements Map,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Object NULL_KEY = new Object();
    private static final int INITIAL_CAPACITY = 16;
    private static boolean ourIsCompatibilityMode = Boolean.getBoolean("svnkit.compatibleHash");
    private transient TableEntry[] myTable;
    private transient int myEntryCount;
    private transient int myModCount;
    private volatile transient Set myKeySet;
    private volatile transient Set myEntrySet;
    private volatile transient Collection myValueCollection;

    public SVNHashMap() {
        this(null);
    }

    public SVNHashMap(Map map) {
        this.init();
        this.putAll(map);
    }

    protected void init() {
        this.myTable = new TableEntry[16];
        this.myEntryCount = 0;
    }

    public void clear() {
        Arrays.fill(this.myTable, null);
        this.myEntryCount = 0;
        ++this.myModCount;
    }

    public boolean isEmpty() {
        return this.myEntryCount == 0;
    }

    public boolean containsKey(Object key) {
        if (this.isEmpty()) {
            return false;
        }
        key = key == null ? NULL_KEY : key;
        int hash = SVNHashMap.hashCode(key);
        int index = this.indexForHash(hash);
        TableEntry entry = this.myTable[index];
        while (entry != null) {
            if (entry.hash == hash && SVNHashMap.eq(key, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (this.isEmpty()) {
            return false;
        }
        if (value == null) {
            return this.containsNullValue();
        }
        int i = 0;
        while (i < this.myTable.length) {
            TableEntry entry = this.myTable[i];
            while (entry != null) {
                if (value.equals(entry.getValue())) {
                    return true;
                }
                entry = entry.next;
            }
            ++i;
        }
        return false;
    }

    private boolean containsNullValue() {
        int i = 0;
        while (i < this.myTable.length) {
            TableEntry entry = this.myTable[i];
            while (entry != null) {
                if (entry.getValue() == null) {
                    return true;
                }
                entry = entry.next;
            }
            ++i;
        }
        return false;
    }

    public Object get(Object key) {
        key = key == null ? NULL_KEY : key;
        int hash = SVNHashMap.hashCode(key);
        int index = this.indexForHash(hash);
        TableEntry entry = this.myTable[index];
        while (entry != null) {
            if (hash == entry.hash && SVNHashMap.eq(key, entry.key)) {
                return entry.getValue();
            }
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.myEntryCount;
    }

    public Object put(Object key, Object value) {
        key = key == null ? NULL_KEY : key;
        int hash = SVNHashMap.hashCode(key);
        int index = this.indexForHash(hash);
        TableEntry entry = this.myTable[index];
        TableEntry previousEntry = null;
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                ++this.myModCount;
                return entry.setValue(value);
            }
            previousEntry = entry;
            entry = entry.next;
        }
        TableEntry newEntry = this.createTableEntry(key, value, hash);
        if (previousEntry != null) {
            previousEntry.next = newEntry;
        } else {
            this.myTable[index] = newEntry;
        }
        ++this.myEntryCount;
        ++this.myModCount;
        if (this.myEntryCount >= this.myTable.length) {
            this.resize(this.myTable.length * 2);
        }
        return null;
    }

    protected TableEntry createTableEntry(Object key, Object value, int hash) {
        return new TableEntry(key, value, hash);
    }

    public Object remove(Object key) {
        if (this.isEmpty()) {
            return null;
        }
        key = key == null ? NULL_KEY : key;
        int hash = SVNHashMap.hashCode(key);
        int index = this.indexForHash(hash);
        TableEntry entry = this.myTable[index];
        TableEntry previousEntry = null;
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                if (previousEntry != null) {
                    previousEntry.next = entry.next;
                } else {
                    this.myTable[index] = entry.next;
                }
                --this.myEntryCount;
                ++this.myModCount;
                return entry.getValue();
            }
            previousEntry = entry;
            entry = entry.next;
        }
        return null;
    }

    public void putAll(Map t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        if (this.myEntryCount + t.size() >= this.myTable.length) {
            this.resize((this.myEntryCount + t.size()) * 2);
        }
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set keySet() {
        if (this.myKeySet == null) {
            this.myKeySet = new KeySet();
        }
        return this.myKeySet;
    }

    public Set entrySet() {
        if (this.myEntrySet == null) {
            this.myEntrySet = new EntrySet();
        }
        return this.myEntrySet;
    }

    public Collection values() {
        if (this.myValueCollection == null) {
            this.myValueCollection = new ValueCollection();
        }
        return this.myValueCollection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            Iterator i = this.entrySet().iterator();
            while (true) {
                if (!i.hasNext()) {
                    return true;
                }
                Map.Entry e = (Map.Entry)i.next();
                Object key = e.getKey();
                Object value = e.getValue();
                if (value == null) {
                    if (t.get(key) != null) return false;
                    if (t.containsKey(key)) continue;
                    return false;
                }
                if (!value.equals(t.get(key))) break;
            }
            return false;
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        SVNHashMap result = new SVNHashMap();
        result.myTable = new TableEntry[this.myTable.length];
        result.myEntryCount = this.myEntryCount;
        result.myModCount = this.myModCount;
        result.putAll((Map)this);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        i = this.myEntryCount > 0 ? this.entrySet().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.myTable.length);
        s.writeInt(this.myEntryCount);
        if (i != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            e = (Map.Entry)i.next();
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
lbl10:
            // 2 sources

            ** while (i.hasNext())
        }
lbl11:
        // 1 sources

    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.myTable = new TableEntry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            ++i;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = (Map.Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append((Object)(key == this ? "(this Map)" : key));
            buf.append("=");
            buf.append((Object)(value == this ? "(this Map)" : value));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private int indexForHash(int hash) {
        return this.myTable.length - 1 & hash;
    }

    private static int hashCode(Object key) {
        if (ourIsCompatibilityMode && String.class == key.getClass()) {
            int hash = 0;
            String str = (String)key;
            int i = 0;
            while (i < str.length()) {
                hash = hash * 33 + str.charAt(i);
                ++i;
            }
            return hash;
        }
        if (key.getClass() == File.class) {
            return SVNHashMap.hashCode(((File)key).getPath());
        }
        return key.hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private void resize(int newSize) {
        oldTable = this.myTable;
        this.myTable = new TableEntry[newSize];
        i = 0;
        while (i < oldTable.length) {
            oldEntry = oldTable[i];
            while (oldEntry != null) {
                block3: {
                    index = this.indexForHash(TableEntry.access$1(oldEntry));
                    newEntry = this.myTable[index];
                    if (newEntry != null) ** GOTO lbl13
                    this.myTable[index] = oldEntry;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        newEntry = TableEntry.access$0(newEntry);
lbl13:
                        // 2 sources

                        ** while (TableEntry.access$0((TableEntry)newEntry) != null)
                    }
lbl14:
                    // 1 sources

                    TableEntry.access$3(newEntry, oldEntry);
                }
                nextEntry = TableEntry.access$0(oldEntry);
                TableEntry.access$3(oldEntry, null);
                oldEntry = nextEntry;
            }
            ++i;
        }
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a.equals(b);
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new TableIterator();
        }

        public int size() {
            return SVNHashMap.this.myEntryCount;
        }

        public boolean contains(Object o) {
            Map.Entry entry;
            if (o instanceof Map.Entry && SVNHashMap.this.containsKey((entry = (Map.Entry)o).getKey())) {
                Object value = SVNHashMap.this.get(entry.getKey());
                if (value == null) {
                    return entry.getValue() == null;
                }
                return value.equals(entry.getValue());
            }
            return false;
        }

        public boolean remove(Object o) {
            if (this.contains(o)) {
                Map.Entry entry = (Map.Entry)o;
                return SVNHashMap.this.remove(entry.getKey()) != null;
            }
            return false;
        }

        public void clear() {
            SVNHashMap.this.clear();
        }
    }

    private class KeyIterator
    extends TableIterator {
        private KeyIterator() {
        }

        public Object next() {
            TableEntry next = (TableEntry)super.next();
            return next.getKey();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return SVNHashMap.this.myEntryCount;
        }

        public boolean contains(Object o) {
            return SVNHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return SVNHashMap.this.remove(o) != null;
        }

        public void clear() {
            SVNHashMap.this.clear();
        }
    }

    protected static class TableEntry
    implements Map.Entry {
        private TableEntry next;
        private Object key;
        private Object value;
        private int hash;

        protected TableEntry() {
        }

        public TableEntry(Object key, Object value, int hash) {
            this.init(key, value, hash);
        }

        protected void init(Object key, Object value, int hash) {
            this.key = key;
            this.setValue(value);
            this.hash = hash;
        }

        public Object setValue(Object value) {
            Object oldValue = this.getValue();
            this.value = value;
            return oldValue;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getKey() {
            return this.key == NULL_KEY ? null : this.key;
        }

        public int hashCode() {
            return (this.key == NULL_KEY ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }
    }

    private class TableIterator
    implements Iterator {
        private int index = 0;
        private TableEntry entry = null;
        private TableEntry previous;
        private int modCount;

        public TableIterator() {
            this.modCount = SVNHashMap.this.myModCount;
            while (this.index < SVNHashMap.this.myTable.length && this.entry == null) {
                this.entry = SVNHashMap.this.myTable[this.index];
                ++this.index;
            }
        }

        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            if (SVNHashMap.this.myModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.entry == null) {
                throw new NoSuchElementException();
            }
            this.previous = this.entry;
            this.entry = this.entry.next;
            while (this.entry == null && this.index < SVNHashMap.this.myTable.length) {
                this.entry = SVNHashMap.this.myTable[this.index];
                ++this.index;
            }
            return this.previous;
        }

        public void remove() {
            if (SVNHashMap.this.myModCount != this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            SVNHashMap.this.remove(this.previous.getKey());
            this.previous = null;
            this.modCount = SVNHashMap.this.myModCount;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return SVNHashMap.this.myEntryCount;
        }

        public boolean contains(Object o) {
            return SVNHashMap.this.containsValue(o);
        }

        public void clear() {
            SVNHashMap.this.clear();
        }
    }

    private class ValueIterator
    extends TableIterator {
        private ValueIterator() {
        }

        public Object next() {
            TableEntry next = (TableEntry)super.next();
            return next.getValue();
        }
    }
}

