/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceException;
import de.regnis.q.sequence.line.QSequenceLine;
import de.regnis.q.sequence.line.QSequenceLineCache;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequenceList;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;

public class FSMergerBySequence {
    public static final String DEFAULT_EOL = System.getProperty("line.separator");
    public static final int NOT_MODIFIED = 0;
    public static final int MERGED = 4;
    public static final int CONFLICTED = 2;
    private final byte[] myConflictStart;
    private final byte[] myConflictSeparator;
    private final byte[] myConflictEnd;
    private final byte[] myOriginalMarker;

    public FSMergerBySequence(byte[] conflictStart, byte[] conflictSeparator, byte[] conflictEnd) {
        this(conflictStart, conflictSeparator, conflictEnd, null);
    }

    public FSMergerBySequence(byte[] conflictStart, byte[] conflictSeparator, byte[] conflictEnd, byte[] originalMarker) {
        this.myConflictStart = conflictStart;
        this.myConflictSeparator = conflictSeparator;
        this.myConflictEnd = conflictEnd;
        this.myOriginalMarker = originalMarker;
    }

    public int merge(QSequenceLineRAData baseData, QSequenceLineRAData localData, QSequenceLineRAData latestData, SVNDiffOptions options, OutputStream result, SVNDiffConflictChoiceStyle style) throws IOException {
        QSequenceLineResult latestResult;
        QSequenceLineResult localResult;
        style = style == null ? SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST : style;
        QSequenceLineTeeSimplifier mySimplifer = this.createSimplifier(options);
        try {
            localResult = QSequenceLineMedia.createBlocks((QSequenceLineRAData)baseData, (QSequenceLineRAData)localData, (QSequenceLineSimplifier)mySimplifer);
            latestResult = QSequenceLineMedia.createBlocks((QSequenceLineRAData)baseData, (QSequenceLineRAData)latestData, (QSequenceLineSimplifier)mySimplifer);
        }
        catch (QSequenceException ex) {
            throw new IOException(ex.getMessage());
        }
        try {
            QSequenceLineCache baseLines = localResult.getLeftCache();
            QSequenceLineCache localLines = localResult.getRightCache();
            QSequenceLineCache latestLines = latestResult.getRightCache();
            FSMergerBySequenceList local = new FSMergerBySequenceList(localResult.getBlocks());
            FSMergerBySequenceList latest = new FSMergerBySequenceList(latestResult.getBlocks());
            List transformedLocalLines = this.transformLocalLines(localResult.getBlocks(), localLines);
            int baseLineIndex = -1;
            boolean conflict = false;
            boolean merged = false;
            boolean chooseOnlyConflicts = style == SVNDiffConflictChoiceStyle.CHOOSE_ONLY_CONFLICTS;
            OutputStream realResult = result;
            if (chooseOnlyConflicts) {
                result = SVNFileUtil.DUMMY_OUT;
            }
            while (local.hasCurrent() || latest.hasCurrent()) {
                if (local.hasCurrent() && latest.hasCurrent() && this.isEqualChange(local.current(), latest.current(), localLines, latestLines)) {
                    baseLineIndex = this.appendLines(result, local.current(), localLines, baseLineIndex, transformedLocalLines);
                    local.forward();
                    latest.forward();
                    continue;
                }
                if (local.hasCurrent() && latest.hasCurrent()) {
                    QSequenceDifferenceBlock localStartBlock = local.current();
                    QSequenceDifferenceBlock latestStartBlock = latest.current();
                    if (this.checkConflict(local, latest, localLines, latestLines, baseLines.getLineCount())) {
                        if (style == SVNDiffConflictChoiceStyle.CHOOSE_LATEST) {
                            baseLineIndex = this.createConflict(result, localStartBlock, local.current(), latestStartBlock, latest.current(), localLines, latestLines, baseLineIndex, transformedLocalLines, style);
                            local.forward();
                            latest.forward();
                            merged = true;
                            continue;
                        }
                        if (style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED) {
                            baseLineIndex = this.createConflict(result, localStartBlock, local.current(), latestStartBlock, latest.current(), localLines, latestLines, baseLineIndex, transformedLocalLines, style);
                            local.forward();
                            latest.forward();
                            merged = true;
                            continue;
                        }
                        if (style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST) {
                            baseLineIndex = this.createConflict(result, localStartBlock, local.current(), latestStartBlock, latest.current(), localLines, latestLines, baseLineIndex, transformedLocalLines, style);
                            local.forward();
                            latest.forward();
                            conflict = true;
                            continue;
                        }
                        if (style != SVNDiffConflictChoiceStyle.CHOOSE_ONLY_CONFLICTS) continue;
                        baseLineIndex = this.createOnlyConflictWithContext(realResult, localStartBlock, local.current(), latestStartBlock, latest.current(), localLines, latestLines, baseLines);
                        local.forward();
                        latest.forward();
                        conflict = true;
                        continue;
                    }
                }
                if (local.hasCurrent() && this.isBefore(local.current(), latest.hasCurrent() ? latest.current() : null)) {
                    baseLineIndex = this.appendLines(result, local.current(), localLines, baseLineIndex, transformedLocalLines);
                    local.forward();
                    merged = true;
                    continue;
                }
                if (!latest.hasCurrent()) continue;
                baseLineIndex = this.appendLines(result, latest.current(), latestLines, baseLineIndex, transformedLocalLines);
                latest.forward();
                merged = true;
            }
            this.appendTransformedLocalLines(baseLineIndex, baseLines.getLineCount(), transformedLocalLines, result);
            if (conflict) {
                return 2;
            }
            if (merged) {
                return 4;
            }
            return 0;
        }
        finally {
            latestResult.close();
            localResult.close();
        }
    }

    private List transformLocalLines(List blocks, QSequenceLineCache localLines) throws IOException {
        ArrayList<QSequenceLine> transformedLocalLines = new ArrayList<QSequenceLine>();
        FSMergerBySequenceList blockList = new FSMergerBySequenceList(blocks);
        int localIndex = 0;
        int baseIndex = 0;
        while (localIndex < localLines.getLineCount()) {
            int baseTo;
            if (blockList.hasCurrent()) {
                QSequenceDifferenceBlock block = blockList.current();
                baseTo = block.getLeftFrom() - 1;
            } else {
                baseTo = Integer.MAX_VALUE;
            }
            while (localIndex < localLines.getLineCount() && baseIndex <= baseTo) {
                transformedLocalLines.add(localLines.getLine(localIndex));
                ++localIndex;
                ++baseIndex;
            }
            if (!blockList.hasCurrent()) continue;
            int index = 0;
            while (index < blockList.current().getLeftSize()) {
                transformedLocalLines.add(null);
                ++index;
            }
            baseIndex += blockList.current().getLeftSize();
            localIndex += blockList.current().getRightSize();
            blockList.forward();
        }
        return transformedLocalLines;
    }

    private boolean isBefore(QSequenceDifferenceBlock block1, QSequenceDifferenceBlock block2) {
        return block1 != null && (block2 == null || block1.getLeftTo() < block2.getLeftFrom());
    }

    private boolean intersect(QSequenceDifferenceBlock block1, QSequenceDifferenceBlock block2, int baseLineCount) {
        int from1 = block1.getLeftFrom();
        int from2 = block2.getLeftFrom();
        int to1 = block1.getLeftTo();
        int to2 = block2.getLeftTo();
        if (to1 < from1) {
            if (to2 < from2) {
                return from1 == from2;
            }
            if (from1 == baseLineCount && to2 >= baseLineCount - 1) {
                return true;
            }
            return from1 >= from2 && from1 <= to2;
        }
        if (to2 < from2) {
            if (from2 == baseLineCount && to1 >= baseLineCount - 1) {
                return true;
            }
            return from2 >= from1 && from2 <= to1;
        }
        return from1 >= from2 && from1 <= to2 || from2 >= from1 && from2 <= to1;
    }

    private int appendLines(OutputStream result, QSequenceDifferenceBlock block, QSequenceLineCache changedLines, int baseLineIndex, List transformedLocalLines) throws IOException {
        this.appendTransformedLocalLines(baseLineIndex, block.getLeftFrom(), transformedLocalLines, result);
        int changedLineIndex = block.getRightFrom();
        while (changedLineIndex <= block.getRightTo()) {
            this.writeLine(result, changedLines.getLine(changedLineIndex));
            ++changedLineIndex;
        }
        return block.getLeftTo();
    }

    private boolean isEqualChange(QSequenceDifferenceBlock localBlock, QSequenceDifferenceBlock latestBlock, QSequenceLineCache localLines, QSequenceLineCache latestLines) throws IOException {
        if (localBlock.getLeftFrom() != latestBlock.getLeftFrom() || localBlock.getLeftTo() != latestBlock.getLeftTo()) {
            return false;
        }
        if (localBlock.getRightTo() - localBlock.getRightFrom() != latestBlock.getRightTo() - latestBlock.getRightFrom()) {
            return false;
        }
        int index = 0;
        while (index < localBlock.getRightTo() - localBlock.getRightFrom() + 1) {
            QSequenceLine latestLine;
            QSequenceLine localLine = localLines.getLine(localBlock.getRightFrom() + index);
            if (!localLine.equals((Object)(latestLine = latestLines.getLine(latestBlock.getRightFrom() + index)))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean checkConflict(FSMergerBySequenceList localChanges, FSMergerBySequenceList latestChanges, QSequenceLineCache localLines, QSequenceLineCache latestLines, int baseLineCount) throws IOException {
        boolean conflict = false;
        while (this.intersect(localChanges.current(), latestChanges.current(), baseLineCount) && !this.isEqualChange(localChanges.current(), latestChanges.current(), localLines, latestLines)) {
            conflict = true;
            if (localChanges.current().getLeftTo() <= latestChanges.current().getLeftTo()) {
                if (!localChanges.hasNext() || !this.intersect(localChanges.peekNext(), latestChanges.current(), baseLineCount)) break;
                localChanges.forward();
                continue;
            }
            if (!latestChanges.hasNext() || !this.intersect(localChanges.current(), latestChanges.peekNext(), baseLineCount)) break;
            latestChanges.forward();
        }
        return conflict;
    }

    private int createConflict(OutputStream result, QSequenceDifferenceBlock localStart, QSequenceDifferenceBlock localEnd, QSequenceDifferenceBlock latestStart, QSequenceDifferenceBlock latestEnd, QSequenceLineCache localLines, QSequenceLineCache latestLines, int baseLineIndex, List transformedLocalLines, SVNDiffConflictChoiceStyle style) throws IOException {
        int index;
        int minBaseFrom = Math.min(localStart.getLeftFrom(), latestStart.getLeftFrom());
        int maxBaseTo = Math.max(localEnd.getLeftTo(), latestEnd.getLeftTo());
        this.appendTransformedLocalLines(baseLineIndex, minBaseFrom, transformedLocalLines, result);
        int localFrom = Math.max(0, localStart.getRightFrom() - (localStart.getLeftFrom() - minBaseFrom));
        int localTo = Math.min(localLines.getLineCount() - 1, localEnd.getRightTo() + (maxBaseTo - localEnd.getLeftTo()));
        int latestFrom = Math.max(0, latestStart.getRightFrom() - (latestStart.getLeftFrom() - minBaseFrom));
        int latestTo = Math.min(latestLines.getLineCount() - 1, latestEnd.getRightTo() + (maxBaseTo - latestEnd.getLeftTo()));
        if (style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST) {
            this.writeBytesAndEol(result, this.myConflictStart);
        }
        if (style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED || style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST) {
            index = localFrom;
            while (index <= localTo) {
                this.writeLine(result, localLines.getLine(index));
                ++index;
            }
        }
        if (style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST) {
            this.writeBytesAndEol(result, this.myConflictSeparator);
        }
        if (style == SVNDiffConflictChoiceStyle.CHOOSE_LATEST || style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST) {
            index = latestFrom;
            while (index <= latestTo) {
                this.writeLine(result, latestLines.getLine(index));
                ++index;
            }
        }
        if (style == SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST) {
            this.writeBytesAndEol(result, this.myConflictEnd);
        }
        return maxBaseTo;
    }

    private int createOnlyConflictWithContext(OutputStream result, QSequenceDifferenceBlock localStart, QSequenceDifferenceBlock localEnd, QSequenceDifferenceBlock latestStart, QSequenceDifferenceBlock latestEnd, QSequenceLineCache localLines, QSequenceLineCache latestLines, QSequenceLineCache baseLines) throws IOException {
        int minBaseFrom = Math.min(localStart.getLeftFrom(), latestStart.getLeftFrom());
        int maxBaseTo = Math.max(localEnd.getLeftTo(), latestEnd.getLeftTo());
        int localFrom = Math.max(0, localStart.getRightFrom() - (localStart.getLeftFrom() - minBaseFrom));
        int localTo = Math.min(localLines.getLineCount() - 1, localEnd.getRightTo() + (maxBaseTo - localEnd.getLeftTo()));
        int latestFrom = Math.max(0, latestStart.getRightFrom() - (latestStart.getLeftFrom() - minBaseFrom));
        int latestTo = Math.min(latestLines.getLineCount() - 1, latestEnd.getRightTo() + (maxBaseTo - latestEnd.getLeftTo()));
        this.writeBytes(result, this.myConflictStart);
        int localLinesNum = localTo - localFrom + 1;
        String localContext = null;
        int localStartFrom = localFrom + 1;
        localContext = localLinesNum > 1 ? " (" + localStartFrom + "," + localLinesNum + ")" : " (" + localStartFrom + ")";
        this.writeBytesAndEol(result, localContext.getBytes());
        int index = localFrom;
        while (index <= localTo) {
            this.writeLine(result, localLines.getLine(index));
            ++index;
        }
        this.writeBytes(result, this.myOriginalMarker);
        int originalLinesNum = maxBaseTo - minBaseFrom + 1;
        String originalContext = null;
        int originalStartFrom = minBaseFrom + 1;
        originalContext = originalLinesNum > 1 ? " (" + originalStartFrom + "," + originalLinesNum + ")" : " (" + originalStartFrom + ")";
        this.writeBytesAndEol(result, originalContext.getBytes());
        int index2 = minBaseFrom;
        while (index2 <= maxBaseTo) {
            this.writeLine(result, baseLines.getLine(index2));
            ++index2;
        }
        this.writeBytesAndEol(result, this.myConflictSeparator);
        index2 = latestFrom;
        while (index2 <= latestTo) {
            this.writeLine(result, latestLines.getLine(index2));
            ++index2;
        }
        this.writeBytes(result, this.myConflictEnd);
        int latestLinesNum = latestTo - latestFrom + 1;
        String latestContext = null;
        int latestStartFrom = latestFrom + 1;
        latestContext = latestLinesNum > 1 ? " (" + latestStartFrom + "," + latestLinesNum + ")" : " (" + latestStartFrom + ")";
        this.writeBytesAndEol(result, latestContext.getBytes());
        return maxBaseTo;
    }

    private void appendTransformedLocalLines(int baseLineIndex, int to, List transformedLocalLines, OutputStream result) throws IOException {
        ++baseLineIndex;
        while (baseLineIndex < to) {
            QSequenceLine sequenceLine = (QSequenceLine)transformedLocalLines.get(baseLineIndex);
            if (sequenceLine == null) {
                throw new IOException("Can not merge: sequence line is null for this base index");
            }
            this.writeLine(result, sequenceLine);
            ++baseLineIndex;
        }
    }

    private void writeLine(OutputStream os, QSequenceLine line) throws IOException {
        byte[] bytes = line.getContentBytes();
        if (bytes.length == 0) {
            return;
        }
        os.write(bytes);
    }

    private void writeBytesAndEol(OutputStream os, byte[] bytes) throws IOException {
        if (bytes.length > 0) {
            os.write(bytes);
            os.write(DEFAULT_EOL.getBytes());
        }
    }

    private void writeBytes(OutputStream os, byte[] bytes) throws IOException {
        if (bytes.length > 0) {
            os.write(bytes);
        }
    }

    private QSequenceLineTeeSimplifier createSimplifier(SVNDiffOptions options) {
        QSequenceLineDummySimplifier eolSimplifier = options != null && options.isIgnoreEOLStyle() ? new QSequenceLineEOLUnifyingSimplifier() : new QSequenceLineDummySimplifier();
        QSequenceLineDummySimplifier spaceSimplifier = new QSequenceLineDummySimplifier();
        if (options != null) {
            if (options.isIgnoreAllWhitespace()) {
                spaceSimplifier = new QSequenceLineWhiteSpaceSkippingSimplifier();
            } else if (options.isIgnoreAmountOfWhitespace()) {
                spaceSimplifier = new QSequenceLineWhiteSpaceReducingSimplifier();
            }
        }
        return new QSequenceLineTeeSimplifier((QSequenceLineSimplifier)eolSimplifier, (QSequenceLineSimplifier)spaceSimplifier);
    }
}

