/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractDiffCallback;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDiffEditor
implements ISVNEditor {
    private SVNWCAccess myWCAccess;
    private boolean myUseAncestry;
    private boolean myIsReverseDiff;
    private boolean myIsCompareToBase;
    private boolean myIsRootOpen;
    private long myTargetRevision;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNDepth myDepth;
    private File myTempDirectory;
    private AbstractDiffCallback myDiffCallback;
    private Collection myChangeLists;
    private String myWCRootPath;

    public SVNDiffEditor(SVNWCAccess wcAccess, SVNAdminAreaInfo info, AbstractDiffCallback callback, boolean useAncestry, boolean reverseDiff, boolean compareToBase, SVNDepth depth, Collection changeLists) {
        this.myWCAccess = wcAccess;
        this.myAdminInfo = info;
        this.myUseAncestry = useAncestry;
        this.myIsReverseDiff = reverseDiff;
        this.myDepth = depth;
        this.myIsCompareToBase = compareToBase;
        this.myDiffCallback = callback;
        this.myChangeLists = changeLists != null ? changeLists : Collections.EMPTY_LIST;
        this.myDeltaProcessor = new SVNDeltaProcessor();
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirInfo(null, "", false, this.myDepth);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        File fullPath = new File(this.myAdminInfo.getAnchor().getRoot(), path);
        SVNAdminArea dir = this.myWCAccess.probeRetrieve(fullPath);
        SVNEntry entry = this.myWCAccess.getEntry(fullPath, false);
        if (entry == null) {
            return;
        }
        String name = SVNPathUtil.tail(path);
        this.myCurrentDirectory.myComparedEntries.add(name);
        if (!this.myIsCompareToBase && entry.isScheduledForDeletion()) {
            return;
        }
        if (entry.isFile()) {
            if (this.myIsReverseDiff) {
                File baseFile = dir.getBaseFile(name, false);
                SVNProperties baseProps = dir.getBaseProperties(name).asMap();
                this.getDiffCallback().fileDeleted(path, baseFile, null, null, null, baseProps, null);
            } else {
                this.reportAddedFile(this.myCurrentDirectory, path, entry);
            }
        } else if (entry.isDirectory()) {
            SVNDirectoryInfo info = this.createDirInfo(this.myCurrentDirectory, path, false, SVNDepth.INFINITY);
            this.reportAddedDir(info);
        }
    }

    private void reportAddedDir(SVNDirectoryInfo info) throws SVNException {
        SVNProperties wcProps;
        SVNProperties propDiff;
        SVNAdminArea dir = this.retrieve(info.myPath);
        SVNEntry thisDirEntry = dir.getEntry(dir.getThisDirName(), false);
        if (SVNWCAccess.matchesChangeList(this.myChangeLists, thisDirEntry) && !(propDiff = SVNDiffEditor.computePropsDiff(new SVNProperties(), wcProps = this.myIsCompareToBase ? dir.getBaseProperties(dir.getThisDirName()).asMap() : dir.getProperties(dir.getThisDirName()).asMap())).isEmpty()) {
            this.getDiffCallback().propertiesChanged(info.myPath, null, propDiff, null);
        }
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (dir.getThisDirName().equals(entry.getName()) || !this.myIsCompareToBase && entry.isScheduledForDeletion()) continue;
            if (entry.isFile()) {
                this.reportAddedFile(info, SVNPathUtil.append(info.myPath, entry.getName()), entry);
                continue;
            }
            if (!entry.isDirectory() || info.myDepth.compareTo(SVNDepth.FILES) <= 0 && info.myDepth != SVNDepth.UNKNOWN) continue;
            SVNDepth depthBelowHere = info.myDepth;
            if (depthBelowHere == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.myPath, entry.getName()), false, depthBelowHere);
            this.reportAddedDir(childInfo);
        }
    }

    private void reportAddedFile(SVNDirectoryInfo info, String path, SVNEntry entry) throws SVNException {
        if (!SVNWCAccess.matchesChangeList(this.myChangeLists, entry)) {
            return;
        }
        if (entry.isCopied()) {
            if (this.myIsCompareToBase) {
                return;
            }
            this.reportModifiedFile(info, entry);
            return;
        }
        SVNAdminArea dir = this.retrieve(info.myPath);
        String name = SVNPathUtil.tail(path);
        SVNProperties wcProps = null;
        wcProps = this.myIsCompareToBase ? dir.getBaseProperties(name).asMap() : dir.getProperties(name).asMap();
        String mimeType = wcProps.getStringValue("svn:mime-type");
        SVNProperties propDiff = SVNDiffEditor.computePropsDiff(new SVNProperties(), wcProps);
        File sourceFile = this.myIsCompareToBase ? dir.getBaseFile(name, false) : this.detranslateFile(dir, name);
        this.getDiffCallback().fileAdded(path, null, sourceFile, 0L, entry.getRevision(), null, mimeType, null, propDiff, null);
    }

    private void reportModifiedFile(SVNDirectoryInfo dirInfo, SVNEntry entry) throws SVNException {
        String mimeType;
        SVNAdminArea dir = this.retrieve(dirInfo.myPath);
        if (!SVNWCAccess.matchesChangeList(this.myChangeLists, entry)) {
            return;
        }
        String schedule = entry.getSchedule();
        String fileName = entry.getName();
        if (!this.getDiffCallback().isDiffCopiedAsAdded() && entry.isCopied()) {
            schedule = null;
        }
        if (!this.myUseAncestry && entry.isScheduledForReplacement()) {
            schedule = null;
        }
        SVNProperties propDiff = null;
        SVNProperties baseProps = null;
        File baseFile = dir.getBaseFile(fileName, false);
        if (SVNFileType.getType(baseFile) == SVNFileType.NONE) {
            baseFile = dir.getFile(SVNAdminUtil.getTextRevertPath(fileName, false));
        }
        if (!entry.isScheduledForDeletion()) {
            if (this.getDiffCallback().isDiffCopiedAsAdded() && entry.isCopied()) {
                baseProps = new SVNProperties();
                propDiff = dir.getProperties(fileName).asMap();
            } else {
                baseProps = dir.getBaseProperties(fileName).asMap();
                boolean modified = dir.hasPropModifications(fileName);
                propDiff = modified ? SVNDiffEditor.computePropsDiff(baseProps, dir.getProperties(fileName).asMap()) : new SVNProperties();
            }
        } else {
            baseProps = dir.getBaseProperties(fileName).asMap();
        }
        boolean isAdded = schedule != null && entry.isScheduledForAddition();
        String filePath = SVNPathUtil.append(dirInfo.myPath, fileName);
        if (schedule != null && (entry.isScheduledForDeletion() || entry.isScheduledForReplacement())) {
            mimeType = dir.getBaseProperties(fileName).getStringPropertyValue("svn:mime-type");
            this.getDiffCallback().fileDeleted(filePath, baseFile, null, mimeType, null, dir.getBaseProperties(fileName).asMap(), null);
            isAdded = entry.isScheduledForReplacement();
        }
        if (isAdded) {
            mimeType = dir.getProperties(fileName).getStringPropertyValue("svn:mime-type");
            File tmpFile = this.detranslateFile(dir, fileName);
            SVNProperties originalProperties = null;
            long revision = entry.getRevision();
            if (entry.isCopied() && this.getDiffCallback().isDiffCopiedAsAdded()) {
                originalProperties = new SVNProperties();
                revision = 0L;
            } else {
                originalProperties = dir.getBaseProperties(fileName).asMap();
            }
            this.getDiffCallback().fileAdded(filePath, null, tmpFile, 0L, revision, mimeType, null, originalProperties, propDiff, null);
        } else if (schedule == null) {
            boolean modified = dir.hasTextModifications(fileName, false);
            File tmpFile = null;
            if (modified) {
                tmpFile = this.detranslateFile(dir, fileName);
            }
            if (modified || propDiff != null && !propDiff.isEmpty()) {
                String baseMimeType = dir.getBaseProperties(fileName).getStringPropertyValue("svn:mime-type");
                String mimeType2 = dir.getProperties(fileName).getStringPropertyValue("svn:mime-type");
                this.getDiffCallback().fileChanged(filePath, modified ? baseFile : null, tmpFile, entry.getRevision(), -1L, baseMimeType, mimeType2, baseProps, propDiff, null);
            }
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNDepth subDirDepth = this.myCurrentDirectory.myDepth;
        if (subDirDepth == SVNDepth.IMMEDIATES) {
            subDirDepth = SVNDepth.EMPTY;
        }
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, path, true, subDirDepth);
    }

    public void openDir(String path, long revision) throws SVNException {
        SVNDepth subDirDepth = this.myCurrentDirectory.myDepth;
        if (subDirDepth == SVNDepth.IMMEDIATES) {
            subDirDepth = SVNDepth.EMPTY;
        }
        this.myCurrentDirectory = this.createDirInfo(this.myCurrentDirectory, path, false, subDirDepth);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentDirectory.myPropertyDiff == null) {
            this.myCurrentDirectory.myPropertyDiff = new SVNProperties();
        }
        this.myCurrentDirectory.myPropertyDiff.put(name, value);
    }

    public void closeDir() throws SVNException {
        SVNProperties diff = this.myCurrentDirectory.myPropertyDiff;
        if (diff != null && !diff.isEmpty()) {
            SVNProperties originalProps = null;
            if (this.myCurrentDirectory.myIsAdded) {
                originalProps = new SVNProperties();
            } else {
                SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myPath);
                if (dir != null && this.myIsCompareToBase) {
                    originalProps = dir.getBaseProperties(dir.getThisDirName()).asMap();
                } else {
                    originalProps = dir.getProperties(dir.getThisDirName()).asMap();
                    SVNProperties baseProps = dir.getBaseProperties(dir.getThisDirName()).asMap();
                    SVNProperties reposProps = this.applyPropChanges(baseProps, this.myCurrentDirectory.myPropertyDiff);
                    diff = SVNDiffEditor.computePropsDiff(originalProps, reposProps);
                }
            }
            if (!this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges(originalProps, diff);
            }
            this.getDiffCallback().propertiesChanged(this.myCurrentDirectory.myPath, originalProps, diff, null);
            this.myCurrentDirectory.myComparedEntries.add("");
        }
        if (!this.myCurrentDirectory.myIsAdded) {
            this.localDirectoryDiff(this.myCurrentDirectory);
        }
        String name = SVNPathUtil.tail(this.myCurrentDirectory.myPath);
        this.myCurrentDirectory = this.myCurrentDirectory.myParent;
        if (this.myCurrentDirectory != null) {
            this.myCurrentDirectory.myComparedEntries.add(name);
        }
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void openFile(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.myCurrentFile = this.createFileInfo(this.myCurrentDirectory, path, false);
        this.myCurrentDirectory.myComparedEntries.add(name);
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (this.myCurrentFile.myPropertyDiff == null) {
            this.myCurrentFile.myPropertyDiff = new SVNProperties();
        }
        this.myCurrentFile.myPropertyDiff.put(name, value);
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        SVNEntry entry = this.myWCAccess.getEntry(this.myAdminInfo.getAnchor().getFile(this.myCurrentFile.myPath), false);
        if (entry != null && entry.isCopied()) {
            this.myCurrentFile.myIsAdded = false;
        }
        if (!this.myCurrentFile.myIsAdded) {
            SVNAdminArea dir = this.retrieve(this.myCurrentDirectory.myPath);
            String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
            this.myCurrentFile.myBaseFile = dir.getBaseFile(fileName, false);
        }
        this.myCurrentFile.myFile = this.createTempFile();
        this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.myBaseFile, this.myCurrentFile.myFile, false);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.myDeltaProcessor.textDeltaEnd();
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        boolean modified;
        String fileName = SVNPathUtil.tail(this.myCurrentFile.myPath);
        File filePath = this.myAdminInfo.getAnchor().getFile(this.myCurrentFile.myPath);
        SVNAdminArea dir = this.myWCAccess.probeRetrieve(filePath);
        SVNEntry entry = this.myWCAccess.getEntry(filePath, false);
        SVNProperties baseProperties = null;
        baseProperties = this.myCurrentFile.myIsAdded ? new SVNProperties() : (dir != null ? dir.getBaseProperties(fileName).asMap() : new SVNProperties());
        SVNProperties reposProperties = this.applyPropChanges(baseProperties, this.myCurrentFile.myPropertyDiff);
        String reposMimeType = reposProperties.getStringValue("svn:mime-type");
        File reposFile = this.myCurrentFile.myFile;
        File localFile = null;
        if (reposFile == null) {
            reposFile = dir.getBaseFile(fileName, false);
        }
        if (this.myCurrentFile.myIsAdded || !this.myIsCompareToBase && entry.isScheduledForDeletion()) {
            if (this.myIsReverseDiff) {
                this.getDiffCallback().fileAdded(commitPath, null, reposFile, 0L, this.myTargetRevision, null, reposMimeType, null, this.myCurrentFile.myPropertyDiff, null);
            } else {
                this.getDiffCallback().fileDeleted(commitPath, reposFile, null, reposMimeType, null, reposProperties, null);
            }
            return;
        }
        boolean bl = modified = this.myCurrentFile.myFile != null;
        if (!modified && !this.myIsCompareToBase) {
            modified = dir.hasTextModifications(fileName, false);
        }
        if (modified) {
            localFile = this.myIsCompareToBase ? dir.getBaseFile(fileName, false) : this.detranslateFile(dir, fileName);
        } else {
            localFile = null;
            reposFile = null;
        }
        SVNProperties originalProps = null;
        if (this.myIsCompareToBase) {
            originalProps = baseProperties;
        } else {
            originalProps = dir.getProperties(fileName).asMap();
            this.myCurrentFile.myPropertyDiff = SVNDiffEditor.computePropsDiff(originalProps, reposProperties);
        }
        if (localFile != null || this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty()) {
            String originalMimeType = originalProps.getStringValue("svn:mime-type");
            if (this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty() && !this.myIsReverseDiff) {
                SVNDiffEditor.reversePropChanges(originalProps, this.myCurrentFile.myPropertyDiff);
            }
            if (localFile != null || reposFile != null || this.myCurrentFile.myPropertyDiff != null && !this.myCurrentFile.myPropertyDiff.isEmpty()) {
                this.getDiffCallback().fileChanged(commitPath, this.myIsReverseDiff ? localFile : reposFile, this.myIsReverseDiff ? reposFile : localFile, this.myIsReverseDiff ? -1L : this.myTargetRevision, this.myIsReverseDiff ? this.myTargetRevision : -1L, this.myIsReverseDiff ? originalMimeType : reposMimeType, this.myIsReverseDiff ? reposMimeType : originalMimeType, originalProps, this.myCurrentFile.myPropertyDiff, null);
            }
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.myIsRootOpen) {
            this.localDirectoryDiff(this.createDirInfo(null, "", false, this.myDepth));
        }
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void cleanup() {
        if (this.myTempDirectory != null) {
            SVNFileUtil.deleteAll(this.myTempDirectory, true);
        }
    }

    private SVNProperties applyPropChanges(SVNProperties props, SVNProperties propChanges) {
        SVNProperties result = new SVNProperties(props);
        if (propChanges != null) {
            for (String name : propChanges.nameSet()) {
                SVNPropertyValue value = propChanges.getSVNPropertyValue(name);
                if (value == null) {
                    result.remove(name);
                    continue;
                }
                result.put(name, value);
            }
        }
        return result;
    }

    private void localDirectoryDiff(SVNDirectoryInfo info) throws SVNException {
        if (this.myIsCompareToBase) {
            return;
        }
        SVNAdminArea dir = this.retrieve(info.myPath);
        boolean anchor = !"".equals(this.myAdminInfo.getTargetName()) && dir == this.myAdminInfo.getAnchor();
        SVNEntry thisDirEntry = dir.getEntry(dir.getThisDirName(), false);
        if (SVNWCAccess.matchesChangeList(this.myChangeLists, thisDirEntry) && !anchor && !info.myComparedEntries.contains("") && dir.hasPropModifications(dir.getThisDirName())) {
            SVNVersionedProperties baseProps = dir.getBaseProperties(dir.getThisDirName());
            SVNProperties propDiff = baseProps.compareTo(dir.getProperties(dir.getThisDirName())).asMap();
            this.getDiffCallback().propertiesChanged(info.myPath, baseProps.asMap(), propDiff, null);
        }
        if (info.myDepth == SVNDepth.EMPTY && !anchor) {
            return;
        }
        SVNHashSet processedFiles = null;
        if (this.getDiffCallback().isDiffUnversioned()) {
            processedFiles = new SVNHashSet();
        }
        Iterator entries = dir.entries(false);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (processedFiles != null && !dir.getThisDirName().equals(entry.getName())) {
                processedFiles.add(entry.getName());
            }
            if (anchor && !this.myAdminInfo.getTargetName().equals(entry.getName()) || dir.getThisDirName().equals(entry.getName()) || info.myComparedEntries.contains(entry.getName())) continue;
            info.myComparedEntries.add(entry.getName());
            if (entry.isFile()) {
                this.reportModifiedFile(info, entry);
                continue;
            }
            if (!entry.isDirectory() || !anchor && info.myDepth.compareTo(SVNDepth.FILES) <= 0 && info.myDepth != SVNDepth.UNKNOWN) continue;
            SVNDepth depthBelowHere = info.myDepth;
            if (depthBelowHere == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.myPath, entry.getName()), false, depthBelowHere);
            this.localDirectoryDiff(childInfo);
        }
        if (this.getDiffCallback().isDiffUnversioned()) {
            String relativePath = dir.getRelativePath(this.myAdminInfo.getAnchor());
            this.diffUnversioned(dir.getRoot(), dir, relativePath, anchor, processedFiles);
        }
    }

    private void diffUnversioned(File root, SVNAdminArea dir, String parentRelativePath, boolean anchor, Set processedFiles) throws SVNException {
        File[] allFiles = SVNFileListUtil.listFiles(root);
        int i = 0;
        while (allFiles != null && i < allFiles.length) {
            block12: {
                SVNFileType fileType;
                File file;
                block13: {
                    file = allFiles[i];
                    if (SVNFileUtil.getAdminDirectoryName().equals(file.getName()) || processedFiles != null && processedFiles.contains(file.getName()) || anchor && !this.myAdminInfo.getTargetName().equals(file.getName())) break block12;
                    if (dir == null) break block13;
                    Collection globalIgnores = SVNStatusEditor.getGlobalIgnores(this.myWCAccess.getOptions());
                    Collection ignores = SVNStatusEditor.getIgnorePatterns(dir, globalIgnores);
                    String rootRelativePath = null;
                    boolean needToComputeRelativePath = false;
                    for (String pattern : ignores) {
                        if (!pattern.startsWith("/")) continue;
                        needToComputeRelativePath = true;
                        break;
                    }
                    if (needToComputeRelativePath) {
                        if (this.myWCRootPath == null) {
                            File wcRoot = SVNWCUtil.getWorkingCopyRoot(dir.getRoot(), true);
                            this.myWCRootPath = wcRoot.getAbsolutePath().replace(File.separatorChar, '/');
                        }
                        if (this.myWCRootPath != null) {
                            rootRelativePath = file.getAbsolutePath().replace(File.separatorChar, '/');
                            if ((rootRelativePath = SVNPathUtil.getPathAsChild(this.myWCRootPath, rootRelativePath)) != null && !rootRelativePath.startsWith("/")) {
                                rootRelativePath = "/" + rootRelativePath;
                            }
                        }
                    }
                    if (SVNStatusEditor.isIgnored(ignores, file, rootRelativePath)) break block12;
                }
                if ((fileType = SVNFileType.getType(file)) == SVNFileType.DIRECTORY) {
                    this.diffUnversioned(file, null, SVNPathUtil.append(parentRelativePath, file.getName()), false, null);
                } else if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                    String mimeType1 = null;
                    String mimeType2 = SVNFileUtil.detectMimeType(file, null);
                    String filePath = SVNPathUtil.append(parentRelativePath, file.getName());
                    this.getDiffCallback().fileAdded(filePath, null, file, 0L, 0L, mimeType1, mimeType2, null, null, null);
                }
            }
            ++i;
        }
    }

    private SVNDirectoryInfo createDirInfo(SVNDirectoryInfo parent, String path, boolean added, SVNDepth depth) {
        SVNDirectoryInfo info = new SVNDirectoryInfo();
        info.myParent = parent;
        info.myPath = path;
        info.myIsAdded = added;
        info.myDepth = depth;
        return info;
    }

    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) {
        SVNFileInfo info = new SVNFileInfo();
        info.myPath = path;
        info.myIsAdded = added;
        if (parent.myIsAdded) {
            while (parent.myIsAdded) {
                parent = parent.myParent;
            }
            info.myPath = SVNPathUtil.append(parent.myPath, "fake");
        }
        return info;
    }

    private File detranslateFile(SVNAdminArea dir, String name) throws SVNException {
        boolean special;
        SVNVersionedProperties properties = dir.getProperties(name);
        String keywords = properties.getStringPropertyValue("svn:keywords");
        String eolStyle = properties.getStringPropertyValue("svn:eol-style");
        String charsetProp = properties.getStringPropertyValue("svnkit:charset");
        String mimeType = properties.getStringPropertyValue("svn:mime-type");
        ISVNOptions options = dir.getWCAccess().getOptions();
        String charset = SVNTranslator.getCharset(charsetProp, mimeType, dir.getFile(name).getPath(), options);
        boolean bl = special = properties.getPropertyValue("svn:special") != null;
        if (!(charset != null || keywords != null || eolStyle != null || special && SVNFileUtil.symlinksSupported())) {
            return dir.getFile(name);
        }
        byte[] eol = SVNTranslator.getEOL(eolStyle, options);
        File tmpFile = this.createTempFile();
        Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null, null);
        SVNTranslator.translate(dir.getFile(name), tmpFile, charset, eol, keywordsMap, special, false);
        return tmpFile;
    }

    private File createTempFile() throws SVNException {
        File tmpFile = null;
        try {
            return File.createTempFile("diff.", ".tmp", this.getTempDirectory());
        }
        catch (IOException e) {
            SVNFileUtil.deleteFile(tmpFile);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
            return null;
        }
    }

    private File getTempDirectory() throws SVNException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = this.getDiffCallback().createTempDirectory();
        }
        return this.myTempDirectory;
    }

    private SVNAdminArea retrieve(String path) throws SVNException {
        File dir = this.myAdminInfo.getAnchor().getFile(path);
        return this.myWCAccess.retrieve(dir);
    }

    private AbstractDiffCallback getDiffCallback() {
        return this.myDiffCallback;
    }

    private static void reversePropChanges(SVNProperties base, SVNProperties diff) {
        ArrayList<String> namesList = new ArrayList<String>(diff.nameSet());
        for (String name : namesList) {
            SVNPropertyValue newValue = diff.getSVNPropertyValue(name);
            SVNPropertyValue oldValue = base.getSVNPropertyValue(name);
            if (oldValue == null && newValue != null) {
                base.put(name, newValue);
                diff.put(name, (SVNPropertyValue)null);
                continue;
            }
            if (oldValue != null && newValue == null) {
                base.put(name, (SVNPropertyValue)null);
                diff.put(name, oldValue);
                continue;
            }
            if (oldValue == null || newValue == null) continue;
            base.put(name, newValue);
            diff.put(name, oldValue);
        }
    }

    private static SVNProperties computePropsDiff(SVNProperties props1, SVNProperties props2) {
        SVNProperties propsDiff = new SVNProperties();
        for (String newPropName : props2.nameSet()) {
            if (props1.containsName(newPropName)) {
                SVNPropertyValue oldValue = props2.getSVNPropertyValue(newPropName);
                SVNPropertyValue value = props1.getSVNPropertyValue(newPropName);
                if (oldValue != null && !oldValue.equals(value)) {
                    propsDiff.put(newPropName, oldValue);
                    continue;
                }
                if (oldValue != null || value == null) continue;
                propsDiff.put(newPropName, oldValue);
                continue;
            }
            propsDiff.put(newPropName, props2.getSVNPropertyValue(newPropName));
        }
        for (String oldPropName : props1.nameSet()) {
            if (props2.containsName(oldPropName)) continue;
            propsDiff.put(oldPropName, (String)null);
        }
        return propsDiff;
    }

    private static class SVNDirectoryInfo {
        private boolean myIsAdded;
        private String myPath;
        private SVNProperties myPropertyDiff;
        private SVNDirectoryInfo myParent;
        private Set myComparedEntries = new SVNHashSet();
        private SVNDepth myDepth;

        private SVNDirectoryInfo() {
        }
    }

    private static class SVNFileInfo {
        private boolean myIsAdded;
        private String myPath;
        private File myFile;
        private File myBaseFile;
        private SVNProperties myPropertyDiff;

        private SVNFileInfo() {
        }
    }
}

