/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMergeInfoManager {
    public Map getMergeInfo(String[] paths, FSRevisionRoot root, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        if (!root.getOwner().supportsMergeInfo()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Querying mergeinfo requires version {0} of the FSFS filesystem schema; filesystem ''{1}'' uses only version {2}", new Integer(3), root.getOwner().getDBRoot(), new Integer(root.getOwner().getDBFormat()));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        Map mergeInfoAsHashes = this.getMergeInfoForPaths(root, paths, inherit, includeDescendants);
        TreeMap<String, SVNMergeInfo> mergeInfo = new TreeMap<String, SVNMergeInfo>();
        for (String path : mergeInfoAsHashes.keySet()) {
            Map pathMergeInfo = (Map)mergeInfoAsHashes.get(path);
            mergeInfo.put(path, new SVNMergeInfo(path, pathMergeInfo));
        }
        return mergeInfo;
    }

    private Map getMergeInfoForPaths(FSRevisionRoot root, String[] paths, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        TreeMap<String, Map> result = new TreeMap<String, Map>();
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            Map pathMergeInfo = this.getMergeInfoForPath(root, path, inherit);
            if (pathMergeInfo != null) {
                result.put(path, pathMergeInfo);
            }
            if (includeDescendants) {
                this.addDescendantMergeInfo(result, root, path);
            }
            ++i;
        }
        return result;
    }

    private void addDescendantMergeInfo(Map result, FSRevisionRoot root, String path) throws SVNException {
        FSRevisionNode node = root.getRevisionNode(path);
        if (node.hasDescendantsWithMergeInfo()) {
            this.crawlDirectoryForMergeInfo(root, path, node, result);
        }
    }

    private Map crawlDirectoryForMergeInfo(FSRevisionRoot root, String path, FSRevisionNode node, Map result) throws SVNException {
        FSFS fsfs = root.getOwner();
        Map entries = node.getDirEntries(fsfs);
        for (FSEntry entry : entries.values()) {
            String kidPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(path, entry.getName()));
            FSRevisionNode kidNode = root.getRevisionNode(kidPath);
            if (kidNode.hasMergeInfo()) {
                SVNProperties propList = kidNode.getProperties(fsfs);
                String mergeInfoString = propList.getStringValue("svn:mergeinfo");
                if (mergeInfoString == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Node-revision #''{0}'' claims to have mergeinfo but doesn''t", (Object)entry.getId());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                Map<String, SVNMergeRangeList> kidMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoString), null);
                result.put(kidPath, kidMergeInfo);
            }
            if (!kidNode.hasDescendantsWithMergeInfo()) continue;
            this.crawlDirectoryForMergeInfo(root, kidPath, kidNode, result);
        }
        return result;
    }

    private Map getMergeInfoForPath(FSRevisionRoot revRoot, String path, SVNMergeInfoInheritance inherit) throws SVNException {
        boolean hasMergeInfo;
        Map mergeInfo = null;
        path = SVNPathUtil.canonicalizeAbsolutePath(path);
        FSParentPath parentPath = revRoot.openPath(path, true, true);
        if (inherit == SVNMergeInfoInheritance.NEAREST_ANCESTOR && parentPath.getParent() == null) {
            return mergeInfo;
        }
        FSParentPath nearestAncestor = null;
        nearestAncestor = inherit == SVNMergeInfoInheritance.NEAREST_ANCESTOR ? parentPath.getParent() : parentPath;
        FSFS fsfs = revRoot.getOwner();
        while (!(hasMergeInfo = nearestAncestor.getRevNode().hasMergeInfo())) {
            if (inherit == SVNMergeInfoInheritance.EXPLICIT) {
                return mergeInfo;
            }
            if ((nearestAncestor = nearestAncestor.getParent()) != null) continue;
            return mergeInfo;
        }
        SVNProperties propList = nearestAncestor.getRevNode().getProperties(fsfs);
        String mergeInfoString = propList.getStringValue("svn:mergeinfo");
        if (mergeInfoString == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Node-revision ''{0}@{1}'' claims to have mergeinfo but doesn''t", nearestAncestor.getAbsPath(), new Long(revRoot.getRevision()));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (nearestAncestor == parentPath) {
            return SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoString), null);
        }
        Map<String, SVNMergeRangeList> tmpMergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoString), null);
        tmpMergeInfo = SVNMergeInfoUtil.getInheritableMergeInfo(tmpMergeInfo, null, -1L, -1L);
        mergeInfo = this.appendToMergedFroms(tmpMergeInfo, parentPath.getRelativePath(nearestAncestor));
        return mergeInfo;
    }

    private Map appendToMergedFroms(Map mergeInfo, String pathComponent) {
        TreeMap<String, SVNMergeRangeList> result = new TreeMap<String, SVNMergeRangeList>();
        for (String path : mergeInfo.keySet()) {
            SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(path);
            result.put(SVNPathUtil.append(path, pathComponent), rangeList.dup());
        }
        return result;
    }
}

