/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNStatusEditor {
    private SVNWCAccess myWCAccess;
    private SVNAdminAreaInfo myAdminInfo;
    private boolean myIsReportAll;
    private boolean myIsNoIgnore;
    private SVNDepth myDepth;
    private ISVNStatusHandler myStatusHandler;
    private Map myExternalsMap;
    private Collection myGlobalIgnores;
    protected SVNURL myRepositoryRoot;
    private Map myRepositoryLocks;
    private long myTargetRevision;
    private String myWCRootPath;
    private ISVNStatusFileProvider myFileProvider;
    private ISVNStatusFileProvider myDefaultFileProvider;

    public SVNStatusEditor(ISVNOptions options, SVNWCAccess wcAccess, SVNAdminAreaInfo info, boolean noIgnore, boolean reportAll, SVNDepth depth, ISVNStatusHandler handler) {
        this.myWCAccess = wcAccess;
        this.myAdminInfo = info;
        this.myIsNoIgnore = noIgnore;
        this.myIsReportAll = reportAll;
        this.myDepth = depth;
        this.myStatusHandler = handler;
        this.myExternalsMap = new SVNHashMap();
        this.myGlobalIgnores = SVNStatusEditor.getGlobalIgnores(options);
        this.myTargetRevision = -1L;
        this.myFileProvider = this.myDefaultFileProvider = new DefaultSVNStatusFileProvider();
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void targetRevision(long revision) {
        this.myTargetRevision = revision;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        try {
            if (this.hasTarget()) {
                File path = this.myAdminInfo.getAnchor().getFile(this.myAdminInfo.getTargetName());
                SVNFileType type = SVNFileType.getType(path);
                if (type == SVNFileType.DIRECTORY) {
                    SVNEntry entry = this.myWCAccess.getEntry(path, false);
                    if (entry == null) {
                        this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), SVNDepth.EMPTY, this.myIsReportAll, true, null, true, this.myStatusHandler);
                    } else {
                        SVNAdminArea target = this.myWCAccess.retrieve(path);
                        this.getDirStatus(null, target, null, this.myDepth, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
                    }
                } else {
                    this.getDirStatus(null, this.myAdminInfo.getAnchor(), this.myAdminInfo.getTargetName(), SVNDepth.EMPTY, this.myIsReportAll, true, null, true, this.myStatusHandler);
                }
            } else {
                this.getDirStatus(null, this.myAdminInfo.getAnchor(), null, this.myDepth, this.myIsReportAll, this.myIsNoIgnore, null, false, this.myStatusHandler);
            }
        }
        finally {
            this.cleanup();
        }
        return null;
    }

    public void setRepositoryInfo(SVNURL root, Map repositoryLocks) {
        this.myRepositoryRoot = root;
        this.myRepositoryLocks = repositoryLocks;
    }

    protected void getDirStatus(SVNEntry parentEntry, SVNAdminArea dir, String entryName, SVNDepth depth, boolean getAll, boolean noIgnore, Collection ignorePatterns, boolean skipThisDir, ISVNStatusHandler handler) throws SVNException {
        File file;
        SVNStatus status;
        this.myWCAccess.checkCancelled();
        depth = depth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : depth;
        Map<String, File> childrenFiles = this.myFileProvider.getChildrenFiles(dir.getRoot());
        SVNEntry dirEntry = this.myWCAccess.getEntry(dir.getRoot(), false);
        String externals = dir.getProperties(dir.getThisDirName()).getStringPropertyValue("svn:externals");
        if (externals != null) {
            String path = dir.getRelativePath(this.myAdminInfo.getAnchor());
            this.myAdminInfo.addExternal(path, externals, externals);
            this.myAdminInfo.addDepth(path, dirEntry.getDepth());
            SVNExternal[] externalsInfo = SVNExternal.parseExternals(dir.getRelativePath(this.myAdminInfo.getAnchor()), externals);
            int i = 0;
            while (i < externalsInfo.length) {
                SVNExternal external = externalsInfo[i];
                this.myExternalsMap.put(SVNPathUtil.append(path, external.getPath()), external);
                ++i;
            }
        }
        if (entryName != null) {
            File file2 = childrenFiles.get(entryName);
            SVNEntry entry = dir.getEntry(entryName, false);
            if (entry != null) {
                SVNFileType fileType = SVNFileType.getType(file2);
                boolean special = fileType == SVNFileType.SYMLINK;
                SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
                this.handleDirEntry(dir, entryName, dirEntry, entry, fileKind, special, depth, getAll, noIgnore, handler);
            } else if (file2 != null) {
                SVNFileType fileType;
                if (ignorePatterns == null) {
                    ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
                }
                boolean special = (fileType = SVNFileType.getType(file2)) == SVNFileType.SYMLINK;
                SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
                this.sendUnversionedStatus(file2, entryName, fileKind, special, dir, ignorePatterns, noIgnore, handler);
            } else {
                SVNTreeConflictDescription treeConflict = this.myWCAccess.getTreeConflict(dir.getFile(entryName));
                if (treeConflict != null) {
                    if (ignorePatterns == null) {
                        ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
                    }
                    this.sendUnversionedStatus(dir.getFile(entryName), entryName, SVNNodeKind.NONE, false, dir, ignorePatterns, true, handler);
                }
            }
            return;
        }
        if (!skipThisDir && (status = this.assembleStatus(dir.getRoot(), dir, dirEntry, parentEntry, SVNNodeKind.DIR, false, this.isReportAll(), false)) != null && handler != null) {
            handler.handleStatus(status);
        }
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        childrenFiles = new TreeMap<String, File>(childrenFiles);
        for (String fileName : childrenFiles.keySet()) {
            SVNEntry entry = dir.getEntry(fileName, true);
            if (SVNStatusEditor.isNameConflict(entry) || entry != null && !entry.isHidden() || SVNFileUtil.getAdminDirectoryName().equals(fileName)) continue;
            file = childrenFiles.get(fileName);
            if (depth == SVNDepth.FILES && file.isDirectory()) continue;
            if (ignorePatterns == null) {
                ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
            }
            this.sendUnversionedStatus(file, fileName, SVNNodeKind.NONE, false, dir, ignorePatterns, noIgnore, handler);
        }
        Map treeConflicts = SVNTreeConflictUtil.readTreeConflicts(dir.getRoot(), dirEntry.getTreeConflictData());
        for (File conflictPath : treeConflicts.keySet()) {
            if (childrenFiles.containsKey(conflictPath.getName()) || dir.getEntry(conflictPath.getName(), false) != null) continue;
            if (ignorePatterns == null) {
                ignorePatterns = SVNStatusEditor.getIgnorePatterns(dir, this.myGlobalIgnores);
            }
            this.sendUnversionedStatus(conflictPath, conflictPath.getName(), SVNNodeKind.NONE, false, dir, ignorePatterns, noIgnore, handler);
        }
        Iterator entries = dir.entries(true);
        while (entries.hasNext()) {
            SVNEntry entry = (SVNEntry)entries.next();
            if (SVNStatusEditor.isNameConflict(entry)) {
                SVNStatus status2 = new SVNStatus(entry.getSVNURL(), dir.getFile(entry.getName()), entry.getKind(), SVNRevision.create(entry.getRevision()), SVNRevision.create(entry.getCommittedRevision()), SVNDate.parseDate(entry.getCommittedDate()), entry.getAuthor(), SVNStatusType.STATUS_NAME_CONFLICT, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, SVNStatusType.STATUS_NONE, false, entry.isCopied(), false, false, null, null, null, null, entry.getCopyFromURL(), SVNRevision.create(entry.getCopyFromRevision()), null, null, entry.asMap(), entry.getChangelistName(), dir.getFormatVersion(), null);
                status2.setDepth(entry.isDirectory() ? entry.getDepth() : SVNDepth.UNKNOWN);
                status2.setEntry(entry);
                status2.setRepositoryRootURL(this.myRepositoryRoot);
                handler.handleStatus(status2);
                continue;
            }
            if (entry.isHidden() || dir.getThisDirName().equals(entry.getName()) || depth == SVNDepth.FILES && entry.isDirectory()) continue;
            file = childrenFiles.get(entry.getName());
            SVNFileType fileType = SVNFileType.getType(file);
            boolean special = fileType == SVNFileType.SYMLINK;
            SVNNodeKind fileKind = SVNFileType.getNodeKind(fileType);
            this.handleDirEntry(dir, entry.getName(), dirEntry, entry, fileKind, special, depth == SVNDepth.INFINITY ? depth : SVNDepth.EMPTY, getAll, noIgnore, handler);
        }
    }

    public static boolean isNameConflict(SVNEntry entry) {
        return entry != null && entry.isAbsent() && "nameconflict".equals(entry.getChecksum());
    }

    protected void cleanup() {
        if (this.hasTarget()) {
            this.myAdminInfo.removeExternal("");
            this.myAdminInfo.removeDepth("");
        }
    }

    protected SVNAdminArea getAnchor() {
        return this.myAdminInfo.getAnchor();
    }

    protected SVNWCAccess getWCAccess() {
        return this.myWCAccess;
    }

    protected SVNDepth getDepth() {
        return this.myDepth;
    }

    protected boolean isReportAll() {
        return this.myIsReportAll;
    }

    protected boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    protected SVNAdminAreaInfo getAdminAreaInfo() {
        return this.myAdminInfo;
    }

    protected ISVNStatusHandler getDefaultHandler() {
        return this.myStatusHandler;
    }

    protected boolean hasTarget() {
        return this.myAdminInfo.getTargetName() != null && !"".equals(this.myAdminInfo.getTargetName());
    }

    protected SVNLock getLock(SVNURL url) {
        return SVNStatusUtil.getLock(this.myRepositoryLocks, url, this.myRepositoryRoot);
    }

    private void handleDirEntry(SVNAdminArea dir, String entryName, SVNEntry dirEntry, SVNEntry entry, SVNNodeKind fileKind, boolean special, SVNDepth depth, boolean getAll, boolean noIgnore, ISVNStatusHandler handler) throws SVNException {
        File path = dir.getFile(entryName);
        if (fileKind == SVNNodeKind.DIR) {
            SVNEntry fullEntry = entry;
            if (entry.getKind() == fileKind) {
                fullEntry = this.myWCAccess.getVersionedEntry(path, false);
            }
            if (fullEntry != entry && (depth == SVNDepth.UNKNOWN || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY)) {
                SVNAdminArea childDir = this.myWCAccess.retrieve(path);
                this.getDirStatus(dirEntry, childDir, null, depth, getAll, noIgnore, null, false, handler);
            } else if (fullEntry != entry) {
                SVNAdminArea childDir = this.myWCAccess.retrieve(path);
                SVNStatus status = this.assembleStatus(path, childDir, fullEntry, dirEntry, fileKind, special, getAll, false);
                if (status != null && handler != null) {
                    handler.handleStatus(status);
                }
            } else {
                SVNStatus status = this.assembleStatus(path, dir, fullEntry, dirEntry, fileKind, special, getAll, false);
                if (status != null && handler != null) {
                    handler.handleStatus(status);
                }
            }
        } else {
            SVNStatus status = this.assembleStatus(path, dir, entry, dirEntry, fileKind, special, getAll, false);
            if (status != null && handler != null) {
                handler.handleStatus(status);
            }
        }
    }

    private void sendUnversionedStatus(File file, String name, SVNNodeKind fileType, boolean special, SVNAdminArea dir, Collection ignorePatterns, boolean noIgnore, ISVNStatusHandler handler) throws SVNException {
        String path = dir.getRelativePath(this.myAdminInfo.getAnchor());
        path = SVNPathUtil.append(path, name);
        boolean isIgnored = SVNStatusEditor.isIgnored(ignorePatterns, file, this.getWCRootRelativePath(ignorePatterns, file));
        boolean isExternal = this.isExternal(path);
        SVNStatus status = this.assembleStatus(file, dir, null, null, fileType, special, true, isIgnored);
        if (status != null) {
            if (isExternal) {
                status.setContentsStatus(SVNStatusType.STATUS_EXTERNAL);
            }
            if (handler != null && (noIgnore || !isIgnored || isExternal || status.getRemoteLock() != null)) {
                handler.handleStatus(status);
            }
        }
    }

    protected SVNStatus assembleStatus(File file, SVNAdminArea dir, SVNEntry entry, SVNEntry parentEntry, SVNNodeKind fileKind, boolean special, boolean reportAll, boolean isIgnored) throws SVNException {
        return SVNStatusUtil.assembleStatus(file, dir, entry, parentEntry, fileKind, special, reportAll, isIgnored, this.myRepositoryLocks, this.myRepositoryRoot, this.myWCAccess);
    }

    protected String getWCRootPath() {
        if (this.myWCRootPath == null) {
            try {
                File root = SVNWCUtil.getWorkingCopyRoot(this.myAdminInfo.getAnchor().getRoot(), true);
                if (root != null) {
                    this.myWCRootPath = root.getAbsolutePath().replace(File.separatorChar, '/');
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return this.myWCRootPath;
    }

    protected String getWCRootRelativePath(Collection ignorePatterns, File file) {
        boolean needToComputeWCRelativePath = false;
        for (String pattern : ignorePatterns) {
            if (!pattern.startsWith("/")) continue;
            needToComputeWCRelativePath = true;
            break;
        }
        if (!needToComputeWCRelativePath) {
            return null;
        }
        String rootRelativePath = null;
        if (this.getWCRootPath() != null) {
            rootRelativePath = file.getAbsolutePath().replace(File.separatorChar, '/');
            rootRelativePath = SVNPathUtil.getPathAsChild(this.getWCRootPath(), rootRelativePath);
            if (rootRelativePath != null && !rootRelativePath.startsWith("/")) {
                rootRelativePath = "/" + rootRelativePath;
            }
        }
        return rootRelativePath;
    }

    private boolean isExternal(String path) {
        if (!this.myExternalsMap.containsKey(path)) {
            for (String externalPath : this.myExternalsMap.keySet()) {
                if (!externalPath.startsWith(String.valueOf(path) + "/")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Collection getIgnorePatterns(SVNAdminArea dir, Collection globalIgnores) throws SVNException {
        String localIgnores = dir.getProperties("").getStringPropertyValue("svn:ignore");
        if (localIgnores != null) {
            SVNHashSet patterns = new SVNHashSet();
            patterns.addAll(globalIgnores);
            StringTokenizer tokens = new StringTokenizer(localIgnores, "\r\n");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                if (token.length() <= 0) continue;
                patterns.add(token);
            }
            return patterns;
        }
        return globalIgnores;
    }

    public static Collection getGlobalIgnores(ISVNOptions options) {
        String[] ignores;
        if (options != null && (ignores = options.getIgnorePatterns()) != null) {
            SVNHashSet patterns = new SVNHashSet();
            int i = 0;
            while (i < ignores.length) {
                patterns.add(ignores[i]);
                ++i;
            }
            return patterns;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean isIgnored(Collection patterns, File file) {
        return SVNStatusEditor.isIgnored(patterns, file, null);
    }

    public static boolean isIgnored(Collection patterns, File file, String relativePath) {
        boolean isDirectory;
        String name = file.getName();
        String dirName = null;
        boolean bl = isDirectory = SVNFileType.getType(file) == SVNFileType.DIRECTORY;
        if (isDirectory) {
            dirName = String.valueOf(name) + "/";
        }
        for (String pattern : patterns) {
            if (pattern.startsWith("/") && relativePath != null) {
                if (!DefaultSVNOptions.matches(pattern, relativePath) && (!isDirectory || !DefaultSVNOptions.matches(pattern, String.valueOf(relativePath) + "/"))) continue;
                return true;
            }
            if (DefaultSVNOptions.matches(pattern, name)) {
                return true;
            }
            if (!isDirectory || !DefaultSVNOptions.matches(pattern, dirName)) continue;
            return true;
        }
        return false;
    }

    public void setFileProvider(ISVNStatusFileProvider fileProvider) {
        this.myFileProvider = new WrapperSVNStatusFileProvider(this.myDefaultFileProvider, fileProvider);
    }

    private static class DefaultSVNStatusFileProvider
    implements ISVNStatusFileProvider {
        private DefaultSVNStatusFileProvider() {
        }

        public Map getChildrenFiles(File parent) {
            File[] children = SVNFileListUtil.listFiles(parent);
            if (children != null) {
                SVNHashMap map = new SVNHashMap();
                int i = 0;
                while (i < children.length) {
                    map.put(children[i].getName(), children[i]);
                    ++i;
                }
                return map;
            }
            return Collections.EMPTY_MAP;
        }
    }

    private static class WrapperSVNStatusFileProvider
    implements ISVNStatusFileProvider {
        private final ISVNStatusFileProvider myDefault;
        private final ISVNStatusFileProvider myDelegate;

        private WrapperSVNStatusFileProvider(ISVNStatusFileProvider defaultProvider, ISVNStatusFileProvider delegate) {
            this.myDefault = defaultProvider;
            this.myDelegate = delegate;
        }

        public Map getChildrenFiles(File parent) {
            Map<String, File> result = this.myDelegate.getChildrenFiles(parent);
            if (result != null) {
                return result;
            }
            return this.myDefault.getChildrenFiles(parent);
        }
    }
}

