/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNXMLAdminArea;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNXMLAdminAreaFactory
extends SVNAdminAreaFactory {
    public static final int WC_FORMAT = 4;

    protected void doCreateVersionedDirectory(File path, String url, String rootURL, String uuid, long revNumber, SVNDepth depth) throws SVNException {
        SVNXMLAdminArea adminArea = new SVNXMLAdminArea(path);
        adminArea.createVersionedDirectory(path, url, rootURL, uuid, revNumber, true, depth);
    }

    protected SVNAdminArea doOpen(File path, int version) throws SVNException {
        if (version != 4) {
            return null;
        }
        return new SVNXMLAdminArea(path);
    }

    protected SVNAdminArea doChangeWCFormat(SVNAdminArea adminArea) throws SVNException {
        if (adminArea == null || adminArea.getClass() == SVNXMLAdminArea.class) {
            return adminArea;
        }
        SVNXMLAdminArea newAdminArea = new SVNXMLAdminArea(adminArea.getRoot());
        newAdminArea.setLocked(true);
        return newAdminArea.formatWC(adminArea);
    }

    public int getSupportedVersion() {
        return 4;
    }

    protected int doCheckWC(File path, Level logLevel) throws SVNException {
        SVNErrorMessage err;
        String line;
        int formatVersion;
        File formatFile;
        block11: {
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            formatFile = new File(adminDir, "format");
            formatVersion = -1;
            BufferedReader reader = null;
            line = null;
            try {
                reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(formatFile, logLevel, SVNLogType.WC), "UTF-8"));
                line = reader.readLine();
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read entries file ''{0}'': {1}", formatFile, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(reader);
                break block11;
            }
            catch (SVNException svne) {
                block12: {
                    block13: {
                        try {
                            SVNFileType type = SVNFileType.getType(path);
                            if (type == SVNFileType.DIRECTORY && formatFile.isFile()) break block12;
                            if (type == SVNFileType.NONE) {
                                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "''{0}'' does not exist", (Object)path);
                                SVNErrorManager.error(err2, SVNLogType.WC);
                                break block13;
                            }
                            if (formatFile.isFile() || !adminDir.isDirectory()) break block13;
                            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "File ''{0}'' does not exist", (Object)formatFile);
                            SVNErrorManager.error(err3, SVNLogType.WC);
                        }
                        catch (Throwable throwable) {
                            SVNFileUtil.closeFile(reader);
                            throw throwable;
                        }
                    }
                    SVNFileUtil.closeFile(reader);
                    return 0;
                }
                throw svne;
            }
            SVNFileUtil.closeFile(reader);
        }
        if (line == null || line.length() == 0) {
            SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)formatFile);
            SVNErrorManager.error(err4, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException e) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)formatFile);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return formatVersion;
    }

    protected int getVersion(File path) throws SVNException {
        SVNErrorMessage err;
        int formatVersion;
        String line;
        File formatFile;
        block9: {
            File adminDir = new File(path, SVNFileUtil.getAdminDirectoryName());
            formatFile = new File(adminDir, "format");
            BufferedReader reader = null;
            line = null;
            formatVersion = -1;
            try {
                reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(formatFile, Level.FINEST, SVNLogType.WC), "UTF-8"));
                line = reader.readLine();
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read format file ''{0}'': {1}", formatFile, e.getLocalizedMessage());
                SVNErrorManager.error(err, e, SVNLogType.WC);
                SVNFileUtil.closeFile(reader);
                break block9;
            }
            catch (SVNException svne) {
                try {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
                    err.setChildErrorMessage(svne.getErrorMessage());
                    SVNErrorManager.error(err, svne, Level.FINEST, SVNLogType.WC);
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(reader);
                    throw throwable;
                }
                SVNFileUtil.closeFile(reader);
                break block9;
            }
            SVNFileUtil.closeFile(reader);
        }
        if (line == null || line.length() == 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Reading ''{0}''", (Object)formatFile);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err1.setChildErrorMessage(err2);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        try {
            formatVersion = Integer.parseInt(line.trim());
        }
        catch (NumberFormatException nfe) {
            err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)formatFile);
            SVNErrorMessage err1 = SVNErrorMessage.create(SVNErrorCode.WC_NOT_DIRECTORY, "''{0}'' is not a working copy", (Object)path);
            err1.setChildErrorMessage(err);
            SVNErrorManager.error(err1, Level.FINEST, SVNLogType.WC);
        }
        return formatVersion;
    }
}

