/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNStatusEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNDiffEditor17
implements ISVNUpdateEditor {
    private long targetRevision;
    private boolean isRootOpen;
    private File localTarget;
    private SVNDepth depth;
    private SVNDirectoryInfo currentDirectory;
    private SVNWCContext wcContext;
    private File workingCopyRoot;
    private boolean isCompareToBase;
    private boolean isReverseDiff;
    private ISvnDiffCallback diffCallback;
    private boolean useAncestry;
    private SVNFileInfo currentFile;
    private SVNDeltaProcessor deltaProcessor;
    private File tempDirectory;
    private Collection<String> changeLists;
    private String relativeToDirectory;
    private boolean diffUnversioned;
    private boolean diffCopiedAsAdded;

    public SVNDiffEditor17(SVNWCContext wcContext, File workingCopyRoot, File localTarget, SVNDepth depth, boolean compareToBase, boolean reverseDiff, ISvnDiffCallback diffCallback, boolean useAncestry, Collection<String> changeLists, boolean diffUnversioned, boolean diffCopiedAsAdded) {
        this.wcContext = wcContext;
        this.workingCopyRoot = workingCopyRoot;
        this.localTarget = localTarget;
        this.depth = depth;
        this.isCompareToBase = compareToBase;
        this.isReverseDiff = reverseDiff;
        this.diffCallback = diffCallback;
        this.useAncestry = useAncestry;
        this.changeLists = changeLists;
        this.diffUnversioned = diffUnversioned;
        this.diffCopiedAsAdded = diffCopiedAsAdded;
        this.deltaProcessor = new SVNDeltaProcessor();
    }

    @Override
    public long getTargetRevision() {
        return this.targetRevision;
    }

    public File getWorkingCopyRoot() {
        return this.workingCopyRoot;
    }

    public ISvnDiffCallback getDiffCallback() {
        return this.diffCallback;
    }

    private SvnDiffCallbackResult getDiffCallbackResult() {
        return null;
    }

    private boolean isDiffCopiedAsAdded() {
        return this.diffCopiedAsAdded;
    }

    private boolean isDiffUnversioned() {
        return this.diffUnversioned;
    }

    private File createTempDirectory() throws SVNException {
        return SVNFileUtil.createTempDirectory("diff");
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.targetRevision = revision;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.isRootOpen = true;
        this.currentDirectory = this.createDirInfo(null, "", false, this.depth);
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        File fullPath = new File(this.getWorkingCopyRoot(), path);
        SVNWCContext.ScheduleInternalInfo schedule = this.wcContext.getNodeScheduleInternal(fullPath, true, false);
        Structure<StructureFields.NodeInfo> nodeInfo = this.wcContext.getDb().readInfo(fullPath, StructureFields.NodeInfo.kind);
        String name = SVNPathUtil.tail(path);
        this.currentDirectory.comparedEntries.add(name);
        if (!this.isCompareToBase && schedule.schedule == SVNWCContext.SVNWCSchedule.delete) {
            return;
        }
        ISVNWCDb.SVNWCDbKind nodeKind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
        if (nodeKind == ISVNWCDb.SVNWCDbKind.File) {
            if (this.isReverseDiff) {
                SVNProperties baseProps = this.wcContext.getDb().getBaseProps(fullPath);
                this.getDiffCallback().fileDeleted(this.getDiffCallbackResult(), fullPath, null, null, null, null, baseProps);
            } else {
                this.reportAddedFile(this.currentDirectory, fullPath);
            }
        } else if (nodeKind == ISVNWCDb.SVNWCDbKind.Dir) {
            SVNDirectoryInfo info = this.createDirInfo(this.currentDirectory, path, false, SVNDepth.INFINITY);
            this.reportAddedDir(info);
        }
    }

    private void reportAddedDir(SVNDirectoryInfo info) throws SVNException {
        SVNProperties wcProps;
        SVNProperties propDiff;
        File fullPath = new File(this.getWorkingCopyRoot(), info.path);
        if (this.wcContext.matchesChangelist(new File(this.getWorkingCopyRoot(), info.path), this.changeLists) && !(propDiff = SVNDiffEditor17.computePropsDiff(new SVNProperties(), wcProps = this.isCompareToBase ? this.wcContext.getPristineProps(fullPath) : this.wcContext.getActualProps(fullPath))).isEmpty()) {
            this.getDiffCallback().dirPropsChanged(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), info.path), true, propDiff, null);
        }
        List<File> children = this.wcContext.getNodeChildren(fullPath, false);
        for (File child : children) {
            SVNWCContext.ScheduleInternalInfo schedule = this.wcContext.getNodeScheduleInternal(child, true, false);
            if (!this.isCompareToBase && schedule.schedule == SVNWCContext.SVNWCSchedule.delete) continue;
            ISVNWCDb.WCDbBaseInfo baseInfo = this.wcContext.getDb().getBaseInfo(child, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind);
            if (baseInfo.kind == ISVNWCDb.SVNWCDbKind.File) {
                this.reportAddedFile(info, child);
                continue;
            }
            if (baseInfo.kind != ISVNWCDb.SVNWCDbKind.Dir || info.depth.compareTo(SVNDepth.FILES) <= 0 && info.depth != SVNDepth.UNKNOWN) continue;
            SVNDepth depthBelowHere = info.depth;
            if (depthBelowHere == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.path, child.getName()), false, depthBelowHere);
            this.reportAddedDir(childInfo);
        }
    }

    private void reportAddedFile(SVNDirectoryInfo info, File entryPath) throws SVNException {
        File sourceFile;
        if (!this.wcContext.matchesChangelist(entryPath, this.changeLists)) {
            return;
        }
        if (!this.matchesLocalTarget(entryPath)) {
            return;
        }
        SVNWCContext.ScheduleInternalInfo schedule = this.wcContext.getNodeScheduleInternal(entryPath, false, true);
        ISVNWCDb.WCDbInfo wcDbInfo = this.wcContext.getDb().readInfo(entryPath, ISVNWCDb.WCDbInfo.InfoField.revision);
        if (schedule.copied) {
            if (this.isCompareToBase) {
                return;
            }
            this.reportModifiedFile(info, entryPath);
            return;
        }
        SVNProperties wcProps = this.isCompareToBase ? this.wcContext.getPristineProps(entryPath) : this.wcContext.getActualProps(entryPath);
        String mimeType = wcProps.getStringValue("svn:mime-type");
        SVNProperties propDiff = SVNDiffEditor17.computePropsDiff(new SVNProperties(), wcProps);
        if (this.isCompareToBase) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.wcContext.getDb().getBaseInfo(entryPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
            sourceFile = this.wcContext.getDb().getPristinePath(entryPath, baseInfo.checksum);
        } else {
            sourceFile = this.detranslateFile(entryPath);
        }
        this.getDiffCallback().fileAdded(this.getDiffCallbackResult(), entryPath, null, sourceFile, 0L, wcDbInfo.revision, null, mimeType, null, -1L, propDiff, null);
    }

    private void reportModifiedFile(SVNDirectoryInfo dirInfo, File entryPath) throws SVNException {
        boolean isAdded;
        SvnChecksum checksum;
        if (!this.wcContext.matchesChangelist(entryPath, this.changeLists)) {
            return;
        }
        if (!this.matchesLocalTarget(entryPath)) {
            return;
        }
        SVNWCContext.ScheduleInternalInfo schedule = this.wcContext.getNodeScheduleInternal(entryPath, true, true);
        SVNWCContext.SVNWCSchedule newSchedule = schedule.schedule;
        if (!this.isDiffCopiedAsAdded() && schedule.copied) {
            newSchedule = null;
        }
        if (!this.useAncestry && schedule.schedule == SVNWCContext.SVNWCSchedule.replace) {
            newSchedule = null;
        }
        SVNProperties propDiff = null;
        SVNProperties baseProps = null;
        try {
            Structure<StructureFields.NodeInfo> infoStructure = this.wcContext.getDb().readInfo(entryPath, StructureFields.NodeInfo.checksum);
            checksum = (SvnChecksum)infoStructure.get(StructureFields.NodeInfo.checksum);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) {
                checksum = null;
            }
            throw e;
        }
        File pristineFile = checksum == null ? null : this.wcContext.getDb().getPristinePath(entryPath, checksum);
        SVNProperties pristineProps = this.wcContext.getPristineProps(entryPath);
        if (pristineProps == null) {
            pristineProps = new SVNProperties();
        }
        if (schedule.schedule != SVNWCContext.SVNWCSchedule.delete) {
            if (this.isDiffCopiedAsAdded() && schedule.copied) {
                baseProps = new SVNProperties();
                propDiff = this.wcContext.getActualProps(entryPath);
            } else {
                baseProps = pristineProps;
                boolean modified = this.wcContext.isPropsModified(entryPath);
                propDiff = modified ? SVNDiffEditor17.computePropsDiff(baseProps, this.wcContext.getActualProps(entryPath)) : new SVNProperties();
            }
        } else {
            baseProps = pristineProps;
        }
        boolean bl = isAdded = newSchedule != null && schedule.schedule == SVNWCContext.SVNWCSchedule.add;
        if (schedule.schedule == SVNWCContext.SVNWCSchedule.delete || schedule.schedule == SVNWCContext.SVNWCSchedule.replace) {
            String mimeType = pristineProps.getStringValue("svn:mime-type");
            this.getDiffCallback().fileDeleted(this.getDiffCallbackResult(), entryPath, pristineFile, null, mimeType, null, pristineProps);
            boolean bl2 = isAdded = schedule.schedule == SVNWCContext.SVNWCSchedule.replace;
        }
        if (isAdded) {
            ISVNWCDb.WCDbInfo wcDbInfo = this.wcContext.getDb().readInfo(entryPath, ISVNWCDb.WCDbInfo.InfoField.revision);
            String mimeType = this.wcContext.getActualProps(entryPath).getStringValue("svn:mime-type");
            File tmpFile = this.detranslateFile(entryPath);
            SVNProperties originalProperties = null;
            long revision = wcDbInfo.revision;
            if (schedule.copied && this.isDiffCopiedAsAdded()) {
                originalProperties = new SVNProperties();
                revision = 0L;
            } else {
                originalProperties = pristineProps;
            }
            this.getDiffCallback().fileAdded(this.getDiffCallbackResult(), entryPath, null, tmpFile, -1L, revision, mimeType, null, null, -1L, propDiff, originalProperties);
        } else if (newSchedule == null || schedule.schedule == SVNWCContext.SVNWCSchedule.normal) {
            boolean modified = this.wcContext.isTextModified(entryPath, false);
            File tmpFile = null;
            if (modified) {
                tmpFile = this.detranslateFile(entryPath);
            }
            if (modified || propDiff != null && !propDiff.isEmpty()) {
                String baseMimeType = pristineProps.getStringValue("svn:mime-type");
                String mimeType = this.wcContext.getActualProps(entryPath).getStringValue("svn:mime-type");
                ISVNWCDb.WCDbInfo wcDbInfo = this.wcContext.getDb().readInfo(entryPath, ISVNWCDb.WCDbInfo.InfoField.revision);
                this.getDiffCallback().fileChanged(this.getDiffCallbackResult(), entryPath, modified ? pristineFile : null, tmpFile, wcDbInfo.revision, -1L, baseMimeType, mimeType, propDiff, baseProps);
            }
        }
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNDepth subDirDepth = this.currentDirectory.depth;
        if (subDirDepth == SVNDepth.IMMEDIATES) {
            subDirDepth = SVNDepth.EMPTY;
        }
        this.currentDirectory = this.createDirInfo(this.currentDirectory, path, true, subDirDepth);
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        SVNDepth subDirDepth = this.currentDirectory.depth;
        if (subDirDepth == SVNDepth.IMMEDIATES) {
            subDirDepth = SVNDepth.EMPTY;
        }
        this.currentDirectory = this.createDirInfo(this.currentDirectory, path, false, subDirDepth);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (this.currentDirectory.propertyDiff == null) {
            this.currentDirectory.propertyDiff = new SVNProperties();
        }
        this.currentDirectory.propertyDiff.put(name, value);
    }

    @Override
    public void closeDir() throws SVNException {
        File fullPath = new File(this.getWorkingCopyRoot(), this.currentDirectory.path);
        SVNProperties diff = this.currentDirectory.propertyDiff;
        if (diff != null && !diff.isEmpty()) {
            SVNProperties originalProps = null;
            if (this.currentDirectory.isAdded) {
                originalProps = new SVNProperties();
            } else if (this.isCompareToBase) {
                originalProps = this.wcContext.getPristineProps(fullPath);
            } else {
                originalProps = this.wcContext.getActualProps(fullPath);
                SVNProperties baseProps = this.wcContext.getPristineProps(fullPath);
                SVNProperties reposProps = this.applyPropChanges(baseProps, this.currentDirectory.propertyDiff);
                diff = SVNDiffEditor17.computePropsDiff(originalProps, reposProps);
            }
            if (!this.isReverseDiff) {
                SVNDiffEditor17.reversePropChanges(originalProps, diff);
            }
            this.getDiffCallback().dirPropsChanged(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), this.currentDirectory.path), this.currentDirectory.isAdded, diff, originalProps);
            this.currentDirectory.comparedEntries.add("");
        }
        if (!this.currentDirectory.isAdded) {
            this.localDirectoryDiff(this.currentDirectory);
        }
        String name = SVNPathUtil.tail(this.currentDirectory.path);
        this.currentDirectory = this.currentDirectory.parent;
        if (this.currentDirectory != null) {
            this.currentDirectory.comparedEntries.add(name);
        }
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.currentFile = this.createFileInfo(this.currentDirectory, path, true);
        this.currentDirectory.comparedEntries.add(name);
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        String name = SVNPathUtil.tail(path);
        this.currentFile = this.createFileInfo(this.currentDirectory, path, false);
        this.currentDirectory.comparedEntries.add(name);
    }

    @Override
    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (this.currentFile.propertyDiff == null) {
            this.currentFile.propertyDiff = new SVNProperties();
        }
        this.currentFile.propertyDiff.put(name, value);
    }

    @Override
    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        SVNWCContext.ScheduleInternalInfo schedule;
        File fullPath = new File(this.getWorkingCopyRoot(), path);
        try {
            schedule = this.wcContext.getNodeScheduleInternal(fullPath, false, true);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                schedule = null;
            }
            throw e;
        }
        if (schedule != null && schedule.copied) {
            this.currentFile.isAdded = false;
        }
        if (!this.currentFile.isAdded) {
            SVNWCContext.PristineContentsInfo pristineContents = this.wcContext.getPristineContents(fullPath, false, true);
            this.currentFile.pristineFile = pristineContents.path;
        }
        this.currentFile.file = this.createTempFile();
        this.deltaProcessor.applyTextDelta(this.currentFile.pristineFile, this.currentFile.file, false);
    }

    @Override
    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        return this.deltaProcessor.textDeltaChunk(diffWindow);
    }

    @Override
    public void textDeltaEnd(String path) throws SVNException {
        this.deltaProcessor.textDeltaEnd();
    }

    @Override
    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        boolean modified;
        SVNWCContext.ScheduleInternalInfo schedule;
        SVNProperties baseProperties;
        File fullPath;
        block21: {
            fullPath = new File(this.workingCopyRoot, commitPath);
            baseProperties = null;
            if (!this.currentFile.isAdded) {
                try {
                    baseProperties = this.wcContext.getDb().getBaseProps(fullPath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block21;
                    throw e;
                }
            }
        }
        if (baseProperties == null) {
            baseProperties = new SVNProperties();
        }
        SVNProperties reposProperties = this.applyPropChanges(baseProperties, this.currentFile.propertyDiff);
        String reposMimeType = reposProperties.getStringValue("svn:mime-type");
        File reposFile = this.currentFile.file;
        File localFile = null;
        if (reposFile == null) {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.wcContext.getDb().getBaseInfo(fullPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
            reposFile = this.wcContext.getDb().getPristinePath(fullPath, baseInfo.checksum);
        }
        try {
            schedule = this.wcContext.getNodeScheduleInternal(fullPath, true, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                schedule = null;
            }
            throw e;
        }
        if (this.currentFile.isAdded || !this.isCompareToBase && schedule != null && schedule.schedule == SVNWCContext.SVNWCSchedule.delete) {
            if (this.isReverseDiff) {
                this.getDiffCallback().fileAdded(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), commitPath), null, reposFile, 0L, this.targetRevision, reposMimeType, null, null, -1L, this.currentFile.propertyDiff, null);
            } else {
                this.getDiffCallback().fileDeleted(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), commitPath), reposFile, null, reposMimeType, null, reposProperties);
            }
            return;
        }
        boolean bl = modified = this.currentFile.file != null;
        if (!modified && !this.isCompareToBase) {
            modified = this.wcContext.isTextModified(fullPath, false);
        }
        if (modified) {
            if (this.isCompareToBase) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.wcContext.getDb().getBaseInfo(fullPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
                localFile = this.wcContext.getDb().getPristinePath(fullPath, baseInfo.checksum);
            } else {
                localFile = this.detranslateFile(fullPath);
            }
        } else {
            localFile = null;
            reposFile = null;
        }
        SVNProperties originalProps = null;
        if (this.isCompareToBase) {
            originalProps = baseProperties;
        } else {
            originalProps = this.wcContext.getDb().readPristineProperties(fullPath);
            this.currentFile.propertyDiff = SVNDiffEditor17.computePropsDiff(originalProps, reposProperties);
        }
        if (localFile != null || this.currentFile.propertyDiff != null && !this.currentFile.propertyDiff.isEmpty()) {
            String originalMimeType = originalProps.getStringValue("svn:mime-type");
            if (this.currentFile.propertyDiff != null && !this.currentFile.propertyDiff.isEmpty() && !this.isReverseDiff) {
                SVNDiffEditor17.reversePropChanges(originalProps, this.currentFile.propertyDiff);
            }
            if (localFile != null || reposFile != null || this.currentFile.propertyDiff != null && !this.currentFile.propertyDiff.isEmpty()) {
                this.getDiffCallback().fileChanged(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), commitPath), this.isReverseDiff ? localFile : reposFile, this.isReverseDiff ? reposFile : localFile, this.isReverseDiff ? -1L : this.targetRevision, this.isReverseDiff ? this.targetRevision : -1L, this.isReverseDiff ? originalMimeType : reposMimeType, this.isReverseDiff ? reposMimeType : originalMimeType, this.currentFile.propertyDiff, originalProps);
            }
        }
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (!this.isRootOpen) {
            this.localDirectoryDiff(this.createDirInfo(null, "", false, this.depth));
        }
        return null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    @Override
    public void absentDir(String path) throws SVNException {
    }

    @Override
    public void absentFile(String path) throws SVNException {
    }

    public void cleanup() {
        if (this.tempDirectory != null) {
            SVNFileUtil.deleteAll(this.tempDirectory, true);
        }
    }

    private SVNProperties applyPropChanges(SVNProperties props, SVNProperties propChanges) {
        SVNProperties result = new SVNProperties(props);
        if (propChanges != null) {
            for (String name : propChanges.nameSet()) {
                SVNPropertyValue value = propChanges.getSVNPropertyValue(name);
                if (value == null) {
                    result.remove(name);
                    continue;
                }
                result.put(name, value);
            }
        }
        return result;
    }

    private void localDirectoryDiff(SVNDirectoryInfo info) throws SVNException {
        if (this.isCompareToBase) {
            return;
        }
        File fullPath = new File(this.getWorkingCopyRoot(), info.path);
        if (this.wcContext.matchesChangelist(new File(this.getWorkingCopyRoot(), info.path), this.changeLists) && !info.comparedEntries.contains("") && this.wcContext.isPropsModified(fullPath) && this.matchesLocalTarget(fullPath)) {
            SVNProperties baseProps = this.wcContext.getPristineProps(fullPath);
            SVNProperties propDiff = baseProps.compareTo(this.wcContext.getActualProps(fullPath));
            this.getDiffCallback().dirPropsChanged(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), info.path), info.isAdded, propDiff, baseProps);
        }
        if (info.depth == SVNDepth.EMPTY) {
            return;
        }
        SVNHashSet processedFiles = null;
        if (this.isDiffUnversioned()) {
            processedFiles = new SVNHashSet();
        }
        List<File> children = this.wcContext.getNodeChildren(fullPath, false);
        for (File child : children) {
            if (processedFiles != null) {
                processedFiles.add(child.getName());
            }
            if (info.comparedEntries.contains(child.getName())) continue;
            info.comparedEntries.add(child.getName());
            Structure<StructureFields.NodeInfo> nodeInfoStructure = this.wcContext.getDb().readInfo(child, StructureFields.NodeInfo.kind);
            ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfoStructure.get(StructureFields.NodeInfo.kind));
            if (kind == ISVNWCDb.SVNWCDbKind.File) {
                this.reportModifiedFile(info, child);
                continue;
            }
            if (kind != ISVNWCDb.SVNWCDbKind.Dir || info.depth.compareTo(SVNDepth.FILES) <= 0 && info.depth != SVNDepth.UNKNOWN) continue;
            SVNDepth depthBelowHere = info.depth;
            if (depthBelowHere == SVNDepth.IMMEDIATES) {
                depthBelowHere = SVNDepth.EMPTY;
            }
            SVNDirectoryInfo childInfo = this.createDirInfo(info, SVNPathUtil.append(info.path, child.getName()), false, depthBelowHere);
            this.localDirectoryDiff(childInfo);
        }
        if (this.isDiffUnversioned()) {
            throw new UnsupportedOperationException();
        }
    }

    private boolean matchesLocalTarget(File fullPath) {
        return this.localTarget == null || SVNPathUtil.isWithinBasePath(this.localTarget.getAbsolutePath(), fullPath.getAbsolutePath());
    }

    private void diffUnversioned(File root, SVNAdminArea dir, String parentRelativePath, boolean anchor, Set processedFiles) throws SVNException {
        File[] allFiles = SVNFileListUtil.listFiles(root);
        int i = 0;
        while (allFiles != null && i < allFiles.length) {
            block12: {
                SVNFileType fileType;
                File file;
                block13: {
                    file = allFiles[i];
                    if (SVNFileUtil.getAdminDirectoryName().equals(file.getName()) || processedFiles != null && processedFiles.contains(file.getName())) break block12;
                    if (dir == null) break block13;
                    Collection globalIgnores = SVNStatusEditor.getGlobalIgnores(this.wcContext.getOptions());
                    Collection ignores = SVNStatusEditor.getIgnorePatterns(dir, globalIgnores);
                    String rootRelativePath = null;
                    boolean needToComputeRelativePath = false;
                    for (String pattern : ignores) {
                        if (!pattern.startsWith("/")) continue;
                        needToComputeRelativePath = true;
                        break;
                    }
                    if (needToComputeRelativePath) {
                        if (this.relativeToDirectory == null) {
                            File wcRoot = SVNWCUtil.getWorkingCopyRoot(dir.getRoot(), true);
                            this.relativeToDirectory = wcRoot.getAbsolutePath().replace(File.separatorChar, '/');
                        }
                        if (this.relativeToDirectory != null) {
                            rootRelativePath = file.getAbsolutePath().replace(File.separatorChar, '/');
                            if ((rootRelativePath = SVNPathUtil.getPathAsChild(this.relativeToDirectory, rootRelativePath)) != null && !rootRelativePath.startsWith("/")) {
                                rootRelativePath = "/" + rootRelativePath;
                            }
                        }
                    }
                    if (SVNStatusEditor.isIgnored(ignores, file, rootRelativePath)) break block12;
                }
                if ((fileType = SVNFileType.getType(file)) == SVNFileType.DIRECTORY) {
                    this.diffUnversioned(file, null, SVNPathUtil.append(parentRelativePath, file.getName()), false, null);
                } else if (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK) {
                    String mimeType1 = null;
                    String mimeType2 = SVNFileUtil.detectMimeType(file, null);
                    String filePath = SVNPathUtil.append(parentRelativePath, file.getName());
                    this.getDiffCallback().fileAdded(this.getDiffCallbackResult(), new File(this.getWorkingCopyRoot(), filePath), null, file, -1L, -1L, mimeType1, mimeType2, null, -1L, null, null);
                }
            }
            ++i;
        }
    }

    private SVNDirectoryInfo createDirInfo(SVNDirectoryInfo parent, String path, boolean added, SVNDepth depth) {
        SVNDirectoryInfo info = new SVNDirectoryInfo();
        info.parent = parent;
        info.path = path;
        info.isAdded = added;
        info.depth = depth;
        return info;
    }

    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) {
        SVNFileInfo info = new SVNFileInfo();
        info.path = path;
        info.isAdded = added;
        if (parent.isAdded) {
            while (parent.isAdded) {
                parent = parent.parent;
            }
            info.path = SVNPathUtil.append(parent.path, "fake");
        }
        return info;
    }

    private File detranslateFile(File fullPath) throws SVNException {
        boolean special;
        SVNProperties properties = this.wcContext.getPristineProps(fullPath);
        if (properties == null) {
            properties = new SVNProperties();
        }
        String keywords = properties.getStringValue("svn:keywords");
        String eolStyle = properties.getStringValue("svn:eol-style");
        String charsetProp = properties.getStringValue("svnkit:charset");
        String mimeType = properties.getStringValue("svn:mime-type");
        ISVNOptions options = this.wcContext.getOptions();
        String charset = SVNTranslator.getCharset(charsetProp, mimeType, fullPath.getPath(), options);
        boolean bl = special = properties.getSVNPropertyValue("svn:special") != null;
        if (!(charset != null || keywords != null || eolStyle != null || special && SVNFileUtil.symlinksSupported())) {
            return fullPath;
        }
        byte[] eol = SVNTranslator.getEOL(eolStyle, options);
        File tmpFile = this.createTempFile();
        Map<String, byte[]> keywordsMap = SVNTranslator.computeKeywords(keywords, null, null, null, null, null, null);
        SVNTranslator.translate(fullPath, tmpFile, charset, eol, keywordsMap, special, false);
        return tmpFile;
    }

    private File createTempFile() throws SVNException {
        File tmpFile = null;
        try {
            return File.createTempFile("diff.", ".tmp", this.getTempDirectory());
        }
        catch (IOException e) {
            SVNFileUtil.deleteFile(tmpFile);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
            return null;
        }
    }

    private File getTempDirectory() throws SVNException {
        if (this.tempDirectory == null) {
            this.tempDirectory = this.createTempDirectory();
        }
        return this.tempDirectory;
    }

    private static void reversePropChanges(SVNProperties base, SVNProperties diff) {
        ArrayList<String> namesList = new ArrayList<String>(diff.nameSet());
        for (String name : namesList) {
            SVNPropertyValue newValue = diff.getSVNPropertyValue(name);
            SVNPropertyValue oldValue = base.getSVNPropertyValue(name);
            if (oldValue == null && newValue != null) {
                base.put(name, newValue);
                diff.put(name, (SVNPropertyValue)null);
                continue;
            }
            if (oldValue != null && newValue == null) {
                base.put(name, (SVNPropertyValue)null);
                diff.put(name, oldValue);
                continue;
            }
            if (oldValue == null || newValue == null) continue;
            base.put(name, newValue);
            diff.put(name, oldValue);
        }
    }

    private static SVNProperties computePropsDiff(SVNProperties props1, SVNProperties props2) {
        SVNProperties propsDiff = new SVNProperties();
        for (String newPropName : props2.nameSet()) {
            if (props1.containsName(newPropName)) {
                SVNPropertyValue oldValue = props2.getSVNPropertyValue(newPropName);
                SVNPropertyValue value = props1.getSVNPropertyValue(newPropName);
                if (oldValue != null && !oldValue.equals(value)) {
                    propsDiff.put(newPropName, oldValue);
                    continue;
                }
                if (oldValue != null || value == null) continue;
                propsDiff.put(newPropName, oldValue);
                continue;
            }
            propsDiff.put(newPropName, props2.getSVNPropertyValue(newPropName));
        }
        for (String oldPropName : props1.nameSet()) {
            if (props2.containsName(oldPropName)) continue;
            propsDiff.put(oldPropName, (String)null);
        }
        return propsDiff;
    }

    private static class SVNDirectoryInfo {
        private boolean isAdded;
        private String path;
        private SVNProperties propertyDiff;
        private SVNDirectoryInfo parent;
        private Set comparedEntries = new SVNHashSet();
        private SVNDepth depth;

        private SVNDirectoryInfo() {
        }
    }

    private static class SVNFileInfo {
        private boolean isAdded;
        private String path;
        private File file;
        private File pristineFile;
        private SVNProperties propertyDiff;

        private SVNFileInfo() {
        }
    }
}

