/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgUpgradeSDb;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNWCDbRoot {
    private SVNWCDb db;
    private File absPath;
    private SVNSqlJetDb sDb;
    private long wcId;
    private int format;
    private List<WCLock> ownedLocks = new ArrayList<WCLock>();

    public SVNWCDbRoot(SVNWCDb db, File absPath, SVNSqlJetDb sDb, long wcId, int format, boolean autoUpgrade, boolean failOnVersionsMismatch, boolean enforceEmptyWQ) throws SVNException {
        SVNErrorMessage err;
        if (sDb != null) {
            try {
                format = sDb.getDb().getOptions().getUserVersion();
            }
            catch (SqlJetException e) {
                if (e.getErrorCode() == SqlJetErrorCode.NOTADB) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, e);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                SVNSqlJetDb.createSqlJetError(e);
            }
        }
        if (format < 1) {
            SqlJetException busyException = new SqlJetException(SqlJetErrorCode.BUSY);
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR), busyException, SVNLogType.WC);
        }
        if (format < 4) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_UPGRADE_REQUIRED, "Working copy format of ''{0}'' is too old ''{1}''", new Object[]{absPath, format});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (format > 31) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT, "This client is too old to work with the working copy at\n''{0}'' (format ''{1}'').", new Object[]{absPath, format});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (failOnVersionsMismatch && format < 29) {
            if (autoUpgrade) {
                format = SvnNgUpgradeSDb.upgrade(absPath, db, sDb, format, null);
            } else {
                err = SVNErrorMessage.create(SVNErrorCode.WC_UPGRADE_REQUIRED, "Working copy format of ''{0}'' is too old ''{1}''", new Object[]{absPath, format});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (format >= 13 && enforceEmptyWQ) {
            sDb.verifyNoWork();
        }
        this.db = db;
        this.absPath = absPath;
        this.sDb = sDb;
        this.wcId = wcId;
        this.format = format;
    }

    public SVNWCDb getDb() {
        return this.db;
    }

    public File getAbsPath() {
        return this.absPath;
    }

    public SVNSqlJetDb getSDb() {
        return this.sDb;
    }

    public long getWcId() {
        return this.wcId;
    }

    public int getFormat() {
        return this.format;
    }

    public List<WCLock> getOwnedLocks() {
        return this.ownedLocks;
    }

    public void close() throws SVNException {
        assert (this.sDb != null);
        try {
            this.sDb.close();
        }
        finally {
            this.sDb = null;
        }
    }

    public File getAbsPath(File localRelPath) {
        return SVNFileUtil.createFilePath(this.getAbsPath(), localRelPath);
    }

    public void ensureNoUnfinishedTransactions() throws SVNException {
        if (this.sDb != null && this.sDb.getOpenCount() != 0) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, "There are unfinished transactions detected in ''{0}''", (Object)this.absPath);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public File computeRelPath(File localAbsPath) {
        String relativePath = SVNPathUtil.getRelativePath(this.getAbsPath().getPath(), localAbsPath.getPath());
        return SVNFileUtil.createFilePath(relativePath);
    }

    public static class WCLock {
        public File localRelpath;
        public int levels;
    }
}

