/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db.statement;

import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

public class SVNWCDbNodesMinOpDepth
extends SVNSqlJetSelectStatement {
    private long minDepth;

    public SVNWCDbNodesMinOpDepth(SVNSqlJetDb sDb) throws SVNException {
        this(sDb, 1L);
    }

    public SVNWCDbNodesMinOpDepth(SVNSqlJetDb sDb, long minDepth) throws SVNException {
        super(sDb, SVNWCDbSchema.NODES);
        this.minDepth = minDepth;
    }

    protected boolean isFilterPassed() throws SVNException {
        return this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth) >= this.minDepth;
    }

    public Long getMinOpDepth(Long wcId, String localRelpath) throws SVNException {
        try {
            this.bindLong(1, wcId);
            this.bindString(2, localRelpath);
            long minOpDepth = Long.MAX_VALUE;
            boolean empty = true;
            while (this.next()) {
                long opDepth;
                if (empty) {
                    empty = false;
                }
                if (minOpDepth <= (opDepth = this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth))) continue;
                minOpDepth = opDepth;
            }
            if (empty) {
                return null;
            }
            Long l = minOpDepth;
            return l;
        }
        finally {
            this.reset();
        }
    }
}

