/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitMediator17;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgCommit
extends SvnNgOperationRunner<SVNCommitInfo, SvnCommit>
implements ISvnCommitRunner,
SvnNgCommitUtil.ISvnUrlKindCallback {
    @Override
    public SvnCommitPacket collectCommitItems(SvnCommit operation) throws SVNException {
        int depthEmptyAfter = -1;
        this.setOperation(operation);
        SvnCommitPacket packet = new SvnCommitPacket();
        ArrayList<String> targets = new ArrayList<String>();
        String[] validatedPaths = new String[((SvnCommit)this.getOperation()).getTargets().size()];
        int i = 0;
        for (SvnTarget target : ((SvnCommit)this.getOperation()).getTargets()) {
            validatedPaths[i] = target.getFile().getAbsolutePath();
            validatedPaths[i] = validatedPaths[i].replace(File.separatorChar, '/');
            ++i;
        }
        String rootPath = SVNPathUtil.condencePaths(validatedPaths, targets, false);
        if (rootPath == null) {
            return packet;
        }
        File baseDir = new File(rootPath).getAbsoluteFile();
        if (targets.isEmpty()) {
            targets.add("");
        }
        if (((SvnCommit)this.getOperation()).isIncludeFileExternals() || ((SvnCommit)this.getOperation()).isIncludeDirectoryExternals()) {
            if (((SvnCommit)this.getOperation()).getDepth() != SVNDepth.UNKNOWN && ((SvnCommit)this.getOperation()).getDepth() != SVNDepth.INFINITY) {
                depthEmptyAfter = targets.size();
            }
            this.appendExternalsAsExplicitTargets(targets, baseDir, ((SvnCommit)this.getOperation()).isIncludeFileExternals(), ((SvnCommit)this.getOperation()).isIncludeDirectoryExternals(), ((SvnCommit)this.getOperation()).getDepth(), this.getWcContext());
        }
        Collection<File> lockTargets = this.determineLockTargets(baseDir, targets);
        HashSet<File> lockedRoots = new HashSet<File>();
        try {
            for (File lockTarget : lockTargets) {
                File lockRoot = this.getWcContext().acquireWriteLock(lockTarget, false, true);
                lockedRoots.add(lockRoot);
            }
            packet.setLockingContext(this, lockedRoots);
            HashMap<SVNURL, String> lockTokens = new HashMap<SVNURL, String>();
            SvnNgCommitUtil.harvestCommittables(this.getWcContext(), packet, lockTokens, baseDir, targets, depthEmptyAfter, ((SvnCommit)this.getOperation()).getDepth(), !((SvnCommit)this.getOperation()).isKeepLocks(), ((SvnCommit)this.getOperation()).getApplicableChangelists(), this, ((SvnCommit)this.getOperation()).getCommitParameters(), null);
            packet.setLockTokens(lockTokens);
            if (((SvnCommit)this.getOperation()).isFailOnMultipleRepositories() && packet.getRepositoryRoots().size() > 1) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit can only commit to a single repository at a time.\nAre all targets part of the same working copy?");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (!packet.isEmpty()) {
                return packet;
            }
            packet.dispose();
            return new SvnCommitPacket();
        }
        catch (SVNException e) {
            packet.dispose();
            SVNErrorMessage err = e.getErrorMessage().wrap("Commit failed (details follow):");
            SVNErrorManager.error(err, SVNLogType.WC);
            return null;
        }
    }

    private void appendExternalsAsExplicitTargets(Collection<String> targets, File baseAbsPath, boolean includeFileExternals, boolean includeDirectoryExternals, SVNDepth depth, SVNWCContext context) throws SVNException {
        if (!includeFileExternals && !includeDirectoryExternals) {
            return;
        }
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        ArrayList<String> newTargets = new ArrayList<String>();
        for (String target : targets) {
            File targetAbsPath = SVNFileUtil.createFilePath(baseAbsPath, target);
            List<SVNWCContext.CommittableExternalInfo> externals = context.committableExternalsBelow(null, targetAbsPath, depth);
            if (externals == null) continue;
            for (SVNWCContext.CommittableExternalInfo xInfo : externals) {
                if (xInfo.kind == SVNNodeKind.FILE && !includeFileExternals || xInfo.kind == SVNNodeKind.DIR && !includeDirectoryExternals) continue;
                File targetRelPath = SVNFileUtil.skipAncestor(baseAbsPath, xInfo.localAbsPath);
                assert (targetRelPath != null && SVNFileUtil.getFilePath(targetRelPath).length() != 0);
                newTargets.add(SVNFileUtil.getFilePath(targetRelPath));
            }
        }
        targets.addAll(newTargets);
    }

    @Override
    protected SVNCommitInfo run(SVNWCContext context) throws SVNException {
        SvnCommitPacket[] packets = ((SvnCommit)this.getOperation()).splitCommitPackets(((SvnCommit)this.getOperation()).isCombinePackets());
        SVNCommitInfo result = SVNCommitInfo.NULL;
        int i = 0;
        while (i < packets.length) {
            if (packets[i] != null && !packets[i].isEmpty()) {
                packets[i] = packets[i].removeSkippedItems();
                SVNURL repositoryRoot = packets[i].getRepositoryRoots().iterator().next();
                result = this.doRun(context, packets[i]);
                if (result != null) {
                    ((SvnCommit)this.getOperation()).receive(SvnTarget.fromURL(repositoryRoot), result);
                }
            }
            ++i;
        }
        return result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected SVNCommitInfo doRun(SVNWCContext context, SvnCommitPacket packet) throws SVNException {
        block47: {
            revisionProperties = ((SvnCommit)this.getOperation()).getRevisionProperties();
            SVNPropertiesManager.validateRevisionProperties(revisionProperties);
            bumpError = null;
            info = null;
            try {
                block46: {
                    for (SVNURL repositoryRoot : packet.getRepositoryRoots()) {
                        items = packet.getItems(repositoryRoot);
                        for (Object item : items) {
                            if (item.hasFlag(64)) {
                                nodeMovedHere = context.nodeWasMovedHere(item.getPath());
                                movedFromAbsPath = nodeMovedHere.movedFromAbsPath;
                                deleteOpRootAbsPath = nodeMovedHere.deleteOpRootAbsPath;
                                if (movedFromAbsPath != null && deleteOpRootAbsPath != null && movedFromAbsPath.equals(deleteOpRootAbsPath)) {
                                    v0 = foundDeleteHalf = packet.getItem(deleteOpRootAbsPath) != null;
                                    if (!foundDeleteHalf && !deleteOpRootAbsPath.equals(deleteHalfParentAbsPath = SVNFileUtil.getFileDir(deleteOpRootAbsPath)) && (parentDeleteOpRootAbsPath = context.getNodeDeletedAncestor(deleteHalfParentAbsPath)) != null) {
                                        v1 = foundDeleteHalf = packet.getItem(parentDeleteOpRootAbsPath) != null;
                                    }
                                    if (!foundDeleteHalf) {
                                        errorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot commit ''{0}'' because it was moved from ''{1}'' which is not part of the commit; both sides of the move must be committed together", new Object[]{item.getPath(), deleteOpRootAbsPath});
                                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                                    }
                                }
                            }
                            if (!item.hasFlag(2)) continue;
                            nodeMovedAway = context.nodeWasMovedAway(item.getPath());
                            movedToAbsPath = nodeMovedAway.movedToAbsPath;
                            copyOpRootAbsPath = nodeMovedAway.opRootAbsPath;
                            if (movedToAbsPath == null || copyOpRootAbsPath == null || !movedToAbsPath.equals(copyOpRootAbsPath) || packet.getItem(copyOpRootAbsPath) != null) continue;
                            errorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot commit ''{0}'' because it was moved to ''{1}'' which is not part of the commit; both sides of the move must be committed together", new Object[]{item.getPath(), copyOpRootAbsPath});
                            SVNErrorManager.error(errorMessage, SVNLogType.WC);
                        }
                    }
                    commitMessage = ((SvnCommit)this.getOperation()).getCommitMessage();
                    if (((SvnCommit)this.getOperation()).getCommitHandler() != null) {
                        block44: {
                            items = new ArrayList<SvnCommitItem>();
                            for (SVNURL rootUrl : packet.getRepositoryRoots()) {
                                items.addAll(packet.getItems(rootUrl));
                            }
                            itemsArray = items.toArray(new SvnCommitItem[items.size()]);
                            commitMessage = ((SvnCommit)this.getOperation()).getCommitHandler().getCommitMessage(commitMessage, itemsArray);
                            if (commitMessage != null) break block44;
                            var27_21 = SVNCommitInfo.NULL;
                            return var27_21;
                        }
                        try {
                            revisionProperties = ((SvnCommit)this.getOperation()).getCommitHandler().getRevisionProperties(commitMessage, itemsArray, revisionProperties);
                        }
                        catch (SVNException e) {
                            err = e.getErrorMessage().wrap("Commit failed (details follow):");
                            SVNErrorManager.error(err, SVNLogType.WC);
                        }
                    }
                    commitMessage = commitMessage == null ? "" : SVNCommitUtil.validateCommitMessage(commitMessage);
                    keepLocks = ((SvnCommit)this.getOperation()).isKeepLocks();
                    repositoryRootUrl = packet.getRepositoryRoots().iterator().next();
                    if (packet.isEmpty(repositoryRootUrl)) {
                        var27_22 = SVNCommitInfo.NULL;
                        return var27_22;
                    }
                    committables = new TreeMap<String, SvnCommitItem>();
                    md5Checksums = new HashMap<File, SvnChecksum>();
                    sha1Checksums = new HashMap<File, SvnChecksum>();
                    baseURL = SvnNgCommitUtil.translateCommitables(packet.getItems(repositoryRootUrl), committables);
                    lockTokens = SvnNgCommitUtil.translateLockTokens(packet.getLockTokens(), baseURL);
                    firstItem = packet.getItems(repositoryRootUrl).iterator().next();
                    repository = this.getRepositoryAccess().createRepository(baseURL, firstItem.getPath());
                    mediator = new SVNCommitMediator17(context, committables);
                    commitEditor = null;
                    try {
                        try {
                            commitEditor = repository.getCommitEditor(commitMessage, lockTokens, keepLocks, revisionProperties, mediator);
                            committer = new SVNCommitter17(context, committables, repositoryRootUrl, mediator.getTmpFiles(), md5Checksums, sha1Checksums);
                            SVNCommitUtil.driveCommitEditor(committer, committables.keySet(), commitEditor, -1L);
                            committer.sendTextDeltas(commitEditor);
                            info = commitEditor.closeEdit();
                            commitEditor = null;
                            if (info.getErrorMessage() == null || info.getErrorMessage().getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
                                queue = new SvnCommittedQueue();
                                try {
                                    try {
                                        for (SvnCommitItem item : packet.getItems(repositoryRootUrl)) {
                                            this.postProcessCommitItem(queue, item, ((SvnCommit)this.getOperation()).isKeepChangelists(), ((SvnCommit)this.getOperation()).isKeepLocks(), (SvnChecksum)sha1Checksums.get(item.getPath()));
                                        }
                                        this.processCommittedQueue(queue, info.getNewRevision(), info.getDate(), info.getAuthor());
                                        this.deleteDeleteFiles(committer, ((SvnCommit)this.getOperation()).getCommitParameters());
                                    }
                                    catch (SVNException e) {
                                        bumpError = e;
                                        throw e;
                                    }
                                }
                                finally {
                                    if (packet.isLastPacket()) {
                                        this.sleepForTimestamp();
                                    }
                                }
                            }
                            this.handleEvent(SVNEventFactory.createSVNEvent(null, SVNNodeKind.NONE, null, info.getNewRevision(), SVNEventAction.COMMIT_COMPLETED, SVNEventAction.COMMIT_COMPLETED, null, null, -1L, -1L));
                            break block46;
                        }
                        catch (SVNException e) {
                            if (e instanceof SVNCancelException) {
                                throw e;
                            }
                            err = e.getErrorMessage().wrap("Commit failed (details follow):");
                            info = new SVNCommitInfo(-1L, null, null, err);
                            this.handleEvent(SVNEventFactory.createErrorEvent(err, SVNEventAction.COMMIT_COMPLETED), -1.0);
                            if (packet.getRepositoryRoots().size() == 1) {
                                SVNErrorManager.error(err, SVNLogType.WC);
                            }
                            if (commitEditor != null) {
                                try {
                                    commitEditor.abortEdit();
                                }
                                catch (SVNException e) {
                                    SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, e, Level.WARNING);
                                }
                            }
                            ** for (tmpFile : mediator.getTmpFiles())
                        }
                    }
                    catch (Throwable var23_41) {
                        if (commitEditor != null) {
                            try {
                                commitEditor.abortEdit();
                            }
                            catch (SVNException e) {
                                SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, e, Level.WARNING);
                            }
                        }
                        ** for (tmpFile : mediator.getTmpFiles())
                    }
lbl-1000:
                    // 1 sources

                    {
                        SVNFileUtil.deleteFile(tmpFile);
                        continue;
lbl110:
                        // 1 sources

                        break block47;
                    }
lbl-1000:
                    // 1 sources

                    {
                        SVNFileUtil.deleteFile(tmpFile);
                        continue;
                    }
lbl122:
                    // 1 sources

                    throw var23_41;
                }
                if (commitEditor != null) {
                    try {
                        commitEditor.abortEdit();
                    }
                    catch (SVNException e) {
                        SVNDebugLog.getDefaultLog().log(SVNLogType.CLIENT, e, Level.WARNING);
                    }
                }
                for (File tmpFile : mediator.getTmpFiles()) {
                    SVNFileUtil.deleteFile(tmpFile);
                }
            }
            finally {
                if (bumpError == null) {
                    packet.dispose();
                }
            }
        }
        return info;
    }

    private void postProcessCommitItem(SvnCommittedQueue queue, SvnCommitItem item, boolean keepChangelists, boolean keepLocks, SvnChecksum sha1Checksum) throws SVNException {
        boolean removeLock = !keepLocks && item.hasFlag(32);
        Map<String, SVNPropertyValue> wcPropChanges = item.getIncomingProperties();
        SVNProperties wcProps = null;
        if (wcPropChanges != null) {
            try {
                wcProps = this.getWcContext().getDb().getBaseDavCache(item.getPath());
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            if (wcProps == null) {
                wcProps = new SVNProperties();
            }
            for (String name : wcPropChanges.keySet()) {
                SVNPropertyValue pv = wcPropChanges.get(name);
                if (pv == null) {
                    wcProps.remove(name);
                    continue;
                }
                wcProps.put(name, pv);
            }
        }
        boolean unlockOnly = item.getFlags() == 32 && wcPropChanges == null;
        this.queueCommitted(queue, item.getPath(), false, wcProps, unlockOnly, removeLock, !keepChangelists, sha1Checksum);
    }

    @Override
    public SVNNodeKind getUrlKind(SVNURL url, long revision) throws SVNException {
        return this.getRepositoryAccess().createRepository(url, null).checkPath("", revision);
    }

    private Collection<File> determineLockTargets(File baseDirectory, Collection<String> targets) throws SVNException {
        HashMap<File, HashSet<File>> wcItems = new HashMap<File, HashSet<File>>();
        for (String t : targets) {
            File target = SVNFileUtil.createFilePath(baseDirectory, t);
            File wcRoot = null;
            try {
                wcRoot = this.getWcContext().getDb().getWCRoot(target);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw e;
            }
            HashSet<File> wcTargets = (HashSet<File>)wcItems.get(wcRoot);
            if (wcTargets == null) {
                wcTargets = new HashSet<File>();
                wcItems.put(wcRoot, wcTargets);
            }
            wcTargets.add(target);
        }
        HashSet<File> lockTargets = new HashSet<File>();
        for (File wcRoot : wcItems.keySet()) {
            Collection wcTargets = (Collection)wcItems.get(wcRoot);
            if (wcTargets.size() == 1) {
                if (wcRoot.equals(wcTargets.iterator().next())) {
                    lockTargets.add(wcRoot);
                    continue;
                }
                lockTargets.add(SVNFileUtil.getParentFile((File)wcTargets.iterator().next()));
                continue;
            }
            if (wcTargets.size() <= 1) continue;
            lockTargets.add(wcRoot);
        }
        return lockTargets;
    }

    @Override
    public Object splitLockingContext(Object lockingContext, SvnCommitPacket newPacket) {
        if (!(lockingContext instanceof Collection)) {
            return lockingContext;
        }
        Collection lockedPaths = (Collection)lockingContext;
        ArrayList<File> newLockedPaths = new ArrayList<File>();
        for (SVNURL root : newPacket.getRepositoryRoots()) {
            block1: for (SvnCommitItem item : newPacket.getItems(root)) {
                File path = item.getPath();
                for (File lockedPath : lockedPaths) {
                    if (!path.equals(lockedPath) && (!path.isFile() || !path.getParentFile().equals(lockedPath))) continue;
                    newLockedPaths.add(lockedPath);
                    continue block1;
                }
            }
        }
        return newLockedPaths;
    }

    @Override
    public void disposeCommitPacket(Object lockingContext, boolean disposeParentContext) throws SVNException {
        if (!(lockingContext instanceof Collection)) {
            if (disposeParentContext) {
                this.getWcContext().close();
            }
            return;
        }
        if (disposeParentContext) {
            Collection lockedPaths = (Collection)lockingContext;
            for (File lockedPath : lockedPaths) {
                try {
                    this.getWcContext().releaseWriteLock(lockedPath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) continue;
                    throw e;
                }
            }
            this.getWcContext().close();
        }
    }

    private void queueCommitted(SvnCommittedQueue queue, File localAbsPath, boolean recurse, SVNProperties wcPropChanges, boolean unlockOnly, boolean removeLock, boolean removeChangelist, SvnChecksum sha1Checksum) {
        SvnCommittedQueueItem cqi = new SvnCommittedQueueItem();
        cqi.localAbspath = localAbsPath;
        cqi.recurse = recurse;
        cqi.noUnlock = !removeLock;
        cqi.keepChangelist = !removeChangelist;
        cqi.sha1Checksum = sha1Checksum;
        cqi.newDavCache = wcPropChanges;
        cqi.unlockOnly = unlockOnly;
        queue.queue.put(localAbsPath, cqi);
    }

    private void processCommittedQueue(SvnCommittedQueue queue, long newRevision, Date revDate, String revAuthor) throws SVNException {
        HashMap itemsMap = new HashMap();
        for (SvnCommittedQueueItem cqi : queue.queue.values()) {
            File root = this.getWcContext().getDb().getWCRoot(cqi.localAbspath);
            if (!itemsMap.containsKey(root)) {
                itemsMap.put(root, new ArrayList());
            }
            ((Collection)itemsMap.get(root)).add(cqi);
        }
        queue.queue.clear();
        for (File root : itemsMap.keySet()) {
            SVNSqlJetDb db = this.getWcContext().getDb().getSDb(root);
            db.beginTransaction(SqlJetTransactionMode.WRITE);
            try {
                try {
                    for (SvnCommittedQueueItem cqi : (Collection)itemsMap.get(root)) {
                        this.processCommittedInternal(cqi.localAbspath, cqi.recurse, true, newRevision, new SVNDate(revDate.getTime(), 0), revAuthor, cqi.newDavCache, cqi.unlockOnly, cqi.noUnlock, cqi.keepChangelist, cqi.sha1Checksum, queue);
                    }
                    this.getWcContext().wqRun(root);
                }
                catch (SVNException th) {
                    db.rollback();
                    throw th;
                }
            }
            finally {
                db.commit();
            }
        }
    }

    private void processCommittedInternal(File localAbspath, boolean recurse, boolean topOfRecurse, long newRevision, SVNDate revDate, String revAuthor, SVNProperties newDavCache, boolean unlockOnly, boolean noUnlock, boolean keepChangelist, SvnChecksum sha1Checksum, SvnCommittedQueue queue) throws SVNException {
        this.processCommittedLeaf(localAbspath, !topOfRecurse, newRevision, revDate, revAuthor, newDavCache, unlockOnly, noUnlock, keepChangelist, sha1Checksum);
    }

    private void processCommittedLeaf(File localAbspath, boolean viaRecurse, long newRevnum, SVNDate newChangedDate, String newChangedAuthor, SVNProperties newDavCache, boolean unlockOnly, boolean noUnlock, boolean keepChangelist, SvnChecksum checksum) throws SVNException {
        long newChangedRev = newRevnum;
        assert (SVNFileUtil.isAbsolute(localAbspath));
        Structure<StructureFields.NodeInfo> nodeInfo = this.getWcContext().getDb().readInfo(localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod, StructureFields.NodeInfo.haveBase, StructureFields.NodeInfo.haveWork);
        File admAbspath = nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir ? localAbspath : SVNFileUtil.getFileDir(localAbspath);
        this.getWcContext().writeCheck(admAbspath);
        if (nodeInfo.get(StructureFields.NodeInfo.status) == ISVNWCDb.SVNWCDbStatus.Deleted) {
            this.getWcContext().getDb().removeBase(localAbspath, false, false, true, !viaRecurse ? newRevnum : -1L, null, null);
            nodeInfo.release();
            return;
        }
        if (nodeInfo.get(StructureFields.NodeInfo.status) == ISVNWCDb.SVNWCDbStatus.NotPresent) {
            nodeInfo.release();
            return;
        }
        if (unlockOnly) {
            if (!noUnlock) {
                this.getWcContext().getDb().removeLock(localAbspath);
            }
        } else {
            SVNSkel workItem = null;
            ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
            if (kind != ISVNWCDb.SVNWCDbKind.Dir) {
                if (checksum == null) {
                    checksum = (SvnChecksum)nodeInfo.get(StructureFields.NodeInfo.checksum);
                    if (viaRecurse && !nodeInfo.is(StructureFields.NodeInfo.propsMod)) {
                        Structure<StructureFields.NodeInfo> moreInfo = this.getWcContext().getDb().readInfo(localAbspath, StructureFields.NodeInfo.changedRev, StructureFields.NodeInfo.changedDate, StructureFields.NodeInfo.changedAuthor);
                        newChangedRev = moreInfo.lng(StructureFields.NodeInfo.changedRev);
                        newChangedDate = (SVNDate)moreInfo.get(StructureFields.NodeInfo.changedDate);
                        newChangedAuthor = (String)moreInfo.get(StructureFields.NodeInfo.changedAuthor);
                        moreInfo.release();
                    }
                }
                workItem = this.getWcContext().wqBuildFileCommit(localAbspath, nodeInfo.is(StructureFields.NodeInfo.propsMod));
            }
            this.getWcContext().getDb().globalCommit(localAbspath, newRevnum, newChangedRev, newChangedDate, newChangedAuthor, checksum, null, newDavCache, keepChangelist, noUnlock, workItem);
        }
    }

    private static class SvnCommittedQueue {
        public Map<File, SvnCommittedQueueItem> queue = new TreeMap<File, SvnCommittedQueueItem>(SVNCommitUtil.FILE_COMPARATOR);

        private SvnCommittedQueue() {
        }
    }

    private static class SvnCommittedQueueItem {
        public File localAbspath;
        public boolean recurse;
        public boolean noUnlock;
        public boolean keepChangelist;
        public SvnChecksum sha1Checksum;
        public SVNProperties newDavCache;
        public boolean unlockOnly;

        private SvnCommittedQueueItem() {
        }
    }
}

