/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc16.SVNUpdateClient16;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRunner;
import org.tmatesoft.svn.core.wc2.SvnCheckout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnOldCheckout
extends SvnOldRunner<Long, SvnCheckout> {
    @Override
    public boolean isApplicable(SvnCheckout operation, SvnWcGeneration wcGeneration) throws SVNException {
        int targetWorkingCopyFormat = operation.getTargetWorkingCopyFormat();
        if (targetWorkingCopyFormat > 0) {
            return targetWorkingCopyFormat < 12;
        }
        return super.isApplicable(operation, wcGeneration);
    }

    @Override
    protected Long run() throws SVNException {
        final int targetWorkingCopyFormat = ((SvnCheckout)this.getOperation()).getTargetWorkingCopyFormat();
        ISVNAdminAreaFactorySelector oldSelector = SVNAdminAreaFactory.getSelector();
        try {
            if (targetWorkingCopyFormat > 0) {
                SVNAdminAreaFactory.setSelector(new ISVNAdminAreaFactorySelector(){

                    @Override
                    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
                        ArrayList<SVNAdminAreaFactory> adminAreaFactories = new ArrayList<SVNAdminAreaFactory>(factories);
                        int index = this.findFactoryByFormat(adminAreaFactories, targetWorkingCopyFormat);
                        if (index > 0) {
                            SVNAdminAreaFactory adminAreaFactory = (SVNAdminAreaFactory)adminAreaFactories.get(index);
                            adminAreaFactories.remove(index);
                            adminAreaFactories.add(0, adminAreaFactory);
                        }
                        return adminAreaFactories;
                    }

                    private int findFactoryByFormat(List<SVNAdminAreaFactory> factories, int workingCopyFormat) {
                        int i = 0;
                        while (i < factories.size()) {
                            SVNAdminAreaFactory factory = factories.get(i);
                            if (factory.getSupportedVersion() == workingCopyFormat) {
                                return i;
                            }
                            ++i;
                        }
                        return -1;
                    }
                });
            }
            SVNUpdateClient16 client = new SVNUpdateClient16(((SvnCheckout)this.getOperation()).getRepositoryPool(), ((SvnCheckout)this.getOperation()).getOptions());
            client.setIgnoreExternals(((SvnCheckout)this.getOperation()).isIgnoreExternals());
            client.setUpdateLocksOnDemand(((SvnCheckout)this.getOperation()).isUpdateLocksOnDemand());
            client.setEventHandler(((SvnCheckout)this.getOperation()).getEventHandler());
            client.setExternalsHandler(SvnCodec.externalsHandler(((SvnCheckout)this.getOperation()).getExternalsHandler()));
            Long l = client.doCheckout(((SvnCheckout)this.getOperation()).getSource().getURL(), this.getFirstTarget(), ((SvnCheckout)this.getOperation()).getSource().getResolvedPegRevision(), ((SvnCheckout)this.getOperation()).getRevision(), ((SvnCheckout)this.getOperation()).getDepth(), ((SvnCheckout)this.getOperation()).isAllowUnversionedObstructions());
            return l;
        }
        finally {
            if (targetWorkingCopyFormat > 0) {
                SVNAdminAreaFactory.setSelector(oldSelector);
            }
        }
    }
}

