/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnHunkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnTargetContent {
    boolean existed;
    int currentLine;
    private SVNWCContext.SVNEolStyle eolStyle;
    private String eolStr;
    private List<Long> lines;
    private List<SvnHunkInfo> hunkInfos = new ArrayList<SvnHunkInfo>();
    private boolean eof;
    private Map<String, byte[]> keywords;
    private Object readBaton;
    private Object writeBaton;
    private ISeekCallback seekCallback;
    private ITellCallback tellCallback;
    private IRealLineCallback readLineCallback;
    private IWriteCallback writeCallback;

    public SvnTargetContent() {
        this.lines = new ArrayList<Long>();
        this.keywords = new HashMap<String, byte[]>();
        this.eolStyle = SVNWCContext.SVNEolStyle.Unknown;
    }

    public String readLine() throws SVNException {
        int maxLine = this.getLines().size() + 1;
        if (this.isEof() || this.getReadLineCallback() == null) {
            return "";
        }
        assert (this.getCurrentLine() <= maxLine);
        if (this.getCurrentLine() == maxLine) {
            long offset = this.getTellCallback().tell(this.getReadBaton());
            this.getLines().add(offset);
        }
        String[] eolStr = new String[1];
        boolean[] eof = new boolean[1];
        String line = this.getReadLineCallback().readLine(this.getReadBaton(), eolStr, eof);
        this.setEof(eof[0]);
        if (this.getEolStyle() == SVNWCContext.SVNEolStyle.None) {
            this.setEolStr(eolStr[0]);
        }
        if ((line = line != null ? SVNTranslator.translateString(line, null, this.getKeywords(), false, false) : "") != null && line.length() > 0 || eolStr != null) {
            this.setCurrentLine(this.getCurrentLine() + 1);
        }
        assert (this.getCurrentLine() > 0);
        return line;
    }

    /*
     * Unable to fully structure code
     */
    protected void seekToLine(int line) throws SVNException {
        block4: {
            if (!SvnTargetContent.$assertionsDisabled && line <= 0) {
                throw new AssertionError();
            }
            if (line == this.getCurrentLine()) {
                return;
            }
            savedLine = this.getCurrentLine();
            savedEof = this.isEof();
            if (line > this.getLines().size()) ** GOTO lbl14
            offset = this.getLines().get(line - 1);
            this.getSeekCallback().seek(this.getReadBaton(), offset);
            this.setCurrentLine(line);
            break block4;
lbl-1000:
            // 1 sources

            {
                this.readLine();
lbl14:
                // 2 sources

                ** while (!this.isEof() && this.getCurrentLine() < line)
            }
        }
        if (savedEof && savedLine > this.getCurrentLine()) {
            this.setEof(false);
        }
    }

    protected int scanForMatch(SvnDiffHunk hunk, boolean matchFirst, int upperLine, int fuzz, boolean ignoreWhitespace, boolean matchModified, ISVNCanceller canceller) throws SVNException {
        int matchedLine = 0;
        while (!(this.getCurrentLine() >= upperLine && upperLine != 0 || this.isEof())) {
            boolean matched;
            if (canceller != null) {
                canceller.checkCancelled();
            }
            if (matched = this.matchHunk(hunk, fuzz, ignoreWhitespace, matchModified)) {
                boolean taken = false;
                List<SvnHunkInfo> hunks = this.getHunkInfos();
                for (SvnHunkInfo hunkInfo : hunks) {
                    int length = matchModified ? hunkInfo.getHunk().getDirectedModifiedLength() : hunkInfo.getHunk().getDirectedOriginalLength();
                    boolean bl = taken = !hunkInfo.isRejected() && this.getCurrentLine() >= hunkInfo.getMatchedLine() && this.getCurrentLine() < hunkInfo.getMatchedLine() + length;
                    if (taken) break;
                }
                if (!taken) {
                    matchedLine = this.getCurrentLine();
                    if (matchFirst) break;
                }
            }
            if (this.isEof()) continue;
            this.seekToLine(this.getCurrentLine() + 1);
        }
        return matchedLine;
    }

    private boolean matchHunk(SvnDiffHunk hunk, int fuzz, boolean ignoreWhitespace, boolean matchModified) throws SVNException {
        String hunkLine;
        boolean[] hunkEof;
        int hunkLength;
        boolean matched = false;
        if (this.isEof()) {
            return matched;
        }
        int savedLine = this.getCurrentLine();
        int linesRead = 0;
        boolean linesMatched = false;
        int leadingContext = hunk.getLeadingContext();
        int trailingContext = hunk.getTrailingContext();
        if (matchModified) {
            hunk.resetModifiedText();
            hunkLength = hunk.getDirectedModifiedLength();
        } else {
            hunk.resetOriginalText();
            hunkLength = hunk.getDirectedOriginalLength();
        }
        do {
            hunkEof = new boolean[1];
            hunkLine = matchModified ? hunk.readLineModifiedText(null, hunkEof) : hunk.readLineOriginalText(null, hunkEof);
            String hunkLineTranslated = SVNTranslator.translateString(hunkLine, null, this.getKeywords(), false, false);
            String targetLine = this.readLine();
            ++linesRead;
            if (hunkEof[0] && hunkLine.length() == 0 || this.isEof() && targetLine.length() == 0) break;
            if (linesRead <= fuzz && leadingContext > fuzz || linesRead > hunkLength - fuzz && trailingContext > fuzz) {
                linesMatched = true;
                continue;
            }
            if (ignoreWhitespace) {
                String hunkLineTrimmed = hunkLineTranslated;
                String targetLineTrimmed = targetLine;
                hunkLineTrimmed = SVNFormatUtil.collapseSpaces(hunkLineTrimmed);
                targetLineTrimmed = SVNFormatUtil.collapseSpaces(targetLineTrimmed);
                linesMatched = hunkLineTrimmed.equals(targetLineTrimmed);
                continue;
            }
            linesMatched = hunkLineTranslated.equals(targetLine);
        } while (linesMatched);
        boolean ret = linesMatched && hunkEof[0] && hunkLine.length() == 0;
        this.seekToLine(savedLine);
        return ret;
    }

    protected boolean matchExistingTarget(SvnDiffHunk hunk) throws SVNException {
        boolean linesMatched;
        hunk.resetModifiedText();
        boolean[] hunkEof = new boolean[1];
        int savedLine = this.getCurrentLine();
        do {
            String line = this.readLine();
            String hunkLine = hunk.readLineModifiedText(null, hunkEof);
            String lineTranslated = SVNTranslator.translateString(line, null, this.getKeywords(), false, false);
            String hunkLineTranslated = SVNTranslator.translateString(hunkLine, null, this.getKeywords(), false, false);
            linesMatched = lineTranslated.equals(hunkLineTranslated);
            if (this.isEof() == hunkEof[0]) continue;
            return false;
        } while (linesMatched && !this.isEof() && !hunkEof[0]);
        boolean result = linesMatched && this.isEof() == hunkEof[0];
        this.seekToLine(savedLine);
        return result;
    }

    public boolean isExisted() {
        return this.existed;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public SVNWCContext.SVNEolStyle getEolStyle() {
        return this.eolStyle;
    }

    public String getEolStr() {
        return this.eolStr;
    }

    public List<Long> getLines() {
        return this.lines;
    }

    public List<SvnHunkInfo> getHunkInfos() {
        return this.hunkInfos;
    }

    public boolean isEof() {
        return this.eof;
    }

    public Map<String, byte[]> getKeywords() {
        return this.keywords;
    }

    public Object getReadBaton() {
        return this.readBaton;
    }

    public ISeekCallback getSeekCallback() {
        return this.seekCallback;
    }

    public ITellCallback getTellCallback() {
        return this.tellCallback;
    }

    public IRealLineCallback getReadLineCallback() {
        return this.readLineCallback;
    }

    public IWriteCallback getWriteCallback() {
        return this.writeCallback;
    }

    public void setExisted(boolean existed) {
        this.existed = existed;
    }

    public void setCurrentLine(int currentLine) {
        this.currentLine = currentLine;
    }

    public void setEolStyle(SVNWCContext.SVNEolStyle eolStyle) {
        this.eolStyle = eolStyle;
    }

    public void setEolStr(String eolStr) {
        this.eolStr = eolStr;
    }

    public void setLines(List<Long> lines) {
        this.lines = lines;
    }

    public void addHunkInfo(SvnHunkInfo hunkInfo) {
        this.hunkInfos.add(hunkInfo);
    }

    public void setEof(boolean eof) {
        this.eof = eof;
    }

    public void setKeywords(Map<String, byte[]> keywords) {
        this.keywords = keywords;
    }

    public void setReadLineCallback(IRealLineCallback readLineCallback) {
        this.readLineCallback = readLineCallback;
    }

    public void setTellCallback(ITellCallback tellCallback) {
        this.tellCallback = tellCallback;
    }

    public void setSeekCallback(ISeekCallback seekCallback) {
        this.seekCallback = seekCallback;
    }

    public void setWriteCallback(IWriteCallback writeCallback) {
        this.writeCallback = writeCallback;
    }

    public void setReadBaton(Object readBaton) {
        this.readBaton = readBaton;
    }

    public void setWriteBaton(Object writeBaton) {
        this.writeBaton = writeBaton;
    }

    public Object getWriteBaton() {
        return this.writeBaton;
    }

    public static interface IRealLineCallback {
        public String readLine(Object var1, String[] var2, boolean[] var3) throws SVNException;
    }

    public static interface ISeekCallback {
        public void seek(Object var1, long var2) throws SVNException;
    }

    public static interface ITellCallback {
        public long tell(Object var1) throws SVNException;
    }

    public static interface IWriteCallback {
        public void write(Object var1, String var2) throws SVNException;
    }

    private static class SymlinkBaton {
        private final File localAbsPath;

        public SymlinkBaton(File absPath) {
            this.localAbsPath = absPath;
        }
    }
}

