/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnLog;
import org.tmatesoft.svn.core.wc2.SvnRevisionRange;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRemoteLog
extends SvnRemoteOperationRunner<SVNLogEntry, SvnLog>
implements ISVNLogEntryHandler {
    @Override
    public boolean isApplicable(SvnCat operation, SvnWcGeneration wcGeneration) throws SVNException {
        return true;
    }

    @Override
    protected SVNLogEntry run() throws SVNException {
        String[] targetPaths = null;
        SVNRevision pegRevision = ((SvnLog)this.getOperation()).getFirstTarget().getPegRevision();
        SvnTarget baseTarget = ((SvnLog)this.getOperation()).getFirstTarget();
        SVNRevision sessionRevision = SVNRevision.UNDEFINED;
        LinkedList<SvnRevisionRange> editedRevisionRanges = new LinkedList<SvnRevisionRange>();
        for (SvnRevisionRange revRange : ((SvnLog)this.getOperation()).getRevisionRanges()) {
            SVNErrorMessage err;
            SVNRevision end;
            SVNRevision start;
            if (revRange.getStart().isValid() && !revRange.getEnd().isValid()) {
                revRange = SvnRevisionRange.create(revRange.getStart(), revRange.getStart());
            } else if (!revRange.getStart().isValid()) {
                start = SVNRevision.UNDEFINED;
                end = SVNRevision.UNDEFINED;
                start = !((SvnLog)this.getOperation()).getFirstTarget().getPegRevision().isValid() ? (((SvnLog)this.getOperation()).hasRemoteTargets() ? SVNRevision.HEAD : SVNRevision.BASE) : ((SvnLog)this.getOperation()).getFirstTarget().getPegRevision();
                if (!revRange.getEnd().isValid()) {
                    end = SVNRevision.create(0L);
                }
                revRange = SvnRevisionRange.create(start, end);
            }
            if (!revRange.getStart().isValid() || !revRange.getEnd().isValid()) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Missing required revision specification");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (((SvnLog)this.getOperation()).hasRemoteTargets() && (this.isRevisionLocalToWc(revRange.getStart()) || this.isRevisionLocalToWc(revRange.getEnd()))) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Revision type requires a working copy path, not a URL");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            editedRevisionRanges.add(revRange);
            if (sessionRevision.isValid()) continue;
            start = revRange.getStart();
            end = revRange.getEnd();
            if (SVNRevision.isValidRevisionNumber(start.getNumber()) && SVNRevision.isValidRevisionNumber(end.getNumber())) {
                sessionRevision = start.getNumber() > end.getNumber() ? start : end;
                continue;
            }
            if (start.getDate() != null && end.getDate() != null) {
                sessionRevision = start.getDate().compareTo(end.getDate()) > 0 ? start : end;
                continue;
            }
            if (start != SVNRevision.HEAD && end != SVNRevision.HEAD) continue;
            sessionRevision = SVNRevision.HEAD;
        }
        if (((SvnLog)this.getOperation()).hasRemoteTargets()) {
            targetPaths = ((SvnLog)this.getOperation()).getTargetPaths() == null ? new String[]{""} : ((SvnLog)this.getOperation()).getTargetPaths();
        } else {
            if (!pegRevision.isValid()) {
                pegRevision = SVNRevision.WORKING;
            }
            SVNURL[] targetUrls = new SVNURL[((SvnLog)this.getOperation()).getTargets().size()];
            ArrayList<String> wcPaths = new ArrayList<String>();
            int i = 0;
            Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(baseTarget, sessionRevision, pegRevision, null);
            SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
            repositoryInfo.release();
            for (SvnTarget target : ((SvnLog)this.getOperation()).getTargets()) {
                this.checkCancelled();
                File path = target.getFile();
                wcPaths.add(path.getAbsolutePath().replace(File.separatorChar, '/'));
                Structure<SvnRepositoryAccess.UrlInfo> locationsInfo = this.getRepositoryAccess().getURLFromPath(target, target.getResolvedPegRevision(), repository);
                targetUrls[i++] = (SVNURL)locationsInfo.get(SvnRepositoryAccess.UrlInfo.url);
            }
            if (targetUrls.length == 0) {
                return null;
            }
            TreeSet<String> targets = new TreeSet<String>();
            SVNURL baseURL = SVNURLUtil.condenceURLs(targetUrls, targets, true);
            if (baseURL == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "target log paths belong to different repositories");
                SVNErrorManager.error(err, SVNLogType.WC);
                return null;
            }
            if (targets.isEmpty()) {
                targets.add("");
            }
            targetPaths = targets.toArray(new String[targets.size()]);
            i = 0;
            while (i < targetPaths.length) {
                targetPaths[i] = SVNEncodingUtil.uriDecode(targetPaths[i]);
                ++i;
            }
            if (this.isRevisionLocalToWc(pegRevision)) {
                String rootWCPath = SVNPathUtil.condencePaths(wcPaths.toArray(new String[wcPaths.size()]), null, true);
                baseTarget = SvnTarget.fromFile(new File(rootWCPath), pegRevision);
            }
        }
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(baseTarget, sessionRevision, pegRevision, null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        repositoryInfo.release();
        Iterator revRangesIter = editedRevisionRanges.iterator();
        while (revRangesIter.hasNext()) {
            this.checkCancelled();
            SvnRevisionRange revRange = (SvnRevisionRange)revRangesIter.next();
            this.checkCancelled();
            Structure<SvnRepositoryAccess.RevisionsPair> pair = this.getRepositoryAccess().getRevisionNumber(repository, baseTarget, revRange.getStart(), null);
            long startRev = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            pair = this.getRepositoryAccess().getRevisionNumber(repository, baseTarget, revRange.getEnd(), pair);
            long endRev = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            pair.release();
            repository.log(targetPaths, startRev, endRev, ((SvnLog)this.getOperation()).isDiscoverChangedPaths(), ((SvnLog)this.getOperation()).isStopOnCopy(), ((SvnLog)this.getOperation()).getLimit(), ((SvnLog)this.getOperation()).isUseMergeHistory(), ((SvnLog)this.getOperation()).getRevisionProperties(), this);
        }
        return (SVNLogEntry)((SvnLog)this.getOperation()).first();
    }

    @Override
    public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
        this.checkCancelled();
        ((SvnLog)this.getOperation()).receive(null, logEntry);
    }
}

