/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.ISVNConnectionListener;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNTunnelProvider;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSVNRepositoryPool
implements ISVNRepositoryPool,
ISVNSession,
ISVNConnectionListener {
    public static final int RUNTIME_POOL = 1;
    public static final int INSTANCE_POOL = 2;
    public static final int NO_POOL = 4;
    private static final long DEFAULT_IDLE_TIMEOUT = 60000L;
    private static volatile ScheduledExecutorService ourTimer;
    private static volatile int ourInstanceCount;
    private ISVNAuthenticationManager myAuthManager;
    private ISVNTunnelProvider myTunnelProvider;
    private ISVNDebugLog myDebugLog;
    private ISVNCanceller myCanceller;
    private Map<String, SVNRepository> myPool;
    private long myTimeout;
    private Map<SVNRepository, Long> myInactiveRepositories = new HashMap<SVNRepository, Long>();
    private ScheduledExecutorService myTimer;
    private boolean myIsKeepConnection;
    private ScheduledFuture<?> myScheduledTimeoutTask;
    private File mySpoolLocation;

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider) {
        this(authManager, tunnelProvider, 60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, long timeout, boolean keepConnection) {
        this.myAuthManager = authManager;
        this.myTunnelProvider = tunnelProvider;
        this.myDebugLog = SVNDebugLog.getDefaultLog();
        this.myTimeout = timeout > 0L ? timeout : 60000L;
        this.myIsKeepConnection = keepConnection;
        this.myTimeout = timeout;
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (ourTimer == null) {
                ourTimer = this.createExecutor();
            }
            if (this.myIsKeepConnection) {
                this.myTimer = ourTimer;
                try {
                    this.myScheduledTimeoutTask = this.myTimer.scheduleWithFixedDelay(new TimeoutTask(), 10L, 10L, TimeUnit.SECONDS);
                }
                catch (IllegalStateException e) {
                    SVNDebugLog.getDefaultLog().logError(SVNLogType.DEFAULT, e);
                    this.myTimer = ourTimer = this.createExecutor();
                    this.myScheduledTimeoutTask = this.myTimer.scheduleWithFixedDelay(new TimeoutTask(), 10L, 10L, TimeUnit.SECONDS);
                }
            }
            ++ourInstanceCount;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
    }

    public DefaultSVNRepositoryPool(ISVNAuthenticationManager authManager, ISVNTunnelProvider tunnelProvider, boolean keepConnections, int poolMode) {
        this(authManager, tunnelProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SVNRepository createRepository(SVNURL url, boolean mayReuse) throws SVNException {
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (this.myIsKeepConnection && this.myTimer == null && ourTimer != null) {
                this.myTimer = ourTimer;
                this.myScheduledTimeoutTask = this.myTimer.scheduleWithFixedDelay(new TimeoutTask(), 10L, 10L, TimeUnit.SECONDS);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            SVNRepository repos = null;
            Map<String, SVNRepository> pool = this.getPool();
            if (!mayReuse || pool == null) {
                repos = SVNRepositoryFactory.create(url, this);
                repos.setAuthenticationManager(this.myAuthManager);
                repos.setTunnelProvider(this.myTunnelProvider);
                repos.setDebugLog(this.myDebugLog);
                repos.setCanceller(this.myCanceller);
                this.setOptionalSpoolLocation(repos, this.myTunnelProvider);
                return repos;
            }
            repos = pool.get(url.getProtocol());
            if (repos != null) {
                repos.setLocation(url, false);
            } else {
                repos = SVNRepositoryFactory.create(url, this);
                if (this.myIsKeepConnection) {
                    repos.addConnectionListener(this);
                }
                pool.put(url.getProtocol(), repos);
            }
            repos.setAuthenticationManager(this.myAuthManager);
            repos.setTunnelProvider(this.myTunnelProvider);
            repos.setDebugLog(this.myDebugLog);
            repos.setCanceller(this.myCanceller);
            this.setOptionalSpoolLocation(repos, this.myTunnelProvider);
            return repos;
        }
    }

    public void setSpoolLocation(File location) {
        this.mySpoolLocation = location;
    }

    public File getSpoolLocation() {
        return this.mySpoolLocation;
    }

    private void setOptionalSpoolLocation(SVNRepository repos, ISVNTunnelProvider options) {
        File spoolLocation;
        if (!(repos instanceof DAVRepository)) {
            return;
        }
        if (!(options instanceof DefaultSVNOptions)) {
            return;
        }
        File poolSpoolLocation = this.getSpoolLocation();
        File configSpoolLocation = ((DefaultSVNOptions)options).getHttpSpoolDirectory();
        File file = spoolLocation = poolSpoolLocation != null ? poolSpoolLocation : configSpoolLocation;
        if (spoolLocation != null) {
            ((DAVRepository)repos).setSpoolLocation(spoolLocation);
        }
    }

    @Override
    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        this.myAuthManager = authManager;
        Map<String, SVNRepository> pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = pool.get(key);
            repository.setAuthenticationManager(this.myAuthManager);
        }
    }

    @Override
    public boolean keepConnection(SVNRepository repository) {
        return this.myIsKeepConnection;
    }

    @Override
    public synchronized void shutdownConnections(boolean shutdownAll) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<SVNRepository, Long> map = this.myInactiveRepositories;
        synchronized (map) {
            this.myTimer = null;
        }
        this.shutdownInactiveRepositories(Long.MAX_VALUE);
        Map<String, SVNRepository> pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = pool.get(key);
            repository.closeSession();
        }
        this.myPool = null;
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (this.myScheduledTimeoutTask != null) {
                this.myScheduledTimeoutTask.cancel(false);
                this.myScheduledTimeoutTask = null;
            }
            if (--ourInstanceCount <= 0) {
                ourInstanceCount = 0;
                DefaultSVNRepositoryPool.shutdownTimer();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownTimer() {
        Class<DefaultSVNRepositoryPool> clazz = DefaultSVNRepositoryPool.class;
        synchronized (DefaultSVNRepositoryPool.class) {
            if (ourTimer != null) {
                try {
                    ourTimer.shutdownNow();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                ourTimer = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void saveCommitMessage(SVNRepository repository, long revision, String message) {
    }

    @Override
    public String getCommitMessage(SVNRepository repository, long revision) {
        return null;
    }

    @Override
    public boolean hasCommitMessage(SVNRepository repository, long revision) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(SVNRepository repository) {
        Map<SVNRepository, Long> map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.put(repository, new Long(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(SVNRepository repository) {
        Map<SVNRepository, Long> map = this.myInactiveRepositories;
        synchronized (map) {
            this.myInactiveRepositories.remove(repository);
        }
    }

    @Override
    public void setCanceller(ISVNCanceller canceller) {
        this.myCanceller = canceller;
        Map<String, SVNRepository> pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = pool.get(key);
            repository.setCanceller(canceller);
        }
    }

    @Override
    public void setDebugLog(ISVNDebugLog log) {
        this.myDebugLog = log == null ? SVNDebugLog.getDefaultLog() : log;
        Map<String, SVNRepository> pool = this.getPool();
        for (String key : pool.keySet()) {
            SVNRepository repository = pool.get(key);
            repository.setDebugLog(this.myDebugLog);
        }
    }

    private long getTimeout() {
        return this.myTimeout;
    }

    private Map<String, SVNRepository> getPool() {
        if (this.myPool == null) {
            this.myPool = new HashMap<String, SVNRepository>();
        }
        return this.myPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInactiveRepositories(long currentTime) {
        Map<SVNRepository, Long> map = this.myInactiveRepositories;
        synchronized (map) {
            Iterator<SVNRepository> repositories = this.myInactiveRepositories.keySet().iterator();
            while (repositories.hasNext()) {
                SVNRepository repos = repositories.next();
                long time = this.myInactiveRepositories.get(repos);
                if (currentTime - time < this.getTimeout()) continue;
                repositories.remove();
                repos.closeSession();
            }
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }

    private class TimeoutTask
    implements Runnable {
        private TimeoutTask() {
        }

        public void run() {
            try {
                DefaultSVNRepositoryPool.this.shutdownInactiveRepositories(System.currentTimeMillis());
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logSevere(SVNLogType.WC, th);
            }
        }
    }
}

