/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnImport;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteDelete;
import org.tmatesoft.svn.core.wc2.SvnRemoteMkDir;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitClient
extends SVNBasicClient {
    private ISVNCommitHandler commitHandler;
    private ISVNCommitParameters commitParameters;
    private boolean failOnMultipleRepositories;

    public SVNCommitClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.setCommitHander(null);
        this.setCommitParameters(null);
        this.setCommitHandler(null);
    }

    public SVNCommitClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNCommitClient(SvnOperationFactory of) {
        super(of);
    }

    protected void initDefaults() {
        this.setCommitHander(null);
        this.setCommitParameters(null);
        this.setCommitHandler(null);
    }

    public void setCommitHander(ISVNCommitHandler handler) {
        if (handler == null) {
            handler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = handler;
    }

    public void setCommitHandler(ISVNCommitHandler handler) {
        if (handler == null) {
            handler = new DefaultSVNCommitHandler();
        }
        this.commitHandler = handler;
    }

    public ISVNCommitHandler getCommitHandler() {
        return this.commitHandler;
    }

    public void setCommitParameters(ISVNCommitParameters parameters) {
        this.commitParameters = parameters;
    }

    public ISVNCommitParameters getCommitParameters() {
        return this.commitParameters;
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage) throws SVNException {
        SvnRemoteDelete delete = this.getOperationsFactory().createRemoteDelete();
        if (this.getCommitHandler() != null) {
            delete.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        int i = 0;
        while (i < urls.length) {
            delete.addTarget(SvnTarget.fromURL(urls[i]));
            ++i;
        }
        delete.setCommitMessage(commitMessage);
        return (SVNCommitInfo)delete.run();
    }

    public SVNCommitInfo doDelete(SVNURL[] urls, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SvnRemoteDelete delete = this.getOperationsFactory().createRemoteDelete();
        if (this.getCommitHandler() != null) {
            delete.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        int i = 0;
        while (i < urls.length) {
            delete.addTarget(SvnTarget.fromURL(urls[i]));
            ++i;
        }
        delete.setCommitMessage(commitMessage);
        delete.setRevisionProperties(revisionProperties);
        return (SVNCommitInfo)delete.run();
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage) throws SVNException {
        SvnRemoteMkDir mkdir = this.getOperationsFactory().createRemoteMkDir();
        if (this.getCommitHandler() != null) {
            mkdir.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        int i = 0;
        while (i < urls.length) {
            mkdir.addTarget(SvnTarget.fromURL(urls[i]));
            ++i;
        }
        mkdir.setCommitMessage(commitMessage);
        return (SVNCommitInfo)mkdir.run();
    }

    public SVNCommitInfo doMkDir(SVNURL[] urls, String commitMessage, SVNProperties revisionProperties, boolean makeParents) throws SVNException {
        SvnRemoteMkDir mkdir = this.getOperationsFactory().createRemoteMkDir();
        if (this.getCommitHandler() != null) {
            mkdir.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        }
        int i = 0;
        while (i < urls.length) {
            mkdir.addTarget(SvnTarget.fromURL(urls[i]));
            ++i;
        }
        mkdir.setCommitMessage(commitMessage);
        mkdir.setRevisionProperties(revisionProperties);
        mkdir.setMakeParents(makeParents);
        return (SVNCommitInfo)mkdir.run();
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, null, true, true, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, boolean useGlobalIgnores, boolean recursive) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, null, useGlobalIgnores, true, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, SVNProperties revisionProperties, boolean useGlobalIgnores, boolean ignoreUnknownNodeTypes, SVNDepth depth) throws SVNException {
        return this.doImport(path, dstURL, commitMessage, revisionProperties, useGlobalIgnores, ignoreUnknownNodeTypes, depth, true);
    }

    public SVNCommitInfo doImport(File path, SVNURL dstURL, String commitMessage, SVNProperties revisionProperties, boolean useGlobalIgnores, boolean ignoreUnknownNodeTypes, SVNDepth depth, boolean applyAutoProperties) throws SVNException {
        SvnImport svnImport = this.getOperationsFactory().createImport();
        svnImport.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        svnImport.setCommitMessage(commitMessage);
        svnImport.setRevisionProperties(revisionProperties);
        svnImport.addTarget(SvnTarget.fromURL(dstURL));
        svnImport.setSource(path);
        svnImport.setDepth(depth);
        svnImport.setUseGlobalIgnores(useGlobalIgnores);
        svnImport.setApplyAutoProperties(applyAutoProperties);
        return (SVNCommitInfo)svnImport.run();
    }

    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, boolean force, boolean recursive) throws SVNException {
        return this.doCommit(paths, keepLocks, commitMessage, null, null, false, force, SVNDepth.fromRecurse(recursive));
    }

    public SVNCommitInfo doCommit(File[] paths, boolean keepLocks, String commitMessage, SVNProperties revisionProperties, String[] changelists, boolean keepChangelist, boolean force, SVNDepth depth) throws SVNException {
        SVNCommitInfo[] infos;
        SVNCommitPacket[] packets = this.doCollectCommitItems(paths, keepLocks, force, depth, true, changelists);
        if (packets != null && (infos = this.doCommit(packets, keepLocks, keepChangelist, commitMessage, revisionProperties)) != null && infos.length > 0) {
            return infos[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, String commitMessage) throws SVNException {
        return this.doCommit(commitPacket, keepLocks, false, commitMessage, null);
    }

    public SVNCommitInfo doCommit(SVNCommitPacket commitPacket, boolean keepLocks, boolean keepChangelist, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        SVNCommitInfo[] infos = this.doCommit(new SVNCommitPacket[]{commitPacket}, keepLocks, keepChangelist, commitMessage, revisionProperties);
        if (infos != null && infos.length > 0) {
            return infos[0];
        }
        return SVNCommitInfo.NULL;
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, String commitMessage) throws SVNException {
        return this.doCommit(commitPackets, keepLocks, false, commitMessage, null);
    }

    public SVNCommitInfo[] doCommit(SVNCommitPacket[] commitPackets, boolean keepLocks, boolean keepChangelist, String commitMessage, SVNProperties revisionProperties) throws SVNException {
        final SVNCommitInfo[] infos = new SVNCommitInfo[commitPackets.length];
        if (commitPackets.length == 0) {
            return infos;
        }
        SvnCommit sharedOperation = null;
        int i = 0;
        while (i < commitPackets.length) {
            SvnCommit commitOperation = ((SvnCodec.SVNCommitPacketWrapper)commitPackets[i]).getOperation();
            if (sharedOperation == null) {
                sharedOperation = commitOperation;
            }
            if (commitOperation != sharedOperation) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit packets created by different commit operations may not be mixed.");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            ++i;
        }
        SvnCommitPacket[] operationPackets = sharedOperation.splitCommitPackets(sharedOperation.isCombinePackets());
        HashSet<SvnCommitPacket> userPacketsSet = new HashSet<SvnCommitPacket>();
        int i2 = 0;
        while (i2 < commitPackets.length) {
            SvnCommitPacket userPacket = ((SvnCodec.SVNCommitPacketWrapper)commitPackets[i2]).getPacket();
            userPacketsSet.add(userPacket);
            ++i2;
        }
        i2 = 0;
        while (i2 < operationPackets.length) {
            if (!userPacketsSet.contains(operationPackets[i2])) {
                operationPackets[i2].dispose();
            }
            ++i2;
        }
        SvnCommit commit = sharedOperation;
        commit.setIncludeDirectoryExternals(!this.isIgnoreExternals());
        commit.setIncludeFileExternals(!this.isIgnoreExternals());
        commit.setCommitMessage(commitMessage);
        commit.setCommitHandler(SvnCodec.commitHandler(this.getCommitHandler()));
        commit.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        if (revisionProperties != null) {
            for (String propertyName : revisionProperties.nameSet()) {
                SVNPropertyValue value = revisionProperties.getSVNPropertyValue(propertyName);
                if (value == null) continue;
                commit.setRevisionProperty(propertyName, value);
            }
        }
        commit.setKeepLocks(keepLocks);
        commit.setKeepChangelists(keepChangelist);
        commit.setReceiver(new ISvnObjectReceiver<SVNCommitInfo>(){
            int index = 0;

            @Override
            public void receive(SvnTarget target, SVNCommitInfo object) throws SVNException {
                infos[this.index++] = object;
            }
        });
        commit.run();
        return infos;
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive) throws SVNException {
        SVNCommitPacket[] packets = this.doCollectCommitItems(paths, keepLocks, force, SVNDepth.fromRecurse(recursive), true, null);
        if (packets != null && packets.length > 0) {
            return packets[0];
        }
        return SVNCommitPacket.EMPTY;
    }

    public SVNCommitPacket doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, SVNDepth depth, String[] changelists) throws SVNException {
        SVNCommitPacket[] packets = this.doCollectCommitItems(paths, keepLocks, force, depth, true, changelists);
        if (packets != null && packets.length > 0) {
            return packets[0];
        }
        return SVNCommitPacket.EMPTY;
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, boolean recursive, boolean combinePackets) throws SVNException {
        return this.doCollectCommitItems(paths, keepLocks, force, SVNDepth.fromRecurse(recursive), combinePackets, null);
    }

    public SVNCommitPacket[] doCollectCommitItems(File[] paths, boolean keepLocks, boolean force, SVNDepth depth, boolean combinePackets, String[] changelists) throws SVNException {
        SvnCommitPacket packet;
        SvnCommit commit = this.getOperationsFactory().createCommit();
        int i = 0;
        while (i < paths.length) {
            commit.addTarget(SvnTarget.fromFile(paths[i]));
            ++i;
        }
        commit.setIncludeFileExternals(!this.isIgnoreExternals());
        commit.setIncludeDirectoryExternals(!this.isIgnoreExternals());
        commit.setKeepLocks(keepLocks);
        commit.setDepth(depth);
        commit.setForce(force);
        commit.setFailOnMultipleRepositories(this.failOnMultipleRepositories);
        commit.setCommitParameters(SvnCodec.commitParameters(this.getCommitParameters()));
        commit.setCombinePackets(combinePackets);
        if (changelists != null && changelists.length > 0) {
            commit.setApplicalbeChangelists(Arrays.asList(changelists));
        }
        if ((packet = commit.collectCommitItems()) != null) {
            SvnCommitPacket[] packets = commit.splitCommitPackets(combinePackets);
            SVNCommitPacket[] result = new SVNCommitPacket[packets.length];
            int i2 = 0;
            while (i2 < packets.length) {
                result[i2] = SvnCodec.commitPacket(commit, packets[i2]);
                ++i2;
            }
            return result;
        }
        return new SVNCommitPacket[0];
    }

    public void setFailOnMultipleRepositories(boolean fail) {
        this.failOnMultipleRepositories = fail;
    }
}

