/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNGNUDiffGenerator;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNNodeEditor;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNChangedDirectoriesHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.ISVNHistoryHandler;
import org.tmatesoft.svn.core.wc.admin.ISVNTreeHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminBasicClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookClient
extends SVNAdminBasicClient {
    private ISVNGNUDiffGenerator myDiffGenerator;

    public SVNLookClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNLookClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNLookClient(SvnOperationFactory of) {
        super(of);
    }

    public SVNLogEntry doGetInfo(File repositoryRoot, SVNRevision revision) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            SVNProperties revProps = fsfs.getRevisionProperties(revNum);
            String date = revProps.getStringValue("svn:date");
            String author = revProps.getStringValue("svn:author");
            String logMessage = revProps.getStringValue("svn:log");
            SVNLogEntry sVNLogEntry = new SVNLogEntry(null, revNum, author, SVNDate.parseDateString(date), logMessage);
            return sVNLogEntry;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public SVNLogEntry doGetInfo(File repositoryRoot, String transactionName) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            SVNProperties txnProps = fsfs.getTransactionProperties(txn.getTxnId());
            String date = txnProps.getStringValue("svn:date");
            String author = txnProps.getStringValue("svn:author");
            String logMessage = txnProps.getStringValue("svn:log");
            SVNLogEntry sVNLogEntry = new SVNLogEntry(null, -1L, author, SVNDate.parseDateString(date), logMessage);
            return sVNLogEntry;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public long doGetYoungestRevision(File repositoryRoot) throws SVNException {
        FSFS fsfs = null;
        try {
            fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
            long l = fsfs.getYoungestRevision();
            return l;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public String doGetUUID(File repositoryRoot) throws SVNException {
        FSFS fsfs = null;
        try {
            fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
            String string = fsfs.getUUID();
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public String doGetAuthor(File repositoryRoot, SVNRevision revision) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            SVNProperties revProps = fsfs.getRevisionProperties(revNum);
            String string = revProps.getStringValue("svn:author");
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public String doGetAuthor(File repositoryRoot, String transactionName) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            SVNProperties txnProps = fsfs.getTransactionProperties(txn.getTxnId());
            String string = txnProps.getStringValue("svn:author");
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doCat(File repositoryRoot, String path, SVNRevision revision, OutputStream out) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            FSRevisionRoot root = fsfs.createRevisionRoot(revNum);
            this.catFile(root, path, out);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doCat(File repositoryRoot, String path, String transactionName, OutputStream out) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            FSTransactionRoot root = fsfs.createTransactionRoot(txn);
            this.catFile(root, path, out);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public Date doGetDate(File repositoryRoot, SVNRevision revision) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            SVNProperties revProps = fsfs.getRevisionProperties(revNum);
            String date = revProps.getStringValue("svn:date");
            if (date != null) {
                SVNDate sVNDate = SVNDate.parseDate(date);
                return sVNDate;
            }
            return null;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public Date doGetDate(File repositoryRoot, String transactionName) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            SVNProperties txnProps = fsfs.getTransactionProperties(txn.getTxnId());
            String date = txnProps.getStringValue("svn:date");
            if (date != null) {
                SVNDate sVNDate = SVNDate.parseDate(date);
                return sVNDate;
            }
            return null;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public String doGetLog(File repositoryRoot, SVNRevision revision) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            SVNProperties revProps = fsfs.getRevisionProperties(revNum);
            String string = revProps.getStringValue("svn:log");
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public String doGetLog(File repositoryRoot, String transactionName) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            SVNProperties txnProps = fsfs.getTransactionProperties(txn.getTxnId());
            String string = txnProps.getStringValue("svn:log");
            return string;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetChanged(File repositoryRoot, SVNRevision revision, ISVNChangeEntryHandler handler, boolean includeCopyInfo) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            FSRevisionRoot root = fsfs.createRevisionRoot(revNum);
            long baseRevision = revNum - 1L;
            SVNNodeEditor editor = this.generateDeltaTree(fsfs, root, baseRevision);
            editor.traverseTree(includeCopyInfo, handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetChanged(File repositoryRoot, String transactionName, ISVNChangeEntryHandler handler, boolean includeCopyInfo) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            FSTransactionRoot root = fsfs.createTransactionRoot(txn);
            long baseRevision = txn.getBaseRevision();
            if (!SVNRevision.isValidRevisionNumber(baseRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Transaction ''{0}'' is not based on a revision; how odd", (Object)transactionName);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            SVNNodeEditor editor = this.generateDeltaTree(fsfs, root, baseRevision);
            editor.traverseTree(includeCopyInfo, handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetChangedDirectories(File repositoryRoot, SVNRevision revision, ISVNChangedDirectoriesHandler handler) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            FSRevisionRoot root = fsfs.createRevisionRoot(revNum);
            long baseRevision = revNum - 1L;
            if (!SVNRevision.isValidRevisionNumber(baseRevision)) {
                return;
            }
            SVNNodeEditor editor = this.generateDeltaTree(fsfs, root, baseRevision);
            editor.traverseChangedDirs(handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetChangedDirectories(File repositoryRoot, String transactionName, ISVNChangedDirectoriesHandler handler) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            FSTransactionRoot root = fsfs.createTransactionRoot(txn);
            long baseRevision = txn.getBaseRevision();
            if (!SVNRevision.isValidRevisionNumber(baseRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Transaction ''{0}'' is not based on a revision; how odd", (Object)transactionName);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            SVNNodeEditor editor = this.generateDeltaTree(fsfs, root, baseRevision);
            editor.traverseChangedDirs(handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetHistory(File repositoryRoot, String path, SVNRevision revision, boolean includeIDs, long limit, ISVNHistoryHandler handler) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            path = path == null ? "/" : path;
            this.getHistory(fsfs, path, 0L, revNum, limit, true, includeIDs, handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public SVNLock doGetLock(File repositoryRoot, String path) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing path argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSFS fsfs = this.open(repositoryRoot, SVNRevision.HEAD);
        try {
            SVNLock sVNLock = fsfs.getLockHelper(path, false);
            return sVNLock;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetTree(File repositoryRoot, String path, SVNRevision revision, boolean includeIDs, boolean recursive, ISVNTreeHandler handler) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            FSRevisionRoot root = fsfs.createRevisionRoot(revNum);
            path = path == null ? "/" : path;
            FSRevisionNode node = root.getRevisionNode(path);
            FSID id = includeIDs ? node.getId() : null;
            SVNNodeKind kind = root.checkNodeKind(path);
            this.getTree(fsfs, root, path, kind, id, includeIDs, 0, recursive, handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetTree(File repositoryRoot, String path, String transactionName, boolean includeIDs, boolean recursive, ISVNTreeHandler handler) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            FSTransactionRoot root = fsfs.createTransactionRoot(txn);
            path = path == null ? "/" : path;
            FSRevisionNode node = root.getRevisionNode(path);
            FSID id = includeIDs ? node.getId() : null;
            SVNNodeKind kind = root.checkNodeKind(path);
            this.getTree(fsfs, root, path, kind, id, includeIDs, 0, recursive, handler);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetDiff(File repositoryRoot, SVNRevision revision, boolean diffDeleted, boolean diffAdded, boolean diffCopyFrom, OutputStream os) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            FSRevisionRoot root = fsfs.createRevisionRoot(revNum);
            long baseRevision = revNum - 1L;
            if (!SVNRevision.isValidRevisionNumber(baseRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid base revision {0}", (Object)new Long(baseRevision));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            SVNNodeEditor editor = this.generateDeltaTree(fsfs, root, baseRevision);
            ISVNGNUDiffGenerator generator = this.getDiffGenerator();
            generator.setDiffAdded(diffAdded);
            generator.setDiffCopied(diffCopyFrom);
            generator.setDiffDeleted(diffDeleted);
            editor.diff(root, baseRevision, generator, os);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doGetDiff(File repositoryRoot, String transactionName, boolean diffDeleted, boolean diffAdded, boolean diffCopyFrom, OutputStream os) throws SVNException {
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            FSTransactionRoot root = fsfs.createTransactionRoot(txn);
            long baseRevision = txn.getBaseRevision();
            if (!SVNRevision.isValidRevisionNumber(baseRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Transaction ''{0}'' is not based on a revision; how odd", (Object)transactionName);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            SVNNodeEditor editor = this.generateDeltaTree(fsfs, root, baseRevision);
            ISVNGNUDiffGenerator generator = this.getDiffGenerator();
            generator.setDiffAdded(diffAdded);
            generator.setDiffCopied(diffCopyFrom);
            generator.setDiffDeleted(diffDeleted);
            editor.diff(root, baseRevision, generator, os);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public SVNPropertyValue doGetProperty(File repositoryRoot, String propName, String path, SVNRevision revision) throws SVNException {
        SVNProperties props = this.getProperties(repositoryRoot, propName, path, revision, null, true, false);
        return props.getSVNPropertyValue(propName);
    }

    public SVNProperties doGetProperties(File repositoryRoot, String path, SVNRevision revision) throws SVNException {
        return this.getProperties(repositoryRoot, null, path, revision, null, false, false);
    }

    public SVNPropertyValue doGetProperty(File repositoryRoot, String propName, String path, String transactionName) throws SVNException {
        SVNProperties props = this.getProperties(repositoryRoot, propName, path, null, transactionName, true, false);
        return props.getSVNPropertyValue(propName);
    }

    public SVNProperties doGetProperties(File repositoryRoot, String path, String transactionName) throws SVNException {
        return this.getProperties(repositoryRoot, null, path, null, transactionName, false, false);
    }

    public SVNPropertyValue doGetRevisionProperty(File repositoryRoot, String propName, SVNRevision revision) throws SVNException {
        SVNProperties revProps = this.getProperties(repositoryRoot, propName, null, revision, null, true, true);
        return revProps.getSVNPropertyValue(propName);
    }

    public SVNProperties doGetRevisionProperties(File repositoryRoot, SVNRevision revision) throws SVNException {
        return this.getProperties(repositoryRoot, null, null, revision, null, false, true);
    }

    public SVNPropertyValue doGetRevisionProperty(File repositoryRoot, String propName, String transactionName) throws SVNException {
        SVNProperties revProps = this.getProperties(repositoryRoot, propName, null, null, transactionName, true, true);
        return revProps.getSVNPropertyValue(propName);
    }

    public SVNProperties doGetRevisionProperties(File repositoryRoot, String transactionName) throws SVNException {
        return this.getProperties(repositoryRoot, null, null, null, transactionName, false, true);
    }

    public long doGetFileSize(File repositoryRoot, String path, String transactionName) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSFS fsfs = this.open(repositoryRoot, transactionName);
        try {
            FSTransactionInfo txn = fsfs.openTxn(transactionName);
            FSTransactionRoot root = fsfs.createTransactionRoot(txn);
            long l = this.getFileSize(root, path);
            return l;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public long doGetFileSize(File repositoryRoot, String path, SVNRevision revision) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSFS fsfs = this.open(repositoryRoot, revision);
        try {
            long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
            FSRevisionRoot root = fsfs.createRevisionRoot(revNum);
            long l = this.getFileSize(root, path);
            return l;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void setDiffGenerator(ISVNGNUDiffGenerator diffGenerator) {
        this.myDiffGenerator = diffGenerator;
    }

    public ISVNGNUDiffGenerator getDiffGenerator() {
        if (this.myDiffGenerator == null) {
            DefaultSVNGNUDiffGenerator defaultDiffGenerator = new DefaultSVNGNUDiffGenerator();
            defaultDiffGenerator.setOptions(this.getOptions());
            this.myDiffGenerator = defaultDiffGenerator;
        }
        return this.myDiffGenerator;
    }

    private void getTree(FSFS fsfs, FSRoot root, String path, SVNNodeKind kind, FSID id, boolean includeIDs, int depth, boolean recursive, ISVNTreeHandler handler) throws SVNException {
        this.checkCancelled();
        if (handler != null) {
            handler.handlePath(new SVNAdminPath(path, includeIDs ? id.toString() : null, depth, kind == SVNNodeKind.DIR));
        }
        if (kind != SVNNodeKind.DIR) {
            return;
        }
        if (recursive || depth == 0) {
            FSRevisionNode node = root.getRevisionNode(path);
            Map entries = node.getDirEntries(fsfs);
            for (String name : entries.keySet()) {
                FSEntry entry = (FSEntry)entries.get(name);
                this.getTree(fsfs, root, SVNPathUtil.getAbsolutePath(SVNPathUtil.append(path, entry.getName())), entry.getType(), includeIDs ? entry.getId() : null, includeIDs, depth + 1, recursive, handler);
            }
        }
    }

    private SVNProperties getProperties(File repositoryRoot, String propName, String path, SVNRevision revision, String txnName, boolean singleProp, boolean revProps) throws SVNException {
        SVNErrorMessage err;
        if (propName == null && singleProp) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing propname argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (path == null && !revProps) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing repository path argument");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSFS fsfs = txnName == null ? this.open(repositoryRoot, revision) : this.open(repositoryRoot, txnName);
        try {
            FSRoot root = null;
            if (txnName == null) {
                long revNum = SVNAdminHelper.getRevisionNumber(revision, fsfs.getYoungestRevision(), fsfs);
                if (revProps) {
                    SVNProperties sVNProperties = fsfs.getRevisionProperties(revNum);
                    return sVNProperties;
                }
                root = fsfs.createRevisionRoot(revNum);
            } else {
                FSTransactionInfo txn = fsfs.openTxn(txnName);
                if (revProps) {
                    SVNProperties sVNProperties = fsfs.getTransactionProperties(txn.getTxnId());
                    return sVNProperties;
                }
                root = fsfs.createTransactionRoot(txn);
            }
            this.verifyPath(root, path);
            FSRevisionNode node = root.getRevisionNode(path);
            SVNProperties sVNProperties = node.getProperties(fsfs);
            return sVNProperties;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    private void getHistory(FSFS fsfs, String path, long start, long end, long limit, boolean crossCopies, boolean includeIDs, ISVNHistoryHandler handler) throws SVNException {
        long revision;
        SVNErrorMessage err;
        if (!SVNRevision.isValidRevisionNumber(start)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid start revision {0}", (Object)String.valueOf(start));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!SVNRevision.isValidRevisionNumber(end)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid end revision {0}", (Object)String.valueOf(end));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (start > end) {
            long tmpRev = start;
            start = end;
            end = tmpRev;
        }
        FSRevisionRoot root = fsfs.createRevisionRoot(end);
        FSNodeHistory history = root.getNodeHistory(path);
        long count = 0L;
        while ((history = history.getPreviousHistory(crossCopies)) != null && (revision = history.getHistoryEntry().getRevision()) >= start) {
            String id = null;
            if (includeIDs) {
                FSRevisionRoot revRoot = fsfs.createRevisionRoot(revision);
                FSRevisionNode node = revRoot.getRevisionNode(history.getHistoryEntry().getPath());
                id = node.getId().toString();
            }
            if (handler != null) {
                try {
                    handler.handlePath(new SVNAdminPath(history.getHistoryEntry().getPath(), id, revision));
                }
                catch (SVNException svne) {
                    if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.CEASE_INVOCATION) break;
                    throw svne;
                }
            }
            if ((limit <= 0L || ++count < limit) && history != null) continue;
        }
    }

    private SVNNodeEditor generateDeltaTree(FSFS fsfs, FSRoot root, long baseRevision) throws SVNException {
        FSRevisionRoot baseRoot = fsfs.createRevisionRoot(baseRevision);
        SVNNodeEditor editor = new SVNNodeEditor(fsfs, baseRoot, this);
        FSRepositoryUtil.replay(fsfs, root, "", -1L, false, editor);
        return editor;
    }

    private void catFile(FSRoot root, String path, OutputStream out) throws SVNException {
        block8: {
            SVNNodeKind kind = this.verifyPath(root, path);
            if (kind != SVNNodeKind.FILE) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Path ''{0}'' is not a file", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (out != null) {
                InputStream contents = null;
                try {
                    try {
                        contents = root.getFileStreamForPath(new SVNDeltaCombiner(), path);
                        byte[] buffer = new byte[16384];
                        int len = 0;
                        do {
                            this.checkCancelled();
                            len = SVNFileUtil.readIntoBuffer(contents, buffer, 0, buffer.length);
                            if (len <= 0) continue;
                            out.write(buffer, 0, len);
                        } while (len == 16384);
                    }
                    catch (IOException ioe) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                        SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                        SVNFileUtil.closeFile(contents);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(contents);
                    throw throwable;
                }
                SVNFileUtil.closeFile(contents);
            }
        }
    }

    private long getFileSize(FSRoot root, String path) throws SVNException {
        SVNNodeKind kind = this.verifyPath(root, path);
        if (kind != SVNNodeKind.FILE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FILE, "Path ''{0}'' is not a file", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return root.getFileSize(path);
    }

    private SVNNodeKind verifyPath(FSRoot root, String path) throws SVNException {
        SVNNodeKind kind = root.checkNodeKind(path);
        if (kind == SVNNodeKind.NONE) {
            SVNErrorMessage err;
            if (SVNPathUtil.isURL(path)) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "''{0}'' is a URL, probably should be a path", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' does not exist", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return kind;
    }

    private FSFS open(File repositoryRoot, SVNRevision revision) throws SVNException {
        if (revision == null || !revision.isValid()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Invalid revision number supplied");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return SVNAdminHelper.openRepository(repositoryRoot, true);
    }

    private FSFS open(File repositoryRoot, String transactionName) throws SVNException {
        if (transactionName == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing transaction name");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return SVNAdminHelper.openRepository(repositoryRoot, true);
    }
}

