/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit.command;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.op.RevertCommitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.command.CommitCommandHandler;
import org.eclipse.egit.ui.internal.dialogs.RevertFailureDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RevertHandler
extends CommitCommandHandler {
    public static final String ID = "org.eclipse.egit.ui.commit.Revert";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<RepositoryCommit> repoCommits = this.getCommits(event);
        Repository repo = repoCommits.get(0).getRepository();
        final Shell shell = this.getPart(event).getSite().getShell();
        final ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RepositoryCommit repoCommit : repoCommits) {
            commits.add(repoCommit.getRevCommit());
        }
        final RevertCommitOperation op = new RevertCommitOperation(repo, commits);
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(UIText.RevertHandler_JobName, commits.size())){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    op.execute(monitor);
                    RevCommit newHead = op.getNewHead();
                    List revertedRefs = op.getRevertedRefs();
                    if (newHead != null && revertedRefs.isEmpty()) {
                        RevertHandler.showRevertedDialog(shell);
                    }
                    if (newHead == null) {
                        RevCommit newestUnmergedCommit = null;
                        for (RevCommit commit : commits) {
                            if (RevertHandler.this.contains(revertedRefs, commit)) continue;
                            newestUnmergedCommit = commit;
                            break;
                        }
                        RevertHandler.showFailureDialog(shell, newestUnmergedCommit, op.getFailingResult());
                    }
                }
                catch (CoreException e) {
                    Activator.handleError(UIText.RevertOperation_InternalError, e, true);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.REVERT_COMMIT.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return null;
    }

    private boolean contains(List<Ref> refs, RevCommit commit) {
        for (Ref ref : refs) {
            if (!ref.getObjectId().equals((AnyObjectId)commit.getId())) continue;
            return true;
        }
        return false;
    }

    private static void showFailureDialog(final Shell shell, final RevCommit commit, final MergeResult result) {
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                RevertFailureDialog.show(shell, commit, result);
            }
        });
    }

    private static void showRevertedDialog(final Shell shell) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)UIText.RevertHandler_NoRevertTitle, (String)UIText.RevertHandler_AlreadyRevertedMessage);
            }
        });
    }
}

