/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.egit.ui.internal.merge.GitCompareEditorInput;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareVersionsHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        if (selection.size() == 2) {
            Iterator it = selection.iterator();
            RevCommit commit1 = (RevCommit)it.next();
            RevCommit commit2 = (RevCommit)it.next();
            Object input = this.getPage(event).getInputInternal().getSingleItem();
            Repository repo = this.getRepository(event);
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            if (input instanceof IFile) {
                IFile resource = (IFile)input;
                RepositoryMapping map = RepositoryMapping.getMapping((IResource)resource);
                if (map != null) {
                    String gitPath = map.getRepoRelativePath((IResource)resource);
                    String commit1Path = this.getRenamedPath(gitPath, (ObjectId)commit1);
                    String commit2Path = this.getRenamedPath(gitPath, (ObjectId)commit2);
                    CompareUtils.openInCompare(commit1, commit2, commit1Path, commit2Path, map.getRepository(), workBenchPage);
                }
            } else if (input instanceof File) {
                File fileInput = (File)input;
                String gitPath = this.getRepoRelativePath(repo, fileInput);
                String commit1Path = this.getRenamedPath(gitPath, (ObjectId)commit1);
                String commit2Path = this.getRenamedPath(gitPath, (ObjectId)commit2);
                CompareUtils.openInCompare(commit1, commit2, commit1Path, commit2Path, repo, workBenchPage);
            } else if (input instanceof IResource) {
                GitCompareEditorInput compareInput = new GitCompareEditorInput(commit1.name(), commit2.name(), repo, (IResource)input);
                CompareUtils.openInCompare(workBenchPage, compareInput);
            } else if (input == null) {
                GitCompareEditorInput compareInput = new GitCompareEditorInput(commit1.name(), commit2.name(), repo);
                CompareUtils.openInCompare(workBenchPage, compareInput);
            }
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        return this.getSelection(page).size() == 2;
    }
}

