/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.search.CommitSearchQuery;
import org.eclipse.egit.ui.internal.search.CommitSearchSettings;
import org.eclipse.egit.ui.internal.search.PatternUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class CommitSearchPage
extends DialogPage
implements ISearchPage {
    public static final String ID = "org.eclipse.egit.ui.commitSearchPage";
    private static final int HISTORY_SIZE = 12;
    private static final String PAGE_NAME = "GitCommitSearchPage";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private List<CommitSearchSettings> fPreviousSearchPatterns = new ArrayList<CommitSearchSettings>(12);
    private boolean firstTime = true;
    private Combo patternCombo;
    private Button isCaseSensitiveButton;
    private Button isRegExButton;
    private Button searchTreeButton;
    private Button searchCommitButton;
    private Button searchParentsButton;
    private Button searchAuthorButton;
    private Button searchCommitterButton;
    private Button searchMessageButton;
    private Button searchAllBranchesButton;
    private CLabel statusLabel;
    private Group repositoryGroup;
    private CheckboxTableViewer repositoryViewer;
    private ISearchPageContainer container;
    private ContentAssistCommandAdapter patternFieldContentAssist;

    private ISearchQuery newQuery() {
        CommitSearchSettings settings = new CommitSearchSettings();
        settings.setTextPattern(this.patternCombo.getText());
        settings.setRegExSearch(this.isRegExButton.getSelection());
        settings.setCaseSensitive(this.isCaseSensitiveButton.getSelection());
        settings.setMatchAuthor(this.searchAuthorButton.getSelection());
        settings.setMatchCommitter(this.searchCommitterButton.getSelection());
        settings.setMatchMessage(this.searchMessageButton.getSelection());
        settings.setMatchCommit(this.searchCommitButton.getSelection());
        settings.setMatchTree(this.searchTreeButton.getSelection());
        settings.setMatchParents(this.searchParentsButton.getSelection());
        settings.setAllBranches(this.searchAllBranchesButton.getSelection());
        Object[] objectArray = this.repositoryViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            settings.addRepository(((RepositoryNode)checked).getRepository().getDirectory().getAbsolutePath());
            ++n2;
        }
        this.fPreviousSearchPatterns.add(0, settings);
        return new CommitSearchQuery(settings);
    }

    public boolean performAction() {
        NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
        return true;
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = this.fPreviousSearchPatterns.get(i).getTextPattern();
            ++i;
        }
        return patterns;
    }

    public void setVisible(boolean visible) {
        if (visible && this.patternCombo != null) {
            if (this.firstTime) {
                this.firstTime = false;
                this.patternCombo.setItems(this.getPreviousSearchPatterns());
                if (!this.initializePatternControl()) {
                    this.patternCombo.select(0);
                    this.handleWidgetSelected();
                }
            }
            this.patternCombo.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    private void updateOKStatus() {
        boolean status = this.validateRegex();
        if (status) {
            status = this.validateScope();
        }
        if (status) {
            status = this.validateRepositories();
        }
        this.getContainer().setPerformActionEnabled(status);
    }

    private boolean validateRepositories() {
        return this.repositoryViewer.getCheckedElements().length > 0;
    }

    private boolean validateScope() {
        return this.searchAuthorButton.getSelection() || this.searchCommitterButton.getSelection() || this.searchMessageButton.getSelection() || this.searchCommitButton.getSelection() || this.searchParentsButton.getSelection() || this.searchTreeButton.getSelection();
    }

    public void createControl(Composite parent) {
        this.readConfiguration();
        this.initializeDialogUnits((Control)parent);
        SearchComposite result = new SearchComposite(parent, 0);
        result.setFont(parent.getFont());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)result);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo((Composite)result);
        this.addTextPatternControls(result);
        this.addScopeControls(result);
        this.addRepositoryControl(result);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.isRegExButton.getSelection()) {
            block5: {
                try {
                    PatternUtils.createPattern(this.patternCombo.getText(), this.isCaseSensitiveButton.getSelection(), true);
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, UIText.CommitSearchPage_ContainingTextHint);
        }
        return true;
    }

    private void addScopeControls(Composite parent) {
        SelectionAdapter statusAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSearchPage.this.updateOKStatus();
            }
        };
        Group scopeArea = new Group(parent, 0);
        scopeArea.setText(UIText.CommitSearchPage_Scope);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)scopeArea);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)scopeArea);
        this.searchMessageButton = new Button((Composite)scopeArea, 32);
        this.searchMessageButton.setText(UIText.CommitSearchPage_Message);
        this.searchMessageButton.setSelection(true);
        this.searchMessageButton.addSelectionListener((SelectionListener)statusAdapter);
        this.searchAuthorButton = new Button((Composite)scopeArea, 32);
        this.searchAuthorButton.setText(UIText.CommitSearchPage_Author);
        this.searchAuthorButton.setSelection(true);
        this.searchAuthorButton.addSelectionListener((SelectionListener)statusAdapter);
        this.searchCommitterButton = new Button((Composite)scopeArea, 32);
        this.searchCommitterButton.setText(UIText.CommitSearchPage_Committer);
        this.searchCommitterButton.setSelection(true);
        this.searchCommitterButton.addSelectionListener((SelectionListener)statusAdapter);
        this.searchCommitButton = new Button((Composite)scopeArea, 32);
        this.searchCommitButton.setText(UIText.CommitSearchPage_CommitId);
        this.searchCommitButton.setSelection(true);
        this.searchCommitButton.addSelectionListener((SelectionListener)statusAdapter);
        this.searchTreeButton = new Button((Composite)scopeArea, 32);
        this.searchTreeButton.setText(UIText.CommitSearchPage_TreeId);
        this.searchTreeButton.setSelection(true);
        this.searchTreeButton.addSelectionListener((SelectionListener)statusAdapter);
        this.searchParentsButton = new Button((Composite)scopeArea, 32);
        this.searchParentsButton.setText(UIText.CommitSearchPage_ParentIds);
        this.searchParentsButton.setSelection(true);
        this.searchParentsButton.addSelectionListener((SelectionListener)statusAdapter);
    }

    private void addRepositoryControl(Composite parent) {
        this.repositoryGroup = new Group(parent, 0);
        this.repositoryGroup.setBackgroundMode(1);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.repositoryGroup);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.repositoryGroup);
        this.repositoryViewer = CheckboxTableViewer.newCheckList((Composite)this.repositoryGroup, (int)2820);
        this.repositoryViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RepositoriesViewLabelProvider()));
        this.repositoryViewer.setContentProvider((IContentProvider)new RepositoriesViewContentProvider());
        this.repositoryViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.repositoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommitSearchPage.this.updateOKStatus();
                CommitSearchPage.this.repositoryGroup.setText(CommitSearchPage.this.getRepositoryText());
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 40).applyTo(this.repositoryViewer.getControl());
        ToolBar checkBar = new ToolBar((Composite)this.repositoryGroup, 0x800200);
        GridDataFactory.swtDefaults().align(1, 128).grab(false, true).applyTo((Control)checkBar);
        ToolItem checkItem = new ToolItem(checkBar, 8);
        checkItem.setToolTipText(UIText.CommitSearchPage_CheckAll);
        Image checkImage = UIIcons.CHECK_ALL.createImage();
        UIUtils.hookDisposal((Widget)checkItem, (Resource)checkImage);
        checkItem.setImage(checkImage);
        checkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSearchPage.this.repositoryViewer.setAllChecked(true);
                CommitSearchPage.this.repositoryGroup.setText(CommitSearchPage.this.getRepositoryText());
                CommitSearchPage.this.updateOKStatus();
            }
        });
        ToolItem uncheckItem = new ToolItem(checkBar, 8);
        uncheckItem.setToolTipText(UIText.CommitSearchPage_UncheckAll);
        Image uncheckImage = UIIcons.UNCHECK_ALL.createImage();
        UIUtils.hookDisposal((Widget)uncheckItem, (Resource)uncheckImage);
        uncheckItem.setImage(uncheckImage);
        uncheckItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSearchPage.this.repositoryViewer.setAllChecked(false);
                CommitSearchPage.this.repositoryGroup.setText(CommitSearchPage.this.getRepositoryText());
                CommitSearchPage.this.updateOKStatus();
            }
        });
        this.searchAllBranchesButton = new Button((Composite)this.repositoryGroup, 32);
        this.searchAllBranchesButton.setText(UIText.CommitSearchPage_SearchAllBranches);
        GridDataFactory.swtDefaults().grab(true, false).span(2, 1).applyTo((Control)this.searchAllBranchesButton);
        this.repositoryGroup.setText(this.getRepositoryText());
    }

    private String getRepositoryText() {
        return MessageFormat.format(UIText.CommitSearchPage_Repositories, this.repositoryViewer.getCheckedElements().length, this.repositoryViewer.getTable().getItemCount());
    }

    private void addTextPatternControls(Composite group) {
        Label label = new Label(group, 0);
        label.setText(UIText.CommitSearchPage_ContainingText);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.patternCombo = new Combo(group, 2052);
        this.patternCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSearchPage.this.handleWidgetSelected();
                CommitSearchPage.this.updateOKStatus();
            }
        });
        this.patternCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommitSearchPage.this.updateOKStatus();
            }
        });
        this.patternCombo.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.patternCombo.setLayoutData((Object)data);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.patternFieldContentAssist = new ContentAssistCommandAdapter((Control)this.patternCombo, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.patternFieldContentAssist.setEnabled(false);
        this.isCaseSensitiveButton = new Button(group, 32);
        this.isCaseSensitiveButton.setText(UIText.CommitSearchPage_CaseSensitive);
        this.isCaseSensitiveButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.isCaseSensitiveButton.setFont(group.getFont());
        this.statusLabel = new CLabel(group, 16384);
        this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.statusLabel.setFont(group.getFont());
        this.statusLabel.setAlignment(16384);
        this.statusLabel.setText(UIText.CommitSearchPage_ContainingTextHint);
        this.isRegExButton = new Button(group, 32);
        this.isRegExButton.setText(UIText.CommitSearchPage_RegularExpression);
        this.isRegExButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommitSearchPage.this.updateOKStatus();
                CommitSearchPage.this.patternFieldContentAssist.setEnabled(CommitSearchPage.this.isRegExButton.getSelection());
            }
        });
        this.isRegExButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.isRegExButton.setFont(group.getFont());
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.patternCombo.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            this.repositoryViewer.setAllChecked(true);
            this.repositoryGroup.setText(this.getRepositoryText());
            return;
        }
        CommitSearchSettings settings = this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.patternCombo.getText().equals(settings.getTextPattern())) {
            return;
        }
        this.isCaseSensitiveButton.setSelection(settings.isCaseSensitive());
        this.isRegExButton.setSelection(settings.isRegExSearch());
        this.patternCombo.setText(settings.getTextPattern());
        this.patternFieldContentAssist.setEnabled(settings.isRegExSearch());
        this.searchAuthorButton.setSelection(settings.isMatchAuthor());
        this.searchCommitButton.setSelection(settings.isMatchCommit());
        this.searchCommitterButton.setSelection(settings.isMatchCommitter());
        this.searchMessageButton.setSelection(settings.isMatchMessage());
        this.searchParentsButton.setSelection(settings.isMatchParents());
        this.searchTreeButton.setSelection(settings.isMatchTree());
        this.searchAllBranchesButton.setSelection(settings.isAllBranches());
        LinkedList<RepositoryNode> repositories = new LinkedList<RepositoryNode>();
        for (String path : settings.getRepositories()) {
            File file = new File(path);
            if (!file.exists()) continue;
            try {
                RepositoryNode node = new RepositoryNode(null, org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(file));
                repositories.add(node);
            }
            catch (IOException iOException) {}
        }
        this.repositoryViewer.setCheckedElements(repositories.toArray());
        this.repositoryGroup.setText(this.getRepositoryText());
    }

    private boolean initializePatternControl() {
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null) {
            if (this.isRegExButton.getSelection()) {
                this.patternCombo.setText(FindReplaceDocumentAdapter.escapeForRegExPattern((String)text));
            } else {
                this.patternCombo.setText(this.insertEscapeChars(text));
            }
            return true;
        }
        return false;
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.length() == 0) {
            return "";
        }
        StringBuilder sbIn = new StringBuilder(text);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            String l = reader.readLine();
            if (l != null) {
                lengthOfFirstLine = l.length();
            }
        }
        catch (IOException iOException) {
            return "";
        }
        StringBuilder sbOut = new StringBuilder(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append('\\');
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private ISearchPageContainer getContainer() {
        return this.container;
    }

    private ISelection getSelection() {
        return this.container.getSelection();
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
        if (section == null) {
            section = dialogSettings.addNewSection(PAGE_NAME);
        }
        return section;
    }

    private void readConfiguration() {
        IDialogSettings settings = this.getDialogSettings();
        try {
            int historySize = settings.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                IDialogSettings histSettings = settings.getSection(STORE_HISTORY + i);
                if (histSettings != null) {
                    this.fPreviousSearchPatterns.add(CommitSearchSettings.create(histSettings));
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            this.fPreviousSearchPatterns.get(i).store(s.addNewSection(STORE_HISTORY + i));
            ++i;
        }
    }

    private void statusMessage(boolean error, String message) {
        this.statusLabel.setText(message);
        if (error) {
            this.statusLabel.setForeground(JFaceColors.getErrorText((Display)this.statusLabel.getDisplay()));
        } else {
            this.statusLabel.setForeground(null);
        }
    }

    private static class SearchComposite
    extends Composite {
        public SearchComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void setLayoutData(Object layoutData) {
            if (this.getLayoutData() == null) {
                super.setLayoutData(layoutData);
            }
        }
    }
}

