/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.internal.base.BasePlugin;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseUtil {
    private static final String BOGUS_SCHEME = URI.createURI((String)"bogus:").scheme();
    private static final Adapter REDUCED = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public Notifier getTarget() {
            return null;
        }
    };

    private BaseUtil() {
    }

    public static BaseResource loadResourceSafely(ResourceSet resourceSet, URI uri) {
        try {
            return (BaseResource)resourceSet.getResource(uri, true);
        }
        catch (Throwable ex) {
            BaseResource resource = (BaseResource)resourceSet.getResource(uri, false);
            if (resource == null) {
                throw new IORuntimeException(ex);
            }
            BasePlugin.INSTANCE.log(ex, 2);
            return resource;
        }
    }

    public static void saveEObject(EObject eObject) {
        try {
            XMLResource xmlResource = (XMLResource)eObject.eResource();
            xmlResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
        }
        catch (IOException ex) {
            BasePlugin.INSTANCE.log(ex);
        }
    }

    public static URI getRootURI(EObject eObject) {
        if (eObject.eIsProxy()) {
            return ((InternalEObject)eObject).eProxyURI();
        }
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObject);
        URI uri = EcoreUtil.getURI((EObject)rootContainer);
        String relativeURIFragmentPath = EcoreUtil.getRelativeURIFragmentPath((EObject)rootContainer, (EObject)eObject);
        if (relativeURIFragmentPath.length() != 0) {
            uri = uri.trimFragment().appendFragment(String.valueOf(uri.fragment()) + "/" + relativeURIFragmentPath);
        }
        return uri;
    }

    public static EStructuralFeature getFeature(EClass eClass, String xmlName) {
        for (EStructuralFeature eStructuralFeature : eClass.getEAllStructuralFeatures()) {
            if (!xmlName.equals(ExtendedMetaData.INSTANCE.getName(eStructuralFeature))) continue;
            return eStructuralFeature;
        }
        return null;
    }

    private static InputStream openInputStream(URIConverter uriConverter, Map<?, ?> options, URI uri) throws IORuntimeException {
        try {
            return uriConverter.createInputStream(uri, options);
        }
        catch (IOException iOException) {
            throw new IORuntimeException();
        }
    }

    private static OutputStream openOutputStream(URIConverter uriConverter, Map<?, ?> options, URI uri) throws IORuntimeException {
        try {
            return uriConverter.createOutputStream(uri, options);
        }
        catch (IOException iOException) {
            throw new IORuntimeException();
        }
    }

    public static void copyFile(URIConverter uriConverter, Map<?, ?> options, URI source, URI target) throws IORuntimeException {
        InputStream input = null;
        OutputStream output = null;
        try {
            input = BaseUtil.openInputStream(uriConverter, options, source);
            output = BaseUtil.openOutputStream(uriConverter, options, target);
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(output);
            IOUtil.closeSilent((Closeable)input);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)output);
        IOUtil.closeSilent((Closeable)input);
    }

    public static byte[] readFile(URIConverter uriConverter, Map<?, ?> options, URI uri) throws IORuntimeException {
        InputStream input = BaseUtil.openInputStream(uriConverter, options, uri);
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(input.available());
            IOUtil.copy((InputStream)input, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
        finally {
            IOUtil.closeSilent((Closeable)input);
        }
    }

    public static void writeFile(URIConverter uriConverter, Map<?, ?> options, URI uri, byte[] bytes) throws IORuntimeException {
        OutputStream output = BaseUtil.openOutputStream(uriConverter, options, uri);
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(bytes);
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
        finally {
            IOUtil.closeSilent((Closeable)output);
        }
    }

    public static void deleteFile(URIConverter uriConverter, Map<?, ?> options, URI uri) throws IORuntimeException {
        try {
            uriConverter.delete(uri, options);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    public static <T> T getObjectByType(Collection<?> objects, EClassifier type) {
        return (T)EcoreUtil.getObjectByType(objects, (EClassifier)type);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(long timeout, Runnable runnable, URIConverter uriConverter, URI ... uris) {
        lockLocations = new URI[uris.length];
        i = 0;
        while (i < uris.length) {
            uri = uris[i];
            if (uri != null) {
                lockLocations[i] = uri.trimSegments(1).appendSegment(String.valueOf(uri.lastSegment()) + ".lock");
            }
            ++i;
        }
        fileLocks = new FileLock[uris.length];
        start = System.currentTimeMillis();
        block26: while (System.currentTimeMillis() - start < timeout) {
            outputStreams = new OutputStream[uris.length];
            try {
                i = 0;
                while (true) {
                    if (i >= uris.length) {
                        runnable.run();
                    }
                    uri = lockLocations[i];
                    if (uri != null) {
                        outputStreams[i] = uriConverter.createOutputStream(uri);
                        if (outputStreams[i] instanceof FileOutputStream) {
                            fileOutputStream = (FileOutputStream)outputStreams[i];
                            fileLocks[i] = fileOutputStream.getChannel().tryLock();
                        }
                    }
                    ++i;
                }
            }
            catch (IOException v0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex1) {
                    throw new RuntimeException(ex1);
                }
            }
            finally {
                i = 0;
                ** while (i < uris.length)
            }
lbl-1000:
            // 1 sources

            {
                outputStream = outputStreams[i];
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable v1) {}
                    try {
                        uriConverter.delete(lockLocations[i], null);
                    }
                    catch (Throwable v2) {}
                    fileLock = fileLocks[i];
                    if (fileLock != null) {
                        try {
                            fileLock.release();
                        }
                        catch (Throwable v3) {}
                    }
                }
                ++i;
                continue;
lbl53:
                // 1 sources

            }
        }
        return false;
    }

    public static String getAnnotation(ModelElement modelElement, String sourceURI, String key) {
        Annotation annotation = modelElement.getAnnotation(sourceURI);
        return annotation == null ? null : (String)annotation.getDetails().get((Object)key);
    }

    public static void setAnnotation(ModelElement modelElement, String sourceURI, String key, String value) {
        Annotation annotation = modelElement.getAnnotation(sourceURI);
        if (value == null) {
            if (annotation != null) {
                annotation.getDetails().removeKey((Object)key);
            }
        } else {
            if (annotation == null) {
                annotation = BaseFactory.eINSTANCE.createAnnotation();
                annotation.setSource(sourceURI);
                modelElement.getAnnotations().add((Object)annotation);
            }
            annotation.getDetails().put((Object)key, (Object)value);
        }
    }

    public static boolean isReduced(ModelElement modelElement) {
        return modelElement.eAdapters().contains((Object)REDUCED);
    }

    public static void setReduced(ModelElement modelElement, boolean reduced) {
        EList eAdapters = modelElement.eAdapters();
        if (reduced) {
            if (!eAdapters.contains((Object)REDUCED)) {
                eAdapters.add((Object)REDUCED);
            }
        } else {
            eAdapters.remove((Object)REDUCED);
        }
    }

    public static URI createBogusURI(URI uri) {
        return URI.createURI((String)("bogus:" + uri));
    }

    public static URI resolveBogusURI(URI uri) {
        return BaseUtil.isBogusURI(uri) ? URI.createURI((String)uri.opaquePart()).appendQuery(uri.query()).appendFragment(uri.fragment()) : uri;
    }

    public static boolean isBogusURI(URI uri) {
        return uri != null && uri.scheme() == BOGUS_SCHEME && uri.hasOpaquePart();
    }
}

