/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.qttest;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.testsrunner.internal.qttest.QtTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.qttest.QtTestsRunnerPlugin;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class QtXmlLogHandler
extends DefaultHandler {
    private static final String XML_NODE_TEST_CASE = "TestCase";
    private static final String XML_NODE_TEST_FUNCTION = "TestFunction";
    private static final String XML_NODE_INCIDENT = "Incident";
    private static final String XML_NODE_MESSAGE = "Message";
    private static final String XML_NODE_DESCRIPTION = "Description";
    private static final String XML_NODE_ENVIRONMENT = "Environment";
    private static final String XML_NODE_QTVERSION = "QtVersion";
    private static final String XML_NODE_QTESTVERSION = "QTestVersion";
    private static final String XML_NODE_BENCHMARK = "BenchmarkResult";
    private static final String XML_NODE_DATATAG = "DataTag";
    private static final String XML_VALUE_INCIDENT_PASS = "pass";
    private static final String XML_VALUE_INCIDENT_XFAIL = "xfail";
    private static final String XML_VALUE_INCIDENT_FAIL = "fail";
    private static final String XML_VALUE_INCIDENT_XPASS = "xpass";
    private static final String XML_VALUE_INCIDENT_UNKNOWN = "??????";
    private static final String XML_VALUE_MESSAGE_WARN = "warn";
    private static final String XML_VALUE_MESSAGE_SYSTEM = "system";
    private static final String XML_VALUE_MESSAGE_QDEBUG = "qdebug";
    private static final String XML_VALUE_MESSAGE_QWARN = "qwarn";
    private static final String XML_VALUE_MESSAGE_QFATAL = "qfatal";
    private static final String XML_VALUE_MESSAGE_SKIP = "skip";
    private static final String XML_VALUE_MESSAGE_INFO = "info";
    private static final String XML_VALUE_MESSAGE_UNKNOWN = "??????";
    private static final String XML_ATTR_TEST_CASE_NAME = "name";
    private static final String XML_ATTR_TEST_FUNCTION_NAME = "name";
    private static final String XML_ATTR_TYPE = "type";
    private static final String XML_ATTR_FILE = "file";
    private static final String XML_ATTR_LINE = "line";
    private static final String XML_ATTR_BENCHMARK_METRIC = "metric";
    private static final String XML_ATTR_BENCHMARK_VALUE = "value";
    private static final String XML_ATTR_BENCHMARK_ITERATIONS = "iterations";
    private static final String XML_ATTR_DATA_TAG = "tag";
    private static final Map<String, ITestMessage.Level> STRING_TO_MESSAGE_LEVEL;
    private static final Map<String, ITestItem.Status> STRING_TO_TEST_STATUS;
    private static final Map<String, ITestMessage.Level> STRING_INCIDENT_TO_MESSAGE_LEVEL;
    private static final Map<String, String> XML_METRICS_TO_UNIT_NAME;
    private ITestModelUpdater modelUpdater;
    private String elementData;
    private String messageText;
    private String fileName;
    private int lineNumber;
    private ITestMessage.Level messageLevel;
    private ITestItem.Status testCaseStatus;
    private String testCaseName;
    private String currentDataTag;
    private String lastDataTag;
    private boolean testCaseAdded;

    static {
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        aMap.put(XML_VALUE_MESSAGE_WARN, ITestMessage.Level.Warning);
        aMap.put(XML_VALUE_MESSAGE_SYSTEM, ITestMessage.Level.Message);
        aMap.put(XML_VALUE_MESSAGE_QDEBUG, ITestMessage.Level.Message);
        aMap.put(XML_VALUE_MESSAGE_QWARN, ITestMessage.Level.Warning);
        aMap.put(XML_VALUE_MESSAGE_QFATAL, ITestMessage.Level.FatalError);
        aMap.put(XML_VALUE_MESSAGE_SKIP, ITestMessage.Level.Info);
        aMap.put(XML_VALUE_MESSAGE_INFO, ITestMessage.Level.Info);
        aMap.put("??????", ITestMessage.Level.FatalError);
        STRING_TO_MESSAGE_LEVEL = Collections.unmodifiableMap(aMap);
        aMap = new HashMap();
        aMap.put(XML_VALUE_INCIDENT_PASS, ITestItem.Status.Passed);
        aMap.put(XML_VALUE_INCIDENT_XFAIL, ITestItem.Status.Failed);
        aMap.put(XML_VALUE_INCIDENT_FAIL, ITestItem.Status.Failed);
        aMap.put(XML_VALUE_INCIDENT_XPASS, ITestItem.Status.Failed);
        aMap.put("??????", ITestItem.Status.Aborted);
        STRING_TO_TEST_STATUS = Collections.unmodifiableMap(aMap);
        aMap = new HashMap();
        aMap.put(XML_VALUE_INCIDENT_PASS, ITestMessage.Level.Info);
        aMap.put(XML_VALUE_INCIDENT_XFAIL, ITestMessage.Level.Error);
        aMap.put(XML_VALUE_INCIDENT_FAIL, ITestMessage.Level.FatalError);
        aMap.put(XML_VALUE_INCIDENT_XPASS, ITestMessage.Level.Error);
        aMap.put("??????", ITestMessage.Level.FatalError);
        STRING_INCIDENT_TO_MESSAGE_LEVEL = Collections.unmodifiableMap(aMap);
        aMap = new HashMap();
        aMap.put("events", QtTestsRunnerMessages.QtXmlLogHandler_metrics_unit_events);
        aMap.put("callgrind", QtTestsRunnerMessages.QtXmlLogHandler_metrics_unit_instructions);
        aMap.put("walltime", QtTestsRunnerMessages.QtXmlLogHandler_metrics_unit_msec);
        aMap.put("cputicks", QtTestsRunnerMessages.QtXmlLogHandler_metrics_unit_ticks);
        XML_METRICS_TO_UNIT_NAME = Collections.unmodifiableMap(aMap);
    }

    QtXmlLogHandler(ITestModelUpdater modelUpdater) {
        this.modelUpdater = modelUpdater;
    }

    private void exitTestCaseIfNecessary() {
        if (this.testCaseAdded) {
            this.modelUpdater.setTestStatus(this.testCaseStatus);
            this.modelUpdater.exitTestCase();
            this.testCaseAdded = false;
        }
    }

    private void createTestCaseIfNecessary() {
        if (!this.lastDataTag.equals(this.currentDataTag)) {
            this.exitTestCaseIfNecessary();
            this.currentDataTag = this.lastDataTag;
            String suffix = !this.currentDataTag.isEmpty() ? MessageFormat.format(QtTestsRunnerMessages.QtXmlLogHandler_datatag_format, this.currentDataTag) : "";
            this.modelUpdater.enterTestCase(String.valueOf(this.testCaseName) + suffix);
            this.testCaseAdded = true;
        }
    }

    private void addTestMessageIfNecessary() {
        if (this.messageText != null) {
            this.modelUpdater.addTestMessage(this.fileName, this.lineNumber, this.messageLevel, this.messageText);
        }
    }

    private void setCurrentTestCaseStatus(ITestItem.Status newStatus) {
        if (newStatus != ITestItem.Status.Passed) {
            this.testCaseStatus = newStatus;
        }
    }

    private String getUnitsByBenchmarkMetric(String benchmarkMetric) throws SAXException {
        String units = XML_METRICS_TO_UNIT_NAME.get(benchmarkMetric);
        if (units == null) {
            this.logAndThrowError(MessageFormat.format(QtTestsRunnerMessages.QtXmlLogHandler_unknown_benchmarck_metric, benchmarkMetric));
        }
        return units;
    }

    private ITestMessage.Level getMessageLevel(Map<String, ITestMessage.Level> map, String incidentTypeStr) throws SAXException {
        ITestMessage.Level result = map.get(incidentTypeStr);
        if (result == null) {
            this.logAndThrowError(MessageFormat.format(QtTestsRunnerMessages.QtXmlLogHandler_unknown_message_level, incidentTypeStr));
        }
        return result;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        this.elementData = null;
        if (qName == XML_NODE_TEST_CASE) {
            String testSuiteName = attrs.getValue("name");
            this.modelUpdater.enterTestSuite(testSuiteName);
        } else if (qName == XML_NODE_TEST_FUNCTION) {
            this.testCaseName = attrs.getValue("name");
            this.currentDataTag = null;
            this.lastDataTag = "";
            this.testCaseAdded = false;
            this.testCaseStatus = ITestItem.Status.Passed;
        } else if (qName == XML_NODE_MESSAGE) {
            String messageLevelStr = attrs.getValue(XML_ATTR_TYPE);
            this.fileName = attrs.getValue(XML_ATTR_FILE);
            this.lineNumber = Integer.parseInt(attrs.getValue(XML_ATTR_LINE).trim());
            this.messageLevel = this.getMessageLevel(STRING_TO_MESSAGE_LEVEL, messageLevelStr);
            this.messageText = null;
            if (messageLevelStr.equals(XML_VALUE_MESSAGE_SKIP)) {
                this.setCurrentTestCaseStatus(ITestItem.Status.Skipped);
            }
        } else if (qName == XML_NODE_INCIDENT) {
            String strType = attrs.getValue(XML_ATTR_TYPE);
            this.fileName = attrs.getValue(XML_ATTR_FILE);
            this.lineNumber = Integer.parseInt(attrs.getValue(XML_ATTR_LINE).trim());
            this.messageLevel = this.getMessageLevel(STRING_INCIDENT_TO_MESSAGE_LEVEL, strType);
            this.messageText = null;
            this.setCurrentTestCaseStatus(STRING_TO_TEST_STATUS.get(strType));
        } else if (qName == XML_NODE_BENCHMARK) {
            this.lastDataTag = attrs.getValue(XML_ATTR_DATA_TAG);
            this.createTestCaseIfNecessary();
            int benchmarkResultIteratations = Integer.parseInt(attrs.getValue(XML_ATTR_BENCHMARK_ITERATIONS).trim());
            float benchmarkResultValue = Integer.parseInt(attrs.getValue(XML_ATTR_BENCHMARK_VALUE).trim());
            String units = this.getUnitsByBenchmarkMetric(attrs.getValue(XML_ATTR_BENCHMARK_METRIC).trim());
            this.modelUpdater.addTestMessage("", 0, ITestMessage.Level.Info, MessageFormat.format(QtTestsRunnerMessages.QtXmlLogHandler_benchmark_result_message, Float.valueOf(benchmarkResultValue / (float)benchmarkResultIteratations), units, Float.valueOf(benchmarkResultValue), benchmarkResultIteratations));
        } else if (qName == XML_NODE_DATATAG) {
            this.lastDataTag = "";
        } else if (qName != XML_NODE_DESCRIPTION && qName != XML_NODE_ENVIRONMENT && qName != XML_NODE_QTVERSION && qName != XML_NODE_QTESTVERSION) {
            this.logAndThrowErrorForElement(qName);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName == XML_NODE_TEST_CASE) {
            this.modelUpdater.exitTestSuite();
        } else if (qName == XML_NODE_TEST_FUNCTION) {
            this.createTestCaseIfNecessary();
            this.exitTestCaseIfNecessary();
        } else if (qName == XML_NODE_DATATAG) {
            this.lastDataTag = this.elementData;
        } else if (qName == XML_NODE_INCIDENT) {
            this.createTestCaseIfNecessary();
            this.addTestMessageIfNecessary();
        } else if (qName == XML_NODE_MESSAGE) {
            this.createTestCaseIfNecessary();
            this.addTestMessageIfNecessary();
        } else if (qName == XML_NODE_DESCRIPTION) {
            this.messageText = this.elementData == null || this.elementData.isEmpty() ? "" : this.elementData;
        } else if (qName != XML_NODE_ENVIRONMENT && qName != XML_NODE_QTVERSION && qName != XML_NODE_QTESTVERSION && qName != XML_NODE_BENCHMARK) {
            this.logAndThrowErrorForElement(qName);
        }
        this.elementData = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        StringBuilder sb = new StringBuilder();
        int i = start;
        while (i < start + length) {
            sb.append(ch[i]);
            ++i;
        }
        this.elementData = sb.toString();
    }

    private void logAndThrowErrorForElement(String tagName) throws SAXException {
        this.logAndThrowError(MessageFormat.format(QtTestsRunnerMessages.QtXmlLogHandler_wrong_tag_name, tagName));
    }

    private void logAndThrowError(String message) throws SAXException {
        SAXException e = new SAXException(message);
        QtTestsRunnerPlugin.log(e);
        throw e;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        QtTestsRunnerPlugin.log(ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        QtTestsRunnerPlugin.log(ex);
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        QtTestsRunnerPlugin.log(ex);
        throw ex;
    }
}

