/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import org.eclipse.cdt.internal.autotools.ui.editors.automake.Directive;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.IVariableDefinition;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MacroDefinition;

public class VariableDefinition
extends MacroDefinition
implements IVariableDefinition {
    static final int TYPE_RECURSIVE_EXPAND = 0;
    static final int TYPE_SIMPLE_EXPAND = 58;
    static final int TYPE_CONDITIONAL = 63;
    static final int TYPE_APPEND = 43;
    int type;
    String varTarget;

    public VariableDefinition(Directive parent, String name, StringBuffer value) {
        this(parent, name, value, 0);
    }

    public VariableDefinition(Directive parent, String name, StringBuffer value, int type) {
        this(parent, "", name, value, type);
    }

    public VariableDefinition(Directive parent, String target, String name, StringBuffer value, int type) {
        super(parent, name, value);
        this.varTarget = target;
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isTargetSpecific()) {
            sb.append(this.getTarget()).append(": ");
        }
        if (this.isOverride()) {
            sb.append("override");
        }
        if (this.isMultiLine()) {
            sb.append("define");
            sb.append(' ');
            sb.append(this.getName()).append('\n');
            sb.append(this.getValue()).append('\n');
            sb.append("endef");
            sb.append('\n');
        } else {
            if (this.isExport()) {
                sb.append("export");
                sb.append(' ');
            }
            sb.append(this.getName());
            if (this.isRecursivelyExpanded()) {
                sb.append(" = ");
            } else if (this.isSimplyExpanded()) {
                sb.append(" := ");
            } else if (this.isConditional()) {
                sb.append(" ?= ");
            } else if (this.isAppend()) {
                sb.append(" += ");
            }
            sb.append(this.getValue()).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean isRecursivelyExpanded() {
        return this.type == 0;
    }

    @Override
    public boolean isSimplyExpanded() {
        return this.type == 58;
    }

    @Override
    public boolean isConditional() {
        return this.type == 63;
    }

    @Override
    public boolean isAppend() {
        return this.type == 43;
    }

    @Override
    public boolean isTargetSpecific() {
        String t = this.getTarget();
        return t != null && t.length() > 0;
    }

    @Override
    public boolean isExport() {
        return false;
    }

    @Override
    public boolean isMultiLine() {
        return false;
    }

    @Override
    public boolean isOverride() {
        return false;
    }

    @Override
    public boolean isAutomatic() {
        return false;
    }

    @Override
    public String getTarget() {
        return this.varTarget;
    }
}

