/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core;

import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamPlugin;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.resource.events.ResourceStatesChangedEvent;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class ResourceChangeListener
implements IResourceChangeListener,
ISaveParticipant {
    public static int INTERESTING_CHANGES = 323584;

    public void resourceChanged(final IResourceChangeEvent event) {
        ProgressMonitorUtility.doTaskScheduledDefault(new AbstractActionOperation("Operation_ResourcesChanged", SVNMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                final HashSet modified = new HashSet();
                final int[] depth = new int[1];
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 8) {
                            return true;
                        }
                        if (!FileUtility.isConnected(resource)) {
                            return false;
                        }
                        IContainer toAdd = null;
                        IResource svnFolder = FileUtility.getSVNFolder(resource);
                        if (svnFolder != null) {
                            toAdd = svnFolder.getParent();
                            return false;
                        }
                        if (delta.getKind() == 1 || delta.getKind() == 2) {
                            toAdd = resource;
                        } else if (delta.getKind() == 4) {
                            int flags = delta.getFlags();
                            if (resource instanceof IContainer && (flags & INTERESTING_CHANGES) != 0 || resource instanceof IFile && (flags & (INTERESTING_CHANGES | 0x100)) != 0) {
                                toAdd = resource;
                            }
                        }
                        if (toAdd != null) {
                            modified.add(toAdd);
                            if (toAdd.getType() != 1) {
                                depth[0] = 2;
                            }
                        }
                        return true;
                    }
                }, 2);
                if (modified.size() > 0) {
                    IResource[] resources = modified.toArray(new IResource[modified.size()]);
                    SVNRemoteStorage.instance().scheduleRefresh(resources, depth[0], new ResourceStatesChangedEvent(FileUtility.getPathNodes(resources), 0, 1), new ResourceStatesChangedEvent(resources, 0, 0));
                }
            }
        });
    }

    public void handleInitialWorkspaceDelta() throws CoreException {
        ISavedState ss = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)SVNTeamPlugin.instance(), (ISaveParticipant)this);
        if (ss != null) {
            ss.processResourceChangeEvents((IResourceChangeListener)this);
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }
}

