/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class UDiffGenerateOperation
extends AbstractActionOperation {
    protected ILocalResource local;
    protected IRepositoryResource remote;
    protected String diffFile;

    public UDiffGenerateOperation(ILocalResource local, IRepositoryResource remote, String diffFile) {
        super("Operation_UDiffGenerate", SVNMessages.class);
        this.local = local;
        this.remote = remote;
        this.diffFile = diffFile;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryLocation location = SVNRemoteStorage.instance().getRepositoryLocation(this.local.getResource());
        ISVNConnector proxy = location.acquireSVNProxy();
        try {
            String projectPath;
            String wcPath = FileUtility.getWorkingCopyPath(this.local.getResource());
            SVNEntryRevisionReference refPrev = new SVNEntryRevisionReference(wcPath, null, SVNRevision.WORKING);
            SVNEntryRevisionReference refNext = SVNUtility.getEntryRevisionReference(this.remote);
            String relativeToDir = projectPath = FileUtility.getWorkingCopyPath((IResource)this.local.getResource().getProject());
            SVNDepth depth = SVNDepth.INFINITY;
            long options = 0L;
            String[] changelistNames = new String[]{};
            this.writeToConsole(0, "svn diff -r " + refNext.revision + " \"" + wcPath + "\"" + ISVNConnector.Options.asCommandLine(options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            proxy.diffTwo(refPrev, refNext, relativeToDir, this.diffFile, depth, options, changelistNames, 0L, (ISVNProgressMonitor)new SVNProgressMonitor(this, monitor, null));
        }
        finally {
            location.releaseSVNProxy(proxy);
        }
    }
}

