/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProjectMapper;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.UnreportableException;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class ReconnectProjectOperation
extends AbstractWorkingCopyOperation {
    protected IRepositoryLocation location;

    public ReconnectProjectOperation(IProject[] projects, IRepositoryLocation location) {
        super("Operation_Reconnect", SVNMessages.class, (IResource[])projects);
        this.location = location;
    }

    public ReconnectProjectOperation(IResourceProvider provider, IRepositoryLocation location) {
        super("Operation_Reconnect", SVNMessages.class, provider);
        this.location = location;
    }

    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IResource[] resources = this.operableData();
        int i = 0;
        while (i < resources.length && !monitor.isCanceled()) {
            final IProject project = (IProject)resources[i];
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    SVNChangeStatus st = SVNUtility.getSVNInfoForNotConnected((IResource)project);
                    if (st == null) {
                        throw new UnreportableException(SVNMessages.getErrorString("Error_NonSVNPath"));
                    }
                    IRepositoryContainer remote = ReconnectProjectOperation.this.location.asRepositoryContainer(SVNUtility.decodeURL(st.url), false);
                    SVNTeamProjectMapper.map(project, remote);
                }
            }, monitor, resources.length);
            ++i;
        }
    }
}

