/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.filters;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemChangeFilterActionCopyString;
import org.eclipse.rse.internal.ui.actions.SystemChangeFilterActionDeleteString;
import org.eclipse.rse.internal.ui.actions.SystemChangeFilterActionMoveStringDown;
import org.eclipse.rse.internal.ui.actions.SystemChangeFilterActionMoveStringUp;
import org.eclipse.rse.internal.ui.actions.SystemChangeFilterActionPasteString;
import org.eclipse.rse.internal.ui.view.SystemViewMenuListener;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.filters.ISystemChangeFilterPaneEditPaneSupplier;
import org.eclipse.rse.ui.filters.ISystemFilterStringEditPaneListener;
import org.eclipse.rse.ui.filters.SystemFilterStringEditPane;
import org.eclipse.rse.ui.internal.model.SystemRegistryUI;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ISystemValidatorUniqueString;
import org.eclipse.rse.ui.validators.ValidatorFilterString;
import org.eclipse.rse.ui.widgets.SystemEditPaneStateMachine;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SystemChangeFilterPane
extends SystemBaseForm
implements SelectionListener,
ISystemFilterStringEditPaneListener,
IMenuListener {
    protected Button applyButton;
    protected Button revertButton;
    protected Button testButton;
    protected SystemEditPaneStateMachine sm;
    protected List listView;
    protected Label filterNameLabel;
    protected Label filterPoolNameLabel;
    protected Label fsLabel;
    private SystemChangeFilterActionCopyString copyAction;
    private SystemChangeFilterActionPasteString pasteAction;
    private SystemChangeFilterActionDeleteString deleteAction;
    private SystemChangeFilterActionMoveStringUp moveUpAction;
    private SystemChangeFilterActionMoveStringDown moveDownAction;
    private MenuManager menuMgr;
    private boolean menuListenerAdded;
    protected ISystemChangeFilterPaneEditPaneSupplier editPaneSupplier;
    protected ISystemFilter inputFilter;
    protected ISystemFilterPoolReferenceManagerProvider refProvider;
    protected ISystemFilterPoolManagerProvider provider;
    protected String namePromptLabel;
    protected String namePromptTip;
    protected String poolPromptLabel;
    protected String poolPromptTip;
    protected String listPromptLabel;
    protected String listPromptTip;
    protected String newEntryLabel;
    protected ISystemValidator filterStringValidator = null;
    protected SystemMessage duplicateFilterStringMsg;
    protected boolean wantTestButton;
    protected boolean editable = true;
    protected boolean caseSensitiveStrings = false;
    protected boolean allowDuplicateStrings = false;
    protected boolean ignoreEvents = false;
    protected boolean resetting = false;
    protected boolean giveEditorFocus = true;
    protected boolean showingNew = true;
    protected boolean supportsMultipleStrings = true;
    protected String[] listItems;

    public SystemChangeFilterPane(Shell shell, ISystemMessageLine msgLine, ISystemChangeFilterPaneEditPaneSupplier editPaneSupplier) {
        super(shell, msgLine);
        this.editPaneSupplier = editPaneSupplier;
        this.namePromptLabel = SystemResources.RESID_CHGFILTER_NAME_LABEL;
        this.namePromptTip = SystemResources.RESID_CHGFILTER_NAME_TOOLTIP;
        this.poolPromptLabel = SystemResources.RESID_CHGFILTER_POOL_LABEL;
        this.poolPromptTip = SystemResources.RESID_CHGFILTER_POOL_TOOLTIP;
        this.listPromptLabel = SystemResources.RESID_CHGFILTER_LIST_LABEL;
        this.listPromptTip = SystemResources.RESID_CHGFILTER_LIST_TOOLTIP;
    }

    public void setSystemFilterPoolReferenceManagerProvider(ISystemFilterPoolReferenceManagerProvider provider) {
        this.refProvider = provider;
    }

    public void setSystemFilterPoolManagerProvider(ISystemFilterPoolManagerProvider provider) {
        this.provider = provider;
    }

    public void setParentPoolPromptLabel(String label, String tip) {
        this.poolPromptLabel = label;
        this.poolPromptTip = tip;
    }

    public String getParentPoolPromptLabel() {
        return this.poolPromptLabel;
    }

    public String getParentPoolPromptTip() {
        return this.poolPromptTip;
    }

    public void setNamePromptLabel(String label, String tip) {
        this.namePromptLabel = label;
        this.namePromptTip = tip;
    }

    public String getNamePromptLabel() {
        return this.namePromptLabel;
    }

    public String getNamePromptTip() {
        return this.namePromptTip;
    }

    public void setListLabel(String label, String tip) {
        this.listPromptLabel = label;
        this.listPromptTip = tip;
    }

    public String getListLabel() {
        return this.listPromptLabel;
    }

    public String getListTip() {
        return this.listPromptTip;
    }

    public void setNewListItemText(String label) {
        this.newEntryLabel = label;
    }

    public String getNewListItemText() {
        return this.newEntryLabel != null ? this.newEntryLabel : SystemResources.RESID_CHGFILTER_LIST_NEWITEM;
    }

    public void setFilterStringValidator(ISystemValidator v) {
        this.filterStringValidator = v;
    }

    public ISystemValidator getFilterStringValidator() {
        return this.filterStringValidator;
    }

    public void setDuplicateFilterStringErrorMessage(SystemMessage msg) {
        this.duplicateFilterStringMsg = msg;
    }

    public SystemMessage getDuplicateFilterStringErrorMessage() {
        return this.duplicateFilterStringMsg;
    }

    public void setWantTestButton(boolean wantTestButton) {
        this.wantTestButton = wantTestButton;
    }

    public boolean getWantTestButton() {
        return this.wantTestButton;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.showingNew = editable;
    }

    public boolean getEditable() {
        return this.editable;
    }

    public void setSupportsMultipleStrings(boolean multi) {
        this.showingNew = multi;
        this.supportsMultipleStrings = multi;
    }

    public boolean getSupportsMultipleStrings() {
        return this.supportsMultipleStrings;
    }

    public void setInputObject(Object inputObject) {
        super.setInputObject(inputObject);
        this.inputFilter = this.getSystemFilter(inputObject);
        this.caseSensitiveStrings = this.inputFilter.areStringsCaseSensitive();
        this.allowDuplicateStrings = this.inputFilter.supportsDuplicateFilterStrings();
    }

    public Control getInitialFocusControl() {
        return this.listView;
    }

    public Control createContents(Composite parent) {
        String[] existingStrings;
        String[] strings;
        Composite composite;
        SystemWidgetHelpers.setHelp((Control)parent, "org.eclipse.rse.ui.dufr0000");
        if (this.getShell() == null) {
            this.setShell(parent.getShell());
        }
        SystemFilterStringEditPane editpane = this.getFilterStringEditPane(this.getShell());
        editpane.setSystemFilterPoolReferenceManagerProvider(this.refProvider);
        editpane.setSystemFilterPoolManagerProvider(this.provider);
        editpane.setChangeFilterMode(true);
        int nbrColumns = 2;
        Composite topComposite = composite = SystemWidgetHelpers.createComposite(parent, nbrColumns);
        SystemWidgetHelpers.createLabel(topComposite, this.namePromptLabel);
        this.filterNameLabel = SystemWidgetHelpers.createLabel(topComposite, "");
        this.filterNameLabel.setToolTipText(this.namePromptTip);
        this.filterNameLabel.setText(this.inputFilter.getName());
        SystemWidgetHelpers.createLabel(topComposite, this.poolPromptLabel);
        this.filterPoolNameLabel = SystemWidgetHelpers.createLabel(topComposite, "");
        this.filterPoolNameLabel.setToolTipText(this.poolPromptTip);
        ISystemFilterPool parentPool = this.inputFilter.getParentFilterPool();
        this.filterPoolNameLabel.setText(parentPool.getName());
        this.addFillerLine(composite, nbrColumns);
        if (this.supportsMultipleStrings) {
            this.listView = SystemWidgetHelpers.createListBox(composite, this.listPromptLabel, null, false, 1);
            GridData data = (GridData)this.listView.getLayoutData();
            data.grabExcessHorizontalSpace = false;
            data.horizontalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.verticalAlignment = 4;
            data.widthHint = 130;
        }
        if ((strings = this.inputFilter.getFilterStrings()) == null) {
            strings = new String[]{};
        }
        int delta = this.showingNew ? 1 : 0;
        this.listItems = new String[delta + strings.length];
        if (this.showingNew) {
            this.listItems[0] = this.getNewListItemText();
        }
        int idx = 0;
        while (idx < strings.length) {
            this.listItems[idx + delta] = strings[idx];
            ++idx;
        }
        if (this.listView != null) {
            this.listView.setItems(this.listItems);
        }
        Composite rightSideComposite = SystemWidgetHelpers.createFlushComposite(composite, 1);
        if (this.listView == null) {
            GridData data = (GridData)rightSideComposite.getLayoutData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            data.horizontalSpan = nbrColumns;
        }
        if (this.listView != null) {
            this.addFillerLine(rightSideComposite, 1);
            this.fsLabel = SystemWidgetHelpers.createLabel(rightSideComposite, "");
            this.addSeparatorLine(rightSideComposite, 1);
        }
        editpane.createContents(rightSideComposite);
        if (!this.allowDuplicateStrings && this.filterStringValidator == null && (existingStrings = this.inputFilter.getFilterStrings()) != null) {
            this.filterStringValidator = new ValidatorFilterString(existingStrings, this.caseSensitiveStrings);
            if (this.duplicateFilterStringMsg != null) {
                ((ValidatorFilterString)this.filterStringValidator).setDuplicateFilterStringErrorMessage(this.duplicateFilterStringMsg);
            }
        }
        this.addSeparatorLine(rightSideComposite, 1);
        int nbrColumns_buttonComposite = 3;
        Composite applyResetButtonComposite = SystemWidgetHelpers.createFlushComposite(rightSideComposite, nbrColumns_buttonComposite);
        if (!this.wantTestButton) {
            ((GridData)applyResetButtonComposite.getLayoutData()).horizontalIndent = 200;
            Label filler = SystemWidgetHelpers.createLabel(applyResetButtonComposite, "");
            ((GridData)filler.getLayoutData()).grabExcessHorizontalSpace = true;
            ((GridData)filler.getLayoutData()).horizontalAlignment = 4;
        }
        if (this.wantTestButton) {
            this.testButton = SystemWidgetHelpers.createPushButton(applyResetButtonComposite, this, SystemResources.RESID_CHGFILTER_BUTTON_TEST_LABEL, SystemResources.RESID_CHGFILTER_BUTTON_TEST_TOOLTIP);
            editpane.setTestButton(this.testButton);
            this.testButton.addSelectionListener((SelectionListener)this);
        }
        this.applyButton = SystemWidgetHelpers.createPushButton(applyResetButtonComposite, this, SystemResources.RESID_CHGFILTER_BUTTON_APPLY_LABEL, SystemResources.RESID_CHGFILTER_BUTTON_APPLY_TOOLTIP);
        this.revertButton = SystemWidgetHelpers.createPushButton(applyResetButtonComposite, this, SystemResources.RESID_CHGFILTER_BUTTON_REVERT_LABEL, SystemResources.RESID_CHGFILTER_BUTTON_REVERT_TOOLTIP);
        this.addGrowableFillerLine(rightSideComposite, 1);
        this.sm = new SystemEditPaneStateMachine(rightSideComposite, this.applyButton, this.revertButton);
        this.sm.setUnsetMode();
        composite.layout(true);
        if (this.listView != null) {
            this.listView.addSelectionListener((SelectionListener)this);
        }
        this.applyButton.addSelectionListener((SelectionListener)this);
        this.revertButton.addSelectionListener((SelectionListener)this);
        editpane.addChangeListener(this);
        if (this.listView != null) {
            this.listView.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    SystemChangeFilterPane.this.giveEditorFocus = true;
                }

                public void mouseDown(MouseEvent e) {
                    SystemChangeFilterPane.this.giveEditorFocus = true;
                }

                public void mouseUp(MouseEvent e) {
                    SystemChangeFilterPane.this.giveEditorFocus = true;
                }
            });
            this.listView.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    SystemChangeFilterPane.this.giveEditorFocus = false;
                }

                public void keyReleased(KeyEvent e) {
                    SystemChangeFilterPane.this.giveEditorFocus = false;
                }
            });
        }
        if (this.listView != null) {
            this.menuMgr = new MenuManager("#ChangeFilterPopupMenu");
            this.menuMgr.setRemoveAllWhenShown(true);
            this.menuMgr.addMenuListener((IMenuListener)this);
            Menu menu = this.menuMgr.createContextMenu((Control)this.listView);
            this.listView.setMenu(menu);
        }
        if (this.listItems.length > 1 || !this.showingNew) {
            if (this.listView != null) {
                if (this.showingNew) {
                    this.listView.select(1);
                } else {
                    this.listView.select(0);
                }
            }
            this.sm.setEditMode();
            editpane.setFilterString(this.listItems[this.showingNew ? 1 : 0], 1);
        } else {
            if (this.listView != null) {
                this.listView.select(0);
            }
            this.sm.setNewMode();
            editpane.setFilterString(null, 0);
        }
        editpane.configureHeadingLabel(this.fsLabel);
        this.setPageComplete(editpane.isComplete());
        if (!this.editable) {
            if (this.listView != null) {
                this.listView.setEnabled(false);
            }
            if (strings.length > 0) {
                editpane.setFilterString(strings[0], 0);
            }
            editpane.setEditable(false);
            this.setPageComplete(true);
        } else if (!this.getSupportsMultipleStrings()) {
            this.setPageComplete(true);
        }
        return composite;
    }

    protected SystemFilterStringEditPane getFilterStringEditPane(Shell shell) {
        return this.editPaneSupplier.getFilterStringEditPane(shell);
    }

    public Button getApplyButton() {
        return this.applyButton;
    }

    public Button getRevertButton() {
        return this.revertButton;
    }

    public boolean processOK() {
        if (!this.editable) {
            return true;
        }
        if (!this.verify(true)) {
            return false;
        }
        ISystemFilterPool pool = this.inputFilter.getParentFilterPool();
        ISystemFilterPoolManager mgr = pool.getSystemFilterPoolManager();
        if (this.listView != null) {
            this.listItems = this.listView.getItems();
        }
        String[] filterStrings = null;
        if (this.showingNew) {
            filterStrings = new String[this.listItems.length - 1];
            int idx = 0;
            while (idx < filterStrings.length) {
                filterStrings[idx] = this.listItems[idx + 1];
                ++idx;
            }
        } else {
            filterStrings = this.listItems;
        }
        try {
            boolean hasChanged = false;
            String[] originalFilterStrings = this.inputFilter.getFilterStrings();
            if (originalFilterStrings.length != filterStrings.length) {
                hasChanged = true;
            } else {
                int i = 0;
                while (i < originalFilterStrings.length && !hasChanged) {
                    String originalFilterString = originalFilterStrings[i];
                    String filterString = filterStrings[i];
                    if (!originalFilterString.equals(filterString)) {
                        hasChanged = true;
                    }
                    ++i;
                }
            }
            if (hasChanged) {
                mgr.updateSystemFilter(this.inputFilter, this.inputFilter.getName(), filterStrings);
            }
        }
        catch (SystemMessageException exc) {
            this.getMessageLine().setErrorMessage(exc.getSystemMessage());
            return false;
        }
        catch (Exception exc) {
            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1161");
            String excText = exc.getMessage();
            if (excText == null) {
                excText = exc.getClass().getName();
            }
            msg.makeSubstitution((Object)excText, (Object)exc);
            this.getMessageLine().setErrorMessage(msg);
            return false;
        }
        return true;
    }

    public boolean verify(boolean doSave) {
        String duplicate;
        this.ignoreEvents = true;
        this.getMessageLine().clearErrorMessage();
        SystemFilterStringEditPane editpane = this.getFilterStringEditPane(this.getShell());
        if (editpane.canSaveImplicitly() && this.sm.isSaveRequired()) {
            if (editpane.verify() != null) {
                this.ignoreEvents = false;
                this.sm.setChangesMade();
                return false;
            }
            if (doSave) {
                this.saveFilterString(editpane.getFilterString(), editpane.getCurrentSelectionIndex());
            }
        } else if (!this.sm.getNewSetByDelete() && editpane.verify() != null) {
            this.ignoreEvents = false;
            return false;
        }
        this.ignoreEvents = false;
        if (!this.allowDuplicateStrings && this.listView != null && (duplicate = this.checkForDuplicates()) != null) {
            SystemMessage errMsg = RSEUIPlugin.getPluginMessage("RSEG1048").makeSubstitution((Object)duplicate);
            this.getMessageLine().setErrorMessage(errMsg);
            this.listView.setFocus();
            return false;
        }
        return true;
    }

    public boolean processCancel() {
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.resetting) {
            return;
        }
        Widget source = e.widget;
        if (source == this.applyButton) {
            this.getMessageLine().clearMessage();
            this.applyPressed();
        } else if (source == this.revertButton) {
            this.getMessageLine().clearMessage();
            this.revertPressed();
        } else if (source == this.testButton) {
            this.getMessageLine().clearMessage();
            this.getFilterStringEditPane(this.getShell()).processTest(this.getShell());
        } else if (source == this.listView) {
            if (this.getFilterStringEditPane(this.getShell()).areErrorsPending()) {
                e.doit = false;
                this.resetting = true;
                this.listView.select(this.getFilterStringEditPane(this.getShell()).getCurrentSelectionIndex());
                this.resetting = false;
                return;
            }
            if (this.getFilterStringEditPane(this.getShell()).canSaveImplicitly() && this.sm.isSaveRequired()) {
                this.getMessageLine().clearMessage();
                this.applyPressed();
                if (this.getMessageLine().getErrorMessage() != null) {
                    e.doit = false;
                    this.sm.setChangesMade();
                    this.resetting = true;
                    this.listView.select(this.getFilterStringEditPane(this.getShell()).getCurrentSelectionIndex());
                    this.resetting = false;
                    this.applyButton.setEnabled(false);
                    return;
                }
            } else {
                this.getMessageLine().clearMessage();
            }
            this.processListSelect();
            if (this.isNewSelected()) {
                this.handleNewFilterStringItemSelection();
            }
        }
    }

    private void processListSelect() {
        Control c;
        this.sm.setNewSetByDelete(false);
        int newIndex = this.listView.getSelectionIndex();
        if (this.isNewSelected() || newIndex == -1) {
            SystemFilterStringEditPane editpane = this.getFilterStringEditPane(this.getShell());
            editpane.setFilterString(null, 0);
            if (this.isNewSelected()) {
                this.sm.setNewMode();
            } else {
                this.sm.setUnsetMode();
            }
            if (this.testButton != null) {
                this.testButton.setEnabled(false);
            }
        } else {
            this.getFilterStringEditPane(this.getShell()).setFilterString(this.getCurrentSelection(), newIndex);
            this.sm.setEditMode();
            if (this.testButton != null) {
                this.testButton.setEnabled(true);
            }
        }
        this.getFilterStringEditPane(this.getShell()).configureHeadingLabel(this.fsLabel);
        if (this.giveEditorFocus && (c = this.getFilterStringEditPane(this.getShell()).getInitialFocusControl()) != null && !c.isDisposed() && c.isVisible()) {
            c.setFocus();
        }
    }

    protected void applyPressed() {
        this.ignoreEvents = true;
        SystemFilterStringEditPane editpane = this.getFilterStringEditPane(this.getShell());
        if (editpane.verify() == null) {
            boolean ok = true;
            String editedFilterString = editpane.getFilterString();
            if (this.filterStringValidator != null) {
                SystemMessage errorMessage;
                String[] names;
                String[] stringArray = names = this.listView != null ? this.listView.getItems() : this.listItems;
                if (!this.allowDuplicateStrings && this.filterStringValidator instanceof ISystemValidatorUniqueString) {
                    ((ISystemValidatorUniqueString)((Object)this.filterStringValidator)).setExistingNamesList(names);
                }
                if ((errorMessage = this.filterStringValidator.validate(editedFilterString)) != null) {
                    ok = false;
                    this.getMessageLine().setErrorMessage(errorMessage);
                }
            }
            if (ok) {
                this.sm.applyPressed();
                this.saveFilterString(editedFilterString, editpane.getCurrentSelectionIndex());
            }
        }
        this.ignoreEvents = false;
    }

    protected void revertPressed() {
        boolean newMode;
        this.ignoreEvents = true;
        this.sm.resetPressed();
        boolean bl = newMode = this.isNewSelected() || this.listView == null || this.listView.getSelectionIndex() == -1;
        if (newMode) {
            this.getFilterStringEditPane(this.getShell()).setFilterString(null, 0);
        } else {
            this.getFilterStringEditPane(this.getShell()).setFilterString(this.getCurrentSelection(), this.listView.getSelectionIndex());
        }
        this.getMessageLine().clearErrorMessage();
        this.setPageComplete(true);
        if (this.testButton != null) {
            this.testButton.setEnabled(!newMode);
        }
        this.ignoreEvents = false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setPageComplete(boolean complete) {
        if (this.applyButton != null && !complete) {
            this.applyButton.setEnabled(false);
        }
        super.setPageComplete(complete);
    }

    protected boolean isNewSelected() {
        if (this.showingNew && this.listView != null) {
            return this.listView.getSelectionIndex() == 0;
        }
        return false;
    }

    protected String getCurrentSelection() {
        if (this.showingNew) {
            if (this.listView.getSelectionCount() >= 1) {
                return this.listView.getSelection()[0];
            }
            return null;
        }
        if (this.listView != null) {
            if (this.listView.getSelectionCount() >= 0) {
                return this.listView.getSelection()[0];
            }
            return null;
        }
        return this.listItems[0];
    }

    protected String createFilterString() {
        String newFilterString = this.getFilterStringEditPane(this.getShell()).getFilterString();
        this.listView.add(newFilterString);
        int selectionIndex = this.listView.getItemCount() - 1;
        this.listView.select(selectionIndex);
        this.sm.setEditMode();
        this.getFilterStringEditPane(this.getShell()).setFilterString(newFilterString, selectionIndex);
        this.getFilterStringEditPane(this.getShell()).configureHeadingLabel(this.fsLabel);
        return newFilterString;
    }

    protected void saveFilterString(String editedFilterString, int currSelectionIndex) {
        if (currSelectionIndex == -1) {
            return;
        }
        if (this.showingNew && currSelectionIndex == 0) {
            this.createFilterString();
        } else if (this.listView != null) {
            this.listView.setItem(currSelectionIndex, editedFilterString);
        } else {
            this.listItems[0] = editedFilterString;
        }
    }

    private ISystemFilter getSystemFilter(Object selectedObject) {
        if (selectedObject instanceof ISystemFilter) {
            return (ISystemFilter)selectedObject;
        }
        return ((ISystemFilterReference)selectedObject).getReferencedFilter();
    }

    public void filterStringChanged(SystemMessage message) {
        if (message != null) {
            this.getMessageLine().setErrorMessage(message);
        } else {
            this.getMessageLine().clearErrorMessage();
        }
        if (this.testButton != null) {
            this.testButton.setEnabled(message == null);
        }
        if (!this.ignoreEvents) {
            this.sm.setChangesMade();
        }
        this.setPageComplete(message == null);
    }

    public void backupChangedState() {
        this.sm.backup();
    }

    public void restoreChangedState() {
        this.sm.restore();
    }

    public void menuAboutToShow(IMenuManager menu) {
        Menu m;
        this.fillContextMenu(menu);
        if (!this.menuListenerAdded && menu instanceof MenuManager && (m = ((MenuManager)menu).getMenu()) != null) {
            this.menuListenerAdded = true;
            SystemViewMenuListener ml = new SystemViewMenuListener();
            m.addMenuListener((MenuListener)ml);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        String currentString = this.getCurrentSelection();
        StructuredSelection selection = null;
        if (currentString != null) {
            selection = new StructuredSelection((Object)currentString);
        }
        this.createStandardGroups(menu);
        SystemBaseAction action = null;
        boolean isNewSelected = this.isNewSelected();
        if (selection != null && !isNewSelected) {
            action = this.getDeleteAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getCopyAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getMoveUpAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
            action = this.getMoveDownAction((ISelection)selection);
            menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
        }
        action = this.getPasteAction((ISelection)selection);
        menu.appendToGroup(action.getContextMenuGroup(), (IAction)action);
    }

    public void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.reorder"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    private SystemChangeFilterActionDeleteString getDeleteAction(ISelection selection) {
        if (this.deleteAction == null) {
            this.deleteAction = new SystemChangeFilterActionDeleteString(this);
        }
        this.deleteAction.setShell(this.getShell());
        this.deleteAction.setSelection(selection);
        return this.deleteAction;
    }

    private SystemChangeFilterActionMoveStringUp getMoveUpAction(ISelection selection) {
        if (this.moveUpAction == null) {
            this.moveUpAction = new SystemChangeFilterActionMoveStringUp(this);
        }
        this.moveUpAction.setShell(this.getShell());
        this.moveUpAction.setSelection(selection);
        return this.moveUpAction;
    }

    private SystemChangeFilterActionMoveStringDown getMoveDownAction(ISelection selection) {
        if (this.moveDownAction == null) {
            this.moveDownAction = new SystemChangeFilterActionMoveStringDown(this);
        }
        this.moveDownAction.setShell(this.getShell());
        this.moveDownAction.setSelection(selection);
        return this.moveDownAction;
    }

    private SystemChangeFilterActionCopyString getCopyAction(ISelection selection) {
        if (this.copyAction == null) {
            this.copyAction = new SystemChangeFilterActionCopyString(this);
        }
        this.copyAction.setShell(this.getShell());
        this.copyAction.setSelection(selection);
        return this.copyAction;
    }

    private SystemChangeFilterActionPasteString getPasteAction(ISelection selection) {
        if (this.pasteAction == null) {
            this.pasteAction = new SystemChangeFilterActionPasteString(this);
        }
        this.pasteAction.setShell(this.getShell());
        if (selection != null) {
            this.pasteAction.setSelection(selection);
        }
        return this.pasteAction;
    }

    public boolean canDelete() {
        return this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1 && this.listView.getItemCount() > 2;
    }

    public void doDelete() {
        int idx = this.listView.getSelectionIndex();
        SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEG1052");
        SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), msg);
        try {
            if (msgDlg.openQuestion()) {
                this.listView.remove(idx);
                this.listView.select(0);
                this.processListSelect();
                this.sm.setNewSetByDelete(true);
                boolean ok = this.verify(false);
                this.setPageComplete(ok);
                if (ok && this.isNewSelected()) {
                    this.handleNewFilterStringItemSelection();
                }
            }
        }
        catch (Exception exception) {}
    }

    protected void handleNewFilterStringItemSelection() {
        this.ignoreEvents = true;
        SystemFilterStringEditPane editpane = this.getFilterStringEditPane(this.getShell());
        boolean anyErrors = editpane.areErrorsPending();
        if (!anyErrors) {
            boolean result;
            boolean bl = result = editpane.verify() == null;
            if (result) {
                this.applyButton.setEnabled(true);
            } else {
                editpane.clearErrorsPending();
                this.getMessageLine().clearErrorMessage();
            }
        }
        this.setPageComplete(true);
        this.ignoreEvents = false;
    }

    public boolean canMoveUp() {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1;
        if (can) {
            int idx = this.listView.getSelectionIndex();
            can = idx > 1;
        }
        return can;
    }

    public void doMoveUp() {
        int idx = this.listView.getSelectionIndex();
        String currentString = this.getCurrentSelection();
        this.listView.remove(idx);
        this.listView.add(currentString, idx - 1);
    }

    public boolean canMoveDown() {
        boolean can;
        boolean bl = can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1;
        if (can) {
            int idx = this.listView.getSelectionIndex();
            can = idx <= this.listView.getItemCount() - 2;
        }
        return can;
    }

    public void doMoveDown() {
        int idx = this.listView.getSelectionIndex();
        String currentString = this.getCurrentSelection();
        this.listView.remove(idx);
        this.listView.add(currentString, idx + 1);
    }

    public boolean canCopy() {
        boolean can = this.sm.getMode() == 8 && !this.sm.areChangesPending() && !this.isNewSelected() && this.listView.getSelectionIndex() != -1;
        return can;
    }

    public void doCopy() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        String selection = this.getCurrentSelection();
        TextTransfer transfer = TextTransfer.getInstance();
        clipboard.setContents(new Object[]{selection}, new Transfer[]{transfer});
        clipboard.dispose();
    }

    public boolean canPaste() {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)clipboard.getContents((Transfer)textTransfer);
        clipboard.dispose();
        return textData != null && textData.length() > 0;
    }

    public void doPaste() {
        Clipboard clipboard = SystemRegistryUI.getInstance().getSystemClipboard();
        TextTransfer textTransfer = TextTransfer.getInstance();
        String textData = (String)clipboard.getContents((Transfer)textTransfer);
        String newCopy = new String(textData);
        int newLocation = this.listView.getSelectionIndex();
        if (newLocation <= 0) {
            this.listView.add(newCopy);
            newLocation = this.listView.getItemCount() - 1;
            this.listView.select(newLocation);
        } else {
            this.listView.add(newCopy, newLocation);
            this.listView.select(newLocation);
        }
        this.processListSelect();
        this.setPageComplete(this.verify(false));
        clipboard.dispose();
    }

    protected String checkForDuplicates() {
        if (this.listView == null) {
            return null;
        }
        String[] strings = this.listView != null ? this.listView.getItems() : this.listItems;
        String duplicate = null;
        boolean noDupes = true;
        int idx = 1;
        while (noDupes && idx < strings.length) {
            int ydx = 1;
            while (noDupes && ydx < strings.length) {
                if (idx != ydx && this.compareFilterStrings(this.caseSensitiveStrings, strings[idx], strings[ydx])) {
                    noDupes = false;
                    duplicate = strings[idx];
                }
                ++ydx;
            }
            ++idx;
        }
        return duplicate;
    }

    public boolean compareFilterStrings(boolean caseSensitive, String filterString1, String filterString2) {
        boolean cs = caseSensitive;
        if (cs) {
            return filterString1.equals(filterString2);
        }
        return filterString1.equalsIgnoreCase(filterString2);
    }
}

