/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.propertypages;

import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.rse.ui.ISystemMassager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SystemComboBoxFieldEditor
extends FieldEditor {
    private Combo textField;
    private String[] contentArray;
    private boolean contentInited = false;
    private boolean readOnly = true;
    private boolean isValid = true;
    private String tip;
    private SelectionListener selectionListener = null;
    private ModifyListener modifyListener = null;
    private boolean ignoreSelection = false;
    private ISystemValidator validator = null;
    private ISystemMassager massager = null;
    private Composite parentComposite;
    private String oldValue;
    private int numColumnsInParentComposite;

    private SystemComboBoxFieldEditor() {
    }

    public SystemComboBoxFieldEditor(String name, String labelText, Vector contents, boolean readOnly, Composite parent) {
        super(name, labelText, parent);
        this.readOnly = readOnly;
        this.oldValue = "";
        this.contentArray = new String[contents.size()];
        int idx = 0;
        while (idx < this.contentArray.length) {
            this.contentArray[idx] = contents.elementAt(idx).toString();
            ++idx;
        }
        this.doOurFillIntoGrid();
        this.initContents();
    }

    public SystemComboBoxFieldEditor(String name, String labelText, String[] contents, boolean readOnly, Composite parent) {
        super(name, labelText, parent);
        this.readOnly = readOnly;
        this.oldValue = "";
        this.contentArray = contents;
        this.doOurFillIntoGrid();
        this.initContents();
    }

    public SystemComboBoxFieldEditor(String name, ResourceBundle rb, String rbKey, String[] contents, boolean readOnly, Composite parent) {
        super(name, rb.getString(String.valueOf(rbKey) + "label"), parent);
        this.readOnly = readOnly;
        this.oldValue = "";
        this.contentArray = contents;
        this.doOurFillIntoGrid();
        this.setToolTipText(rb.getString(String.valueOf(rbKey) + "tooltip"));
        this.initContents();
    }

    public void setValidator(ISystemValidator validator) {
        this.validator = validator;
        if (this.textField != null) {
            this.textField.setTextLimit(validator.getMaximumNameLength());
        }
    }

    public void setMassager(ISystemMassager massager) {
        this.massager = massager;
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected void doStore() {
        String text = this.textField.getText();
        if (this.massager != null) {
            text = this.massager.massage(text);
            this.ignoreSelection = true;
            this.textField.setText(text);
            this.ignoreSelection = false;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), text);
    }

    protected void doLoadDefault() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this.initSelection(value);
        }
    }

    protected void doLoad() {
        if (this.textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.initSelection(value);
        }
    }

    private void initSelection(String value) {
        if (value != null) {
            this.ignoreSelection = true;
            this.textField.setText(value);
            this.oldValue = value;
            this.ignoreSelection = false;
        } else {
            this.oldValue = "";
        }
    }

    private void initContents() {
        if (this.contentArray != null && this.textField != null && !this.contentInited) {
            this.textField.setItems(this.contentArray);
            this.contentInited = true;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.parentComposite = parent;
        this.numColumnsInParentComposite = numColumns;
    }

    protected void doOurFillIntoGrid() {
        this.getLabelControl(this.parentComposite);
        this.textField = this.getTextControl(this.parentComposite);
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = this.numColumnsInParentComposite - 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textField.setLayoutData((Object)gd);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    public Combo getTextControl() {
        return this.textField;
    }

    public Combo getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = this.isReadOnly() ? SystemWidgetHelpers.createReadonlyCombo(parent, null) : SystemWidgetHelpers.createCombo(parent, null);
            if (this.tip != null) {
                this.textField.setToolTipText(this.tip);
            }
            this.initContents();
            this.textField.addSelectionListener(this.getSelectionListener());
            if (!this.isReadOnly()) {
                this.textField.addModifyListener(this.getModifyListener());
                if (this.validator != null) {
                    this.textField.setTextLimit(this.validator.getMaximumNameLength());
                }
                this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusGained(FocusEvent e) {
                        SystemComboBoxFieldEditor.this.refreshValidState();
                    }

                    public void focusLost(FocusEvent e) {
                        SystemComboBoxFieldEditor.this.clearErrorMessage();
                    }
                });
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    SystemComboBoxFieldEditor.this.textField = null;
                }
            });
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    public void setToolTipText(String tip) {
        if (this.textField != null) {
            this.textField.setToolTipText(tip);
        }
        this.tip = tip;
    }

    protected boolean isReadOnly() {
        return this.readOnly;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == SystemComboBoxFieldEditor.this.textField) {
                    SystemComboBoxFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void selectionChanged() {
        if (!this.ignoreSelection) {
            this.setPresentsDefaultValue(false);
        }
        this.ignoreSelection = false;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.createModifyListener();
        }
        return this.modifyListener;
    }

    protected void createModifyListener() {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Widget widget = event.widget;
                if (widget == SystemComboBoxFieldEditor.this.textField && !SystemComboBoxFieldEditor.this.ignoreSelection) {
                    SystemComboBoxFieldEditor.this.valueChanged();
                }
            }
        };
    }

    protected void validate() {
        if (!this.ignoreSelection) {
            this.setPresentsDefaultValue(false);
            if (this.validator != null) {
                String errmsg = null;
                String value = this.textField.getText();
                if (!this.isSpecialValue(value)) {
                    errmsg = this.validator.isValid(value);
                }
                if (errmsg != null) {
                    this.showErrorMessage(errmsg);
                } else {
                    this.clearErrorMessage();
                }
                this.isValid = errmsg == null;
            }
        }
        this.ignoreSelection = false;
    }

    private boolean isSpecialValue(String input) {
        if (this.contentArray == null) {
            return false;
        }
        boolean match = false;
        int idx = 0;
        while (!match && idx < this.contentArray.length) {
            if (input.equalsIgnoreCase(this.contentArray[idx])) {
                match = true;
            }
            ++idx;
        }
        return match;
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        String newValue = this.textField.getText();
        this.fireValueChanged("field_editor_value", this.oldValue, newValue);
        this.oldValue = newValue;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = true;
        if (!this.isReadOnly()) {
            this.validate();
        }
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setFocus();
        }
    }
}

