/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TmfAnalysisRequirement {
    public static final String TYPE_EVENT = "event";
    private final String fType;
    private final Map<String, ValuePriorityLevel> fValues = new HashMap<String, ValuePriorityLevel>();
    private final Set<String> fInformation = new HashSet<String>();

    public TmfAnalysisRequirement(String type) {
        this.fType = type;
    }

    public TmfAnalysisRequirement(String type, Iterable<String> values, ValuePriorityLevel level) {
        this.fType = type;
        this.addValues(values, level);
    }

    public Boolean merge(TmfAnalysisRequirement subRequirement, ValuePriorityLevel maxSubRequirementValueLevel) {
        if (!this.isSameType(subRequirement).booleanValue()) {
            return false;
        }
        Set<String> values = subRequirement.getValues();
        for (String value : values) {
            int minLevel = Math.min(subRequirement.getValueLevel(value).ordinal(), maxSubRequirementValueLevel.ordinal());
            ValuePriorityLevel subRequirementValueLevel = ValuePriorityLevel.values()[minLevel];
            if (this.fValues.containsKey(value)) {
                ValuePriorityLevel requirementValueLevel = this.getValueLevel(value);
                int newValueLevel = Math.max(requirementValueLevel.ordinal(), subRequirementValueLevel.ordinal());
                ValuePriorityLevel highestLevel = ValuePriorityLevel.values()[newValueLevel];
                this.addValue(value, highestLevel);
                continue;
            }
            this.addValue(value, subRequirementValueLevel);
        }
        this.fInformation.addAll(subRequirement.getInformation());
        return true;
    }

    public void addValues(Iterable<String> values, ValuePriorityLevel level) {
        for (String value : values) {
            this.addValue(value, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(String value, ValuePriorityLevel level) {
        Map<String, ValuePriorityLevel> map = this.fValues;
        synchronized (map) {
            this.fValues.put(value, level);
        }
    }

    public void addInformation(String information) {
        this.fInformation.add(information);
    }

    public Boolean isSameType(TmfAnalysisRequirement requirement) {
        return this.fType.equals(requirement.getType());
    }

    public String getType() {
        return this.fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getValues() {
        Map<String, ValuePriorityLevel> map = this.fValues;
        synchronized (map) {
            return this.fValues.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getValues(ValuePriorityLevel level) {
        Map<String, ValuePriorityLevel> map = this.fValues;
        synchronized (map) {
            HashSet<String> values = new HashSet<String>();
            for (Map.Entry<String, ValuePriorityLevel> entry : this.fValues.entrySet()) {
                if (entry.getValue() != level) continue;
                values.add(entry.getKey());
            }
            return values;
        }
    }

    public Set<String> getInformation() {
        return this.fInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValuePriorityLevel getValueLevel(String value) {
        Map<String, ValuePriorityLevel> map = this.fValues;
        synchronized (map) {
            return this.fValues.get(value);
        }
    }

    public boolean isFulfilled(@NonNull ITmfTrace trace) {
        switch (this.fType) {
            case "event": {
                if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) break;
                Set<String> traceEvents = TmfEventTypeCollectionHelper.getEventNames(((ITmfTraceWithPreDefinedEvents)((Object)trace)).getContainedEventTypes());
                Set<String> mandatoryValues = this.getValues(ValuePriorityLevel.MANDATORY);
                return traceEvents.containsAll(mandatoryValues);
            }
            default: {
                return true;
            }
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.fType) + ": " + this.fValues;
    }

    public static enum ValuePriorityLevel {
        OPTIONAL,
        MANDATORY;

    }
}

