/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.floatingpoint;

import java.math.BigInteger;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPAbstractPane;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.FPRenderingMessages;
import org.eclipse.cdt.debug.ui.memory.floatingpoint.Rendering;
import org.eclipse.debug.core.DebugException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class FPAddressPane
extends FPAbstractPane {
    final int bytesPerColumn;

    public FPAddressPane(Rendering parent) {
        super(parent);
        this.bytesPerColumn = this.fRendering.getFPDataType().getByteLength();
    }

    @Override
    protected BigInteger getViewportAddress(int col, int row) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        address = address.add(BigInteger.valueOf((row * this.fRendering.getColumnCount() + col) * this.fRendering.getFPDataType().getByteLength()));
        return address;
    }

    @Override
    protected void appendSelection(int x, int y) {
        try {
            if (this.fSelectionStartAddress == null) {
                return;
            }
            BigInteger address = this.getViewportAddress(x / this.getCellWidth(), y / this.getCellHeight());
            if (address.compareTo(this.fSelectionStartAddress) == 0) {
                this.fRendering.getSelection().setEnd(null, null);
            } else {
                this.fRendering.getSelection().setEnd(address.add(BigInteger.valueOf(this.fRendering.getFPDataType().getByteLength() * this.fRendering.getColumnCount())), address);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_APPEND_SELECTION"), e);
        }
    }

    public Point computeSize(int wHint, int hHint) {
        return new Point(this.getCellWidth() + this.fRendering.getRenderSpacing(), 100);
    }

    @Override
    protected int getCellCharacterCount() {
        return this.fRendering.getAddressBytes() * 2 + 2;
    }

    @Override
    protected int getCellWidth() {
        GC gc = new GC((Drawable)this);
        StringBuffer buf = new StringBuffer();
        int index = 0;
        while (index < this.getCellCharacterCount()) {
            buf.append("0");
            ++index;
        }
        int width = gc.textExtent((String)buf.toString()).x;
        gc.dispose();
        return width;
    }

    private int getColumnCount() {
        return 0;
    }

    private BigInteger getCellAddressAt(int x, int y) throws DebugException {
        BigInteger address = this.fRendering.getViewportStartAddress();
        int col = x / this.getCellWidth();
        int row = y / this.getCellHeight();
        if (col > this.getColumnCount()) {
            return null;
        }
        address = address.add(BigInteger.valueOf(row * this.fRendering.getColumnCount() * this.fRendering.getAddressesPerColumn() / this.fRendering.getBytesPerCharacter()));
        address = address.add(BigInteger.valueOf(col * this.fRendering.getAddressesPerColumn()));
        return address;
    }

    @Override
    protected Point getCellLocation(BigInteger cellAddress) {
        try {
            BigInteger address = this.fRendering.getViewportStartAddress();
            int cellOffset = cellAddress.subtract(address).intValue();
            cellOffset *= this.fRendering.getAddressableSize();
            if (this.fRendering.getColumnCount() == 0) {
                return new Point(0, 0);
            }
            int row = cellOffset / (this.fRendering.getColumnCount() * this.fRendering.getCharsPerColumn() / this.fRendering.getBytesPerCharacter());
            int col = (cellOffset -= row * this.fRendering.getColumnCount() * this.fRendering.getCharsPerColumn() / this.fRendering.getBytesPerCharacter()) / this.fRendering.getCharsPerColumn() / this.fRendering.getBytesPerCharacter();
            int x = col * this.getCellWidth() + this.fRendering.getCellPadding();
            int y = row * this.getCellHeight() + this.fRendering.getCellPadding();
            return new Point(x, y);
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_DETERMINE_CELL_LOCATION"), e);
            return null;
        }
    }

    @Override
    protected int getNumberOfBytesRepresentedByColumn() {
        return this.fRendering.getBytesPerRow();
    }

    @Override
    protected void positionCaret(int x, int y) {
        try {
            BigInteger cellAddress = this.getCellAddressAt(x, y);
            if (cellAddress != null) {
                Point cellPosition = this.getCellLocation(cellAddress);
                int offset = x - cellPosition.x;
                int x2 = offset / this.getCellCharacterWidth();
                if (x2 >= this.getCellCharacterCount()) {
                    cellAddress = cellAddress.add(BigInteger.valueOf(this.getNumberOfBytesRepresentedByColumn()));
                    x2 = 0;
                    cellPosition = this.getCellLocation(cellAddress);
                }
                this.fCaret.setLocation(cellPosition.x + x2 * this.getCellCharacterWidth(), cellPosition.y);
                this.fCaretAddress = cellAddress;
                this.fSubCellCaretPosition = x2;
                this.setCaretAddress(this.fCaretAddress);
            }
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_POSITION_CURSOR"), e);
        }
    }

    @Override
    protected void paint(PaintEvent pe) {
        super.paint(pe);
        GC gc = pe.gc;
        FontMetrics fontMetrics = gc.getFontMetrics();
        int textHeight = fontMetrics.getHeight();
        int cellHeight = textHeight + this.fRendering.getCellPadding() * 2;
        int memBytesPerCol = this.fRendering.getFPDataType().getByteLength();
        try {
            BigInteger start = this.fRendering.getViewportStartAddress();
            int index = 0;
            while (index < this.getBounds().height / cellHeight) {
                BigInteger memAddress = start.add(BigInteger.valueOf(index * this.fRendering.getColumnCount() * memBytesPerCol));
                gc.setForeground(this.fRendering.getFPRendering().getColorText());
                if (this.fRendering.getSelection().isSelected(memAddress)) {
                    gc.setBackground(this.fRendering.getFPRendering().getColorSelection());
                    gc.fillRectangle(this.fRendering.getCellPadding() * 2, cellHeight * index, this.getCellWidth(), cellHeight);
                    gc.setForeground(this.fRendering.getFPRendering().getColorBackground());
                } else {
                    gc.setBackground(this.fRendering.getFPRendering().getColorBackground());
                    gc.fillRectangle(this.fRendering.getCellPadding() * 2, cellHeight * index, this.getCellWidth(), cellHeight);
                    this.applyCustomColor(gc);
                }
                gc.drawText(this.fRendering.getAddressString(memAddress), this.fRendering.getCellPadding() * 2, cellHeight * index + this.fRendering.getCellPadding());
                ++index;
            }
        }
        catch (Exception e) {
            this.fRendering.logError(FPRenderingMessages.getString("FPRendering.FAILURE_PAINT"), e);
        }
    }

    protected void applyCustomColor(GC gc) {
        gc.setForeground(this.fRendering.getFPRendering().getColorText());
    }
}

