/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.persistence.IRSEImportExportProvider;
import org.eclipse.rse.internal.persistence.dom.RSEDOMExporter;
import org.eclipse.rse.internal.persistence.dom.RSEDOMImporter;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.services.Mutex;

public class RSEPersistenceManager
implements IRSEPersistenceManager {
    private Map knownProviders = new HashMap(10);
    private Map loadedProviders = new HashMap(10);
    private Set saveJobs = new HashSet(10);
    private RSEDOMExporter _exporter;
    private RSEDOMImporter _importer;
    private RSESaveParticipant saveParticipant = new RSESaveParticipant();
    private RSESaveJobChangeListener jobChangeListener = new RSESaveJobChangeListener();
    private Mutex mutex = new Mutex();
    private volatile boolean canScheduleSave = true;

    public RSEPersistenceManager(ISystemRegistry registry) {
        this._exporter = RSEDOMExporter.getInstance();
        this._importer = RSEDOMImporter.getInstance();
        this._importer.setSystemRegistry(registry);
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)RSECorePlugin.getDefault(), (ISaveParticipant)this.saveParticipant);
        }
        catch (CoreException e) {
            RSECorePlugin.getDefault().getLogger().logError("Could not register save participant.", e);
        }
        this.getProviderExtensions();
    }

    public boolean isBusy() {
        return this.mutex.isLocked();
    }

    public void registerPersistenceProvider(String id, IRSEPersistenceProvider provider) {
        ProviderRecord pr = this.getProviderRecord(id);
        if (provider instanceof IRSEImportExportProvider) {
            IRSEImportExportProvider ieProvider = (IRSEImportExportProvider)((Object)provider);
            ieProvider.setId(id);
        }
        pr.provider = provider;
        this.loadedProviders.put(provider, id);
    }

    public IRSEPersistenceProvider getPersistenceProvider(String id) {
        ProviderRecord pr = this.getProviderRecord(id);
        if (pr.provider == null) {
            IRSEPersistenceProvider provider = this.loadProvider(pr.configurationElement);
            this.registerPersistenceProvider(id, provider);
        }
        return pr.provider;
    }

    public String[] getPersistenceProviderIds() {
        Set ids = this.knownProviders.keySet();
        String[] result = new String[ids.size()];
        ids.toArray(result);
        return result;
    }

    public boolean commitProfile(ISystemProfile profile, long timeout) {
        boolean result = false;
        result = this.save(profile, true, timeout);
        return result;
    }

    public ISystemProfile[] commitProfiles(long timeout) {
        ArrayList<ISystemProfile> failed = new ArrayList<ISystemProfile>(10);
        ISystemProfile[] profiles = RSECorePlugin.getTheSystemRegistry().getSystemProfileManager().getSystemProfiles();
        int idx = 0;
        while (idx < profiles.length) {
            ISystemProfile profile = profiles[idx];
            try {
                boolean ok = this.commitProfile(profile, timeout);
                if (!ok) {
                    failed.add(profile);
                }
            }
            catch (Exception exc) {
                Logger logger = RSECorePlugin.getDefault().getLogger();
                String profileName = profile.getName();
                String message = "Error saving profile " + profileName;
                logger.logError(message, exc);
                failed.add(profile);
            }
            ++idx;
        }
        ISystemProfile[] result = new ISystemProfile[failed.size()];
        failed.toArray(result);
        return result;
    }

    public void migrateProfile(ISystemProfile profile, IRSEPersistenceProvider persistenceProvider) {
        this.migrateProfile(profile, persistenceProvider, true);
    }

    public IStatus migrateProfile(ISystemProfile profile, IRSEPersistenceProvider persistenceProvider, boolean delete) {
        IStatus result = Status.OK_STATUS;
        IRSEPersistenceProvider oldProvider = profile.getPersistenceProvider();
        oldProvider = oldProvider == null ? this.getDefaultPersistenceProvider() : oldProvider;
        IRSEPersistenceProvider newProvider = persistenceProvider;
        IRSEPersistenceProvider iRSEPersistenceProvider = newProvider = newProvider == null ? this.getDefaultPersistenceProvider() : newProvider;
        if (oldProvider != newProvider) {
            String profileName = profile.getName();
            profile.setPersistenceProvider(newProvider);
            profile.commit();
            if (delete) {
                this.deleteProfile(oldProvider, profileName);
            } else {
                result = oldProvider.setMigrationMark(profileName, true);
            }
        }
        return result;
    }

    public void deleteProfile(final IRSEPersistenceProvider persistenceProvider, final String profileName) {
        Job job = new Job(RSECoreMessages.RSEPersistenceManager_DeleteProfileJobName){

            protected IStatus run(IProgressMonitor monitor) {
                IRSEPersistenceProvider p = persistenceProvider != null ? persistenceProvider : RSEPersistenceManager.this.getDefaultPersistenceProvider();
                IStatus result = p.deleteProfile(profileName, monitor);
                return result;
            }
        };
        job.schedule();
    }

    public ISystemProfile[] restoreProfiles(long timeout) {
        ProviderRecord pr;
        String[] ids = this.getPersistenceProviderIds();
        ArrayList<ProviderRecord> selectedRecords = new ArrayList<ProviderRecord>(10);
        int i = 0;
        while (i < ids.length) {
            IRSEPersistenceProvider provider;
            String id = ids[i];
            pr = this.getProviderRecord(id);
            if (pr.isAutostart() && (provider = this.getPersistenceProvider(id)) != null) {
                pr.setRestored(false);
                selectedRecords.add(pr);
            }
            ++i;
        }
        ArrayList<ISystemProfile> profiles = new ArrayList<ISystemProfile>(10);
        Iterator z = selectedRecords.iterator();
        while (z.hasNext()) {
            pr = (ProviderRecord)z.next();
            ISystemProfile[] providerProfiles = this.restoreProfiles(pr.provider, timeout);
            profiles.addAll(Arrays.asList(providerProfiles));
        }
        ISystemProfile[] result = new ISystemProfile[profiles.size()];
        profiles.toArray(result);
        return result;
    }

    public ISystemProfile[] restoreProfiles(IRSEPersistenceProvider provider, long timeout) {
        ProviderRecord pr = this.getProviderRecord(provider);
        pr.setRestored(false);
        List profiles = this.loadProfiles(provider, timeout);
        pr.setRestored(true);
        ISystemProfile[] result = new ISystemProfile[profiles.size()];
        profiles.toArray(result);
        return result;
    }

    public boolean isRestoreComplete() {
        boolean isComplete = true;
        String[] ids = this.getPersistenceProviderIds();
        int i = 0;
        while (i < ids.length && isComplete) {
            String id = ids[i];
            ProviderRecord pr = this.getProviderRecord(id);
            if (pr.isAutostart()) {
                isComplete = isComplete && pr.isRestored();
            }
            ++i;
        }
        return isComplete;
    }

    private ProviderRecord getProviderRecord(String providerId) {
        ProviderRecord providerRecord = (ProviderRecord)this.knownProviders.get(providerId);
        if (providerRecord == null) {
            providerRecord = new ProviderRecord();
            this.knownProviders.put(providerId, providerRecord);
        }
        return providerRecord;
    }

    private ProviderRecord getProviderRecord(IRSEPersistenceProvider provider) {
        ProviderRecord pr = null;
        String id = (String)this.loadedProviders.get(provider);
        pr = id != null ? this.getProviderRecord(id) : new ProviderRecord();
        return pr;
    }

    private void getProviderExtensions() {
        Logger logger = RSECorePlugin.getDefault().getLogger();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] providerCandidates = registry.getConfigurationElementsFor("org.eclipse.rse.core", "persistenceProviders");
        int j = 0;
        while (j < providerCandidates.length) {
            IConfigurationElement configurationElement = providerCandidates[j];
            if (configurationElement.getName().equals("persistenceProvider")) {
                String candidateId = configurationElement.getAttribute("id");
                if (candidateId != null) {
                    ProviderRecord pr = this.getProviderRecord(candidateId);
                    pr.configurationElement = configurationElement;
                    pr.providerId = candidateId;
                } else {
                    logger.logError("Missing id attribute in persistenceProvider element", null);
                }
            } else {
                logger.logError("Invalid element in persistenceProviders extension point", null);
            }
            ++j;
        }
    }

    private IRSEPersistenceProvider loadProvider(IConfigurationElement configurationElement) {
        IRSEPersistenceProvider provider = null;
        try {
            provider = (IRSEPersistenceProvider)configurationElement.createExecutableExtension("class");
            Properties properties = new Properties();
            IConfigurationElement[] children = configurationElement.getChildren("property");
            int i = 0;
            while (i < children.length) {
                IConfigurationElement child = children[i];
                String name = child.getAttribute("name");
                String value = child.getAttribute("value");
                properties.put(name, value);
                ++i;
            }
            provider.setProperties(properties);
        }
        catch (CoreException e) {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logError("Exception loading persistence provider", e);
        }
        return provider;
    }

    private IRSEPersistenceProvider getDefaultPersistenceProvider() {
        String providerId = this.getDefaultPersistenceProviderId();
        IRSEPersistenceProvider provider = this.getPersistenceProvider(providerId);
        return provider;
    }

    private String getDefaultPersistenceProviderId() {
        IPreferencesService ps = Platform.getPreferencesService();
        String providerId = ps.getString("org.eclipse.rse.core", "DEFAULT_PERSISTENCE_PROVIDER", "", null);
        return providerId;
    }

    private List loadProfiles(IRSEPersistenceProvider persistenceProvider, long timeout) {
        ArrayList<ISystemProfile> profiles = new ArrayList<ISystemProfile>(10);
        String[] profileNames = persistenceProvider.getSavedProfileNames();
        int i = 0;
        while (i < profileNames.length) {
            String profileName = profileNames[i];
            ISystemProfile profile = this.load(persistenceProvider, profileName, timeout);
            if (profile != null) {
                profiles.add(profile);
            }
            ++i;
        }
        return profiles;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ISystemProfile load(IRSEPersistenceProvider provider, String profileName, long timeout) {
        ISystemProfile profile = null;
        if (!this.mutex.waitForLock(null, timeout)) return profile;
        try {
            RSEDOM dom = provider.loadRSEDOM(profileName, (IProgressMonitor)new NullProgressMonitor());
            if (dom != null && (profile = this._importer.restoreProfile(dom)) != null) {
                profile.setPersistenceProvider(provider);
                this.cleanTree(profile);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mutex.release();
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        this.mutex.release();
        return profile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(ISystemProfile profile, boolean force, long timeout) {
        boolean result = false;
        if (!this.mutex.waitForLock(null, timeout)) return result;
        try {
            IRSEPersistenceProvider provider = profile.getPersistenceProvider();
            if (provider == null) {
                provider = this.getDefaultPersistenceProvider();
                profile.setPersistenceProvider(provider);
            }
            RSEDOM dom = this._exporter.createRSEDOM(profile, force);
            this.cleanTree(profile);
            if (dom.needsSave()) {
                Job job = provider.getSaveJob(dom);
                if (job != null && this.canScheduleSave && timeout > 0L) {
                    job.addJobChangeListener((IJobChangeListener)this.jobChangeListener);
                    job.schedule(2000L);
                } else {
                    provider.saveRSEDOM(dom, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            result = true;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.mutex.release();
            throw throwable;
        }
        {
            Object var9_10 = null;
        }
        this.mutex.release();
        return result;
    }

    private void cleanTree(IRSEPersistableContainer node) {
        node.setWasRestored(true);
        node.setTainted(false);
        node.setDirty(false);
        IRSEPersistableContainer[] children = node.getPersistableChildren();
        int i = 0;
        while (i < children.length) {
            IRSEPersistableContainer child = children[i];
            this.cleanTree(child);
            ++i;
        }
    }

    private class ProviderRecord {
        private String providerId = null;
        private IConfigurationElement configurationElement = null;
        private IRSEPersistenceProvider provider = null;
        private boolean restored = false;

        private ProviderRecord() {
        }

        synchronized boolean isRestored() {
            return this.restored;
        }

        synchronized void setRestored(boolean restored) {
            this.restored = restored;
        }

        boolean isAutostart() {
            boolean isAutostart = this.configurationElement != null && "true".equals(this.configurationElement.getAttribute("autostart"));
            boolean isDefault = this.providerId.equals(RSEPersistenceManager.this.getDefaultPersistenceProviderId());
            return isAutostart || isDefault;
        }
    }

    private class RSESaveJobChangeListener
    implements IJobChangeListener {
        private RSESaveJobChangeListener() {
        }

        public void aboutToRun(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            Set set = RSEPersistenceManager.this.saveJobs;
            synchronized (set) {
                RSEPersistenceManager.this.saveJobs.remove(event.getJob());
            }
        }

        public void running(IJobChangeEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduled(IJobChangeEvent event) {
            Set set = RSEPersistenceManager.this.saveJobs;
            synchronized (set) {
                RSEPersistenceManager.this.saveJobs.add(event.getJob());
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }
    }

    private class RSESaveParticipant
    implements ISaveParticipant {
        public void doneSaving(ISaveContext context) {
            RSEPersistenceManager.this.canScheduleSave = true;
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
            RSEPersistenceManager.this.canScheduleSave = false;
        }

        public void rollback(ISaveContext context) {
            RSEPersistenceManager.this.canScheduleSave = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saving(ISaveContext context) throws CoreException {
            ArrayList jobs = new ArrayList(10);
            Set set = RSEPersistenceManager.this.saveJobs;
            synchronized (set) {
                jobs.addAll(RSEPersistenceManager.this.saveJobs);
            }
            Iterator z = jobs.iterator();
            while (z.hasNext()) {
                Job job = (Job)z.next();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

