/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ClientNotifyInformation;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.ProgressEvent;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.BlameCallback;
import org.apache.subversion.javahl.callback.ChangelistCallback;
import org.apache.subversion.javahl.callback.ClientNotifyCallback;
import org.apache.subversion.javahl.callback.CommitCallback;
import org.apache.subversion.javahl.callback.CommitMessageCallback;
import org.apache.subversion.javahl.callback.ConflictResolverCallback;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ImportFilterCallback;
import org.apache.subversion.javahl.callback.InfoCallback;
import org.apache.subversion.javahl.callback.InheritedProplistCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.callback.PatchCallback;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.ProplistCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DiffOptions;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Version;
import org.apache.subversion.javahl.types.VersionExtended;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNClient
implements ISVNClient {
    protected long cppAddr;
    private ClientContext clientContext = new ClientContext();

    static {
        NativeResources.loadNativeLibrary();
    }

    public SVNClient() {
        this.cppAddr = this.ctNative();
        try {
            this.setConfigDirectory(null);
        }
        catch (ClientException clientException) {}
    }

    private long getCppAddr() {
        return this.cppAddr;
    }

    private native long ctNative();

    @Override
    public native void dispose();

    public native void finalize();

    @Override
    public Version getVersion() {
        return NativeResources.getVersion();
    }

    @Override
    public native VersionExtended getVersionExtended(boolean var1);

    @Override
    public native String getAdminDirectoryName();

    @Override
    public native boolean isAdminDirectory(String var1);

    public native String getLastPath();

    @Override
    public native void status(String var1, Depth var2, boolean var3, boolean var4, boolean var5, boolean var6, Collection<String> var7, StatusCallback var8) throws ClientException;

    @Override
    public native void list(String var1, Revision var2, Revision var3, Depth var4, int var5, boolean var6, ListCallback var7) throws ClientException;

    @Override
    public native void username(String var1);

    @Override
    public native void password(String var1);

    @Override
    public native void setPrompt(UserPasswordCallback var1);

    @Override
    public native void logMessages(String var1, Revision var2, List<RevisionRange> var3, boolean var4, boolean var5, boolean var6, Set<String> var7, long var8, LogMessageCallback var10) throws ClientException;

    @Override
    public native long checkout(String var1, String var2, Revision var3, Revision var4, Depth var5, boolean var6, boolean var7) throws ClientException;

    @Override
    public void notification2(ClientNotifyCallback notify) {
        this.clientContext.notify = notify;
    }

    @Override
    public void setConflictResolver(ConflictResolverCallback listener) {
        this.clientContext.resolver = listener;
    }

    @Override
    public void setProgressCallback(ProgressCallback listener) {
        this.clientContext.listener = listener;
    }

    @Override
    public native void remove(Set<String> var1, boolean var2, boolean var3, Map<String, String> var4, CommitMessageCallback var5, CommitCallback var6) throws ClientException;

    @Override
    public native void revert(String var1, Depth var2, Collection<String> var3) throws ClientException;

    @Override
    public native void add(String var1, Depth var2, boolean var3, boolean var4, boolean var5, boolean var6) throws ClientException;

    @Override
    public void add(String path, Depth depth, boolean force, boolean noIgnores, boolean addParents) throws ClientException {
        this.add(path, depth, force, noIgnores, false, addParents);
    }

    @Override
    public native long[] update(Set<String> var1, Revision var2, Depth var3, boolean var4, boolean var5, boolean var6, boolean var7) throws ClientException;

    @Override
    public native void commit(Set<String> var1, Depth var2, boolean var3, boolean var4, Collection<String> var5, Map<String, String> var6, CommitMessageCallback var7, CommitCallback var8) throws ClientException;

    @Override
    public native void copy(List<CopySource> var1, String var2, boolean var3, boolean var4, boolean var5, Map<String, String> var6, CommitMessageCallback var7, CommitCallback var8) throws ClientException;

    @Override
    public native void move(Set<String> var1, String var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, Map<String, String> var8, CommitMessageCallback var9, CommitCallback var10) throws ClientException;

    @Override
    public void move(Set<String> srcPaths, String destPath, boolean force, boolean moveAsChild, boolean makeParents, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.move(srcPaths, destPath, force, moveAsChild, makeParents, false, true, revpropTable, handler, callback);
    }

    @Override
    public native void mkdir(Set<String> var1, boolean var2, Map<String, String> var3, CommitMessageCallback var4, CommitCallback var5) throws ClientException;

    @Override
    public native void cleanup(String var1) throws ClientException;

    @Override
    public native void resolve(String var1, Depth var2, ConflictResult.Choice var3) throws SubversionException;

    @Override
    public native long doExport(String var1, String var2, Revision var3, Revision var4, boolean var5, boolean var6, Depth var7, String var8) throws ClientException;

    @Override
    public native long doSwitch(String var1, String var2, Revision var3, Revision var4, Depth var5, boolean var6, boolean var7, boolean var8, boolean var9) throws ClientException;

    @Override
    public native void doImport(String var1, String var2, Depth var3, boolean var4, boolean var5, boolean var6, Map<String, String> var7, ImportFilterCallback var8, CommitMessageCallback var9, CommitCallback var10) throws ClientException;

    @Override
    public void doImport(String path, String url, Depth depth, boolean noIgnore, boolean ignoreUnknownNodeTypes, Map<String, String> revpropTable, CommitMessageCallback handler, CommitCallback callback) throws ClientException {
        this.doImport(path, url, depth, noIgnore, false, ignoreUnknownNodeTypes, revpropTable, null, handler, callback);
    }

    @Override
    public native Set<String> suggestMergeSources(String var1, Revision var2) throws SubversionException;

    @Override
    public native void merge(String var1, Revision var2, String var3, Revision var4, String var5, boolean var6, Depth var7, boolean var8, boolean var9, boolean var10, boolean var11) throws ClientException;

    @Override
    public void merge(String path1, Revision revision1, String path2, Revision revision2, String localPath, boolean force, Depth depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, depth, ignoreAncestry, ignoreAncestry, dryRun, recordOnly);
    }

    @Override
    public native void merge(String var1, Revision var2, List<RevisionRange> var3, String var4, boolean var5, Depth var6, boolean var7, boolean var8, boolean var9, boolean var10) throws ClientException;

    @Override
    public void merge(String path, Revision pegRevision, List<RevisionRange> revisions, String localPath, boolean force, Depth depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws ClientException {
        this.merge(path, pegRevision, revisions, localPath, force, depth, ignoreAncestry, ignoreAncestry, dryRun, recordOnly);
    }

    @Override
    public native void mergeReintegrate(String var1, Revision var2, String var3, boolean var4) throws ClientException;

    @Override
    public native Mergeinfo getMergeinfo(String var1, Revision var2) throws SubversionException;

    @Override
    public native void getMergeinfoLog(Mergeinfo.LogKind var1, String var2, Revision var3, String var4, Revision var5, Revision var6, Revision var7, boolean var8, Depth var9, Set<String> var10, LogMessageCallback var11) throws ClientException;

    @Override
    public void getMergeinfoLog(Mergeinfo.LogKind kind, String pathOrUrl, Revision pegRevision, String mergeSourceUrl, Revision srcPegRevision, boolean discoverChangedPaths, Depth depth, Set<String> revProps, LogMessageCallback callback) throws ClientException {
        Revision unspecified = new Revision(Revision.Kind.unspecified);
        this.getMergeinfoLog(kind, pathOrUrl, pegRevision, mergeSourceUrl, srcPegRevision, unspecified, unspecified, discoverChangedPaths, depth, revProps, callback);
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target1, revision1, target2, revision2, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, false, false, null);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, OutputStream stream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly) throws ClientException {
        this.diff(target1, revision1, target2, revision2, relativeToDir, stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, null);
    }

    @Override
    public void diff(String target1, Revision revision1, String target2, Revision revision2, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target1, revision1, target2, revision2, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, options);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public native void diff(String var1, Revision var2, String var3, Revision var4, String var5, OutputStream var6, Depth var7, Collection<String> var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, DiffOptions var15) throws ClientException;

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, false, false, null);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, OutputStream stream, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly) throws ClientException {
        this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, null);
    }

    @Override
    public void diff(String target, Revision pegRevision, Revision startRevision, Revision endRevision, String relativeToDir, String outFileName, Depth depth, Collection<String> changelists, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, boolean copiesAsAdds, boolean ignoreProps, boolean propsOnly, DiffOptions options) throws ClientException {
        try {
            FileOutputStream stream = new FileOutputStream(outFileName);
            this.diff(target, pegRevision, startRevision, endRevision, relativeToDir, (OutputStream)stream, depth, changelists, ignoreAncestry, noDiffDeleted, force, copiesAsAdds, ignoreProps, propsOnly, options);
        }
        catch (FileNotFoundException ex) {
            throw ClientException.fromException(ex);
        }
    }

    @Override
    public native void diff(String var1, Revision var2, Revision var3, Revision var4, String var5, OutputStream var6, Depth var7, Collection<String> var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, DiffOptions var15) throws ClientException;

    @Override
    public native void diffSummarize(String var1, Revision var2, String var3, Revision var4, Depth var5, Collection<String> var6, boolean var7, DiffSummaryCallback var8) throws ClientException;

    @Override
    public native void diffSummarize(String var1, Revision var2, Revision var3, Revision var4, Depth var5, Collection<String> var6, boolean var7, DiffSummaryCallback var8) throws ClientException;

    @Override
    public native void properties(String var1, Revision var2, Revision var3, Depth var4, Collection<String> var5, ProplistCallback var6) throws ClientException;

    @Override
    public native void properties(String var1, Revision var2, Revision var3, Depth var4, Collection<String> var5, InheritedProplistCallback var6) throws ClientException;

    @Override
    public native void propertySetLocal(Set<String> var1, String var2, byte[] var3, Depth var4, Collection<String> var5, boolean var6) throws ClientException;

    @Override
    public native void propertySetRemote(String var1, long var2, String var4, byte[] var5, CommitMessageCallback var6, boolean var7, Map<String, String> var8, CommitCallback var9) throws ClientException;

    @Override
    public native byte[] revProperty(String var1, String var2, Revision var3) throws ClientException;

    @Override
    public native Map<String, byte[]> revProperties(String var1, Revision var2) throws ClientException;

    @Override
    public native void setRevProperty(String var1, String var2, Revision var3, String var4, String var5, boolean var6) throws ClientException;

    @Override
    public byte[] propertyGet(String path, String name, Revision revision, Revision pegRevision) throws ClientException {
        return this.propertyGet(path, name, revision, pegRevision, null);
    }

    @Override
    public native byte[] propertyGet(String var1, String var2, Revision var3, Revision var4, Collection<String> var5) throws ClientException;

    @Override
    public byte[] fileContent(String path, Revision revision, Revision pegRevision) throws ClientException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.streamFileContent(path, revision, pegRevision, stream);
        return stream.toByteArray();
    }

    @Override
    public native void streamFileContent(String var1, Revision var2, Revision var3, OutputStream var4) throws ClientException;

    @Override
    public native void relocate(String var1, String var2, String var3, boolean var4) throws ClientException;

    @Override
    public native void blame(String var1, Revision var2, Revision var3, Revision var4, boolean var5, boolean var6, BlameCallback var7) throws ClientException;

    @Override
    public native void setConfigDirectory(String var1) throws ClientException;

    @Override
    public native String getConfigDirectory() throws ClientException;

    @Override
    public native void cancelOperation() throws ClientException;

    @Override
    public native void addToChangelist(Set<String> var1, String var2, Depth var3, Collection<String> var4) throws ClientException;

    @Override
    public native void removeFromChangelists(Set<String> var1, Depth var2, Collection<String> var3) throws ClientException;

    @Override
    public native void getChangelists(String var1, Collection<String> var2, Depth var3, ChangelistCallback var4) throws ClientException;

    @Override
    public native String getVersionInfo(String var1, String var2, boolean var3) throws ClientException;

    @Override
    public native void upgrade(String var1) throws ClientException;

    public static native void enableLogging(ClientLogLevel var0, String var1);

    public static native String version();

    public static native int versionMajor();

    public static native int versionMinor();

    public static native int versionMicro();

    @Override
    public native void lock(Set<String> var1, String var2, boolean var3) throws ClientException;

    @Override
    public native void unlock(Set<String> var1, boolean var2) throws ClientException;

    @Override
    public native void info2(String var1, Revision var2, Revision var3, Depth var4, Collection<String> var5, InfoCallback var6) throws ClientException;

    @Override
    public native void patch(String var1, String var2, boolean var3, int var4, boolean var5, boolean var6, boolean var7, PatchCallback var8) throws ClientException;

    private class ClientContext
    implements ClientNotifyCallback,
    ProgressCallback,
    ConflictResolverCallback {
        public ClientNotifyCallback notify = null;
        public ProgressCallback listener = null;
        public ConflictResolverCallback resolver = null;

        private ClientContext() {
        }

        public void onNotify(ClientNotifyInformation notifyInfo) {
            if (this.notify != null) {
                this.notify.onNotify(notifyInfo);
            }
        }

        public void onProgress(ProgressEvent event) {
            if (this.listener != null) {
                this.listener.onProgress(event);
            }
        }

        public ConflictResult resolve(ConflictDescriptor conflict) throws SubversionException {
            if (this.resolver != null) {
                return this.resolver.resolve(conflict);
            }
            return new ConflictResult(ConflictResult.Choice.postpone, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientLogLevel {
        NoLog,
        ErrorLog,
        ExceptionLog,
        EntryLog;

    }
}

