/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.types.Lock;
import org.eclipse.team.svn.core.connector.ISVNManager;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNRepositoryFreezeAction;
import org.eclipse.team.svn.core.connector.ISVNRepositoryMessageCallback;
import org.eclipse.team.svn.core.connector.ISVNRepositoryNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNLock;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevisionRange;
import org.eclipse.team.svn.core.utility.SVNRepositoryNotificationComposite;
import org.polarion.team.svn.connector.javahl.ConversionUtility;
import org.polarion.team.svn.connector.javahl.JavaHLService;

public class JavaHLManager
extends JavaHLService
implements ISVNManager {
    protected ISVNRepos svnAdmin = new SVNRepos();
    protected SVNRepositoryNotificationComposite composite = new SVNRepositoryNotificationComposite();
    protected ISVNRepositoryNotificationCallback installedNotificationCallback;

    public void create(String repositoryPath, ISVNManager.RepositoryKind repositoryType, String configPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("repositoryPath", repositoryPath);
        parameters.put("repositoryType", repositoryType);
        parameters.put("configPath", configPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("createRepository", parameters);
        repositoryPath = (String)parameters.get("repositoryPath");
        repositoryType = (ISVNManager.RepositoryKind)parameters.get("repositoryType");
        configPath = (String)parameters.get("configPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                ISVNManager.RepositoryKind fsType = repositoryType == null ? ISVNManager.RepositoryKind.FSFS : repositoryType;
                this.svnAdmin.create(new File(repositoryPath), (options & 0x400L) != 0L, (options & 0x800L) != 0L, configPath != null ? new File(configPath) : null, fsType.id);
                this.fireSucceeded("createRepository", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "createRepository", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void deltify(String path, SVNRevisionRange range, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("range", range);
        parameters.put("monitor", monitor);
        this.fireAsked("deltify", parameters);
        path = (String)parameters.get("path");
        range = (SVNRevisionRange)parameters.get("range");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                this.svnAdmin.deltify(new File(path), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to));
                this.fireSucceeded("deltify", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "deltify", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void hotCopy(String path, String targetPath, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("targetPath", targetPath);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("hotCopy", parameters);
        path = (String)parameters.get("path");
        targetPath = (String)parameters.get("targetPath");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                this.svnAdmin.hotcopy(new File(path), new File(targetPath), (options & 1L) != 0L);
                this.fireSucceeded("hotCopy", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "hotCopy", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void dump(String path, OutputStream dataOut, SVNRevisionRange range, ISVNRepositoryNotificationCallback callback, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("dataOut", dataOut);
        parameters.put("range", range);
        parameters.put("callback", callback);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("dump", parameters);
        path = (String)parameters.get("path");
        dataOut = (OutputStream)parameters.get("dataOut");
        range = (SVNRevisionRange)parameters.get("range");
        callback = (ISVNRepositoryNotificationCallback)parameters.get("callback");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.add(callback);
                wrapper.start();
                this.svnAdmin.dump(new File(path), dataOut, ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), (options & 2L) != 0L, (options & 4L) != 0L, ConversionUtility.convert((ISVNRepositoryNotificationCallback)this.composite));
                this.fireSucceeded("dump", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "dump", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.remove(callback);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.remove(callback);
        }
    }

    public void listDBLogs(String path, ISVNRepositoryMessageCallback receiver, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("receiver", receiver);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("listDBLogs", parameters);
        path = (String)parameters.get("path");
        receiver = (ISVNRepositoryMessageCallback)parameters.get("receiver");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                if ((options & 8L) != 0L) {
                    this.svnAdmin.listUnusedDBLogs(new File(path), ConversionUtility.convert(receiver));
                } else {
                    this.svnAdmin.listDBLogs(new File(path), ConversionUtility.convert(receiver));
                }
                this.fireSucceeded("listDBLogs", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "listDBLogs", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void load(String path, InputStream dataInput, SVNRevisionRange range, String relativePath, ISVNRepositoryNotificationCallback callback, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("dataInput", dataInput);
        parameters.put("range", range);
        parameters.put("relativePath", relativePath);
        parameters.put("callback", callback);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("load", parameters);
        path = (String)parameters.get("path");
        dataInput = (InputStream)parameters.get("dataInput");
        range = (SVNRevisionRange)parameters.get("range");
        relativePath = (String)parameters.get("relativePath");
        callback = (ISVNRepositoryNotificationCallback)parameters.get("callback");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.add(callback);
                wrapper.start();
                this.svnAdmin.load(new File(path), dataInput, ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), (options & 0x10L) != 0L, (options & 0x20L) != 0L, (options & 0x40L) != 0L, (options & 0x80L) != 0L, relativePath, ConversionUtility.convert((ISVNRepositoryNotificationCallback)this.composite));
                this.fireSucceeded("load", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "load", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.remove(callback);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.remove(callback);
        }
    }

    public void listTransactions(String path, ISVNRepositoryMessageCallback receiver, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("receiver", receiver);
        parameters.put("monitor", monitor);
        this.fireAsked("listTransactions", parameters);
        path = (String)parameters.get("path");
        receiver = (ISVNRepositoryMessageCallback)parameters.get("receiver");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                this.svnAdmin.lstxns(new File(path), ConversionUtility.convert(receiver));
                this.fireSucceeded("listTransactions", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "listTransactions", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public long recover(String path, ISVNRepositoryNotificationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("recover", parameters);
        path = (String)parameters.get("path");
        callback = (ISVNRepositoryNotificationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.add(callback);
            wrapper.start();
            long retVal = this.svnAdmin.recover(new File(path), ConversionUtility.convert((ISVNRepositoryNotificationCallback)this.composite));
            this.fireSucceeded("recover", parameters, null);
            long l = retVal;
            return l;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "recover", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.remove(callback);
        }
        return 0L;
    }

    public void freeze(ISVNRepositoryFreezeAction action, String[] paths, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("action", action);
        parameters.put("paths", paths);
        parameters.put("monitor", monitor);
        this.fireAsked("freeze", parameters);
        action = (ISVNRepositoryFreezeAction)parameters.get("action");
        paths = (String[])parameters.get("paths");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                File[] files = new File[paths.length];
                int i = 0;
                while (i < paths.length) {
                    files[i] = new File(paths[i]);
                    ++i;
                }
                this.svnAdmin.freeze(ConversionUtility.convert(action), files);
                this.fireSucceeded("freeze", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "freeze", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void removeTransaction(String path, String[] transactions, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("transactions", transactions);
        parameters.put("monitor", monitor);
        this.fireAsked("removeTransaction", parameters);
        path = (String)parameters.get("path");
        transactions = (String[])parameters.get("transactions");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                this.svnAdmin.rmtxns(new File(path), transactions);
                this.fireSucceeded("removeTransaction", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeTransaction", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void setRevisionProperty(SVNEntryReference reference, SVNProperty property, long options, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("reference", reference);
        parameters.put("property", property);
        parameters.put("options", options);
        parameters.put("monitor", monitor);
        this.fireAsked("setReppositoryRevisionProperty", parameters);
        reference = (SVNEntryReference)parameters.get("reference");
        property = (SVNProperty)parameters.get("property");
        options = (Long)parameters.get("options");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                this.svnAdmin.setRevProp(new File(reference.path), ConversionUtility.convert(reference.pegRevision), property.name, property.value, (options & 0x100L) != 0L, (options & 0x200L) != 0L);
                this.fireSucceeded("setReppositoryRevisionProperty", parameters, null);
            }
            catch (SubversionException ex) {
                this.handleSubversionException(ex, "setReppositoryRevisionProperty", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void verify(String path, SVNRevisionRange range, ISVNRepositoryNotificationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("range", range);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("verify", parameters);
        path = (String)parameters.get("path");
        range = (SVNRevisionRange)parameters.get("range");
        callback = (ISVNRepositoryNotificationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.add(callback);
                wrapper.start();
                this.svnAdmin.verify(new File(path), ConversionUtility.convert(range.from), ConversionUtility.convert(range.to), ConversionUtility.convert((ISVNRepositoryNotificationCallback)this.composite));
                this.fireSucceeded("verify", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "verify", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.remove(callback);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.remove(callback);
        }
    }

    public SVNLock[] listLocks(String path, SVNDepth depth, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("depth", depth);
        parameters.put("monitor", monitor);
        this.fireAsked("listLocks", parameters);
        path = (String)parameters.get("path");
        depth = (SVNDepth)parameters.get("depth");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
            wrapper.start();
            Set<Lock> locks = this.svnAdmin.lslocks(new File(path), ConversionUtility.convertDepth(depth));
            SVNLock[] retVal = new SVNLock[locks == null ? 0 : locks.size()];
            int i = 0;
            for (Lock lock : locks) {
                retVal[i++] = ConversionUtility.convert(lock);
            }
            this.fireSucceeded("listLocks", parameters, null);
            SVNLock[] sVNLockArray = retVal;
            return sVNLockArray;
        }
        catch (ClientException ex) {
            this.handleClientException(ex, "listLocks", parameters);
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
        return null;
    }

    public void removeLocks(String path, String[] locks, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("locks", locks);
        parameters.put("monitor", monitor);
        this.fireAsked("removeLocks", parameters);
        path = (String)parameters.get("path");
        locks = (String[])parameters.get("locks");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                wrapper.start();
                this.svnAdmin.rmlocks(new File(path), locks);
                this.fireSucceeded("removeLocks", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "removeLocks", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
        }
    }

    public void upgrade(String path, ISVNRepositoryNotificationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("repositoryUpgrade", parameters);
        path = (String)parameters.get("path");
        callback = (ISVNRepositoryNotificationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.add(callback);
                wrapper.start();
                this.svnAdmin.upgrade(new File(path), ConversionUtility.convert((ISVNRepositoryNotificationCallback)this.composite));
                this.fireSucceeded("repositoryUpgrade", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "repositoryUpgrade", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.remove(callback);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.remove(callback);
        }
    }

    public void pack(String path, ISVNRepositoryNotificationCallback callback, ISVNProgressMonitor monitor) throws SVNConnectorException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("path", path);
        parameters.put("callback", callback);
        parameters.put("monitor", monitor);
        this.fireAsked("pack", parameters);
        path = (String)parameters.get("path");
        callback = (ISVNRepositoryNotificationCallback)parameters.get("callback");
        monitor = (ISVNProgressMonitor)parameters.get("monitor");
        JavaHLService.ProgressMonitorWrapper wrapper = new JavaHLService.ProgressMonitorWrapper(this, monitor);
        try {
            try {
                this.composite.add((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.add(callback);
                wrapper.start();
                this.svnAdmin.pack(new File(path), ConversionUtility.convert((ISVNRepositoryNotificationCallback)this.composite));
                this.fireSucceeded("pack", parameters, null);
            }
            catch (ClientException ex) {
                this.handleClientException(ex, "pack", parameters);
                wrapper.finish();
                this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
                this.composite.remove(callback);
            }
        }
        finally {
            wrapper.finish();
            this.composite.remove((ISVNRepositoryNotificationCallback)wrapper);
            this.composite.remove(callback);
        }
    }

    public void dispose() {
        this.svnAdmin.dispose();
    }

    protected void cancelOperation() throws Exception {
        this.svnAdmin.cancelOperation();
    }
}

