/*
 * Decompiled with CFR 0.152.
 */
package org.polarion.team.svn.connector.javahl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SubversionException;
import org.eclipse.team.svn.core.connector.ISVNCallListener;
import org.eclipse.team.svn.core.connector.ISVNNotificationCallback;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.ISVNRepositoryNotificationCallback;
import org.eclipse.team.svn.core.connector.SVNConnectorAuthenticationException;
import org.eclipse.team.svn.core.connector.SVNConnectorCancelException;
import org.eclipse.team.svn.core.connector.SVNConnectorException;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryStatus;
import org.eclipse.team.svn.core.connector.SVNNotification;
import org.eclipse.team.svn.core.connector.SVNRepositoryNotification;
import org.polarion.team.svn.connector.javahl.ConversionUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaHLService {
    private static ProgressMonitorThread monitorWrapperThread;
    private ArrayList<ISVNCallListener> callListeners = new ArrayList();

    public void addCallListener(ISVNCallListener listener) {
        this.callListeners.add(listener);
    }

    public void removeCallListener(ISVNCallListener listener) {
        this.callListeners.remove(listener);
    }

    protected void handleSubversionException(SubversionException ex, String methodName, Map<String, Object> parameters) throws SVNConnectorException {
        SVNConnectorException exception = new SVNConnectorException(ConversionUtility.convertZeroCodedLine(ex.getMessage()), (Throwable)ex);
        this.fireFailed(methodName, parameters, exception);
        throw exception;
    }

    protected void handleClientException(ClientException ex, String methodName, Map<String, Object> parameters) throws SVNConnectorException {
        String msg = ConversionUtility.convertZeroCodedLine(ex.getMessage());
        Object exception = null;
        if (this.findConflict(ex)) {
            exception = new SVNConnectorUnresolvedConflictException(msg, (Throwable)ex);
        }
        if (this.findCancel(ex)) {
            exception = new SVNConnectorCancelException(msg, (Throwable)ex);
        }
        if (this.findAuthentication(ex)) {
            exception = new SVNConnectorAuthenticationException(msg, (Throwable)ex);
        }
        if (exception == null) {
            exception = new SVNConnectorException(msg, ex.getAprError(), (Throwable)ex);
        }
        if (methodName != null) {
            this.fireFailed(methodName, parameters, (SVNConnectorException)((Object)exception));
        }
        throw exception;
    }

    protected boolean findConflict(ClientException t) {
        return t.getAprError() == 160024 || t.getAprError() == 160028;
    }

    protected boolean findAuthentication(ClientException t) {
        return t.getAprError() == 170001;
    }

    protected boolean findCancel(ClientException t) {
        return t.getAprError() == 200015;
    }

    protected void fireAsked(String methodName, Map<String, Object> parameters) {
        ISVNCallListener[] iSVNCallListenerArray = this.callListeners.toArray(new ISVNCallListener[0]);
        int n = iSVNCallListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNCallListener listener = iSVNCallListenerArray[n2];
            listener.asked(methodName, parameters);
            ++n2;
        }
    }

    protected void fireSucceeded(String methodName, Map<String, Object> parameters, Object returnValue) {
        ISVNCallListener[] iSVNCallListenerArray = this.callListeners.toArray(new ISVNCallListener[0]);
        int n = iSVNCallListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNCallListener listener = iSVNCallListenerArray[n2];
            listener.succeeded(methodName, parameters, returnValue);
            ++n2;
        }
    }

    protected void fireFailed(String methodName, Map<String, Object> parameters, SVNConnectorException exception) {
        ISVNCallListener[] iSVNCallListenerArray = this.callListeners.toArray(new ISVNCallListener[0]);
        int n = iSVNCallListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISVNCallListener listener = iSVNCallListenerArray[n2];
            listener.failed(methodName, parameters, exception);
            ++n2;
        }
    }

    protected abstract void cancelOperation() throws Exception;

    private static synchronized ProgressMonitorThread getProgressMonitorThread() {
        if (monitorWrapperThread == null) {
            monitorWrapperThread = new ProgressMonitorThread();
            monitorWrapperThread.start();
        }
        return monitorWrapperThread;
    }

    protected static ISVNProgressMonitor.ItemState makeItemState(SVNNotification arg0) {
        return new ISVNProgressMonitor.ItemState(arg0.path, arg0.action.id, arg0.kind, arg0.mimeType, arg0.contentState.id, arg0.propState.id, arg0.revision, arg0.errMsg);
    }

    protected static ISVNProgressMonitor.ItemState makeItemState(SVNRepositoryNotification arg0) {
        return new ISVNProgressMonitor.ItemState(arg0.path, arg0.action.id, SVNEntry.Kind.UNKNOWN, null, SVNEntryStatus.Kind.NONE.id, SVNEntryStatus.Kind.NONE.id, arg0.revision, arg0.warning);
    }

    protected static class ProgressMonitorThread
    extends Thread {
        private final List<ProgressMonitorWrapper> monitors = new ArrayList<ProgressMonitorWrapper>();

        public ProgressMonitorThread() {
            super("JavaHL 1.8 Connector");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(ProgressMonitorWrapper monitor) {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                this.monitors.add(monitor);
                this.monitors.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(ProgressMonitorWrapper monitor) {
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                this.monitors.remove(monitor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.isInterrupted()) {
                this.checkForActivityCancelled();
                try {
                    List<ProgressMonitorWrapper> list = this.monitors;
                    synchronized (list) {
                        if (this.monitors.size() == 0) {
                            this.monitors.wait();
                        } else {
                            this.monitors.wait(100L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkForActivityCancelled() {
            ProgressMonitorWrapper[] monitors;
            List<ProgressMonitorWrapper> list = this.monitors;
            synchronized (list) {
                monitors = this.monitors.toArray(new ProgressMonitorWrapper[this.monitors.size()]);
            }
            long staleThreadsTime = System.currentTimeMillis() - 3000L;
            ProgressMonitorWrapper[] progressMonitorWrapperArray = monitors;
            int n = monitors.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressMonitorWrapper monitor = progressMonitorWrapperArray[n2];
                if (monitor.isCanceled()) {
                    if (monitor.getCancellationTime() < staleThreadsTime) {
                        monitor.interrupt();
                    }
                } else if (monitor.monitor.isActivityCancelled()) {
                    monitor.cancel();
                }
                ++n2;
            }
        }
    }

    protected class ProgressMonitorWrapper
    implements ISVNNotificationCallback,
    ISVNRepositoryNotificationCallback {
        public ISVNProgressMonitor monitor;
        protected int current;
        protected boolean isCanceled;
        protected long cancellationTime;
        protected Thread monitoredThread;

        public ProgressMonitorWrapper(ISVNProgressMonitor monitor) {
            this.monitor = monitor;
            this.current = 0;
            this.isCanceled = false;
        }

        public void cancel() {
            try {
                this.isCanceled = true;
                this.cancellationTime = System.currentTimeMillis();
                JavaHLService.this.cancelOperation();
            }
            catch (Exception exception) {}
        }

        public void notify(SVNNotification info) {
            this.monitor.progress(this.current++, -1, JavaHLService.makeItemState(info));
        }

        public void notify(SVNRepositoryNotification info) {
            this.monitor.progress(this.current++, -1, JavaHLService.makeItemState(info));
        }

        public void start() {
            this.monitoredThread = Thread.currentThread();
            JavaHLService.getProgressMonitorThread().add(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            ProgressMonitorWrapper progressMonitorWrapper = this;
            synchronized (progressMonitorWrapper) {
                this.monitoredThread = null;
            }
            JavaHLService.getProgressMonitorThread().remove(this);
        }

        public synchronized void interrupt() {
            if (this.monitoredThread != null) {
                this.monitoredThread.interrupt();
            }
        }

        public boolean isCanceled() {
            return this.isCanceled;
        }

        public long getCancellationTime() {
            return this.cancellationTime;
        }
    }
}

