/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TextAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class PersonAttributeEditor
extends TextAttributeEditor {
    private ContentAssistCommandAdapter contentAssistCommandAdapter = null;

    public PersonAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    @Override
    public Text getText() {
        return super.getText();
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        String userName = this.getModel().getTaskRepository().getUserName();
        if (this.isReadOnly() || userName == null || userName.length() == 0) {
            super.createControl(parent, toolkit);
        } else {
            final Composite composite = new Composite(parent, 0);
            GridLayout parentLayout = new GridLayout(2, false);
            parentLayout.marginHeight = 0;
            parentLayout.marginWidth = 0;
            parentLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)parentLayout);
            composite.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            super.createControl(composite, toolkit);
            this.getText().setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.getText());
            final ImageHyperlink selfLink = new ImageHyperlink(composite, 524288);
            selfLink.setToolTipText(Messages.PersonAttributeEditor_Insert_My_User_Id_Tooltip);
            selfLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_SMALL));
            selfLink.setActiveImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_SMALL));
            selfLink.setHoverImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME_SMALL));
            selfLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    String userName = PersonAttributeEditor.this.getModel().getTaskRepository().getUserName();
                    if (userName != null && userName.length() > 0) {
                        PersonAttributeEditor.this.getText().setText(userName);
                        PersonAttributeEditor.this.setValue(userName);
                    }
                }
            });
            GridDataFactory.fillDefaults().align(1, 0x1000000).exclude(true).applyTo((Control)selfLink);
            MouseTrackAdapter mouseListener = new MouseTrackAdapter(){
                int version = 0;

                public void mouseEnter(MouseEvent e) {
                    ((GridData)selfLink.getLayoutData()).exclude = false;
                    composite.layout();
                    selfLink.redraw();
                    ++this.version;
                }

                public void mouseExit(MouseEvent e) {
                    final int lastVersion = this.version;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (version != lastVersion || selfLink.isDisposed()) {
                                return;
                            }
                            selfLink.redraw();
                            ((GridData)selfLink.getLayoutData()).exclude = true;
                            composite.layout();
                        }
                    });
                }
            };
            composite.addMouseTrackListener((MouseTrackListener)mouseListener);
            this.getText().addMouseTrackListener((MouseTrackListener)mouseListener);
            selfLink.addMouseTrackListener((MouseTrackListener)mouseListener);
            toolkit.paintBordersFor(composite);
            this.setControl((Control)composite);
        }
    }

    @Override
    public String getValue() {
        IRepositoryPerson repositoryPerson = this.getAttributeMapper().getRepositoryPerson(this.getTaskAttribute());
        if (repositoryPerson != null) {
            return this.isReadOnly() ? repositoryPerson.toString() : repositoryPerson.getPersonId();
        }
        return "";
    }

    @Override
    public void setValue(String text) {
        IRepositoryPerson person = this.getAttributeMapper().getTaskRepository().createPerson(text);
        this.getAttributeMapper().setRepositoryPerson(this.getTaskAttribute(), person);
        this.attributeChanged();
    }

    @Override
    protected void decorateIncoming(Color color) {
        if (this.getControl() != null) {
            this.getControl().setBackground(color);
        }
        if (this.getText() != null && this.getText() != this.getControl()) {
            this.getText().setBackground(color);
        }
    }

    public ContentAssistCommandAdapter getContentAssistCommandAdapter() {
        return this.contentAssistCommandAdapter;
    }

    public void setContentAssistCommandAdapter(ContentAssistCommandAdapter contentAssistCommandAdapter) {
        this.contentAssistCommandAdapter = contentAssistCommandAdapter;
    }
}

