/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.line.QSequenceLineMedia;
import de.regnis.q.sequence.line.QSequenceLineRAData;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import de.regnis.q.sequence.line.QSequenceLineResult;
import de.regnis.q.sequence.line.simplifier.QSequenceLineDummySimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineEOLUnifyingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineTeeSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceReducingSimplifier;
import de.regnis.q.sequence.line.simplifier.QSequenceLineWhiteSpaceSkippingSimplifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslatorInputStream;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.SVNFileRevision;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAnnotationGenerator
implements ISVNFileRevisionHandler {
    private File myTmpDirectory;
    private boolean myIsTmpDirCreated;
    private String myPath;
    private long myCurrentRevision;
    private String myCurrentAuthor;
    private Date myCurrentDate;
    private boolean myIsCurrentResultOfMerge;
    private String myCurrentPath;
    private File myPreviousFile;
    private File myPreviousOriginalFile;
    private File myCurrentFile;
    private List myMergeBlameChunks;
    private List myBlameChunks;
    private SVNDeltaProcessor myDeltaProcessor;
    private ISVNEventHandler myCancelBaton;
    private long myStartRevision;
    private boolean myIsForce;
    private boolean myIncludeMergedRevisions;
    private SVNDiffOptions myDiffOptions;
    private QSequenceLineSimplifier mySimplifier;
    private ISVNAnnotateHandler myFileHandler;
    private String myEncoding;
    private boolean myIsLastRevisionReported;

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, ISVNEventHandler cancelBaton) {
        this(path, tmpDirectory, startRevision, false, cancelBaton);
    }

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, boolean force, ISVNEventHandler cancelBaton) {
        this(path, tmpDirectory, startRevision, force, new SVNDiffOptions(), cancelBaton);
    }

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, boolean force, SVNDiffOptions diffOptions, ISVNEventHandler cancelBaton) {
        this(path, tmpDirectory, startRevision, force, false, diffOptions, null, null, cancelBaton);
    }

    public SVNAnnotationGenerator(String path, File tmpDirectory, long startRevision, boolean force, boolean includeMergedRevisions, SVNDiffOptions diffOptions, String encoding, ISVNAnnotateHandler handler, ISVNEventHandler cancelBaton) {
        this.myTmpDirectory = tmpDirectory;
        this.myCancelBaton = cancelBaton;
        this.myPath = path;
        this.myIsForce = force;
        if (!this.myTmpDirectory.isDirectory()) {
            this.myTmpDirectory.mkdirs();
            this.myIsTmpDirCreated = true;
        }
        this.myMergeBlameChunks = new ArrayList();
        this.myBlameChunks = new ArrayList();
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myStartRevision = startRevision;
        this.myDiffOptions = diffOptions == null ? new SVNDiffOptions() : diffOptions;
        this.myIncludeMergedRevisions = includeMergedRevisions;
        this.myFileHandler = handler;
        this.myEncoding = encoding;
    }

    public void openRevision(SVNFileRevision fileRevision) throws SVNException {
        String newMimeType;
        SVNProperties propDiff = fileRevision.getPropertiesDelta();
        String string = newMimeType = propDiff != null ? propDiff.getStringValue("svn:mime-type") : null;
        if (!this.myIsForce && SVNProperty.isBinaryMimeType(newMimeType)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_IS_BINARY_FILE, "Cannot calculate blame information for binary file ''{0}''", (Object)this.myPath);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        this.myCurrentRevision = fileRevision.getRevision();
        boolean known = fileRevision.getRevision() >= this.myStartRevision;
        SVNProperties props = fileRevision.getRevisionProperties();
        if (this.myCancelBaton != null) {
            File file = SVNPathUtil.isURL(this.myPath) ? null : new File(this.myPath);
            SVNEvent event = SVNEventFactory.createSVNEvent(file, SVNNodeKind.NONE, null, this.myCurrentRevision, SVNEventAction.ANNOTATE, null, null, null, props, null);
            if (file == null) {
                event.setURL(SVNURL.parseURIEncoded(this.myPath));
            }
            this.myCancelBaton.handleEvent(event, -1.0);
            this.myCancelBaton.checkCancelled();
        }
        this.myCurrentAuthor = known && props != null && props.getStringValue("svn:author") != null ? props.getStringValue("svn:author") : null;
        this.myCurrentDate = known && props != null && props.getStringValue("svn:date") != null ? SVNDate.parseDate(fileRevision.getRevisionProperties().getStringValue("svn:date")) : null;
        this.myIsCurrentResultOfMerge = fileRevision.isResultOfMerge();
        if (this.myIncludeMergedRevisions) {
            this.myCurrentPath = fileRevision.getPath();
        }
    }

    public void closeRevision(String token) throws SVNException {
    }

    public void applyTextDelta(String token, String baseChecksum) throws SVNException {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp", false);
        }
        this.myDeltaProcessor.applyTextDelta(this.myPreviousFile, this.myCurrentFile, false);
    }

    public OutputStream textDeltaChunk(String token, SVNDiffWindow diffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(diffWindow);
    }

    public void textDeltaEnd(String token) throws SVNException {
        boolean generate;
        this.myIsLastRevisionReported = false;
        this.myDeltaProcessor.textDeltaEnd();
        if (this.myIncludeMergedRevisions) {
            this.myMergeBlameChunks = this.addFileBlame(this.myPreviousFile, this.myCurrentFile, this.myMergeBlameChunks);
            if (!this.myIsCurrentResultOfMerge) {
                this.myBlameChunks = this.addFileBlame(this.myPreviousOriginalFile, this.myCurrentFile, this.myBlameChunks);
                if (this.myPreviousOriginalFile == null) {
                    this.myPreviousOriginalFile = this.myCurrentFile;
                    this.myCurrentFile = null;
                } else {
                    SVNFileUtil.rename(this.myCurrentFile, this.myPreviousOriginalFile);
                }
                this.myPreviousFile = this.myPreviousOriginalFile;
            } else if (this.myPreviousFile != null && this.myPreviousFile != this.myPreviousOriginalFile) {
                SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
            } else {
                this.myPreviousFile = this.myCurrentFile;
                this.myCurrentFile = null;
            }
        } else {
            this.myBlameChunks = this.addFileBlame(this.myPreviousFile, this.myCurrentFile, this.myBlameChunks);
            if (this.myPreviousFile == null) {
                this.myPreviousFile = this.myCurrentFile;
                this.myCurrentFile = null;
            } else {
                SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
            }
        }
        if (this.myFileHandler != null && (generate = this.myFileHandler.handleRevision(this.myCurrentDate, this.myCurrentDate != null ? this.myCurrentRevision : -1L, this.myCurrentAuthor, this.myPreviousFile))) {
            this.myIsLastRevisionReported = true;
            this.reportAnnotations(this.myFileHandler, this.myEncoding);
        }
    }

    public void addFileBlame(InputStream contents) throws SVNException {
        block8: {
            if (this.myCurrentFile == null) {
                this.myCurrentFile = SVNFileUtil.createUniqueFile(this.myTmpDirectory, "annotate", ".tmp", false);
            }
            OutputStream os = null;
            try {
                try {
                    os = SVNFileUtil.openFileForWriting(this.myCurrentFile);
                    SVNTranslator.copy(contents, os);
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
                    SVNErrorManager.error(err, SVNLogType.WC);
                    SVNFileUtil.closeFile(os);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(os);
                throw throwable;
            }
            SVNFileUtil.closeFile(os);
        }
        this.myBlameChunks = this.addFileBlame(this.myPreviousFile, this.myCurrentFile, this.myBlameChunks);
        if (this.myPreviousFile == null) {
            this.myPreviousFile = this.myCurrentFile;
            this.myCurrentFile = null;
        } else {
            SVNFileUtil.rename(this.myCurrentFile, this.myPreviousFile);
        }
    }

    public boolean isLastRevisionReported() {
        return this.myIsLastRevisionReported;
    }

    public void reportAnnotations(ISVNAnnotateHandler handler, String inputEncoding) throws SVNException {
        block15: {
            if (handler == null) {
                return;
            }
            SVNErrorManager.assertionFailure(this.myPreviousFile != null, null, SVNLogType.WC);
            int mergedCount = -1;
            if (this.myIncludeMergedRevisions) {
                if (this.myBlameChunks.isEmpty()) {
                    BlameChunk chunk = new BlameChunk();
                    chunk.blockStart = 0;
                    chunk.author = this.myCurrentAuthor;
                    chunk.date = this.myCurrentDate;
                    chunk.revision = this.myCurrentRevision;
                    chunk.path = this.myCurrentPath;
                    this.myBlameChunks.add(chunk);
                }
                this.normalizeBlames(this.myBlameChunks, this.myMergeBlameChunks);
                mergedCount = 0;
            }
            inputEncoding = inputEncoding == null ? System.getProperty("file.encoding") : inputEncoding;
            CharsetDecoder decoder = Charset.forName(inputEncoding).newDecoder();
            SVNTranslatorInputStream stream = null;
            try {
                try {
                    stream = new SVNTranslatorInputStream(SVNFileUtil.openFileForReading(this.myPreviousFile), SVNProperty.EOL_LF_BYTES, true, null, false);
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < this.myBlameChunks.size()) {
                        BlameChunk chunk = (BlameChunk)this.myBlameChunks.get(i);
                        String mergedAuthor = null;
                        long mergedRevision = -1L;
                        Date mergedDate = null;
                        String mergedPath = null;
                        if (mergedCount >= 0) {
                            BlameChunk mergedChunk = (BlameChunk)this.myMergeBlameChunks.get(mergedCount++);
                            mergedAuthor = mergedChunk.author;
                            mergedRevision = mergedChunk.revision;
                            mergedDate = mergedChunk.date;
                            mergedPath = mergedChunk.path;
                        }
                        BlameChunk nextChunk = null;
                        if (i < this.myBlameChunks.size() - 1) {
                            nextChunk = (BlameChunk)this.myBlameChunks.get(i + 1);
                        }
                        int lineNo = chunk.blockStart;
                        while (nextChunk == null || lineNo < nextChunk.blockStart) {
                            this.myCancelBaton.checkCancelled();
                            buffer.setLength(0);
                            String line = SVNFileUtil.readLineFromStream(stream, buffer, decoder);
                            boolean isEOF = false;
                            if (line == null) {
                                isEOF = true;
                                if (buffer.length() > 0) {
                                    line = buffer.toString();
                                }
                            }
                            if (!isEOF || line != null) {
                                handler.handleLine(chunk.date, chunk.revision, chunk.author, line, mergedDate, mergedRevision, mergedAuthor, mergedPath, lineNo);
                            }
                            if (isEOF) break;
                            ++lineNo;
                        }
                        ++i;
                    }
                    handler.handleEOF();
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err, ioe, SVNLogType.DEFAULT);
                    SVNFileUtil.closeFile(stream);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(stream);
                throw throwable;
            }
            SVNFileUtil.closeFile(stream);
        }
    }

    public void dispose() {
        this.myIsCurrentResultOfMerge = false;
        if (this.myCurrentFile != null) {
            SVNFileUtil.deleteAll(this.myCurrentFile, true);
        }
        if (this.myPreviousFile != null) {
            SVNFileUtil.deleteAll(this.myPreviousFile, true);
            this.myPreviousFile = null;
        }
        if (this.myPreviousOriginalFile != null) {
            SVNFileUtil.deleteAll(this.myPreviousOriginalFile, true);
            this.myPreviousOriginalFile = null;
        }
        if (this.myIsTmpDirCreated) {
            SVNFileUtil.deleteAll(this.myTmpDirectory, true);
        }
        this.myBlameChunks.clear();
        this.myMergeBlameChunks.clear();
    }

    private List addFileBlame(File previousFile, File currentFile, List chain) throws SVNException {
        block18: {
            if (previousFile == null) {
                BlameChunk chunk = new BlameChunk();
                chunk.author = this.myCurrentAuthor;
                chunk.revision = this.myCurrentDate != null ? this.myCurrentRevision : -1L;
                chunk.date = this.myCurrentDate;
                chunk.blockStart = 0;
                chunk.path = this.myCurrentPath;
                chain.add(chunk);
                return chain;
            }
            RandomAccessFile left = null;
            RandomAccessFile right = null;
            try {
                try {
                    left = new RandomAccessFile(previousFile, "r");
                    right = new RandomAccessFile(currentFile, "r");
                    QSequenceLineResult result = QSequenceLineMedia.createBlocks((QSequenceLineRAData)new QSequenceLineRAFileData(left), (QSequenceLineRAData)new QSequenceLineRAFileData(right), (QSequenceLineSimplifier)this.createSimplifier());
                    try {
                        List blocksList = result.getBlocks();
                        int i = 0;
                        while (i < blocksList.size()) {
                            QSequenceDifferenceBlock block = (QSequenceDifferenceBlock)blocksList.get(i);
                            if (block.getLeftSize() > 0) {
                                this.deleteBlameChunk(block.getRightFrom(), block.getLeftSize(), chain);
                            }
                            if (block.getRightSize() > 0) {
                                this.insertBlameChunk(this.myCurrentRevision, this.myCurrentAuthor, this.myCurrentDate, this.myCurrentPath, block.getRightFrom(), block.getRightSize(), chain);
                            }
                            ++i;
                        }
                    }
                    finally {
                        result.close();
                    }
                }
                catch (Throwable e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Exception while generating annotation: {0}", (Object)e.getMessage());
                    SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
                    if (left != null) {
                        SVNFileUtil.closeFile(left);
                    }
                    if (right != null) {
                        SVNFileUtil.closeFile(right);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (left != null) {
                    SVNFileUtil.closeFile(left);
                }
                if (right != null) {
                    SVNFileUtil.closeFile(right);
                }
                throw throwable;
            }
            if (left != null) {
                SVNFileUtil.closeFile(left);
            }
            if (right != null) {
                SVNFileUtil.closeFile(right);
            }
        }
        return chain;
    }

    private void insertBlameChunk(long revision, String author, Date date, String path, int start, int length, List chain) {
        int[] index = new int[1];
        BlameChunk startPoint = this.findBlameChunk(chain, start, index);
        int adjustFromIndex = -1;
        if (startPoint.blockStart == start) {
            BlameChunk insert = new BlameChunk();
            insert.copy(startPoint);
            insert.blockStart = start + length;
            chain.add(index[0] + 1, insert);
            startPoint.author = author;
            startPoint.revision = revision;
            startPoint.date = date;
            startPoint.path = path;
            adjustFromIndex = index[0] + 2;
        } else {
            BlameChunk middle = new BlameChunk();
            middle.author = author;
            middle.revision = revision;
            middle.date = date;
            middle.path = path;
            middle.blockStart = start;
            BlameChunk insert = new BlameChunk();
            insert.copy(startPoint);
            insert.blockStart = start + length;
            chain.add(index[0] + 1, middle);
            chain.add(index[0] + 2, insert);
            adjustFromIndex = index[0] + 3;
        }
        this.adjustBlameChunks(chain, adjustFromIndex, length);
    }

    private void deleteBlameChunk(int start, int length, List chain) {
        BlameChunk tail;
        int[] ind = new int[1];
        BlameChunk first = this.findBlameChunk(chain, start, ind);
        int firstInd = ind[0];
        BlameChunk last = this.findBlameChunk(chain, start + length, ind);
        int lastInd = ind[0];
        if (first != last) {
            int deleteCount = lastInd - firstInd - 1;
            int i = 0;
            while (i < deleteCount) {
                chain.remove(firstInd + 1);
                ++i;
            }
            lastInd -= deleteCount;
            last.blockStart = start;
            if (first.blockStart == start) {
                first.copy(last);
                chain.remove(lastInd);
                --lastInd;
                last = first;
            }
        }
        int tailInd = lastInd < chain.size() - 1 ? lastInd + 1 : -1;
        BlameChunk blameChunk = tail = tailInd > 0 ? (BlameChunk)chain.get(tailInd) : null;
        if (tail != null && tail.blockStart == last.blockStart + length) {
            last.copy(tail);
            chain.remove(tail);
            --tailInd;
            tail = last;
        }
        if (tail != null) {
            this.adjustBlameChunks(chain, tailInd, -length);
        }
    }

    private void adjustBlameChunks(List chain, int startIndex, int adjust) {
        int i = startIndex;
        while (i < chain.size()) {
            BlameChunk curChunk = (BlameChunk)chain.get(i);
            curChunk.blockStart += adjust;
            ++i;
        }
    }

    private BlameChunk findBlameChunk(List chain, int offset, int[] index) {
        BlameChunk prevChunk = null;
        index[0] = -1;
        for (BlameChunk chunk : chain) {
            if (chunk.blockStart > offset) break;
            prevChunk = chunk;
            index[0] = index[0] + 1;
        }
        return prevChunk;
    }

    private void normalizeBlames(List chain, List mergedChain) throws SVNException {
        BlameChunk insert;
        BlameChunk mergedChunk;
        BlameChunk chunk;
        int i = 0;
        int k = 0;
        while (i < chain.size() - 1 && k < mergedChain.size() - 1) {
            BlameChunk tmpChunk;
            chunk = (BlameChunk)chain.get(i);
            mergedChunk = (BlameChunk)mergedChain.get(k);
            SVNErrorManager.assertionFailure(chunk.blockStart == mergedChunk.blockStart, null, SVNLogType.WC);
            BlameChunk nextChunk = (BlameChunk)chain.get(i + 1);
            BlameChunk nextMergedChunk = (BlameChunk)mergedChain.get(k + 1);
            if (nextChunk.blockStart < nextMergedChunk.blockStart) {
                tmpChunk = new BlameChunk();
                tmpChunk.copy(mergedChunk);
                tmpChunk.blockStart = nextChunk.blockStart;
                mergedChain.add(k + 1, tmpChunk);
                nextMergedChunk = tmpChunk;
            }
            if (nextChunk.blockStart > nextMergedChunk.blockStart) {
                tmpChunk = new BlameChunk();
                tmpChunk.copy(chunk);
                tmpChunk.blockStart = nextMergedChunk.blockStart;
                chain.add(i + 1, tmpChunk);
            }
            ++i;
            ++k;
        }
        if (i == chain.size() - 1 && k == mergedChain.size() - 1) {
            return;
        }
        if (k == mergedChain.size() - 1) {
            ++i;
            while (i < chain.size()) {
                chunk = (BlameChunk)chain.get(i);
                mergedChunk = (BlameChunk)mergedChain.get(mergedChain.size() - 1);
                insert = new BlameChunk();
                insert.copy(mergedChunk);
                insert.blockStart = chunk.blockStart;
                mergedChain.add(insert);
                ++k;
                ++i;
            }
        }
        if (i == chain.size() - 1) {
            ++k;
            while (k < mergedChain.size()) {
                BlameChunk mergedChunk2 = (BlameChunk)mergedChain.get(k);
                BlameChunk chunk2 = (BlameChunk)chain.get(chain.size() - 1);
                insert = new BlameChunk();
                insert.copy(chunk2);
                insert.blockStart = mergedChunk2.blockStart;
                chain.add(insert);
                ++i;
                ++k;
            }
        }
    }

    private QSequenceLineSimplifier createSimplifier() {
        if (this.mySimplifier == null) {
            QSequenceLineEOLUnifyingSimplifier first = this.myDiffOptions.isIgnoreEOLStyle() ? new QSequenceLineEOLUnifyingSimplifier() : new QSequenceLineDummySimplifier();
            QSequenceLineDummySimplifier second = new QSequenceLineDummySimplifier();
            if (this.myDiffOptions.isIgnoreAllWhitespace()) {
                second = new QSequenceLineWhiteSpaceSkippingSimplifier();
            } else if (this.myDiffOptions.isIgnoreAmountOfWhitespace()) {
                second = new QSequenceLineWhiteSpaceReducingSimplifier();
            }
            this.mySimplifier = new QSequenceLineTeeSimplifier((QSequenceLineSimplifier)first, (QSequenceLineSimplifier)second);
        }
        return this.mySimplifier;
    }

    private static class BlameChunk {
        public int blockStart;
        public long revision;
        public String author;
        public Date date;
        public String path;

        private BlameChunk() {
        }

        public void copy(BlameChunk chunk) {
            this.author = chunk.author;
            this.date = chunk.date;
            this.revision = chunk.revision;
            this.path = chunk.path;
            this.blockStart = chunk.blockStart;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("\n----\nPath: " + this.path);
            buf.append("\nRevision: " + this.revision);
            buf.append("\nAuthor: " + this.author);
            buf.append("\nDate: " + SVNDate.formatConsoleShortDate(this.date));
            buf.append("\nBlock start: " + this.blockStart);
            buf.append("\n");
            return buf.toString();
        }
    }
}

