/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.auth;

import com.trilead.ssh2.auth.AgentProxy;
import java.io.File;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;

public class SVNSSHAuthentication
extends SVNAuthentication {
    private char[] myPassword;
    private char[] myPassphrase;
    private File myPrivateKeyFile;
    private AgentProxy myAgentProxy;
    private int myPortNumber;
    private char[] myPrivateKeyValue;

    public static SVNSSHAuthentication newInstance(String userName, char[] password, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNSSHAuthentication(userName, password, null, null, null, null, portNumber, storageAllowed, url, isPartial);
    }

    public static SVNSSHAuthentication newInstance(String userName, File keyFile, char[] passphrase, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNSSHAuthentication(userName, null, keyFile, null, passphrase, null, portNumber, storageAllowed, url, isPartial);
    }

    public static SVNSSHAuthentication newInstance(String userName, char[] keyValue, char[] passphrase, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNSSHAuthentication(userName, null, null, keyValue, passphrase, null, portNumber, storageAllowed, url, isPartial);
    }

    public static SVNSSHAuthentication newInstance(String userName, AgentProxy agentProxy, int portNumber, SVNURL url, boolean isPartial) {
        return new SVNSSHAuthentication(userName, null, null, null, null, agentProxy, portNumber, false, url, isPartial);
    }

    public SVNSSHAuthentication(String userName, String password, int portNumber, boolean storageAllowed) {
        this(userName, password == null ? new char[]{} : password.toCharArray(), null, null, null, null, portNumber, storageAllowed, null, false);
    }

    public SVNSSHAuthentication(String userName, String password, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this(userName, password == null ? new char[]{} : password.toCharArray(), null, null, null, null, portNumber, storageAllowed, url, isPartial);
    }

    public SVNSSHAuthentication(String userName, File keyFile, String passphrase, int portNumber, boolean storageAllowed) {
        this(userName, null, keyFile, passphrase != null ? passphrase.toCharArray() : null, null, null, portNumber, storageAllowed, null, false);
    }

    public SVNSSHAuthentication(String userName, File keyFile, String passphrase, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this(userName, null, keyFile, null, passphrase != null ? passphrase.toCharArray() : null, null, portNumber, storageAllowed, url, isPartial);
    }

    public SVNSSHAuthentication(String userName, char[] privateKey, String passphrase, int portNumber, boolean storageAllowed) {
        this(userName, null, null, privateKey, passphrase != null ? passphrase.toCharArray() : null, null, portNumber, storageAllowed, null, false);
    }

    public SVNSSHAuthentication(String userName, char[] privateKey, String passphrase, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this(userName, null, null, privateKey, passphrase != null ? passphrase.toCharArray() : null, null, portNumber, storageAllowed, url, isPartial);
    }

    public SVNSSHAuthentication(String userName, AgentProxy agentProxy, int portNumber, SVNURL url, boolean isPartial) {
        this(userName, null, null, null, null, agentProxy, portNumber, false, url, isPartial);
    }

    private SVNSSHAuthentication(String userName, char[] password, File keyFile, char[] keyValue, char[] passphrase, AgentProxy agentProxy, int portNumber, boolean storageAllowed, SVNURL url, boolean isPartial) {
        super("svn.ssh", userName, storageAllowed, url, isPartial);
        this.myAgentProxy = agentProxy;
        this.myPassword = password;
        this.myPassphrase = passphrase;
        this.myPrivateKeyFile = keyFile;
        this.myPrivateKeyValue = keyValue;
        this.myPortNumber = portNumber;
    }

    public String getPassword() {
        return this.myPassword != null ? new String(this.myPassword) : null;
    }

    public char[] getPasswordValue() {
        return this.myPassword;
    }

    public String getPassphrase() {
        return this.myPassphrase != null ? new String(this.myPassphrase) : null;
    }

    public char[] getPassphraseValue() {
        return this.myPassword;
    }

    public File getPrivateKeyFile() {
        return this.myPrivateKeyFile;
    }

    public char[] getPrivateKey() {
        return this.myPrivateKeyValue;
    }

    public int getPortNumber() {
        return this.myPortNumber;
    }

    public boolean hasPrivateKey() {
        return this.myPrivateKeyFile != null || this.myPrivateKeyValue != null;
    }

    public AgentProxy getAgentProxy() {
        return this.myAgentProxy;
    }

    public void dismissSensitiveData() {
        super.dismissSensitiveData();
        SVNEncodingUtil.clearArray(this.myPassphrase);
        SVNEncodingUtil.clearArray(this.myPassword);
        SVNEncodingUtil.clearArray(this.myPrivateKeyValue);
    }

    public SVNAuthentication copy() {
        return new SVNSSHAuthentication(this.getUserName(), this.copyOf(this.myPassword), this.myPrivateKeyFile, this.copyOf(this.myPrivateKeyValue), this.copyOf(this.myPassphrase), this.myAgentProxy, this.myPortNumber, this.isStorageAllowed(), this.getURL(), this.isPartial());
    }
}

