/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.client;

import java.io.File;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.client.ISVNClientInterfaceEx;
import org.tmatesoft.svn.core.client.SVNClientAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.javahl17.SVNClientImpl;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitParameters;
import org.tmatesoft.svn.core.wc.ISVNCommitParameters;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import org.tmatesoft.svn.core.wc2.SvnCommit;

public class SVNClientEx17
extends SVNClientImpl
implements ISVNClientInterfaceEx {
    private boolean myIsCommitMissingFiles;
    private String myProxyPassword;
    private String myProxyUserName;
    private int myProxyPort;
    private String myProxyHost;
    private int mySSHPort;
    private String mySSHUserName;
    private String mySSHPassphrase;
    private String mySSHKeyPath;
    private String mySSLPassphrase;
    private String mySSLCertPath;
    private String mySSH2Password;
    private String mySSH2UserName;
    private int mySSH2Port;
    protected boolean myIsStoreSSL;
    protected ISvnCommitParameters commitParams;

    public SVNClientEx17() {
        super(null);
    }

    public void setSSLCertificateCacheEnabled(boolean enabled) {
        if (enabled != this.isSSLCertificateCacheEnabled()) {
            this.myIsStoreSSL = enabled;
            this.updateSvnOperationsFactory();
        }
    }

    public boolean isSSLCertificateCacheEnabled() {
        return this.myIsStoreSSL;
    }

    public boolean isCredentialsCacheEnabled() {
        return this.getOptions().isAuthStorageEnabled();
    }

    public void setCredentialsCacheEnabled(boolean cacheCredentials) {
        if (cacheCredentials != this.isCredentialsCacheEnabled()) {
            this.getOptions().setAuthStorageEnabled(cacheCredentials);
            this.updateSvnOperationsFactory();
        }
    }

    public void setCommitMissedFiles(boolean commitMissingFiles) {
        this.myIsCommitMissingFiles = commitMissingFiles;
        this.commitParams = SvnCodec.commitParameters(new DefaultSVNCommitParameters(){

            public ISVNCommitParameters.Action onMissingFile(File file) {
                return SVNClientEx17.this.myIsCommitMissingFiles ? DELETE : SKIP;
            }

            public ISVNCommitParameters.Action onMissingDirectory(File file) {
                return SVNClientEx17.this.myIsCommitMissingFiles ? DELETE : ERROR;
            }
        });
    }

    protected SvnCommit getSVNCommit() {
        SvnCommit commit = super.getSVNCommit();
        if (this.commitParams != null) {
            commit.setCommitParameters(this.commitParams);
        }
        return commit;
    }

    public boolean isCommitMissingFile() {
        return this.myIsCommitMissingFiles;
    }

    public void setClientSSLCertificate(String certPath, String passphrase) {
        this.mySSLCertPath = certPath;
        this.mySSLPassphrase = passphrase;
        this.updateSvnOperationsFactory();
    }

    public void setSSHCredentials(String userName, String privateKeyPath, String passphrase, int port) {
        this.mySSHKeyPath = privateKeyPath;
        this.mySSHPassphrase = passphrase;
        this.mySSHUserName = userName;
        this.mySSHPort = port;
        this.updateSvnOperationsFactory();
    }

    public void setSSHCredentials(String userName, String password, int port) {
        this.mySSH2Password = password;
        this.mySSH2UserName = userName;
        this.mySSH2Port = port;
        this.updateSvnOperationsFactory();
    }

    public void setProxy(String host, int port, String userName, String password) {
        this.myProxyHost = host;
        this.myProxyPort = port;
        this.myProxyUserName = userName;
        this.myProxyPassword = password;
        this.updateSvnOperationsFactory();
    }

    protected ISVNAuthenticationManager createAuthenticationManager(File configDir, String userName, String password, boolean allowSave) {
        SVNClientAuthenticationManager authManager = new SVNClientAuthenticationManager(configDir, allowSave, this.myIsStoreSSL, userName, password);
        authManager.setProxy(this.myProxyHost, this.myProxyPort, this.myProxyUserName, this.myProxyPassword);
        authManager.setClientSSLCertificate(this.mySSLCertPath, this.mySSLPassphrase);
        authManager.setSSHCredentials(this.mySSHUserName, this.mySSHKeyPath, this.mySSHPassphrase, this.mySSHPort);
        authManager.setSSHCredentials(this.mySSH2UserName, this.mySSH2Password, this.mySSH2Port);
        return authManager;
    }
}

