/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.ISVNSqlJetTrigger;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.wc17.db.SvnNodesPristineTrigger;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNSqlJetDeleteStatement
extends SVNSqlJetSelectStatement {
    public SVNSqlJetDeleteStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        super(sDb, fromTable);
        this.transactionMode = SqlJetTransactionMode.WRITE;
        if (SVNWCDbSchema.NODES == fromTable) {
            SvnNodesPristineTrigger trigger = new SvnNodesPristineTrigger();
            this.addTrigger(trigger);
        }
    }

    protected void beforeDelete(ISqlJetCursor cursor) {
        for (ISVNSqlJetTrigger trigger : this.getTriggers()) {
            try {
                trigger.beforeDelete(cursor);
            }
            catch (SqlJetException sqlJetException) {
                // empty catch block
            }
        }
    }

    @Override
    public long exec() throws SVNException {
        long n = 0L;
        this.statementStarted();
        while (!this.eof()) {
            try {
                this.beforeDelete(this.getCursor());
                this.getCursor().delete();
            }
            catch (SqlJetException e) {
                this.statementCompleted(e);
                SVNSqlJetDb.createSqlJetError(e);
                return n;
            }
            ++n;
        }
        this.statementCompleted(null);
        return n;
    }
}

