/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.List;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.wc2.SvnChecksum;

public class SVNSqlJetUnionStatement
extends SVNSqlJetStatement {
    private SVNSqlJetStatement[] statements;
    private int current = 0;

    public SVNSqlJetUnionStatement(SVNSqlJetDb sDb, SVNSqlJetStatement ... statements) {
        super(sDb);
        this.statements = statements;
    }

    public boolean next() throws SVNException {
        if (this.statements == null) {
            return false;
        }
        boolean next = false;
        while (!next && this.current < this.statements.length) {
            SVNSqlJetStatement stmt = this.statements[this.current];
            if (stmt != null) {
                next = stmt.next();
            }
            if (next) continue;
            ++this.current;
        }
        return next;
    }

    protected ISqlJetCursor getCursor() {
        if (this.statements == null) {
            return null;
        }
        if (this.current < this.statements.length) {
            return this.statements[this.current].getCursor();
        }
        return null;
    }

    public void reset() throws SVNException {
        this.current = 0;
        if (this.statements == null) {
            return;
        }
        SVNSqlJetStatement[] sVNSqlJetStatementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            SVNSqlJetStatement stmt = sVNSqlJetStatementArray[n2];
            stmt.reset();
            ++n2;
        }
    }

    private void updateBinds() {
        if (this.statements == null) {
            return;
        }
        SVNSqlJetStatement[] sVNSqlJetStatementArray = this.statements;
        int n = this.statements.length;
        int n2 = 0;
        while (n2 < n) {
            SVNSqlJetStatement stmt = sVNSqlJetStatementArray[n2];
            List<Object> stmtBinds = stmt.getBinds();
            stmtBinds.clear();
            stmtBinds.addAll(this.getBinds());
            ++n2;
        }
    }

    public void bindf(String format, Object ... data) throws SVNException {
        super.bindf(format, data);
        this.updateBinds();
    }

    public void bindLong(int i, long v) {
        super.bindLong(i, v);
        this.updateBinds();
    }

    public void bindString(int i, String string) {
        super.bindString(i, string);
        this.updateBinds();
    }

    public void bindNull(int i) {
        super.bindNull(i);
        this.updateBinds();
    }

    public void bindBlob(int i, byte[] serialized) {
        super.bindBlob(i, serialized);
        this.updateBinds();
    }

    public void bindChecksum(int i, SvnChecksum checksum) {
        super.bindChecksum(i, checksum);
        this.updateBinds();
    }

    public void bindProperties(int i, SVNProperties props) throws SVNException {
        super.bindProperties(i, props);
        this.updateBinds();
    }
}

