/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

class DAVKeyManager {
    private static final String CERTIFICATE_FILE = "svnkit.ssl.client-cert-file";
    private static final String CERTIFICATE_PASSPHRASE = "svnkit.ssl.client-cert-password";
    private static final String OLD_CERTIFICATE_FILE = "javasvn.ssl.client-cert-file";
    private static final String OLD_CERTIFICATE_PASSPHRASE = "javasvn.ssl.client-cert-password";
    private static KeyManager[] ourKeyManagers;
    private static boolean ourIsInitialized;

    DAVKeyManager() {
    }

    public static KeyManager[] getKeyManagers() {
        KeyStore keyStore;
        char[] passphrase;
        block22: {
            if (ourIsInitialized) {
                return ourKeyManagers;
            }
            ourIsInitialized = true;
            String certFileName = System.getProperty(CERTIFICATE_FILE, System.getProperty(OLD_CERTIFICATE_FILE));
            if (certFileName == null) {
                return null;
            }
            passphrase = null;
            String pph = System.getProperty(CERTIFICATE_PASSPHRASE, System.getProperty(OLD_CERTIFICATE_PASSPHRASE));
            if (pph != null) {
                passphrase = pph.toCharArray();
            }
            keyStore = null;
            InputStream is = null;
            try {
                try {
                    keyStore = KeyStore.getInstance("PKCS12");
                    if (keyStore != null) {
                        is = new FileInputStream(certFileName);
                        keyStore.load(is, passphrase);
                    }
                }
                catch (Throwable th) {
                    SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, th);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        KeyManagerFactory kmf = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, passphrase);
                    ourKeyManagers = kmf.getKeyManagers();
                }
            }
            catch (Throwable e) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, e);
            }
        }
        return ourKeyManagers;
    }
}

