/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.io.fs.FSClosestCopy;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.io.fs.FSHooks;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSLock;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentationCacheUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.io.fs.IFSRepresentationCacheManager;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.util.SVNLogType;

public class FSFS {
    public static final String DB_DIR = "db";
    public static final String REVS_DIR = "revs";
    public static final String REPOS_FORMAT_FILE = "format";
    public static final String DB_FORMAT_FILE = "format";
    public static final String DB_LOGS_LOCK_FILE = "db-logs.lock";
    public static final String DB_LOCK_FILE = "db.lock";
    public static final String CURRENT_FILE = "current";
    public static final String UUID_FILE = "uuid";
    public static final String FS_TYPE_FILE = "fs-type";
    public static final String TXN_CURRENT_FILE = "txn-current";
    public static final String MIN_UNPACKED_REV_FILE = "min-unpacked-rev";
    public static final String TXN_CURRENT_LOCK_FILE = "txn-current-lock";
    public static final String REVISION_PROPERTIES_DIR = "revprops";
    public static final String WRITE_LOCK_FILE = "write-lock";
    public static final String LOCKS_DIR = "locks";
    public static final String DAV_DIR = "dav";
    public static final String TRANSACTIONS_DIR = "transactions";
    public static final String TRANSACTION_PROTOS_DIR = "txn-protorevs";
    public static final String NODE_ORIGINS_DIR = "node-origins";
    public static final String REP_CACHE_DB = "rep-cache.db";
    public static final String PACK_EXT = ".pack";
    public static final String PACK_KIND_PACK = "pack";
    public static final String PACK_KIND_MANIFEST = "manifest";
    public static final String ENABLE_REP_SHARING_OPTION = "enable-rep-sharing";
    public static final String REP_SHARING_SECTION = "rep-sharing";
    public static final String PATH_CONFIG = "fsfs.conf";
    public static final String TXN_PATH_EXT = ".txn";
    public static final String TXN_MERGEINFO_PATH = "mergeinfo";
    public static final String TXN_PATH_EXT_CHILDREN = ".children";
    public static final String PATH_PREFIX_NODE = "node.";
    public static final String TXN_PATH_EXT_PROPS = ".props";
    public static final String SVN_OPAQUE_LOCK_TOKEN = "opaquelocktoken:";
    public static final String TXN_PATH_REV = "rev";
    public static final String PATH_LOCK_KEY = "path";
    public static final String CHILDREN_LOCK_KEY = "children";
    public static final String TOKEN_LOCK_KEY = "token";
    public static final String OWNER_LOCK_KEY = "owner";
    public static final String IS_DAV_COMMENT_LOCK_KEY = "is_dav_comment";
    public static final String CREATION_DATE_LOCK_KEY = "creation_date";
    public static final String EXPIRATION_DATE_LOCK_KEY = "expiration_date";
    public static final String COMMENT_LOCK_KEY = "comment";
    public static final String PRE_12_COMPAT_UNNEEDED_FILE_CONTENTS = "This file is not used by Subversion 1.3.x or later.However, its existence is required for compatibility withSubversion 1.2.x or earlier.";
    public static final int DIGEST_SUBDIR_LEN = 3;
    public static final int REPOSITORY_FORMAT = 5;
    public static final int REPOSITORY_FORMAT_LEGACY = 3;
    public static final int DB_FORMAT_PRE_17 = 4;
    public static final int DB_FORMAT = 5;
    public static final int DB_FORMAT_LOW = 1;
    public static final int LAYOUT_FORMAT_OPTION_MINIMAL_FORMAT = 3;
    public static final int MIN_CURRENT_TXN_FORMAT = 3;
    public static final int MIN_PROTOREVS_DIR_FORMAT = 3;
    public static final int MIN_NO_GLOBAL_IDS_FORMAT = 3;
    public static final int MIN_MERGE_INFO_FORMAT = 3;
    public static final int MIN_REP_SHARING_FORMAT = 4;
    public static final int MIN_PACKED_FORMAT = 4;
    public static final int MIN_KIND_IN_CHANGED_FORMAT = 4;
    public static final int MIN_PACKED_REVPROP_FORMAT = 5;
    private static long DEFAULT_MAX_FILES_PER_DIRECTORY = 1000L;
    private static final String DB_TYPE = "fsfs";
    public static final String REVISION_PROPERTIES_DB = "revprops.db";
    public static final String REVISION_PROPERTIES_TABLE = "revprop";
    public static final String MIN_UNPACKED_REVPROP = "min-unpacked-revprop";
    public static final boolean DB_FORMAT_PRE_17_USE_AS_DEFAULT = true;
    private int myDBFormat;
    private int myReposFormat;
    private String myUUID;
    private String myFSType;
    private File myRepositoryRoot;
    private File myRevisionsRoot;
    private File myRevisionPropertiesRoot;
    private File myTransactionsRoot;
    private File myLocksRoot;
    private File myDBRoot;
    private File myWriteLockFile;
    private File myCurrentFile;
    private File myTransactionCurrentFile;
    private File myTransactionCurrentLockFile;
    private File myTransactionProtoRevsRoot;
    private File myNodeOriginsDir;
    private File myRepositoryFormatFile;
    private File myDBFormatFile;
    private File myUUIDFile;
    private File myFSTypeFile;
    private File myMinUnpackedRevFile;
    private File myRepositoryCacheFile;
    private long myMaxFilesPerDirectory;
    private long myYoungestRevisionCache;
    private long myMinUnpackedRevision;
    private SVNConfigFile myConfig;
    private IFSRepresentationCacheManager myReposCacheManager;
    private SVNSqlJetDb myRevisionProperitesDb;
    private long myMinUnpackedRevProp;
    private boolean myIsHooksEnabled;

    public FSFS(File repositoryRoot) {
        this.myRepositoryRoot = repositoryRoot;
        this.myMaxFilesPerDirectory = 0L;
        this.setHooksEnabled(true);
    }

    public void setHooksEnabled(boolean enabled) {
        this.myIsHooksEnabled = enabled;
    }

    public boolean isHooksEnabled() {
        return this.myIsHooksEnabled;
    }

    public int getDBFormat() {
        return this.myDBFormat;
    }

    public long getMaxFilesPerDirectory() {
        return this.myMaxFilesPerDirectory;
    }

    public int getReposFormat() {
        return this.myReposFormat;
    }

    public void open() throws SVNException {
        this.openRoot();
        this.openDB();
    }

    public void close() throws SVNException {
        if (this.myReposCacheManager != null) {
            this.myReposCacheManager.close();
            this.myReposCacheManager = null;
        }
        if (this.myRevisionProperitesDb != null) {
            this.myRevisionProperitesDb.close();
            this.myRevisionProperitesDb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openForRecovery() throws SVNException {
        FSWriteLock writeLock;
        this.openRoot();
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                try {
                    SVNFileUtil.createFile(this.getCurrentFile(), "0 1 1\n", "US-ASCII");
                }
                catch (SVNException sVNException) {}
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
        this.openDB();
    }

    public void openRoot() throws SVNException {
        int format;
        block6: {
            FSFile formatFile = new FSFile(this.getRepositoryFormatFile());
            format = -1;
            try {
                try {
                    format = formatFile.readInt();
                }
                catch (NumberFormatException nfe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "First line of ''{0}'' contains non-digit", (Object)formatFile.getFile());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                    formatFile.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                formatFile.close();
                throw throwable;
            }
            formatFile.close();
        }
        if (format != 5 && format != 3) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_UNSUPPORTED_VERSION, "Expected repository format ''{0}'' or ''{1}''; found format ''{2}''", new Integer(3), new Integer(5), new Integer(format));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        this.myReposFormat = format;
    }

    public void openDB() throws SVNException {
        File dbCurrentFile;
        int format = this.readDBFormat();
        FSRepositoryUtil.checkReposDBFormat(format);
        this.myDBFormat = format;
        this.getFSType();
        if (this.myDBFormat >= 4) {
            this.getMinUnpackedRev();
        }
        boolean isRepSharingAllowed = true;
        SVNConfigFile config = this.loadConfig();
        if (config != null) {
            String optionValue = config.getPropertyValue(REP_SHARING_SECTION, ENABLE_REP_SHARING_OPTION);
            isRepSharingAllowed = DefaultSVNOptions.getBooleanValue(optionValue, true);
        }
        if (this.myDBFormat >= 4 && isRepSharingAllowed) {
            this.myReposCacheManager = FSRepresentationCacheUtil.open(this);
        }
        if (!(dbCurrentFile = this.getCurrentFile()).exists() || !dbCurrentFile.canRead()) {
            if (this.myReposCacheManager != null) {
                this.myReposCacheManager.close();
                this.myReposCacheManager = null;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can''t open file ''{0}''", (Object)dbCurrentFile);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (this.myDBFormat >= 5) {
            this.updateMinUnpackedRevProp();
            this.myRevisionProperitesDb = SVNSqlJetDb.open(this.getRevisionPropertiesDbPath(), SVNSqlJetDb.Mode.ReadWrite);
        }
    }

    public String getFSType() throws SVNException {
        if (this.myFSType == null) {
            FSFile fsTypeFile = new FSFile(this.getFSTypeFile());
            try {
                this.myFSType = fsTypeFile.readLine(128);
            }
            finally {
                fsTypeFile.close();
            }
            if (!DB_TYPE.equals(this.myFSType)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_UNKNOWN_FS_TYPE, "Unsupported fs type ''{0}''", (Object)this.myFSType);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        return this.myFSType;
    }

    public int readDBFormat() throws SVNException {
        int format = -1;
        FSFile formatFile = new FSFile(this.getDBFormatFile());
        try {
            try {
                format = formatFile.readInt();
                this.readOptions(formatFile, format);
            }
            catch (SVNException svne) {
                if (svne.getCause() instanceof FileNotFoundException) {
                    format = 1;
                } else if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "Can''t read first line of format file ''{0}''", (Object)formatFile.getFile());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                } else {
                    throw svne;
                }
                formatFile.close();
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "Format file ''{0}'' contains an unexpected non-digit", (Object)formatFile.getFile());
                SVNErrorManager.error(err, SVNLogType.FSFS);
                formatFile.close();
            }
        }
        finally {
            formatFile.close();
        }
        return format;
    }

    public String getUUID() throws SVNException {
        if (this.myUUID == null) {
            FSFile formatFile = new FSFile(this.getUUIDFile());
            try {
                this.myUUID = formatFile.readLine(38);
            }
            finally {
                formatFile.close();
            }
        }
        return this.myUUID;
    }

    public File getDBRoot() {
        if (this.myDBRoot == null) {
            this.myDBRoot = new File(this.myRepositoryRoot, DB_DIR);
        }
        return this.myDBRoot;
    }

    public File getWriteLockFile() {
        if (this.myWriteLockFile == null) {
            this.myWriteLockFile = new File(this.getDBRoot(), WRITE_LOCK_FILE);
        }
        return this.myWriteLockFile;
    }

    public File getUUIDFile() {
        if (this.myUUIDFile == null) {
            this.myUUIDFile = new File(this.getDBRoot(), UUID_FILE);
        }
        return this.myUUIDFile;
    }

    public File getDBRevsDir() {
        if (this.myRevisionsRoot == null) {
            this.myRevisionsRoot = new File(this.getDBRoot(), REVS_DIR);
        }
        return this.myRevisionsRoot;
    }

    public File getDBLocksDir() {
        if (this.myLocksRoot == null) {
            this.myLocksRoot = new File(this.getDBRoot(), LOCKS_DIR);
        }
        return this.myLocksRoot;
    }

    public File getFSTypeFile() {
        if (this.myFSTypeFile == null) {
            this.myFSTypeFile = new File(this.getDBRoot(), FS_TYPE_FILE);
        }
        return this.myFSTypeFile;
    }

    public File getTransactionsParentDir() {
        if (this.myTransactionsRoot == null) {
            this.myTransactionsRoot = new File(this.getDBRoot(), TRANSACTIONS_DIR);
        }
        return this.myTransactionsRoot;
    }

    public File getRepositoryRoot() {
        return this.myRepositoryRoot;
    }

    public File getRevisionPropertiesRoot() {
        if (this.myRevisionPropertiesRoot == null) {
            this.myRevisionPropertiesRoot = new File(this.getDBRoot(), REVISION_PROPERTIES_DIR);
        }
        return this.myRevisionPropertiesRoot;
    }

    public File getRepositoryFormatFile() {
        if (this.myRepositoryFormatFile == null) {
            this.myRepositoryFormatFile = new File(this.myRepositoryRoot, "format");
        }
        return this.myRepositoryFormatFile;
    }

    public File getDBFormatFile() {
        if (this.myDBFormatFile == null) {
            this.myDBFormatFile = new File(this.getDBRoot(), "format");
        }
        return this.myDBFormatFile;
    }

    public File getNodeOriginsDir() {
        if (this.myNodeOriginsDir == null) {
            this.myNodeOriginsDir = new File(this.getDBRoot(), NODE_ORIGINS_DIR);
        }
        return this.myNodeOriginsDir;
    }

    public File getCurrentFile() {
        if (this.myCurrentFile == null) {
            this.myCurrentFile = new File(this.getDBRoot(), CURRENT_FILE);
        }
        return this.myCurrentFile;
    }

    public File getRepositoryCacheFile() {
        if (this.myRepositoryCacheFile == null) {
            this.myRepositoryCacheFile = new File(this.getDBRoot(), REP_CACHE_DB);
        }
        return this.myRepositoryCacheFile;
    }

    public File getDBLogsLockFile() throws SVNException {
        File lockFile = new File(this.getDBRoot(), "locks/db-logs.lock");
        if (!lockFile.exists()) {
            try {
                SVNFileUtil.createFile(lockFile, PRE_12_COMPAT_UNNEEDED_FILE_CONTENTS, "US-ASCII");
            }
            catch (SVNException svne) {
                SVNErrorMessage err = svne.getErrorMessage().wrap("Creating db logs lock file");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        return lockFile;
    }

    public long getDatedRevision(Date date) throws SVNException {
        long latest;
        long top = latest = this.getYoungestRevision();
        long bottom = 0L;
        Date currentTime = null;
        while (bottom <= top) {
            long middle = (top + bottom) / 2L;
            currentTime = this.getRevisionTime(middle);
            if (currentTime.compareTo(date) > 0) {
                if (middle - 1L < 0L) {
                    return 0L;
                }
                Date prevTime = this.getRevisionTime(middle - 1L);
                if (prevTime.compareTo(date) < 0) {
                    return middle - 1L;
                }
                top = middle - 1L;
                continue;
            }
            if (currentTime.compareTo(date) < 0) {
                if (middle + 1L > latest) {
                    return latest;
                }
                Date nextTime = this.getRevisionTime(middle + 1L);
                if (nextTime.compareTo(date) > 0) {
                    return middle;
                }
                bottom = middle + 1L;
                continue;
            }
            return middle;
        }
        return 0L;
    }

    public long getYoungestRevision() throws SVNException {
        FSFile file = new FSFile(this.getCurrentFile());
        try {
            String line = file.readLine(180);
            int spaceIndex = line.indexOf(32);
            this.myYoungestRevisionCache = spaceIndex > 0 ? Long.parseLong(line.substring(0, spaceIndex)) : Long.parseLong(line);
            long l = this.myYoungestRevisionCache;
            return l;
        }
        catch (NumberFormatException nfe) {
            this.myYoungestRevisionCache = 0L;
        }
        finally {
            file.close();
        }
        return this.myYoungestRevisionCache;
    }

    public long getMinUnpackedRev() throws SVNException {
        FSFile file = new FSFile(this.getMinUnpackedRevFile());
        try {
            long l = this.myMinUnpackedRevision = file.readLong();
            return l;
        }
        catch (NumberFormatException nfe) {
            this.myMinUnpackedRevision = 0L;
        }
        finally {
            file.close();
        }
        return this.myMinUnpackedRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() throws SVNException {
        FSWriteLock writeLock;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                if (this.myDBFormat == 5) {
                    return;
                }
                if (this.myDBFormat < 3) {
                    File txnCurrentFile = this.getTransactionCurrentFile();
                    SVNFileUtil.createFile(txnCurrentFile, "0\n", "US-ASCII");
                    SVNFileUtil.createEmptyFile(this.getTransactionCurrentLockFile());
                }
                if (this.myDBFormat < 3) {
                    File txnProtoRevsDir = this.getTransactionProtoRevsDir();
                    txnProtoRevsDir.mkdirs();
                }
                if (this.myDBFormat < 4) {
                    SVNFileUtil.createFile(this.getMinUnpackedRevFile(), "0\n", "US-ASCII");
                }
                if (this.myDBFormat < 4) {
                    SVNFileUtil.createFile(this.getMinUnpackedRevFile(), "0\n", "US-ASCII");
                }
                if (this.myDBFormat < 5) {
                    SVNFileUtil.createFile(this.getMinUnpackedRevPropPath(), "0\n", "US-ASCII");
                    this.myRevisionProperitesDb = SVNSqlJetDb.open(this.getRevisionPropertiesDbPath(), SVNSqlJetDb.Mode.RWCreate);
                    this.myRevisionProperitesDb.execStatement(SVNWCDbStatements.REVPROP_CREATE_SCHEMA);
                }
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
            this.close();
            this.open();
        }
    }

    protected void writeDBFormat(int format, long maxFilesPerDir, boolean overwrite) throws SVNException {
        File formatFile = this.getDBFormatFile();
        SVNErrorManager.assertionFailure(format >= 1 && format <= 5, "unexpected format " + String.valueOf(format), SVNLogType.FSFS);
        String contents = null;
        contents = format >= 3 ? (maxFilesPerDir > 0L ? String.valueOf(format) + "\nlayout sharded " + maxFilesPerDir + "\n" : String.valueOf(format) + "\nlayout linear") : String.valueOf(format) + "\n";
        if (!overwrite) {
            SVNFileUtil.createFile(formatFile, contents, "US-ASCII");
        } else {
            File tmpFile;
            block8: {
                tmpFile = SVNFileUtil.createUniqueFile(formatFile.getParentFile(), formatFile.getName(), ".tmp", false);
                OutputStream os = null;
                try {
                    try {
                        os = SVNFileUtil.openFileForWriting(tmpFile);
                        os.write(contents.getBytes("US-ASCII"));
                    }
                    catch (IOException e) {
                        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                        SVNErrorManager.error(error, SVNLogType.FSFS);
                        SVNFileUtil.closeFile(os);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(os);
                    throw throwable;
                }
                SVNFileUtil.closeFile(os);
            }
            if (SVNFileUtil.isWindows) {
                SVNFileUtil.setReadonly(formatFile, false);
            }
            SVNFileUtil.rename(tmpFile, formatFile);
        }
        SVNFileUtil.setReadonly(formatFile, true);
    }

    public SVNProperties getRevisionProperties(long revision) throws SVNException {
        try {
            return this.readRevisionProperties(revision);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_REVISION && this.myDBFormat >= 5) {
                this.updateMinUnpackedRevProp();
                return this.readRevisionProperties(revision);
            }
            throw e;
        }
    }

    private SVNProperties readRevisionProperties(long revision) throws SVNException {
        this.ensureRevisionsExists(revision);
        if (this.myDBFormat < 5 || revision >= this.myMinUnpackedRevProp) {
            FSFile file = new FSFile(this.getRevisionPropertiesFile(revision, false));
            try {
                SVNProperties sVNProperties = file.readProperties(false, true);
                return sVNProperties;
            }
            finally {
                file.close();
            }
        }
        SVNSqlJetStatement stmt = this.myRevisionProperitesDb.getStatement(SVNWCDbStatements.FSFS_GET_REVPROP);
        try {
            stmt.bindLong(1, revision);
            boolean have_row = stmt.next();
            if (!have_row) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision ''{0}''", (Object)revision);
                SVNErrorManager.error(err, SVNLogType.FSFS);
                return null;
            }
            SVNProperties sVNProperties = stmt.getColumnProperties(SVNWCDbSchema.REVPROP__Fields.properties);
            return sVNProperties;
        }
        finally {
            stmt.reset();
        }
    }

    public FSRevisionRoot createRevisionRoot(long revision) throws SVNException {
        this.ensureRevisionsExists(revision);
        return new FSRevisionRoot(this, revision);
    }

    public FSTransactionRoot createTransactionRoot(FSTransactionInfo txn) throws SVNException {
        SVNProperties txnProps = this.getTransactionProperties(txn.getTxnId());
        int flags = 0;
        if (txnProps.getStringValue("svn:check-ood") != null) {
            flags |= 1;
        }
        if (txnProps.getStringValue("svn:check-locks") != null) {
            flags |= 2;
        }
        return new FSTransactionRoot(this, txn.getTxnId(), txn.getBaseRevision(), flags);
    }

    public FSTransactionInfo openTxn(String txnName) throws SVNException {
        SVNFileType kind = SVNFileType.getType(this.getTransactionDir(txnName));
        if (kind != SVNFileType.DIRECTORY) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_TRANSACTION, "No such transaction");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSTransactionRoot txnRoot = new FSTransactionRoot(this, txnName, -1L, 0);
        FSTransactionInfo localTxn = txnRoot.getTxn();
        return new FSTransactionInfo(localTxn.getBaseRevision(), txnName);
    }

    public FSRevisionNode getRevisionNode(FSID id) throws SVNException {
        FSFile revisionFile = null;
        if (id.isTxn()) {
            File file = new File(this.getTransactionDir(id.getTxnID()), PATH_PREFIX_NODE + id.getNodeID() + "." + id.getCopyID());
            revisionFile = new FSFile(file);
        } else {
            revisionFile = this.openAndSeekRevision(id.getRevision(), id.getOffset());
        }
        Map headers = null;
        try {
            headers = revisionFile.readHeader();
        }
        finally {
            revisionFile.close();
        }
        FSRevisionNode node = FSRevisionNode.fromMap(headers);
        if (node.isFreshTxnRoot()) {
            node.setFreshRootPredecessorId(node.getPredecessorId());
        }
        return node;
    }

    public Map getDirContents(FSRevisionNode revNode) throws SVNException {
        FSRepresentation txtRep = revNode.getTextRepresentation();
        if (txtRep != null && txtRep.isTxn()) {
            FSFile childrenFile = this.getTransactionRevisionNodeChildrenFile(revNode.getId());
            Map entries = null;
            try {
                SVNProperties rawEntries = childrenFile.readProperties(false, false);
                rawEntries.putAll(childrenFile.readProperties(true, false));
                rawEntries.removeNullValues();
                entries = this.parsePlainRepresentation(rawEntries, true);
            }
            finally {
                childrenFile.close();
            }
            return entries;
        }
        if (txtRep != null) {
            FSFile revisionFile = null;
            try {
                revisionFile = this.openAndSeekRepresentation(txtRep);
                String repHeader = revisionFile.readLine(160);
                if (!"PLAIN".equals(repHeader)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                revisionFile.resetDigest();
                SVNProperties rawEntries = revisionFile.readProperties(false, false);
                String checksum = revisionFile.digest();
                if (!checksum.equals(txtRep.getMD5HexDigest())) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", checksum, txtRep.getMD5HexDigest());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                Map map = this.parsePlainRepresentation(rawEntries, false);
                return map;
            }
            finally {
                if (revisionFile != null) {
                    revisionFile.close();
                }
            }
        }
        return new SVNHashMap();
    }

    public SVNProperties getProperties(FSRevisionNode revNode) throws SVNException {
        if (revNode.getPropsRepresentation() != null && revNode.getPropsRepresentation().isTxn()) {
            FSFile propsFile = null;
            try {
                propsFile = this.getTransactionRevisionNodePropertiesFile(revNode.getId());
                SVNProperties sVNProperties = propsFile.readProperties(false, true);
                return sVNProperties;
            }
            finally {
                if (propsFile != null) {
                    propsFile.close();
                }
            }
        }
        if (revNode.getPropsRepresentation() != null) {
            FSRepresentation propsRep = revNode.getPropsRepresentation();
            FSFile revisionFile = null;
            try {
                revisionFile = this.openAndSeekRepresentation(propsRep);
                String repHeader = revisionFile.readLine(160);
                if (!"PLAIN".equals(repHeader)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed representation header");
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                revisionFile.resetDigest();
                SVNProperties props = revisionFile.readProperties(false, true);
                String checksum = revisionFile.digest();
                if (!checksum.equals(propsRep.getMD5HexDigest())) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Checksum mismatch while reading representation:\n   expected:  {0}\n     actual:  {1}", checksum, propsRep.getMD5HexDigest());
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                SVNProperties sVNProperties = props;
                return sVNProperties;
            }
            finally {
                if (revisionFile != null) {
                    revisionFile.close();
                }
            }
        }
        return new SVNProperties();
    }

    public String[] getNextRevisionIDs() throws SVNException {
        SVNErrorMessage err;
        int spaceInd;
        String[] ids = new String[2];
        FSFile currentFile = new FSFile(this.getCurrentFile());
        String idsLine = null;
        try {
            idsLine = currentFile.readLine(80);
        }
        finally {
            currentFile.close();
        }
        if (idsLine == null || idsLine.length() == 0) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(err2, SVNLogType.FSFS);
        }
        if ((spaceInd = idsLine.indexOf(32)) == -1) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if ((spaceInd = (idsLine = idsLine.substring(spaceInd + 1)).indexOf(32)) == -1) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Corrupt current file");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String nodeID = idsLine.substring(0, spaceInd);
        String copyID = idsLine.substring(spaceInd + 1);
        ids[0] = nodeID;
        ids[1] = copyID;
        return ids;
    }

    public String getAndIncrementTxnKey() throws SVNException {
        FSWriteLock writeLock;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForCurrentTxn("_txn-current", this);
        synchronized (fSWriteLock) {
            String string;
            try {
                File tmpFile;
                String txnId;
                File txnCurrentFile;
                block15: {
                    writeLock.lock();
                    txnCurrentFile = this.getTransactionCurrentFile();
                    FSFile reader = new FSFile(txnCurrentFile);
                    txnId = null;
                    try {
                        txnId = reader.readLine(200);
                    }
                    finally {
                        reader.close();
                    }
                    String nextTxnId = FSRepositoryUtil.generateNextKey(txnId);
                    OutputStream txnCurrentOS = null;
                    tmpFile = null;
                    try {
                        try {
                            tmpFile = SVNFileUtil.createUniqueFile(txnCurrentFile.getParentFile(), TXN_CURRENT_FILE, ".tmp", false);
                            txnCurrentOS = SVNFileUtil.openFileForWriting(tmpFile);
                            nextTxnId = String.valueOf(nextTxnId) + "\n";
                            txnCurrentOS.write(nextTxnId.getBytes("UTF-8"));
                        }
                        catch (IOException ioe) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                            SVNFileUtil.closeFile(txnCurrentOS);
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        SVNFileUtil.closeFile(txnCurrentOS);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(txnCurrentOS);
                }
                SVNFileUtil.rename(tmpFile, txnCurrentFile);
                string = txnId;
            }
            catch (Throwable throwable) {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
                throw throwable;
            }
            writeLock.unlock();
            FSWriteLock.release(writeLock);
            return string;
        }
    }

    public Map listTransactions() {
        SVNHashMap result = new SVNHashMap();
        File txnsDir = this.getTransactionsParentDir();
        File[] entries = SVNFileListUtil.listFiles(txnsDir);
        int i = 0;
        while (i < entries.length) {
            File entry = entries[i];
            if (entry.getName().length() > TXN_PATH_EXT.length() && entry.getName().endsWith(TXN_PATH_EXT)) {
                String txnName = entry.getName().substring(0, entry.getName().lastIndexOf(TXN_PATH_EXT));
                result.put(txnName, entry);
            }
            ++i;
        }
        return result;
    }

    public File getNewRevisionFile(long newRevision) {
        if (this.myMaxFilesPerDirectory > 0L && newRevision % this.myMaxFilesPerDirectory == 0L) {
            File shardDir = new File(this.getDBRevsDir(), String.valueOf(newRevision / this.myMaxFilesPerDirectory));
            shardDir.mkdirs();
        }
        File revFile = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File shardDir = new File(this.getDBRevsDir(), String.valueOf(newRevision / this.myMaxFilesPerDirectory));
            revFile = new File(shardDir, String.valueOf(newRevision));
        } else {
            revFile = new File(this.getDBRevsDir(), String.valueOf(newRevision));
        }
        return revFile;
    }

    public File getNewRevisionPropertiesFile(long newRevision) {
        if (this.myMaxFilesPerDirectory > 0L && newRevision % this.myMaxFilesPerDirectory == 0L) {
            File shardDir = new File(this.getRevisionPropertiesRoot(), String.valueOf(newRevision / this.myMaxFilesPerDirectory));
            shardDir.mkdirs();
        }
        File revPropsFile = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File shardDir = new File(this.getRevisionPropertiesRoot(), String.valueOf(newRevision / this.myMaxFilesPerDirectory));
            revPropsFile = new File(shardDir, String.valueOf(newRevision));
        } else {
            revPropsFile = new File(this.getRevisionPropertiesRoot(), String.valueOf(newRevision));
        }
        return revPropsFile;
    }

    public File getTransactionDir(String txnID) {
        return new File(this.getTransactionsParentDir(), String.valueOf(txnID) + TXN_PATH_EXT);
    }

    public void setYoungestRevisionCache(long revision) {
        this.myYoungestRevisionCache = revision;
    }

    public void setUUID(String uuid) throws SVNException {
        File uniqueFile;
        block5: {
            uniqueFile = SVNFileUtil.createUniqueFile(this.getDBRoot(), UUID_FILE, ".tmp", false);
            uuid = String.valueOf(uuid) + '\n';
            OutputStream uuidOS = null;
            try {
                try {
                    uuidOS = SVNFileUtil.openFileForWriting(uniqueFile);
                    uuidOS.write(uuid.getBytes("US-ASCII"));
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error writing repository UUID to ''{0}''", (Object)this.getUUIDFile());
                    err.setChildErrorMessage(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage()));
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                    SVNFileUtil.closeFile(uuidOS);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(uuidOS);
                throw throwable;
            }
            SVNFileUtil.closeFile(uuidOS);
        }
        SVNFileUtil.rename(uniqueFile, this.getUUIDFile());
    }

    public File getRevisionPropertiesFile(long revision, boolean returnMissing) throws SVNException {
        File revPropsFile = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File shardDir = new File(this.getRevisionPropertiesRoot(), String.valueOf(revision / this.myMaxFilesPerDirectory));
            revPropsFile = new File(shardDir, String.valueOf(revision));
        } else {
            revPropsFile = new File(this.getRevisionPropertiesRoot(), String.valueOf(revision));
        }
        if (!revPropsFile.exists() && !returnMissing) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(revision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return revPropsFile;
    }

    public FSFile openAndSeekRepresentation(FSRepresentation rep) throws SVNException {
        if (!rep.isTxn()) {
            return this.openAndSeekRevision(rep.getRevision(), rep.getOffset());
        }
        return this.openAndSeekTransaction(rep);
    }

    public File getNextIDsFile(String txnID) {
        return new File(this.getTransactionDir(txnID), "next-ids");
    }

    public void writeNextIDs(String txnID, String nodeID, String copyID) throws SVNException {
        block5: {
            OutputStream nextIdsFile = null;
            try {
                try {
                    nextIdsFile = SVNFileUtil.openFileForWriting(this.getNextIDsFile(txnID));
                    String ids = String.valueOf(nodeID) + " " + copyID + "\n";
                    nextIdsFile.write(ids.getBytes("UTF-8"));
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                    SVNFileUtil.closeFile(nextIdsFile);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(nextIdsFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(nextIdsFile);
        }
    }

    public void changeTransactionProperties(String txnId, SVNProperties txnProperties) throws SVNException {
        for (String propName : txnProperties.nameSet()) {
            SVNPropertyValue propValue = txnProperties.getSVNPropertyValue(propName);
            this.setTransactionProperty(txnId, propName, propValue);
        }
    }

    public void setTransactionProperty(String txnID, String name, SVNPropertyValue propertyValue) throws SVNException {
        FSRepositoryUtil.validateProperty(name, propertyValue);
        SVNWCProperties revProps = new SVNWCProperties(this.getTransactionPropertiesFile(txnID), null);
        revProps.setPropertyValue(name, propertyValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionProperty(long revision, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        this.ensureRevisionsExists(revision);
        if (this.myDBFormat < 5 || revision >= this.myMinUnpackedRevProp) {
            FSWriteLock writeLock;
            FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(this);
            synchronized (fSWriteLock) {
                try {
                    writeLock.lock();
                    SVNWCProperties revProps = new SVNWCProperties(this.getRevisionPropertiesFile(revision, false), null);
                    revProps.setPropertyValue(propertyName, propertyValue);
                }
                finally {
                    writeLock.unlock();
                    FSWriteLock.release(writeLock);
                }
            }
        }
        SVNProperties revisionProperties = this.getRevisionProperties(revision);
        revisionProperties.put(propertyName, propertyValue);
        SVNSqlJetStatement stmt = this.myRevisionProperitesDb.getStatement(SVNWCDbStatements.FSFS_SET_REVPROP);
        try {
            stmt.insert(revision, SVNSkel.createPropList(revisionProperties.asMap()).getData());
        }
        finally {
            stmt.reset();
        }
    }

    public SVNProperties getTransactionProperties(String txnID) throws SVNException {
        FSFile txnPropsFile = new FSFile(this.getTransactionPropertiesFile(txnID));
        try {
            SVNProperties sVNProperties = txnPropsFile.readProperties(false, true);
            return sVNProperties;
        }
        finally {
            txnPropsFile.close();
        }
    }

    public File getTransactionPropertiesFile(String txnID) {
        return new File(this.getTransactionDir(txnID), "props");
    }

    public File getTransactionProtoRevsDir() {
        if (this.myTransactionProtoRevsRoot == null) {
            this.myTransactionProtoRevsRoot = new File(this.getDBRoot(), TRANSACTION_PROTOS_DIR);
        }
        return this.myTransactionProtoRevsRoot;
    }

    public File getTransactionProtoRevFile(String txnID) {
        if (this.myDBFormat >= 3) {
            return new File(this.getTransactionProtoRevsDir(), String.valueOf(txnID) + ".rev");
        }
        return new File(this.getTransactionDir(txnID), TXN_PATH_REV);
    }

    public File getTransactionProtoRevLockFile(String txnID) {
        if (this.myDBFormat >= 3) {
            return new File(this.getTransactionProtoRevsDir(), String.valueOf(txnID) + ".rev-lock");
        }
        return new File(this.getTransactionDir(txnID), "rev-lock");
    }

    public void purgeTxn(String txnID) throws SVNException {
        SVNFileUtil.deleteAll(this.getTransactionDir(txnID), true);
        if (this.getDBFormat() >= 3) {
            SVNFileUtil.deleteFile(this.getTransactionProtoRevFile(txnID));
            SVNFileUtil.deleteFile(this.getTransactionProtoRevLockFile(txnID));
        }
    }

    public void createNewTxnNodeRevisionFromRevision(String txnID, FSRevisionNode sourceNode) throws SVNException {
        if (sourceNode.getId().isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Copying from transactions not allowed");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSRevisionNode revNode = FSRevisionNode.dumpRevisionNode(sourceNode);
        revNode.setPredecessorId(sourceNode.getId());
        revNode.setCount(revNode.getCount() + 1L);
        revNode.setCopyFromPath(null);
        revNode.setIsFreshTxnRoot(true);
        revNode.setCopyFromRevision(-1L);
        revNode.setId(FSID.createTxnId(sourceNode.getId().getNodeID(), sourceNode.getId().getCopyID(), txnID));
        this.putTxnRevisionNode(revNode.getId(), revNode);
    }

    public void putTxnRevisionNode(FSID id, FSRevisionNode revNode) throws SVNException {
        block6: {
            if (!id.isTxn()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Attempted to write to non-transaction");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            OutputStream revNodeFile = null;
            try {
                try {
                    revNodeFile = SVNFileUtil.openFileForWriting(this.getTransactionRevNodeFile(id));
                    this.writeTxnNodeRevision(revNodeFile, revNode);
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                    SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                    SVNFileUtil.closeFile(revNodeFile);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(revNodeFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(revNodeFile);
        }
    }

    public File getTransactionRevNodeFile(FSID id) {
        return new File(this.getTransactionDir(id.getTxnID()), PATH_PREFIX_NODE + id.getNodeID() + "." + id.getCopyID());
    }

    public void writeTxnNodeRevision(OutputStream revNodeFile, FSRevisionNode revNode) throws IOException {
        String id = "id: " + revNode.getId() + "\n";
        revNodeFile.write(id.getBytes("UTF-8"));
        String type = "type: " + revNode.getType() + "\n";
        revNodeFile.write(type.getBytes("UTF-8"));
        if (revNode.getPredecessorId() != null) {
            String predId = "pred: " + revNode.getPredecessorId() + "\n";
            revNodeFile.write(predId.getBytes("UTF-8"));
        }
        String count = "count: " + revNode.getCount() + "\n";
        revNodeFile.write(count.getBytes("UTF-8"));
        if (revNode.getTextRepresentation() != null) {
            FSRepresentation txtRep = revNode.getTextRepresentation();
            String textRepresentation = "text: " + (txtRep.getTxnId() != null && revNode.getType() == SVNNodeKind.DIR ? "-1" : txtRep.getStringRepresentation(this.myDBFormat)) + "\n";
            revNodeFile.write(textRepresentation.getBytes("UTF-8"));
        }
        if (revNode.getPropsRepresentation() != null) {
            FSRepresentation propRep = revNode.getPropsRepresentation();
            String propsRepresentation = "props: " + (propRep.getTxnId() != null ? "-1" : propRep.getStringRepresentation(this.myDBFormat)) + "\n";
            revNodeFile.write(propsRepresentation.getBytes("UTF-8"));
        }
        String cpath = "cpath: " + revNode.getCreatedPath() + "\n";
        revNodeFile.write(cpath.getBytes("UTF-8"));
        if (revNode.getCopyFromPath() != null) {
            String copyFromPath = "copyfrom: " + revNode.getCopyFromRevision() + " " + revNode.getCopyFromPath() + "\n";
            revNodeFile.write(copyFromPath.getBytes("UTF-8"));
        }
        if (revNode.getCopyRootRevision() != revNode.getId().getRevision() || !revNode.getCopyRootPath().equals(revNode.getCreatedPath())) {
            String copyroot = "copyroot: " + revNode.getCopyRootRevision() + " " + revNode.getCopyRootPath() + "\n";
            revNodeFile.write(copyroot.getBytes("UTF-8"));
        }
        if (revNode.isFreshTxnRoot()) {
            String isFreshRootStr = "is-fresh-txn-root: y\n";
            revNodeFile.write(isFreshRootStr.getBytes("UTF-8"));
        }
        if (this.supportsMergeInfo()) {
            if (revNode.getMergeInfoCount() > 0L) {
                String mergeInfoCntStr = "minfo-cnt: " + revNode.getMergeInfoCount() + "\n";
                revNodeFile.write(mergeInfoCntStr.getBytes("UTF-8"));
            }
            if (revNode.hasMergeInfo()) {
                String hasMergeInfoStr = "minfo-here: y\n";
                revNodeFile.write(hasMergeInfoStr.getBytes("UTF-8"));
            }
        }
        revNodeFile.write("\n".getBytes("UTF-8"));
    }

    public SVNLock getLock(String repositoryPath, boolean haveWriteLock, boolean throwError) throws SVNException {
        SVNLock lock = this.fetchLockFromDigestFile(null, repositoryPath = SVNPathUtil.canonicalizeAbsolutePath(repositoryPath), null);
        if (lock == null) {
            if (!throwError) {
                return null;
            }
            SVNErrorManager.error(FSErrors.errorNoSuchLock(repositoryPath, this), SVNLogType.FSFS);
        }
        Date current = new Date(System.currentTimeMillis());
        if (lock.getExpirationDate() != null && current.compareTo(lock.getExpirationDate()) > 0) {
            if (haveWriteLock) {
                this.deleteLock(lock);
            }
            if (!throwError) {
                return null;
            }
            SVNErrorManager.error(FSErrors.errorLockExpired(lock.getID(), this), SVNLogType.FSFS);
        }
        return lock;
    }

    public void deleteLock(SVNLock lock) throws SVNException {
        String reposPath = lock.getPath();
        String childToKill = null;
        ArrayList children = new ArrayList();
        while (true) {
            this.fetchLockFromDigestFile(null, reposPath, children);
            if (childToKill != null) {
                children.remove(childToKill);
            }
            if (children.size() == 0) {
                childToKill = this.getDigestFromRepositoryPath(reposPath);
                File digestFile = this.getDigestFileFromRepositoryPath(reposPath);
                SVNFileUtil.deleteFile(digestFile);
            } else {
                this.writeDigestLockFile(null, children, reposPath, false);
                childToKill = null;
            }
            if ("/".equals(reposPath)) break;
            if ("".equals(reposPath = SVNPathUtil.removeTail(reposPath))) {
                reposPath = "/";
            }
            children.clear();
        }
    }

    public void walkDigestFiles(File digestFile, ISVNLockHandler getLocksHandler, boolean haveWriteLock) throws SVNException {
        LinkedList children = new LinkedList();
        SVNLock lock = this.fetchLockFromDigestFile(digestFile, null, children);
        if (lock != null) {
            Date current = new Date(System.currentTimeMillis());
            if (lock.getExpirationDate() == null || current.compareTo(lock.getExpirationDate()) < 0) {
                getLocksHandler.handleLock(lock.getPath(), lock, null);
            } else if (haveWriteLock) {
                this.deleteLock(lock);
            }
        }
        if (children.isEmpty()) {
            return;
        }
        for (String digestName : children) {
            File parent = new File(this.getDBLocksDir(), digestName.substring(0, 3));
            File childDigestFile = new File(parent, digestName);
            this.walkDigestFiles(childDigestFile, getLocksHandler, haveWriteLock);
        }
    }

    public SVNLock getLockHelper(String repositoryPath, boolean haveWriteLock) throws SVNException {
        SVNLock lock = null;
        try {
            lock = this.getLock(repositoryPath, haveWriteLock, false);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_SUCH_LOCK || svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_LOCK_EXPIRED) {
                return null;
            }
            throw svne;
        }
        return lock;
    }

    public SVNLock fetchLockFromDigestFile(File digestFile, String repositoryPath, Collection children) throws SVNException {
        SVNProperties lockProps;
        block15: {
            File digestLockFile = digestFile == null ? this.getDigestFileFromRepositoryPath(repositoryPath) : digestFile;
            lockProps = null;
            if (digestLockFile.exists()) {
                FSFile reader = new FSFile(digestLockFile);
                try {
                    try {
                        lockProps = reader.readProperties(false, true);
                    }
                    catch (SVNException svne) {
                        SVNErrorMessage err = svne.getErrorMessage().wrap("Can't parse lock/entries hashfile ''{0}''", digestLockFile);
                        SVNErrorManager.error(err, SVNLogType.FSFS);
                        reader.close();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
            } else {
                lockProps = new SVNProperties();
            }
        }
        FSLock lock = null;
        String lockPath = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(PATH_LOCK_KEY));
        if (lockPath != null) {
            String creationTime;
            String davComment;
            String lockOwner;
            String lockToken = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(TOKEN_LOCK_KEY));
            if (lockToken == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this), SVNLogType.FSFS);
            }
            if ((lockOwner = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(OWNER_LOCK_KEY))) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this), SVNLogType.FSFS);
            }
            if ((davComment = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(IS_DAV_COMMENT_LOCK_KEY))) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this), SVNLogType.FSFS);
            }
            if ((creationTime = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(CREATION_DATE_LOCK_KEY))) == null) {
                SVNErrorManager.error(FSErrors.errorCorruptLockFile(lockPath, this), SVNLogType.FSFS);
            }
            Date creationDate = SVNDate.parseDateString(creationTime);
            String expirationTime = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(EXPIRATION_DATE_LOCK_KEY));
            Date expirationDate = null;
            if (expirationTime != null) {
                expirationDate = SVNDate.parseDateString(expirationTime);
            }
            String comment = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(COMMENT_LOCK_KEY));
            lock = new FSLock(lockPath, lockToken, lockOwner, comment, creationDate, expirationDate, "1".equals(davComment));
        }
        String childEntries = SVNPropertyValue.getPropertyAsString(lockProps.getSVNPropertyValue(CHILDREN_LOCK_KEY));
        if (children != null && childEntries != null) {
            String[] digests = childEntries.split("\n");
            int i = 0;
            while (i < digests.length) {
                children.add(digests[i]);
                ++i;
            }
        }
        return lock;
    }

    public File getDigestFileFromRepositoryPath(String repositoryPath) throws SVNException {
        String digest = this.getDigestFromRepositoryPath(repositoryPath);
        File parent = new File(this.getDBLocksDir(), digest.substring(0, 3));
        return new File(parent, digest);
    }

    public String getDigestFromRepositoryPath(String repositoryPath) throws SVNException {
        repositoryPath = SVNPathUtil.canonicalizeAbsolutePath(repositoryPath);
        MessageDigest digestFromPath = null;
        try {
            digestFromPath = MessageDigest.getInstance("MD5");
            digestFromPath.update(repositoryPath.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException nsae) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", (Object)nsae.getLocalizedMessage());
            SVNErrorManager.error(err, nsae, SVNLogType.FSFS);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
        return SVNFileUtil.toHexDigest(digestFromPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPath(String path, String token, String username, boolean breakLock, boolean enableHooks) throws SVNException {
        FSWriteLock writeLock;
        path = SVNPathUtil.canonicalizeAbsolutePath(path);
        String[] paths = new String[]{path};
        if (!breakLock && username == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot unlock path ''{0}'', no authenticated username available", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (enableHooks && this.isHooksEnabled()) {
            FSHooks.runPreUnlockHook(this.myRepositoryRoot, path, username);
        }
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                this.unlock(path, token, username, breakLock);
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
        if (enableHooks && this.isHooksEnabled()) {
            try {
                FSHooks.runPostUnlockHook(this.myRepositoryRoot, paths, username);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_UNLOCK_HOOK_FAILED, "Unlock succeeded, but post-unlock hook failed");
                err.setChildErrorMessage(svne.getErrorMessage());
                SVNErrorManager.error(err, svne, SVNLogType.FSFS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock lockPath(String path, String token, String username, String comment, Date expirationDate, long currentRevision, boolean stealLock, boolean isDAVComment) throws SVNException {
        FSWriteLock writeLock;
        path = SVNPathUtil.canonicalizeAbsolutePath(path);
        String[] paths = new String[]{path};
        if (username == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot lock path ''{0}'', no authenticated username available.", (Object)path);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String customToken = null;
        if (this.isHooksEnabled() && (customToken = FSHooks.runPreLockHook(this.myRepositoryRoot, path, username, comment, stealLock)) != null) {
            token = customToken;
        }
        SVNLock lock = null;
        FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLockForDB(this);
        synchronized (fSWriteLock) {
            try {
                writeLock.lock();
                lock = this.lock(path, token, username, comment, expirationDate, currentRevision, stealLock, isDAVComment);
            }
            finally {
                writeLock.unlock();
                FSWriteLock.release(writeLock);
            }
        }
        if (this.isHooksEnabled()) {
            try {
                FSHooks.runPostLockHook(this.myRepositoryRoot, paths, username);
            }
            catch (SVNException svne) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_LOCK_HOOK_FAILED, "Lock succeeded, but post-lock hook failed");
                err.setChildErrorMessage(svne.getErrorMessage());
                SVNErrorManager.error(err, svne, SVNLogType.FSFS);
            }
        }
        return lock;
    }

    public SVNProperties compoundMetaProperties(long revision) throws SVNException {
        SVNProperties metaProperties = new SVNProperties();
        SVNProperties revProps = this.getRevisionProperties(revision);
        String uuid = this.getUUID();
        String rev = String.valueOf(revision);
        metaProperties.put("svn:entry:last-author", revProps.getStringValue("svn:author"));
        metaProperties.put("svn:entry:committed-date", revProps.getStringValue("svn:date"));
        metaProperties.put("svn:entry:committed-rev", rev);
        metaProperties.put("svn:entry:uuid", uuid);
        return metaProperties;
    }

    public long getDeletedRevision(String path, long startRev, long endRev) throws SVNException {
        FSClosestCopy closestCopy;
        FSID endNodeId;
        FSRevisionNode endNode;
        FSRevisionRoot endRoot;
        FSID startNodeId;
        block15: {
            SVNErrorMessage err;
            if (FSRepository.isInvalidRevision(startRev)) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid start revision {0}", (Object)new Long(startRev));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (FSRepository.isInvalidRevision(endRev)) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid end revision {0}", (Object)new Long(endRev));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (startRev > endRev) {
                long tmpRev = endRev;
                endRev = startRev;
                startRev = tmpRev;
            }
            FSRevisionRoot startRoot = this.createRevisionRoot(startRev);
            FSRevisionNode startNode = null;
            try {
                startNode = startRoot.getRevisionNode(path);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    return -1L;
                }
                throw svne;
            }
            startNodeId = startNode.getId();
            endRoot = this.createRevisionRoot(endRev);
            endNode = null;
            try {
                endNode = endRoot.getRevisionNode(path);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) break block15;
                throw svne;
            }
        }
        if (endNode != null && startNodeId.compareTo(endNodeId = endNode.getId()) != -1 && ((closestCopy = endRoot.getClosestCopy(path)) == null || closestCopy.getRevisionRoot() == null || closestCopy.getRevisionRoot().getRevision() <= startRev)) {
            return -1L;
        }
        long midRev = (startRev + endRev) / 2L;
        while (true) {
            FSRevisionRoot root = this.createRevisionRoot(midRev);
            FSRevisionNode node = null;
            try {
                node = root.getRevisionNode(path);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    endRev = midRev;
                    midRev = (startRev + endRev) / 2L;
                }
                throw svne;
            }
            if (node == null) continue;
            FSID currentNodeId = node.getId();
            int nodeRelationship = startNodeId.compareTo(currentNodeId);
            FSClosestCopy closestCopy2 = root.getClosestCopy(path);
            if (nodeRelationship == -1 || closestCopy2 != null && closestCopy2.getRevisionRoot() != null && closestCopy2.getRevisionRoot().getRevision() > startRev) {
                endRev = midRev;
                midRev = (startRev + endRev) / 2L;
                continue;
            }
            if (endRev - midRev == 1L) {
                return endRev;
            }
            startRev = midRev;
            midRev = (startRev + endRev) / 2L;
        }
    }

    public SVNLocationEntry getPreviousLocation(String path, long revision, long[] appearedRevision) throws SVNException {
        FSRevisionRoot root;
        FSClosestCopy closestCopy;
        if (appearedRevision != null && appearedRevision.length > 0) {
            appearedRevision[0] = -1L;
        }
        if ((closestCopy = (root = this.createRevisionRoot(revision)).getClosestCopy(path)) == null) {
            return null;
        }
        FSRevisionRoot copyTargetRoot = closestCopy.getRevisionRoot();
        if (copyTargetRoot == null) {
            return null;
        }
        String copyTargetPath = closestCopy.getPath();
        FSRevisionNode copyFromNode = copyTargetRoot.getRevisionNode(copyTargetPath);
        String copyFromPath = copyFromNode.getCopyFromPath();
        long copyFromRevision = copyFromNode.getCopyFromRevision();
        String remainder = "";
        if (!path.equals(copyTargetPath) && (remainder = path.substring(copyTargetPath.length())).startsWith("/")) {
            remainder = remainder.substring(1);
        }
        String previousPath = SVNPathUtil.getAbsolutePath(SVNPathUtil.append(copyFromPath, remainder));
        if (appearedRevision != null && appearedRevision.length > 0) {
            appearedRevision[0] = copyTargetRoot.getRevision();
        }
        return new SVNLocationEntry(copyFromRevision, previousPath);
    }

    public String getNodeOrigin(String nodeID) throws SVNException {
        SVNProperties nodeOrigins = this.getNodeOriginsFromFile(nodeID);
        if (nodeOrigins != null) {
            return nodeOrigins.getStringValue(nodeID);
        }
        return null;
    }

    public void setNodeOrigin(String nodeID, FSID nodeRevisionID) throws SVNException {
        File nodeOriginsDir = this.getNodeOriginsDir();
        this.ensureDirExists(nodeOriginsDir, true);
        SVNProperties nodeOrigins = this.getNodeOriginsFromFile(nodeID);
        if (nodeOrigins == null) {
            nodeOrigins = new SVNProperties();
        }
        String oldNodeRevID = nodeOrigins.getStringValue(nodeID);
        String nodeRevIDToStore = nodeRevisionID.toString();
        if (oldNodeRevID != null && !nodeRevIDToStore.equals(oldNodeRevID)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Node origin for ''{0}'' exists with a different value ({1}) than what we were about to store ({2})", nodeID, oldNodeRevID, nodeRevIDToStore);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        nodeOrigins.put(nodeID, nodeRevIDToStore);
        File nodeOriginFile = this.getNodeOriginFile(nodeID);
        File tmpFile = SVNFileUtil.createUniqueFile(nodeOriginFile.getParentFile(), nodeOriginFile.getName(), ".tmp", false);
        SVNWCProperties.setProperties(nodeOrigins, nodeOriginFile, tmpFile, "END");
    }

    public boolean supportsMergeInfo() {
        return this.myDBFormat >= 3;
    }

    public void readOptions(FSFile formatFile, int formatNumber) throws SVNException {
        while (true) {
            String line = null;
            try {
                line = formatFile.readLine(80);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.STREAM_UNEXPECTED_EOF) break;
            }
            if (formatNumber >= 3 && line.startsWith("layout ")) {
                String optionValue = line.substring(7);
                if (optionValue.equals("linear")) {
                    this.myMaxFilesPerDirectory = 0L;
                    continue;
                }
                if (optionValue.startsWith("sharded ")) {
                    optionValue = optionValue.substring(8);
                    try {
                        this.myMaxFilesPerDirectory = Long.parseLong(optionValue);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "Format file ''{0}'' contains an unexpected non-digit", (Object)formatFile.getFile());
                        SVNErrorManager.error(err, SVNLogType.FSFS);
                    }
                    continue;
                }
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_VERSION_FILE_FORMAT, "''{0}'' contains invalid filesystem format option ''{1}''", formatFile.getFile(), line);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    public IFSRepresentationCacheManager getRepositoryCacheManager() {
        return this.myReposCacheManager;
    }

    public static File findRepositoryRoot(File path) {
        if (path == null) {
            path = new File("");
        }
        File rootPath = path;
        while (!FSFS.isRepositoryRoot(rootPath)) {
            if ((rootPath = rootPath.getParentFile()) != null) continue;
            return null;
        }
        return rootPath;
    }

    public static String findRepositoryRoot(String host, String path) {
        if (path == null) {
            path = "";
        }
        String testPath = host != null ? SVNPathUtil.append("\\\\" + host, path) : path;
        testPath = testPath.replaceFirst("\\|", "\\:");
        File rootPath = new File(testPath).getAbsoluteFile();
        while (!FSFS.isRepositoryRoot(rootPath)) {
            if (rootPath.getParentFile() == null) {
                return null;
            }
            path = SVNPathUtil.removeTail(path);
            rootPath = rootPath.getParentFile();
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static long getDefaultMaxFilesPerDirectory() {
        return DEFAULT_MAX_FILES_PER_DIRECTORY;
    }

    public static void setDefaultMaxFilesPerDirectory(long maxFilesPerDirectory) {
        DEFAULT_MAX_FILES_PER_DIRECTORY = maxFilesPerDirectory;
    }

    protected boolean isPackedRevision(long revision) {
        return revision < this.myMinUnpackedRevision;
    }

    protected File getNodeOriginFile(String nodeID) {
        String nodeIDMinusLastChar = nodeID.length() == 1 ? "0" : nodeID.substring(0, nodeID.length() - 1);
        return new File(this.getNodeOriginsDir(), nodeIDMinusLastChar);
    }

    protected FSFile getTransactionRevisionPrototypeFile(String txnID) {
        File revFile = this.getTransactionProtoRevFile(txnID);
        return new FSFile(revFile);
    }

    protected FSFile getTransactionChangesFile(String txnID) {
        File file = new File(this.getTransactionDir(txnID), "changes");
        return new FSFile(file);
    }

    protected FSFile getTransactionRevisionNodeChildrenFile(FSID txnID) {
        File childrenFile = new File(this.getTransactionDir(txnID.getTxnID()), PATH_PREFIX_NODE + txnID.getNodeID() + "." + txnID.getCopyID() + TXN_PATH_EXT_CHILDREN);
        return new FSFile(childrenFile);
    }

    protected FSFile getRevisionFSFile(long revision) throws SVNException {
        File revisionFile = this.getRevisionFile(revision);
        if (!revisionFile.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(revision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return new FSFile(revisionFile);
    }

    protected FSFile getPackOrRevisionFSFile(long revision) throws SVNException {
        File file = this.getAbsoluteRevisionPath(revision);
        if (!file.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(revision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return new FSFile(file);
    }

    protected File getAbsoluteRevisionPath(long revision) throws SVNException {
        if (!this.isPackedRevision(revision)) {
            File revFile = this.getRevisionFile(revision);
            if (revFile.exists()) {
                return revFile;
            }
            this.getMinUnpackedRev();
            if (!this.isPackedRevision(revision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Revision file ''{0}'' does not exist, and r{1} is not packed", revFile, String.valueOf(revision));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        return this.getPackedRevPath(revision, PACK_KIND_PACK);
    }

    protected FSFile getTransactionRevisionNodePropertiesFile(FSID id) {
        File revNodePropsFile = new File(this.getTransactionDir(id.getTxnID()), PATH_PREFIX_NODE + id.getNodeID() + "." + id.getCopyID() + TXN_PATH_EXT_PROPS);
        return new FSFile(revNodePropsFile);
    }

    protected File getPackedRevPath(long revision, String kind) throws SVNException {
        SVNErrorManager.assertionFailure(this.myMaxFilesPerDirectory > 0L, "max files per directory is 0 or negative: " + String.valueOf(this.myMaxFilesPerDirectory), SVNLogType.FSFS);
        SVNErrorManager.assertionFailure(this.isPackedRevision(revision), "revision " + String.valueOf(revision) + " is not packed", SVNLogType.FSFS);
        File file = new File(this.getDBRevsDir(), String.valueOf(revision / this.myMaxFilesPerDirectory) + PACK_EXT);
        file = new File(file, kind);
        return file;
    }

    protected File getPackDir(long revision) {
        return new File(this.getDBRevsDir(), String.valueOf(revision) + PACK_EXT);
    }

    protected File getPackFile(long revision) {
        return new File(this.getPackDir(revision), PACK_KIND_PACK);
    }

    protected File getManifestFile(long revision) {
        return new File(this.getPackDir(revision), PACK_KIND_MANIFEST);
    }

    protected File getRevisionFile(long revision) throws SVNException {
        SVNErrorManager.assertionFailure(!this.isPackedRevision(revision), "revision " + String.valueOf(revision) + " is not expected to be packed", SVNLogType.FSFS);
        File revisionFile = null;
        if (this.myMaxFilesPerDirectory > 0L) {
            File shardDir = new File(this.getDBRevsDir(), String.valueOf(revision / this.myMaxFilesPerDirectory));
            revisionFile = new File(shardDir, String.valueOf(revision));
        } else {
            revisionFile = new File(this.getDBRevsDir(), String.valueOf(revision));
        }
        return revisionFile;
    }

    protected File getMinUnpackedRevFile() {
        if (this.myMinUnpackedRevFile == null) {
            this.myMinUnpackedRevFile = new File(this.getDBRoot(), MIN_UNPACKED_REV_FILE);
        }
        return this.myMinUnpackedRevFile;
    }

    protected File getTransactionCurrentFile() {
        if (this.myTransactionCurrentFile == null) {
            this.myTransactionCurrentFile = new File(this.getDBRoot(), TXN_CURRENT_FILE);
        }
        return this.myTransactionCurrentFile;
    }

    protected File getTransactionCurrentLockFile() {
        if (this.myTransactionCurrentLockFile == null) {
            this.myTransactionCurrentLockFile = new File(this.getDBRoot(), TXN_CURRENT_LOCK_FILE);
        }
        return this.myTransactionCurrentLockFile;
    }

    protected File getConfigFile() {
        return new File(this.getDBRoot(), PATH_CONFIG);
    }

    protected void writeCurrentFile(long revision, String nextNodeID, String nextCopyID) throws SVNException, IOException {
        String line = null;
        line = this.getDBFormat() >= 3 ? String.valueOf(revision) + "\n" : String.valueOf(revision) + " " + nextNodeID + " " + nextCopyID + "\n";
        File currentFile = this.getCurrentFile();
        File tmpCurrentFile = SVNFileUtil.createUniqueFile(currentFile.getParentFile(), currentFile.getName(), ".tmp", false);
        OutputStream currentOS = null;
        try {
            currentOS = SVNFileUtil.openFileForWriting(tmpCurrentFile);
            currentOS.write(line.getBytes("US-ASCII"));
        }
        finally {
            SVNFileUtil.closeFile(currentOS);
        }
        SVNFileUtil.rename(tmpCurrentFile, currentFile);
    }

    protected long getPackedOffset(long revision) throws SVNException {
        LinkedList<Long> manifest;
        block8: {
            File manifestFile = this.getPackedRevPath(revision, PACK_KIND_MANIFEST);
            BufferedReader reader = null;
            manifest = new LinkedList<Long>();
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(SVNFileUtil.openFileForReading(manifestFile)));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        Long offset = null;
                        try {
                            offset = Long.valueOf(line);
                        }
                        catch (NumberFormatException nfe) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT);
                            SVNErrorManager.error(err, SVNLogType.FSFS);
                        }
                        manifest.add(offset);
                    }
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                    SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                    SVNFileUtil.closeFile(reader);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(reader);
                throw throwable;
            }
            SVNFileUtil.closeFile(reader);
        }
        Long revOffsetLong = (Long)manifest.get((int)(revision % this.myMaxFilesPerDirectory));
        SVNErrorManager.assertionFailure(revOffsetLong != null, "offset for revision " + String.valueOf(revision) + " is null", SVNLogType.FSFS);
        return revOffsetLong;
    }

    private SVNConfigFile loadConfig() {
        File confFile = this.getConfigFile();
        if (this.myDBFormat < 4 || !confFile.exists()) {
            return null;
        }
        this.myConfig = new SVNConfigFile(confFile);
        return this.myConfig;
    }

    private void ensureRevisionsExists(long revision) throws SVNException {
        SVNErrorMessage err;
        if (FSRepository.isInvalidRevision(revision)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Invalid revision number ''{0}''", (Object)new Long(revision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (revision <= this.myYoungestRevisionCache) {
            return;
        }
        this.getYoungestRevision();
        if (revision <= this.myYoungestRevisionCache) {
            return;
        }
        err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "No such revision {0}", (Object)String.valueOf(revision));
        SVNErrorManager.error(err, SVNLogType.FSFS);
    }

    private SVNProperties getNodeOriginsFromFile(String nodeID) throws SVNException {
        File nodeOriginFile = this.getNodeOriginFile(nodeID);
        if (!nodeOriginFile.exists()) {
            return null;
        }
        FSFile reader = new FSFile(nodeOriginFile);
        return reader.readProperties(false, true);
    }

    private void unlock(String path, String token, String username, boolean breakLock) throws SVNException {
        SVNLock lock = this.getLock(path, true, true);
        if (!breakLock) {
            if (token == null || !token.equals(lock.getID())) {
                SVNErrorManager.error(FSErrors.errorNoSuchLock(lock.getPath(), this), SVNLogType.FSFS);
            }
            if (username == null || "".equals(username)) {
                SVNErrorManager.error(FSErrors.errorNoUser(this), SVNLogType.FSFS);
            }
            if (!username.equals(lock.getOwner())) {
                SVNErrorManager.error(FSErrors.errorLockOwnerMismatch(username, lock.getOwner(), this), SVNLogType.FSFS);
            }
        }
        this.deleteLock(lock);
    }

    private SVNLock lock(String path, String token, String username, String comment, Date expirationDate, long currentRevision, boolean stealLock, boolean isDAVComment) throws SVNException {
        SVNLock existingLock;
        long youngestRev = this.getYoungestRevision();
        FSRevisionRoot root = this.createRevisionRoot(youngestRev);
        SVNNodeKind kind = root.checkNodeKind(path);
        if (token != null) {
            if (!token.startsWith(SVN_OPAQUE_LOCK_TOKEN)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Lock token URI ''{0}'' has bad scheme; expected ''opaquelocktoken''", (Object)token);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            int i = 0;
            while (i < token.length()) {
                if (token.charAt(i) > '\u00ff') {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Lock token ''{0}'' is not ASCII at byte ''{1}''", new Object[]{token, new Integer(i)});
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
                ++i;
            }
            if (!SVNEncodingUtil.isXMLSafe(token)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Lock token URI ''{0}'' is not XML-safe", (Object)token);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        if (kind == SVNNodeKind.DIR) {
            SVNErrorManager.error(FSErrors.errorNotFile(path, this), SVNLogType.FSFS);
        } else if (kind == SVNNodeKind.NONE) {
            if (currentRevision >= 0L) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Path ''{0}'' doesn''t exist in HEAD revision", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "Path ''{0}'' doesn''t exist in HEAD revision", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        if (username == null || "".equals(username)) {
            SVNErrorManager.error(FSErrors.errorNoUser(this), SVNLogType.FSFS);
        }
        if (FSRepository.isValidRevision(currentRevision)) {
            SVNErrorMessage err;
            FSRevisionNode node = root.getRevisionNode(path);
            long createdRev = node.getCreatedRevision();
            if (FSRepository.isInvalidRevision(createdRev)) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Path ''{0}'' doesn''t exist in HEAD revision", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (currentRevision < createdRev) {
                err = SVNErrorMessage.create(SVNErrorCode.FS_OUT_OF_DATE, "Lock failed: newer version of ''{0}'' exists", (Object)path);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        if ((existingLock = this.getLockHelper(path, true)) != null) {
            if (!stealLock) {
                SVNErrorManager.error(FSErrors.errorPathAlreadyLocked(existingLock.getPath(), existingLock.getOwner(), this), SVNLogType.FSFS);
            } else {
                this.deleteLock(existingLock);
            }
        }
        FSLock lock = null;
        if (token == null) {
            token = FSRepositoryUtil.generateLockToken();
            lock = new FSLock(path, token, username, comment, new Date(System.currentTimeMillis()), expirationDate, isDAVComment);
        } else {
            lock = new FSLock(path, token, username, comment, new Date(System.currentTimeMillis()), expirationDate, isDAVComment);
        }
        this.setLock(lock, isDAVComment);
        return lock;
    }

    private void setLock(SVNLock lock, boolean isDAVComment) throws SVNException {
        if (lock == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: attempted to set a null lock");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        String lastChild = "";
        String path = lock.getPath();
        ArrayList<String> children = new ArrayList<String>();
        while (true) {
            String digestFileName = this.getDigestFromRepositoryPath(path);
            SVNLock fetchedLock = this.fetchLockFromDigestFile(null, path, children);
            if (lock != null) {
                fetchedLock = lock;
                lock = null;
                lastChild = digestFileName;
            } else {
                if (!children.isEmpty() && children.contains(lastChild)) break;
                children.add(lastChild);
            }
            this.writeDigestLockFile(fetchedLock, children, path, isDAVComment);
            if ("/".equals(path)) break;
            if ("".equals(path = SVNPathUtil.removeTail(path))) {
                path = "/";
            }
            children.clear();
        }
    }

    private boolean ensureDirExists(File dir, boolean create) {
        if (!dir.exists() && create) {
            return dir.mkdirs();
        }
        return dir.exists();
    }

    private void writeDigestLockFile(SVNLock lock, Collection children, String repositoryPath, boolean isDAVComment) throws SVNException {
        if (!this.ensureDirExists(this.getDBLocksDir(), true)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Can''t create a directory at ''{0}''", (Object)this.getDBLocksDir());
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        File digestLockFile = this.getDigestFileFromRepositoryPath(repositoryPath);
        String digest = this.getDigestFromRepositoryPath(repositoryPath);
        File lockDigestSubdir = new File(this.getDBLocksDir(), digest.substring(0, 3));
        if (!this.ensureDirExists(lockDigestSubdir, true)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Can't create a directory at ''{0}''", (Object)lockDigestSubdir);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        SVNProperties props = new SVNProperties();
        if (lock != null) {
            props.put(PATH_LOCK_KEY, lock.getPath());
            props.put(OWNER_LOCK_KEY, lock.getOwner());
            props.put(TOKEN_LOCK_KEY, lock.getID());
            String isDAVCommentValue = isDAVComment ? "1" : "0";
            props.put(IS_DAV_COMMENT_LOCK_KEY, isDAVCommentValue);
            if (lock.getComment() != null) {
                props.put(COMMENT_LOCK_KEY, lock.getComment());
            }
            if (lock.getCreationDate() != null) {
                props.put(CREATION_DATE_LOCK_KEY, SVNDate.formatDate(lock.getCreationDate()));
            }
            if (lock.getExpirationDate() != null) {
                props.put(EXPIRATION_DATE_LOCK_KEY, SVNDate.formatDate(lock.getExpirationDate()));
            }
        }
        if (children != null && children.size() > 0) {
            Object[] digests = children.toArray();
            StringBuffer value = new StringBuffer();
            int i = 0;
            while (i < digests.length) {
                value.append(digests[i]);
                value.append('\n');
                ++i;
            }
            props.put(CHILDREN_LOCK_KEY, value.toString());
        }
        try {
            SVNWCProperties.setProperties(props, digestLockFile, SVNFileUtil.createUniqueFile(digestLockFile.getParentFile(), digestLockFile.getName(), ".tmp", false), "END");
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Cannot write lock/entries hashfile ''{0}''", digestLockFile);
            SVNErrorManager.error(err, svne, SVNLogType.FSFS);
        }
    }

    private FSFile openAndSeekTransaction(FSRepresentation rep) {
        FSFile file = this.getTransactionRevisionPrototypeFile(rep.getTxnId());
        file.seek(rep.getOffset());
        return file;
    }

    private FSFile openAndSeekRevision(long revision, long offset) throws SVNException {
        this.ensureRevisionsExists(revision);
        FSFile file = this.getPackOrRevisionFSFile(revision);
        if (this.isPackedRevision(revision)) {
            long revOffset = this.getPackedOffset(revision);
            offset += revOffset;
        }
        file.seek(offset);
        return file;
    }

    private Map parsePlainRepresentation(SVNProperties entries, boolean mayContainNulls) throws SVNException {
        SVNHashMap representationMap = new SVNHashMap();
        for (String name : entries.nameSet()) {
            String unparsedEntry = entries.getStringValue(name);
            if (unparsedEntry == null && mayContainNulls) continue;
            FSEntry nextRepEntry = this.parseRepEntryValue(name, unparsedEntry);
            if (nextRepEntry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Directory entry corrupt");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            representationMap.put(name, nextRepEntry);
        }
        return representationMap;
    }

    private FSEntry parseRepEntryValue(String name, String value) {
        if (value == null) {
            return null;
        }
        int spaceInd = value.indexOf(32);
        if (spaceInd == -1) {
            return null;
        }
        String kind = value.substring(0, spaceInd);
        String rawID = value.substring(spaceInd + 1);
        SVNNodeKind type = SVNNodeKind.parseKind(kind);
        FSID id = FSID.fromString(rawID);
        if (type != SVNNodeKind.DIR && type != SVNNodeKind.FILE || id == null) {
            return null;
        }
        return new FSEntry(id, type, name);
    }

    private Date getRevisionTime(long revision) throws SVNException {
        SVNProperties revisionProperties = this.getRevisionProperties(revision);
        String timeString = revisionProperties.getStringValue("svn:date");
        if (timeString == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Failed to find time on revision {0}", (Object)new Long(revision));
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        return SVNDate.parseDateString(timeString);
    }

    private static boolean isRepositoryRoot(File candidatePath) {
        File formatFile = new File(candidatePath, "format");
        SVNFileType fileType = SVNFileType.getType(formatFile);
        if (fileType != SVNFileType.FILE) {
            return false;
        }
        File dbFile = new File(candidatePath, DB_DIR);
        fileType = SVNFileType.getType(dbFile);
        return fileType == SVNFileType.DIRECTORY || fileType == SVNFileType.SYMLINK;
    }

    public File getRevisionPropertiesDbPath() {
        return SVNFileUtil.createFilePath(this.getRevisionPropertiesRoot(), REVISION_PROPERTIES_DB);
    }

    public File getMinUnpackedRevPropPath() {
        return SVNFileUtil.createFilePath(this.getDBRoot(), MIN_UNPACKED_REVPROP);
    }

    public void updateMinUnpackedRevProp() throws SVNException {
        assert (this.myDBFormat >= 5);
        this.myMinUnpackedRevProp = this.getMinUnpackedRevProp();
    }

    public long getMinUnpackedRevProp() throws SVNException {
        FSFile file = new FSFile(this.getMinUnpackedRevPropPath());
        try {
            long l = file.readLong();
            return l;
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
        finally {
            file.close();
        }
    }

    public SVNSqlJetDb getRevisionProperitesDb() {
        return this.myRevisionProperitesDb;
    }
}

