/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.auth.AgentProxy;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshAuthenticationException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshConnection;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshHostDisposedException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSession;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SshHost {
    private static final long CONNECTION_INACTIVITY_TIMEOUT = 600000L;
    private static final long MAX_CONCURRENT_OPENERS = 3L;
    private static final int MAX_SESSIONS_PER_CONNECTION = 8;
    private String myHost;
    private int myPort;
    private ServerHostKeyVerifier myHostVerifier;
    private char[] myPrivateKey;
    private char[] myPassphrase;
    private char[] myPassword;
    private String myUserName;
    private AgentProxy myAgentProxy;
    private int myConnectTimeout;
    private boolean myIsLocked;
    private boolean myIsDisposed;
    private List<SshConnection> myConnections;
    private Object myOpenerLock = new Object();
    private int myOpenersCount;
    private int myReadTimeout;

    public SshHost(String host, int port) {
        this.myConnections = new LinkedList<SshConnection>();
        this.myHost = host;
        this.myPort = port;
    }

    public void setHostVerifier(ServerHostKeyVerifier verifier) {
        this.myHostVerifier = verifier;
    }

    public void setConnectionTimeout(int timeout) {
        this.myConnectTimeout = timeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.myReadTimeout = readTimeout;
    }

    public void setCredentials(String userName, char[] key, char[] passphrase, char[] password, AgentProxy agentProxy) {
        this.myUserName = userName;
        this.myPrivateKey = key;
        this.myPassphrase = passphrase;
        this.myPassword = password;
        this.myAgentProxy = agentProxy;
    }

    public boolean purge() {
        try {
            this.lock();
            int size = this.myConnections.size();
            long time = System.currentTimeMillis();
            Iterator<SshConnection> connections = this.myConnections.iterator();
            while (connections.hasNext()) {
                SshConnection connection = connections.next();
                if (connection.getSessionsCount() != 0) continue;
                if (this.myConnections.size() == 1) {
                    long timeout = time - connection.lastAcccessTime();
                    if (timeout < 600000L) continue;
                    connection.close();
                    connections.remove();
                    continue;
                }
                connection.close();
                connections.remove();
            }
            if (this.myConnections.size() == 0 && size > 0) {
                this.setDisposed(true);
            }
            boolean bl = this.isDisposed();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void setDisposed(boolean disposed) {
        this.myIsDisposed = disposed;
        if (disposed) {
            for (SshConnection connection : this.myConnections) {
                connection.close();
            }
            this.myConnections.clear();
        }
    }

    public String getKey() {
        String key = String.valueOf(this.myUserName) + ":" + this.myHost + ":" + this.myPort;
        if (this.myPrivateKey != null) {
            key = String.valueOf(key) + ":" + new String(this.myPrivateKey);
        }
        if (this.myPassphrase != null) {
            key = String.valueOf(key) + ":" + new String(this.myPassphrase);
        }
        if (this.myPassword != null) {
            key = String.valueOf(key) + ":" + new String(this.myPassword);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void lock() {
        List<SshConnection> list = this.myConnections;
        synchronized (list) {
            while (true) {
                if (!this.myIsLocked) {
                    this.myIsLocked = true;
                    return;
                }
                try {
                    this.myConnections.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock() {
        List<SshConnection> list = this.myConnections;
        synchronized (list) {
            this.myIsLocked = false;
            this.myConnections.notifyAll();
        }
    }

    public SshSession openSession() throws IOException {
        SshSession session = this.useExistingConnection();
        if (session != null) {
            return session;
        }
        SshConnection newConnection = null;
        this.addOpener();
        try {
            session = this.useExistingConnection();
            if (session != null) {
                SshSession sshSession = session;
                return sshSession;
            }
            newConnection = this.openConnection();
        }
        finally {
            this.removeOpener();
        }
        if (newConnection != null) {
            this.lock();
            try {
                if (this.isDisposed()) {
                    newConnection.close();
                    throw new SshHostDisposedException();
                }
                this.myConnections.add(newConnection);
                SshSession sshSession = newConnection.openSession();
                return sshSession;
            }
            finally {
                this.unlock();
            }
        }
        throw new IOException("Cannot establish SSH connection with " + this.myHost + ":" + this.myPort);
    }

    private SshSession useExistingConnection() throws IOException {
        this.lock();
        try {
            if (this.isDisposed()) {
                throw new SshHostDisposedException();
            }
            Iterator<SshConnection> connections = this.myConnections.iterator();
            while (connections.hasNext()) {
                SshConnection connection = connections.next();
                if (connection.getSessionsCount() >= 8) continue;
                try {
                    SshSession sshSession = connection.openSession();
                    return sshSession;
                }
                catch (IOException e) {
                    block9: {
                        String message;
                        if (e.getMessage() == null || !(message = e.getMessage()).contains("connection is closed") && !message.contains("connection is being shutdown")) break block9;
                        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SSH connection has been unexpectedly closed");
                        connection.close();
                        connections.remove();
                        this.unlock();
                        return null;
                    }
                    throw e;
                }
            }
        }
        finally {
            this.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpener() {
        Object object = this.myOpenerLock;
        synchronized (object) {
            --this.myOpenersCount;
            this.myOpenerLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addOpener() {
        Object object = this.myOpenerLock;
        synchronized (object) {
            while (true) {
                if ((long)this.myOpenersCount < 3L) {
                    ++this.myOpenersCount;
                    return;
                }
                try {
                    this.myOpenerLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private SshConnection openConnection() throws IOException {
        String passphrase;
        Connection connection = new Connection(this.myHost, this.myPort);
        connection.connect(new ServerHostKeyVerifier(){

            public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
                if (SshHost.this.myHostVerifier != null) {
                    SshHost.this.myHostVerifier.verifyServerHostKey(hostname, port, serverHostKeyAlgorithm, serverHostKey);
                }
                return true;
            }
        }, this.myConnectTimeout, this.myReadTimeout, this.myConnectTimeout);
        boolean authenticated = false;
        final String password = this.myPassword != null ? new String(this.myPassword) : null;
        String string = passphrase = this.myPassphrase != null ? new String(this.myPassphrase) : null;
        if (this.myAgentProxy != null) {
            authenticated = connection.authenticateWithAgent(this.myUserName, this.myAgentProxy);
        }
        if (!authenticated && this.myPrivateKey != null) {
            authenticated = connection.authenticateWithPublicKey(this.myUserName, this.myPrivateKey, passphrase);
        }
        if (!authenticated && this.myPassword != null) {
            String[] methods = connection.getRemainingAuthMethods(this.myUserName);
            int i = 0;
            while (!authenticated && i < methods.length) {
                if ("password".equals(methods[i])) {
                    authenticated = connection.authenticateWithPassword(this.myUserName, password);
                } else if ("keyboard-interactive".equals(methods[i])) {
                    authenticated = connection.authenticateWithKeyboardInteractive(this.myUserName, new InteractiveCallback(){

                        public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
                            String[] reply = new String[numPrompts];
                            int i = 0;
                            while (i < reply.length) {
                                reply[i] = password;
                                ++i;
                            }
                            return reply;
                        }
                    });
                }
                ++i;
            }
        }
        if (!authenticated) {
            connection.close();
            throw new SshAuthenticationException("Credentials rejected by SSH server.");
        }
        return new SshConnection(this, connection);
    }

    public String toString() {
        return String.valueOf(this.myUserName) + "@" + this.myHost + ":" + this.myPort + ":" + this.myConnections.size();
    }
}

